/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.util.ParamHelper;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleGroupFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.client.AbstractRoleF7UI;
import com.kingdee.eas.base.permission.client.RoleEditUI;
import com.kingdee.eas.base.permission.client.RoleGroupEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.KDTableUtil;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class RoleF7UI
extends AbstractRoleF7UI {
    private static final Logger logger = CoreUIObject.getLogger(RoleF7UI.class);
    protected boolean isSingleSelect = true;
    private RoleInfo roleInfo = null;
    private RoleCollection roleCol = null;
    private boolean isCanceled = true;
    private EntityViewInfo f7EVI = null;
    private static final String role_ID_CELLNAME = "id";
    private static final String GROUP_ID_CELLNAME = "group.id";
    private static final String GROUP_NAME_CELLNAME = "group.name";
    private FilterInfo roleRangeFilter = null;
    private boolean mergeroleRangeFilter = true;
    private boolean isCapitalSensitiveQuery = false;

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName(this.getUIHandlerClassName());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCapitalSensitiveQuery();
        HashMap map = (HashMap)this.getUIContext();
        if (map.get("F7_EVI") != null) {
            this.f7EVI = (EntityViewInfo)map.get("F7_EVI");
        }
        this.mergeF7Filter();
        this.chkLike.setSelected(true);
        this.tblMain.removeRows();
        KDTable currentTable = this.getMainTable();
        this.tblMain.getGroupManager().setGroup(true);
        this.btnConfirm.setEnabled(true);
        this.btnQuit.setEnabled(true);
        this.btnFastQuery.setEnabled(true);
        this.tblMain.refresh();
    }

    protected String[] getNotOrderColumns() {
        String[] columnKeys = new String[]{GROUP_NAME_CELLNAME};
        return columnKeys;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return RoleGroupFactory.getRemoteInstance();
    }

    protected ICoreBase getBizInterface() throws BOSException {
        return RoleFactory.getRemoteInstance();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initTree() throws Exception {
        super.initTree();
    }

    protected String getKeyFieldName() {
        return role_ID_CELLNAME;
    }

    protected String getRootName() {
        return PermissionResUtil.getResource("res_111");
    }

    protected String getLongNumberFieldName() {
        return "";
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int[] rowID;
        KDTSelectBlock block;
        if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            super.tblMain_tableClicked(e);
            return;
        }
        if (this.tblMain.getSelectManager().size() > 0 && (block = this.tblMain.getSelectManager().get(0)).getMode() == 8 && (rowID = KDTableUtil.getSelectedRows((KDTable)this.tblMain)).length == 1) {
            return;
        }
        if (e.getClickCount() == 2) {
            this.storeData();
            this.close(false);
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.storeData();
        this.close(false);
    }

    private void storeData() throws Exception {
        int i;
        int[] rowIDs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        KDTSelectManager manager = this.tblMain.getSelectManager();
        if (this.tblMain.getRowCount() > 0 && manager.size() > 0 && manager.get(0).getMode() == 8) {
            rowIDs = new int[this.tblMain.getRowCount()];
            for (i = 0; i < rowIDs.length; ++i) {
                rowIDs[i] = i;
            }
        }
        if (this.isSingleSelect) {
            if (rowIDs.length > 0) {
                String strID = this.tblMain.getRow(rowIDs[0]).getCell(role_ID_CELLNAME).getValue().toString();
                IRole iRole = RoleFactory.getRemoteInstance();
                this.roleInfo = iRole.getRoleInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)strID)));
                this.isCanceled = false;
                this.getUIWindow().close();
            }
        } else {
            if (this.roleCol == null) {
                this.roleCol = new RoleCollection();
            }
            for (i = 0; i < rowIDs.length; ++i) {
                if (rowIDs[i] == -1) continue;
                RoleInfo roleInfo = new RoleInfo();
                roleInfo.setId(BOSUuid.read((String)this.tblMain.getRow(rowIDs[i]).getCell(role_ID_CELLNAME).getValue().toString()));
                if (this.tblMain.getRow(rowIDs[i]).getCell("name").getValue() != null) {
                    roleInfo.setName(this.tblMain.getRow(rowIDs[i]).getCell("name").getValue().toString());
                }
                roleInfo.setNumber(this.tblMain.getRow(rowIDs[i]).getCell("number").getValue().toString());
                this.roleCol.add(roleInfo);
            }
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterinfo = null;
        if (this.f7EVI != null && (filterinfo = this.f7EVI.getFilter()) != null && this.mergeroleRangeFilter) {
            try {
                filterinfo = (FilterInfo)filterinfo.clone();
                filterinfo.mergeFilter(this.roleRangeFilter, "and");
            }
            catch (BOSException e) {
                logger.error((Object)"Permission.roleF7UI.getDefaultFilterForQuery:", (Throwable)e);
            }
        }
        return filterinfo != null ? filterinfo : this.roleRangeFilter;
    }

    private void close(boolean isCanceled) {
        this.isCanceled = isCanceled;
        this.getUIWindow().close();
    }

    @Override
    public void actionQuit_actionPerformed(ActionEvent e) throws Exception {
        this.close(true);
    }

    public RoleInfo getRoleInfo() {
        return this.roleInfo;
    }

    public RoleCollection getRoleCollection() {
        return this.roleCol;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    @Override
    public void actionFastQuery_actionPerformed(ActionEvent e) throws Exception {
        super.btnFastQuery_actionPerformed(e);
        String theValue = this.txtValue.getText().trim();
        if (theValue.length() != 0) {
            String theCompareString = "=";
            String fieldName = "name";
            if (this.cboKey.getSelectedIndex() == 0) {
                fieldName = "name";
            } else if (this.cboKey.getSelectedIndex() == 1) {
                fieldName = "number";
            }
            if (this.chkLike.isSelected()) {
                theCompareString = "like";
                theValue = ParamHelper.getMatchString((String)fieldName, (String)theValue, (String)"");
            }
            theValue = "'" + theValue + "'";
            String oql = "where ";
            oql = this.isCapitalSensitiveQuery ? oql + fieldName + " " + theCompareString + " " + theValue : oql + "upper(" + fieldName + ") " + theCompareString + " " + theValue.toUpperCase();
            try {
                this.mainQuery = new EntityViewInfo(oql.toString());
            }
            catch (Exception ex) {
                this.mainQuery = new EntityViewInfo();
            }
        } else {
            this.mainQuery = new EntityViewInfo();
        }
        this.mergeF7Filter();
        this.tblMain.removeRows();
        this.tblMain.requestFocusInWindow();
        this.selectFirstRow();
    }

    private void initCapitalSensitiveQuery() {
        String capitalSensitiveQuery = ParamHelper.getCapitalSensitiveQuery();
        if (capitalSensitiveQuery != null && capitalSensitiveQuery.equalsIgnoreCase("true")) {
            this.isCapitalSensitiveQuery = true;
        }
    }

    private void mergeF7Filter() throws Exception {
        if (this.f7EVI != null && this.f7EVI.getFilter() != null && this.f7EVI.getFilter().getFilterItems().size() > 0) {
            EntityViewInfo cloneFilter = (EntityViewInfo)this.f7EVI.clone();
            if (this.mainQuery.getFilter() != null && this.mainQuery.getFilter().getFilterItems().size() > 0) {
                this.mainQuery.getFilter().mergeFilter(cloneFilter.getFilter(), "and");
            } else {
                this.mainQuery.setFilter(cloneFilter.getFilter());
            }
        }
        if (this.mergeroleRangeFilter) {
            FilterInfo roleFilter = this.mainQuery.getFilter();
            if (roleFilter == null) {
                this.mainQuery.setFilter(this.roleRangeFilter);
            } else {
                this.mainQuery.getFilter().mergeFilter(this.roleRangeFilter, "and");
            }
        }
    }

    protected String getEditUIName() {
        return RoleEditUI.class.getName();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.actionConfirm_actionPerformed(null);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        return null;
    }

    protected String getGroupEditUIName() {
        return RoleGroupEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return GROUP_ID_CELLNAME;
    }
}

