/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.FieldAccessCollection;
import com.kingdee.eas.base.permission.FieldAccessFactory;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.FieldPermFacadeFactory;
import com.kingdee.eas.base.permission.GrantRoleFieldFactory;
import com.kingdee.eas.base.permission.GrantUserFieldFactory;
import com.kingdee.eas.base.permission.IFieldAccess;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractRoleFieldAccessAccreditUI;
import com.kingdee.eas.base.permission.client.util.FieldAccessUtil;
import com.kingdee.eas.base.permission.client.util.UIUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class RoleFieldAccessAccreditUI
extends AbstractRoleFieldAccessAccreditUI {
    private static final int FIELD_NAME_INDEX = 0;
    private static final int VIEWABLE_INDEX = 1;
    private static final int EDITABLE_INDEX = 2;
    private static final int GRANT_INDEX = 3;
    public static final String TARGET_ROLE_PK = "rolePK";
    private Set oldGrantFields = null;
    private static final String GRANTABLE = "grantable";
    private Map loadedData = null;
    private FieldAccessCollection oldData = null;
    private BOSObjectType currentBOSObjectType = null;
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName(this.getUIHandlerClassName());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void initUI() throws EASBizException, BOSException {
        this.buildTree();
        this.initTable();
    }

    private void initTable() {
        this.tblMain.checkParsed(true);
        this.tblMain.getColumn(GRANTABLE).getStyleAttributes().setHided(false);
    }

    private void buildTree() {
        DefaultKingdeeTreeNode root = this.createNode();
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        this.tree.setModel((TreeModel)model);
        UIUtil.addStandardPopupMenu(this.tree);
    }

    private Set getGrantedRoleFields(BOSObjectType objectType) throws Exception {
        return GrantRoleFieldFactory.getRemoteInstance().getGrantedFields(this.getTargetRolePK(), objectType);
    }

    private DefaultKingdeeTreeNode createNode() {
        return SubSystemUtils.getKDTreeNode((IBriefViewTreeNode)SubSystemUtils.getRemoveEmptyPackageNode((IBriefViewTreeNode)SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_base_fieldpermission")));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnSubmit);
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.setButtonDefaultStyl(this.btnSelectAll);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.setButtonDefaultStyl(this.btnClearAll);
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    private IObjectPK getTargetRolePK() {
        if (this.getUIContext().get(TARGET_ROLE_PK) != null) {
            return (IObjectPK)this.getUIContext().get(TARGET_ROLE_PK);
        }
        return null;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.save();
    }

    private void save() throws Exception {
        if (this.currentBOSObjectType != null) {
            FieldAccessCollection currentResult = this.getCurrentResult();
            if (currentResult.size() == 0) {
                this.deleteFieldAccess(this.currentBOSObjectType);
            } else {
                FieldPermFacadeFactory.getRemoteInstance().saveRoleFieldPerm(this.getTargetRolePK(), this.currentBOSObjectType, this.getCurrentGrantFields(), currentResult);
            }
            this.refreshList();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"accreditPermSucceed"));
        }
    }

    private void deleteFieldAccess(BOSObjectType objectType) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("bizObjectType", (Object)objectType.toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("role.id", (Object)this.getTargetRolePK().toString()));
        IFieldAccess iFieldAccess = FieldAccessFactory.getRemoteInstance();
        iFieldAccess.delete(filterInfo);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.setValue(Boolean.TRUE);
        super.actionSelectAll_actionPerformed(e);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.setValue(Boolean.FALSE);
        super.actionClearAll_actionPerformed(e);
    }

    private void setValue(Boolean value) {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                int endCol = selectBlock.getRight();
                for (int beginCol = selectBlock.getLeft(); beginCol <= endCol; ++beginCol) {
                    if (beginCol == 1 || beginCol == 2) {
                        this.tblMain.getRow(j).getCell(beginCol).setValue((Object)value);
                        if (beginCol == 2 && value.booleanValue()) {
                            this.tblMain.getRow(j).getCell(1).setValue((Object)value);
                        }
                        if (beginCol == 1 && !value.booleanValue()) {
                            this.tblMain.getRow(j).getCell(2).setValue((Object)value);
                        }
                    }
                    if (beginCol != 3) continue;
                    this.tblMain.getRow(j).getCell(GRANTABLE).setValue((Object)value);
                }
            }
        }
    }

    @Override
    protected void tree_valueChanged(TreeSelectionEvent e) throws Exception {
        super.tree_valueChanged(e);
        this.alertSave();
        this.refreshList();
    }

    private void setCurrentEntityType() {
        MetaDataBriefInfo mdbInfo;
        DefaultKingdeeTreeNode node;
        Object userObject;
        Object object = this.tree.getLastSelectedPathComponent();
        if (object != null && object instanceof DefaultKingdeeTreeNode && (userObject = (node = (DefaultKingdeeTreeNode)object).getUserObject()) instanceof MetaDataBriefInfo && (mdbInfo = (MetaDataBriefInfo)userObject).getMetaDataType().equals((Object)MetaDataTypeList.ENTITY)) {
            this.currentBOSObjectType = mdbInfo.getBOType();
            return;
        }
        this.currentBOSObjectType = null;
    }

    private void alertSave() throws Exception {
        int isYes;
        if (this.currentBOSObjectType != null && this.isModify() && MsgBox.isYes((int)(isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"fieldAccessIsChange"))))) {
            this.save();
            this.abort();
        }
    }

    private boolean isModify() {
        return this.isFieldAccessModify() || this.isGrantFieldModify();
    }

    private boolean isFieldAccessModify() {
        FieldAccessCollection currentResult = this.getCurrentResult();
        int size = currentResult.size();
        int oldSize = this.oldData.size();
        if (currentResult.size() == this.oldData.size()) {
            int i;
            HashMap<String, FieldAccessInfo> oldDataMap = new HashMap<String, FieldAccessInfo>();
            for (i = 0; i < oldSize; ++i) {
                oldDataMap.put(this.oldData.get(i).getFieldName(), this.oldData.get(i));
            }
            for (i = 0; i < size; ++i) {
                FieldAccessInfo fieldAccessInfo = currentResult.get(i);
                String fieldName = fieldAccessInfo.getFieldName();
                if (oldDataMap.containsKey(fieldName)) {
                    FieldAccessInfo oldFieldAccessInfo = (FieldAccessInfo)oldDataMap.get(fieldName);
                    if (fieldAccessInfo.getAccessValue() == oldFieldAccessInfo.getAccessValue()) continue;
                    return true;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isGrantFieldModify() {
        Set currentGrantFields = this.getCurrentGrantFields();
        return !this.oldGrantFields.containsAll(currentGrantFields) || !currentGrantFields.containsAll(this.oldGrantFields);
    }

    private FieldAccessCollection getCurrentResult() {
        FieldAccessCollection result = new FieldAccessCollection();
        UserInfo userInfo = new UserInfo();
        FullOrgUnitInfo org = new FullOrgUnitInfo();
        RoleInfo roleInfo = new RoleInfo();
        roleInfo.setId(BOSUuid.read((String)this.getTargetRolePK().toString()));
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            boolean isViewable = (Boolean)row.getCell(1).getValue();
            boolean isEditable = (Boolean)row.getCell(2).getValue();
            String fieldName = (String)row.getCell(0).getUserObject();
            FieldAccessInfo info = new FieldAccessInfo();
            info.setBizObjectType(this.currentBOSObjectType.toString());
            info.setFieldName(fieldName);
            info.setViewable(isViewable);
            info.setEditable(isEditable);
            info.setCU(this.getCurrentCU());
            info.setUser(userInfo);
            info.setOrg(org);
            info.setRole(roleInfo);
            result.add(info);
        }
        return result;
    }

    private Set getCurrentGrantFields() {
        HashSet<String> ret = new HashSet<String>();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            boolean isGrant = (Boolean)row.getCell(GRANTABLE).getValue();
            if (!isGrant) continue;
            ret.add(row.getCell(0).getUserObject().toString());
        }
        return ret;
    }

    private void refreshList() throws Exception {
        this.setCurrentEntityType();
        if (this.currentBOSObjectType != null) {
            this.loadCurrentFieldAccess(this.currentBOSObjectType);
            this.loadRowData(this.currentBOSObjectType);
            this.oldData = this.getCurrentResult();
            this.oldGrantFields = this.getCurrentGrantFields();
        } else {
            this.loadedData = null;
            this.tblMain.removeRows();
            this.oldData = null;
            this.oldGrantFields = null;
        }
    }

    private Map loadCurrentFieldAccess(BOSObjectType objectType) throws BOSException {
        this.loadedData = new HashMap();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("bizObjectType", (Object)objectType.toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("role.id", (Object)this.getTargetRolePK().toString()));
        entityViewInfo.setFilter(filterInfo);
        IFieldAccess iFieldAccess = FieldAccessFactory.getRemoteInstance();
        FieldAccessCollection collection = iFieldAccess.getFieldAccessCollection(entityViewInfo);
        if (collection != null) {
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                FieldAccessInfo info = collection.get(i);
                this.loadedData.put(info.getFieldName(), info);
            }
        }
        return this.loadedData;
    }

    private void loadRowData(BOSObjectType objectType) throws Exception {
        this.tblMain.setRefresh(false);
        this.tblMain.removeRows();
        Set result = FieldAccessUtil.getFieldAccessStrategy(objectType, this.getCurrentCUPK());
        Set fieldInfos = FieldAccessUtil.getEntityFieldInfos(objectType);
        if (this.isCurrentUserBizAdmin()) {
            Set grantedFields = GrantUserFieldFactory.getRemoteInstance().getGrantedFields((IObjectPK)new ObjectUuidPK(this.getCurrentUserInfo().getId()), this.getCurrentOrgPK(), objectType);
            fieldInfos = FieldAccessUtil.getGrantedFieldInfos(fieldInfos, grantedFields);
        }
        Set grantRoleFields = this.getGrantedRoleFields(objectType);
        for (String[] fieldInfo : fieldInfos) {
            if (!result.contains(fieldInfo[1])) continue;
            IRow row = this.tblMain.addRow();
            row.getCell(0).setValue((Object)fieldInfo[0]);
            row.getCell(0).setUserObject((Object)fieldInfo[1]);
            if (this.loadedData.containsKey(fieldInfo[1])) {
                FieldAccessInfo info = (FieldAccessInfo)this.loadedData.get(fieldInfo[1]);
                row.getCell(1).setValue((Object)info.isViewable());
                row.getCell(2).setValue((Object)info.isEditable());
            } else {
                row.getCell(1).setValue((Object)Boolean.TRUE);
                row.getCell(2).setValue((Object)Boolean.TRUE);
            }
            if (grantRoleFields.contains(fieldInfo[1])) {
                row.getCell(GRANTABLE).setValue((Object)Boolean.TRUE);
                continue;
            }
            row.getCell(GRANTABLE).setValue((Object)Boolean.FALSE);
        }
        this.tblMain.setRefresh(true);
        this.tblMain.reLayoutAndPaint();
    }

    private IObjectPK getCurrentOrgPK() {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId());
    }

    private CtrlUnitInfo getCurrentCU() {
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private UserInfo getCurrentUserInfo() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    private boolean isCurrentUserBizAdmin() {
        return this.getCurrentUserInfo().isBizAdmin();
    }

    private IObjectPK getCurrentCUPK() {
        return new ObjectUuidPK(this.getCurrentCU().getId());
    }

    @Override
    protected void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
        super.tblMain_editValueChanged(e);
        boolean flag = e.getValue() == null ? false : (Boolean)e.getValue();
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == 1) {
            if (!flag) {
                this.tblMain.getRow(rowIndex).getCell(2).setValue((Object)Boolean.FALSE);
            }
        } else if (colIndex == 2 && flag) {
            this.tblMain.getRow(rowIndex).getCell(1).setValue((Object)Boolean.TRUE);
        }
    }
}

