/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.BizObjectForRoleInfo;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.RuleFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractRuleListUI;
import com.kingdee.eas.base.permission.client.RuleEditUI;
import com.kingdee.eas.base.permission.client.RuleTreeUtil;
import com.kingdee.eas.base.permission.client.util.UIUtil;
import com.kingdee.eas.base.permission.helper.CUHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.query.QuickFilteringSupportManager;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class RuleListUI
extends AbstractRuleListUI {
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static Logger logger = Logger.getLogger((String)RuleListUI.class.getName());
    private static final String BIZ_OBJECT_INDEX = "bizObject";
    QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public RuleListUI() throws Exception {
        this.checkIsNormalUser();
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public boolean isPrepareActionView() {
        return true;
    }

    @Override
    public boolean isPrepareActionQuery() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        try {
            if (clientHanlder != null) {
                RequestContext request = new RequestContext();
                request.put("getCurrentUserPK", (Object)ToolUtils.getCurrentUserPK());
                clientHanlder.setRequestContext((Serializable)request);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return clientHanlder;
    }

    public RequestContext prepareActionAddNew(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionAddNew(itemAction);
        request.put("getCurrentUserPK", (Object)ToolUtils.getCurrentUserPK());
        return request;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    private void initUI() throws Exception {
        this.buildTree();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        this.selectDefaultNode();
        this.initWorkButton();
        this.addKeyFunction();
    }

    private BOSObjectType getEntityType() {
        BOSObjectType entityType = null;
        Object objEntityType = this.getUIContext().get("entityType");
        if (objEntityType != null) {
            entityType = (BOSObjectType)objEntityType;
        }
        return entityType;
    }

    private IObjectPK getCtrlUnitPK() {
        IObjectPK ctrlUnitPK = null;
        Object objCtrlUnitPK = this.getUIContext().get("ctrlUnitPK");
        ctrlUnitPK = objCtrlUnitPK != null ? (IObjectPK)objCtrlUnitPK : this.getCurrentCUPK();
        return ctrlUnitPK;
    }

    private IObjectPK getCurrentCUPK() {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId());
    }

    private void selectDefaultNode() {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.tree.getModel().getRoot();
        this.tree.setSelectionNode(root);
        BOSObjectType entityType = this.getEntityType();
        if (entityType != null) {
            Enumeration enumeration = root.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                MetaDataBriefInfo mdbInfo;
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)enumeration.nextElement();
                Object userObject = node.getUserObject();
                if (!(userObject instanceof MetaDataBriefInfo) || !(mdbInfo = (MetaDataBriefInfo)userObject).getMetaDataType().equals((Object)MetaDataTypeList.ENTITY) || !entityType.equals((Object)mdbInfo.getBOType())) continue;
                this.tree.setSelectionNode(node);
            }
        }
    }

    private void checkIsNormalUser() throws EASBizException, BOSException {
        boolean isCUAdmin = Administrator.isCUAdmin(null, this.getCurrentUserPK());
        boolean isBizAdmin = this.getCurrentUser().isBizAdmin();
        if (!isCUAdmin && !isBizAdmin) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"normalUserCanNotUse"));
            this.abort();
        }
    }

    private IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(this.getCurrentUser().getId());
    }

    private UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    private void buildTree() throws Exception {
        RuleTreeUtil.createRuleRootNode(this.tree);
        if (this.tree.getModel().getRoot() == null || !this.tree.isRootVisible() && ((KDTreeNode)this.tree.getModel().getRoot()).getChildCount() <= 0) {
            this.tree = new KDTree();
            DefaultKingdeeTreeNode root = this.createNode();
            DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
            this.tree.setModel((TreeModel)model);
            this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    try {
                        RuleListUI.this.tree_valueChanged(e);
                    }
                    catch (Exception exc) {
                        RuleListUI.this.handUIException(exc);
                    }
                }
            });
        }
        UIUtil.addStandardPopupMenu(this.tree);
        this.tview.setTree(this.tree);
    }

    private DefaultKingdeeTreeNode createNode() throws BOSException, EASBizException {
        HashSet<DefaultKingdeeTreeNode> removed = new HashSet<DefaultKingdeeTreeNode>();
        Set objectTypes = this.getObjectTypes();
        DefaultKingdeeTreeNode root = SubSystemUtils.getKDTreeNode((IBriefViewTreeNode)SubSystemUtils.getRemoveEmptyPackageNode((IBriefViewTreeNode)SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_base_permission")));
        Enumeration enumeration = root.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            MetaDataBriefInfo mdbInfo;
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)enumeration.nextElement();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof MetaDataBriefInfo) || !(mdbInfo = (MetaDataBriefInfo)userObject).getMetaDataType().equals((Object)MetaDataTypeList.ENTITY) || objectTypes.contains(mdbInfo.getBOType().toString())) continue;
            removed.add(node);
        }
        for (DefaultKingdeeTreeNode node : removed) {
            node.removeFromParent();
        }
        PermissionCommonUtil.removeEmptyPackageNode(root);
        return root;
    }

    private Set getObjectTypes() throws BOSException, EASBizException {
        HashSet<String> objectTypes = new HashSet<String>();
        IPermItem iPermItem = PermItemFactory.getRemoteInstance();
        PermItemCollection collection = iPermItem.getPermObjectType(true);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            PermItemInfo permItemInfo = collection.get(i);
            objectTypes.add(permItemInfo.getObjectType());
        }
        return objectTypes;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnAddNew.setEnabled(true);
        this.btnEdit.setEnabled(true);
        this.btnRemove.setEnabled(true);
    }

    protected String getEditUIName() {
        return RuleEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RuleFactory.getRemoteInstance();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dlg = super.initCommonQueryDialog();
        dlg.setShowSorter(false);
        return dlg;
    }

    private EntityViewInfo getEntityViewInfo(DefaultKingdeeTreeNode node) {
        ArrayList bosTypes = this.getBOSObjectTypes(node);
        return this.buildEntityViewInfo(bosTypes);
    }

    private ArrayList getBOSObjectTypes(DefaultKingdeeTreeNode node) {
        assert (node != null);
        ArrayList<String> bosTypes = new ArrayList<String>();
        Enumeration enumeration = node.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            BizObjectForRoleInfo roleInfo;
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)enumeration.nextElement();
            Object userObject = child.getUserObject();
            if (userObject instanceof MetaDataBriefInfo) {
                MetaDataBriefInfo mdbInfo = (MetaDataBriefInfo)userObject;
                if (!mdbInfo.getMetaDataType().equals((Object)MetaDataTypeList.ENTITY)) continue;
                bosTypes.add(mdbInfo.getBOType().toString());
                continue;
            }
            if (!(userObject instanceof BizObjectForRoleInfo) || !(roleInfo = (BizObjectForRoleInfo)userObject).isIsLeaf()) continue;
            bosTypes.add(roleInfo.getNumber());
        }
        return bosTypes;
    }

    private EntityViewInfo buildEntityViewInfo(ArrayList bosTypes) {
        assert (bosTypes != null);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer buffer = new StringBuffer();
        int size = bosTypes.size();
        for (int i = 0; i < size; ++i) {
            filterInfo.getFilterItems().add(new FilterItemInfo(BIZ_OBJECT_INDEX, (Object)((String)bosTypes.get(i))));
            if (i == size - 1) {
                buffer.append(" #").append(i).append(" ");
                continue;
            }
            buffer.append(" #").append(i).append(" OR ");
        }
        filterInfo.setMaskString(buffer.toString());
        entityViewInfo.setFilter(filterInfo);
        return entityViewInfo;
    }

    @Override
    protected void tree_valueChanged(TreeSelectionEvent e) throws Exception {
        super.tree_valueChanged(e);
        Object object = e.getPath().getLastPathComponent();
        if (object instanceof DefaultKingdeeTreeNode) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)object;
            this.mainQuery = this.getEntityViewInfo(this.getEntityViewInfo(node));
        }
        this.tblMain.refresh();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        try {
            EntityViewInfo execCondition = viewInfo == null ? new EntityViewInfo() : (EntityViewInfo)viewInfo.clone();
            Object object = this.tree.getLastSelectedPathComponent();
            if (this.tree.getLastSelectedPathComponent() != null && object instanceof DefaultKingdeeTreeNode) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)object;
                EntityViewInfo treeCondition = this.getEntityViewInfo(this.getEntityViewInfo(node));
                if (execCondition.getFilter() != null && execCondition.getFilter().getFilterItems().size() > 0) {
                    if (treeCondition.getFilter() != null && treeCondition.getFilter().getFilterItems().size() > 0) {
                        execCondition.getFilter().mergeFilter(treeCondition.getFilter(), "AND");
                    }
                } else if (treeCondition.getFilter() != null && treeCondition.getFilter().getFilterItems().size() > 0) {
                    execCondition.setFilter(treeCondition.getFilter());
                }
            }
            IQueryExecutor queryExecutor = super.getQueryExecutor(queryPK, execCondition);
            return queryExecutor;
        }
        catch (BOSException e) {
            this.handUIException(e);
            return null;
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        super.refresh(e);
    }

    private void showAlert() {
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"bizObjectIsNotSelected"));
        this.abort();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        if (this.btnAddNew.equals(e.getSource()) || this.menuItemAddNew.equals(e.getSource())) {
            Object object = this.tree.getLastSelectedPathComponent();
            if (object != null && object instanceof DefaultKingdeeTreeNode) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)object;
                Object userObject = node.getUserObject();
                if (node.isLeaf() && userObject instanceof BizObjectForRoleInfo) {
                    BizObjectForRoleInfo mdbInfo = (BizObjectForRoleInfo)userObject;
                    uiContext.put((Object)BIZ_OBJECT_INDEX, (Object)mdbInfo.getNumber());
                } else if (node.isLeaf() && userObject instanceof MetaDataBriefInfo) {
                    MetaDataBriefInfo mdbInfo = (MetaDataBriefInfo)userObject;
                    uiContext.put((Object)BIZ_OBJECT_INDEX, (Object)mdbInfo.getBOType().toString());
                } else {
                    this.showAlert();
                }
            } else {
                this.showAlert();
            }
        } else if (this.btnEdit.equals(e.getSource()) || this.btnView.equals(e.getSource())) {
            int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
            String bizObject = (String)this.tblMain.getRow(rowIndex).getCell(BIZ_OBJECT_INDEX).getValue();
            uiContext.put((Object)BIZ_OBJECT_INDEX, (Object)bizObject);
        }
        uiContext.put((Object)"ctrlUnitPK", (Object)this.getCtrlUnitPK());
    }

    @Override
    protected void tblMain_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        super.tblMain_activeCellChanged(e);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        try {
            return CUHelper.getCuFilterByUser(this.getCurrentUser());
        }
        catch (Exception be) {
            logger.error((Object)"", (Throwable)be);
            this.handleException(be);
            return super.getDefaultFilterForQuery();
        }
    }

    private void addKeyFunction() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke("F10"), "getEntityWithoutQuery");
        this.getActionMap().put("getEntityWithoutQuery", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringBuffer entitys = new StringBuffer();
                DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)RuleListUI.this.tree.getModel().getRoot();
                this.getEntityWithoutQuery(entitys, root);
                logger.info((Object)("-----------------------------------start-----------------------------------\n" + entitys.toString() + "-------------------------------------end----------------------------------\n"));
            }

            private void getEntityWithoutQuery(StringBuffer entitys, DefaultKingdeeTreeNode node) {
                if (!node.isLeaf()) {
                    Enumeration children = node.children();
                    while (children.hasMoreElements()) {
                        DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)children.nextElement();
                        if (!child.isLeaf()) {
                            this.getEntityWithoutQuery(entitys, child);
                            continue;
                        }
                        MetaDataBriefInfo mdbriefInfo = (MetaDataBriefInfo)child.getUserObject();
                        String bosType = mdbriefInfo.getBOType().toString();
                        EntityObjectInfo entity = null;
                        try {
                            entity = this.getEntity(bosType);
                        }
                        catch (Exception e) {
                            logger.info((Object)("The following bosType does not exist:" + bosType));
                            continue;
                        }
                        String query = entity.getExtendedProperty("defaultF7Query");
                        if (!this.isBaseData(entity) || StringUtils.isEmpty((String)query)) continue;
                        entitys.append(entity.getFullName());
                        entitys.append("   " + PermissionResUtil.getResource("res_97"));
                        entitys.append(entity.getAlias());
                        entitys.append("\n");
                    }
                }
            }

            private EntityObjectInfo getEntity(String bosType) {
                IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                return loader.getEntity(BOSObjectType.create((String)bosType));
            }

            private boolean isBaseData(EntityObjectInfo entity) {
                String packageString = entity.getPackage();
                return packageString != null && packageString.indexOf("com.kingdee.eas.basedata") == 0;
            }
        });
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.setMustQueryAtFirst(true);
        return this.qfsi.supportExecutionWithoutFilters();
    }

    protected QuickFilteringSupportManager createQuickFilteringSupportManager() throws Exception {
        QuickFilteringSupportItems qfsi = this.getQuickFilteringSupport();
        if (qfsi != null && this.getBizType() != null) {
            qfsi.setBosType(this.getBizType().toString());
        }
        return new QuickFilteringSupportManager((ListUI)this, qfsi, (Component)this.splRule);
    }

    public void refreshList() throws Exception {
        int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        super.refreshList();
        if (selectedRows.length > 0) {
            KDTableUtil.setSelectedRow((KDTable)this.tblMain, (int)selectedRows[0]);
            this.tblMain.getLayoutManager().scrollRowToShow(selectedRows[0]);
        }
    }
}

