/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IServerConfigFileCache;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.ServerConfigFileFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractUsbKeyToolUI;
import com.kingdee.eas.base.permission.service.helper.UsbKeyPermissionServiceHelper;
import com.kingdee.eas.base.permission.service.helper.UsbKeyProxy;
import com.kingdee.eas.util.CryptException;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class UsbKeyToolUI
extends AbstractUsbKeyToolUI {
    private static final Logger logger = CoreUIObject.getLogger(UsbKeyToolUI.class);
    private static String USB_RESOURCE_FILENAME = "com.kingdee.eas.base.permission.PermissionUsbKeyResource";

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        super.actionClose_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    public void actionTest_actionPerformed(ActionEvent e) throws Exception {
        super.actionTest_actionPerformed(e);
        if (this.pmtUser.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)USB_RESOURCE_FILENAME, (String)"USER_IS_NOT_NULL"));
            return;
        }
        if (StringUtils.isEmpty((String)this.txtSourceStr.getText())) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)USB_RESOURCE_FILENAME, (String)"ENCRYPT_TXT_ISEMPTY"));
            return;
        }
        UsbKeyPermissionServiceHelper helper = new UsbKeyPermissionServiceHelper();
        try {
            helper.checkUsbKeyPermission(null, ((UserInfo)this.pmtUser.getData()).getId().toString());
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)USB_RESOURCE_FILENAME, (String)"VERIFY_RIGHT"));
        }
        catch (PermissionException pe) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)((Object)pe));
        }
    }

    private String encryptStr() throws CryptException {
        if (StringUtils.isEmpty((String)this.txtSourceStr.getText())) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)USB_RESOURCE_FILENAME, (String)"ENCRYPT_TXT_ISEMPTY"));
            return "";
        }
        return CryptoTean.encrypt((String)"", (String)this.txtSourceStr.getText());
    }

    @Override
    public void actionConfig_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfig_actionPerformed(e);
        if (StringUtils.isEmpty((String)this.txtSourceStr.getText())) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)USB_RESOURCE_FILENAME, (String)"ENCRYPT_TXT_ISEMPTY"));
            return;
        }
        IServerConfigFileCache serverConfig = ServerConfigFileFactory.getRemoteInstance();
        boolean restart = serverConfig.buildServerFile(this.encryptStr());
        if (restart) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)USB_RESOURCE_FILENAME, (String)"RESTART_SERVER"));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)USB_RESOURCE_FILENAME, (String)"CONFIG_SUCCESS"));
        }
    }

    @Override
    public void actionMakeUsb_actionPerformed(ActionEvent e) throws Exception {
        super.actionMakeUsb_actionPerformed(e);
        if (!StringUtils.isEmpty((String)this.txtSourceStr.getText().trim())) {
            if (this.pmtUser.getData() == null) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)USB_RESOURCE_FILENAME, (String)"USER_IS_NOT_NULL"));
                return;
            }
        } else {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)USB_RESOURCE_FILENAME, (String)"ENCRYPT_TXT_ISEMPTY"));
            return;
        }
        UserInfo userInfo = (UserInfo)this.pmtUser.getData();
        String userEncryptTxt = CryptoTean.encrypt(null, (String)(userInfo.getId().toString() + this.txtSourceStr.getText()));
        UsbKeyProxy usbKeyProxy = new UsbKeyProxy();
        usbKeyProxy.write(userEncryptTxt);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)USB_RESOURCE_FILENAME, (String)"WRITE_USB_SUCCESS"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUserListF7();
    }

    private void initUserListF7() {
        if (this.pmtUser == null) {
            this.pmtUser = new KDBizPromptBox();
        }
        this.pmtUser.setQueryInfo("com.kingdee.eas.base.permission.app.UserListQuery");
        this.pmtUser.setEditFormat("$name$");
        this.pmtUser.setCommitFormat("$name$");
        this.pmtUser.setDisplayFormat("$number$($name$)");
    }
}

