/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.WindowState4NivigationEnum;
import com.kingdee.eas.base.permission.client.AbstractUserDiscreteAccreditBatchOneUI;
import com.kingdee.eas.base.permission.client.DiscreteAccreditManager;
import com.kingdee.eas.base.permission.client.DiscreteDataContext;
import com.kingdee.eas.base.permission.client.IDiscreteAccreditProvider;
import com.kingdee.eas.base.permission.client.IDiscreteDataSelector;
import com.kingdee.eas.base.permission.client.QueryHelperInfo;
import com.kingdee.eas.base.permission.client.helper.DiscreteAcreditHelper;
import com.kingdee.eas.base.permission.client.helper.OrgHelper;
import com.kingdee.eas.base.permission.client.nivigate.INivigationNeedUI;
import com.kingdee.eas.base.permission.client.util.TableHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.uihelper.OrgTypeClientCenter;
import com.kingdee.eas.basedata.org.client.uihelper.OrgTypeClientDefaultImpl;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class UserDiscreteAccreditBatchOneUI
extends AbstractUserDiscreteAccreditBatchOneUI
implements INivigationNeedUI {
    private static final Logger logger = CoreUIObject.getLogger(UserDiscreteAccreditBatchOneUI.class);
    private DiscreteDataContext ctx = null;
    private IDiscreteAccreditProvider discreteAccreditProvider = null;
    private TableHelper tableHelper = null;
    private boolean onloadOver = false;
    private boolean needClearCache = false;
    private WindowState4NivigationEnum curWinState;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCtx();
        this.initUI();
        this.initOrg();
        this.initTable();
        this.onloadOver = true;
    }

    private void initTable() {
        QueryHelperInfo queryHelperInfo = new QueryHelperInfo();
        queryHelperInfo.setIMetaDataPK(this.discreteAccreditProvider.getQueryPK());
        String formatXml = null;
        this.tblBizObjDataTable.setFormatXml(formatXml);
        this.tableHelper = new TableHelper(queryHelperInfo, this.tblBizObjDataTable);
        this.tableHelper.fillTableHeader();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ToolUtils.aryToStr(this.ctx.getUserDiscreteAccreditBatchInfo().getBizObjIdList(), false), CompareType.INCLUDE));
        this.tableHelper.setFilterInfo(filterInfo);
        this.tableHelper.deal();
        this.tableHelper.setNeedRequestData(true);
        this.tblBizObjDataTable.removeRows();
        this.tableHelper.setNeedRequestData(false);
    }

    private void initCtx() {
        this.ctx = (DiscreteDataContext)this.getUIContext().get(DiscreteDataContext.class.getName());
        this.discreteAccreditProvider = DiscreteAccreditManager.getInstace().getProvider(BOSObjectType.create((String)this.ctx.getBizObjType()));
    }

    private void initOrg() throws EASBizException, BOSException {
        this.pmtOrg.setSelector((KDPromptSelector)this.getOrgF7());
        this.pmtOrg.setData((Object)SysContext.getSysContext().getCurrentOrgUnit().castToFullOrgUnitInfo());
        this.pmtOrg.setEditable(false);
    }

    private NewOrgViewF7PromptDialog getOrgF7() throws EASBizException, BOSException {
        OrgType orgType = OrgHelper.getBizObjectOrgType(BOSObjectType.create((String)this.ctx.getBizObjType()));
        OrgTypeClientDefaultImpl clientHelper = (OrgTypeClientDefaultImpl)OrgTypeClientCenter.getInstance().getClientImp(orgType);
        NewOrgViewF7PromptDialog orgF7 = clientHelper.createNewF7ByCondition("TREETYPE_ORDINARY");
        this.pmtOrg.setSelector((KDPromptSelector)orgF7);
        if (!OrgType.NONE.equals((Object)orgType)) {
            OrgHelper.setF7ByUser(orgF7);
        }
        orgF7.setMultiSelect(false);
        return orgF7;
    }

    private void initUI() {
        Icon bg = EASResource.getIcon((String)"imgGuide_pic338");
        this.lblFirstImg.setIcon(bg);
        Icon addIcon = EASResource.getIcon((String)"imgTbtn_addline");
        this.btnAdd.setText(null);
        this.btnAdd.setIcon(addIcon);
        Icon removeIcon = EASResource.getIcon((String)"imgTbtn_deleteline");
        this.btnDelete.setText(null);
        this.btnDelete.setIcon(removeIcon);
        if (!DiscreteAcreditHelper.isAddOperator(this.ctx)) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"userDiscreteOneTitle"));
        }
    }

    private IDiscreteDataSelector getBizDataDialog() throws Exception {
        IDiscreteDataSelector selector = this.discreteAccreditProvider.getSelector(this.getCurrentUserPK(), this.getSelectedOrgPK(), (IUIObject)this);
        return selector;
    }

    @Override
    public void actionAddBizData_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddBizData_actionPerformed(e);
        IDiscreteDataSelector dlg = this.getBizDataDialog();
        if (dlg instanceof KDCommonPromptDialog) {
            ((KDCommonPromptDialog)dlg).setHasHideQuichFilterPanel(true);
        }
        dlg.show();
        if (!dlg.isCanceled()) {
            Object data = dlg.getData();
            this.tableHelper.addRow(data);
        }
    }

    @Override
    public void actionDelBizData_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblBizObjDataTable.getSelectManager().size() == 0) {
            return;
        }
        this.tableHelper.removeRow(e);
    }

    private IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
    }

    private IObjectPK getSelectedOrgPK() {
        if (this.pmtOrg.getData() == null) {
            return null;
        }
        return new ObjectUuidPK(((OrgUnitInfo)this.pmtOrg.getData()).getId());
    }

    @Override
    protected void pmtOrg_dataChanged(DataChangeEvent e) throws Exception {
        super.pmtOrg_dataChanged(e);
        if (this.onloadOver) {
            this.tblBizObjDataTable.removeRows();
            this.needClearCache = true;
        }
        if (this.pmtOrg.getData() != null) {
            this.ctx.setCurOrg(((OrgUnitInfo)this.pmtOrg.getData()).castToFullOrgUnitInfo());
        }
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        if (this.checkDataOK()) {
            this.setCtxData();
            this.destroyWindow();
            this.setWindowState(WindowState4NivigationEnum.NEXT);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionResource", (String)"pleaseSelectDataFirst"));
        }
    }

    private boolean checkDataOK() {
        if (this.pmtOrg.getData() == null) {
            return false;
        }
        return this.tblBizObjDataTable.getRowCount() != 0;
    }

    private void setCtxData() {
        Set allIdSet = this.tableHelper.getAllBizDataIDs();
        this.ctx.getUserDiscreteAccreditBatchInfo().setBizObjIdList(ToolUtils.trans2List(allIdSet));
        this.ctx.setCurOrg(((OrgUnitInfo)this.pmtOrg.getData()).castToFullOrgUnitInfo());
    }

    @Override
    public void actionQuit_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuit_actionPerformed(e);
        this.setWindowState(WindowState4NivigationEnum.CLOSE);
        this.destroyWindow();
    }

    public void setWindowState(WindowState4NivigationEnum windowState) {
        this.curWinState = windowState;
    }

    @Override
    public WindowState4NivigationEnum getWindowState() {
        return this.curWinState;
    }

    @Override
    public boolean isNeedClearCache() {
        return this.needClearCache;
    }

    public boolean destroyWindow() {
        boolean result = super.destroyWindow();
        this.setWindowState(WindowState4NivigationEnum.CLOSE);
        return result;
    }
}

