/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.WindowState4NivigationEnum;
import com.kingdee.eas.base.permission.client.AbstractUserDiscreteAccreditBatchThreeUI;
import com.kingdee.eas.base.permission.client.DiscreteAccreditManager;
import com.kingdee.eas.base.permission.client.DiscreteDataContext;
import com.kingdee.eas.base.permission.client.IDiscreteAccreditProvider;
import com.kingdee.eas.base.permission.client.helper.DiscreteAcreditHelper;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.client.nivigate.INivigationNeedUI;
import com.kingdee.eas.base.permission.client.nivigate.NivigationCtx;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class UserDiscreteAccreditBatchThreeUI
extends AbstractUserDiscreteAccreditBatchThreeUI
implements INivigationNeedUI {
    private static final Logger logger = CoreUIObject.getLogger(UserDiscreteAccreditBatchThreeUI.class);
    private DiscreteDataContext ctx = null;
    private IDiscreteAccreditProvider discreteAccreditProvider = null;
    private WindowState4NivigationEnum curWinState;
    private boolean needClearCache = false;
    private Map depPermItems = null;
    private Map beenDepPermItems = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCtx();
        this.initUI();
        this.loadPermItems();
    }

    private void initCtx() {
        this.ctx = (DiscreteDataContext)this.getUIContext().get(DiscreteDataContext.class.getName());
        this.discreteAccreditProvider = DiscreteAccreditManager.getInstace().getProvider(BOSObjectType.create((String)this.ctx.getBizObjType()));
    }

    private void loadPermItems() throws EASBizException, BOSException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        Set permItemNames = (Set)iPermission.getConfigurationInfo().getDiscretEntityPermItems().get(this.ctx.getBizObjType());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", new HashSet(permItemNames), CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("enableDataPermission", (Object)new Integer(1)));
        entityViewInfo.setFilter(filterInfo);
        IPermItem iPermItem = PermItemFactory.getRemoteInstance();
        PermItemCollection permItems = iPermItem.getPermItemCollection(entityViewInfo);
        this.pnlMain.setLayout((LayoutManager)new FlowLayout());
        HashSet<ObjectUuidPK> setPermItemPK = new HashSet<ObjectUuidPK>();
        int size = permItems.size();
        for (int i = 0; i < size; ++i) {
            PermItemInfo permItemInfo = permItems.get(i);
            this.pnlMain.add((Component)this.createBox(permItemInfo));
            setPermItemPK.add(new ObjectUuidPK(permItemInfo.getId()));
        }
        ObjectUuidPK[] permItemPKs = setPermItemPK.toArray(new ObjectUuidPK[setPermItemPK.size()]);
        this.depPermItems = iPermItem.getDepPermItems((IObjectPK[])permItemPKs);
        this.beenDepPermItems = iPermItem.getBeenDepPermItems((IObjectPK[])permItemPKs);
    }

    private KDCheckBox createBox(PermItemInfo permItemInfo) {
        KDCheckBox checkBox = new KDCheckBox(permItemInfo.getAlias());
        checkBox.setText(permItemInfo.getAlias());
        checkBox.setUserObject((Object)permItemInfo);
        checkBox.setBounds(new Rectangle(80, 66, 140, 19));
        this.grpCheckbox.add((AbstractButton)checkBox);
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                UserDiscreteAccreditBatchThreeUI.this.processDepCheckBox(e);
            }
        });
        return checkBox;
    }

    private void initUI() {
        Icon bg = EASResource.getIcon((String)"imgGuide_pic338");
        this.lblthreeImg.setIcon(bg);
        Icon SelectAllIcon = EASResource.getIcon((String)"imgTbtn_selectall");
        this.btnSelectAll.setText(null);
        this.btnSelectAll.setIcon(SelectAllIcon);
        Icon SelectNoneAllIcon = EASResource.getIcon((String)"imgTbtn_deleteall");
        this.btnDeleteAll.setText(null);
        this.btnDeleteAll.setIcon(SelectNoneAllIcon);
        if (!DiscreteAcreditHelper.isAddOperator(this.ctx)) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"userDiscreteThreeTitle"));
            this.kDLabel2.setText(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"userDiscreteThreeLable"));
        }
    }

    @Override
    public void actionBefore_actionPerformed(ActionEvent e) throws Exception {
        super.actionBefore_actionPerformed(e);
        this.destroyWindow();
        this.setWindowState(WindowState4NivigationEnum.BEFORE);
    }

    @Override
    public void actionFinish_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkDataOK()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionResource", (String)"pleaseSelectDataFirst"));
            return;
        }
        LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
        dialog.setLongTimeTask(new ILongTimeTask(){

            @Override
            public Object exec() throws Exception {
                UserDiscreteAccreditBatchThreeUI.this.finish();
                return "";
            }

            @Override
            public void afterExec(Object result) throws Exception {
            }
        });
        this.setWindowState(WindowState4NivigationEnum.FINISH);
        dialog.show();
    }

    private void finish() {
        this.setCtxData();
        this.destroyWindow();
        this.setWindowState(WindowState4NivigationEnum.FINISH);
    }

    private boolean checkDataOK() {
        List selectPermSet = this.getSelectPermItem();
        return selectPermSet != null && !selectPermSet.isEmpty();
    }

    private void setCtxData() {
        this.ctx.getUserDiscreteAccreditBatchInfo().setPermItemIdList(this.getSelectPermItem());
    }

    @Override
    public void actionQuit_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuit_actionPerformed(e);
        this.setWindowState(WindowState4NivigationEnum.CLOSE);
        this.destroyWindow();
    }

    @Override
    public void actionDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteAll_actionPerformed(e);
        this.setCheckBoxState(false);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        this.setCheckBoxState(true);
    }

    private void setCheckBoxState(boolean isSelectAll) {
        Enumeration enumer = this.grpCheckbox.getElements();
        while (enumer.hasMoreElements()) {
            KDCheckBox tempBox = (KDCheckBox)enumer.nextElement();
            tempBox.setSelected(isSelectAll);
        }
    }

    private List getSelectPermItem() {
        ArrayList<String> selectPermSet = new ArrayList<String>();
        ArrayList beenDepPermSelectSet = new ArrayList();
        Enumeration enumer = this.grpCheckbox.getElements();
        while (enumer.hasMoreElements()) {
            KDCheckBox tempBox = (KDCheckBox)enumer.nextElement();
            if (!tempBox.isSelected()) continue;
            String permItemId = ((PermItemInfo)tempBox.getUserObject()).getId().toString();
            selectPermSet.add(permItemId);
            PermItemCollection collection = (PermItemCollection)((Object)this.depPermItems.get(permItemId));
            beenDepPermSelectSet.addAll(ToolUtils.transCol2ListByPeroperty((IObjectCollection)collection, new IObjectCol2List(){

                @Override
                public String getList(Object obj) {
                    PermItemInfo permItemInfo = (PermItemInfo)obj;
                    if (permItemInfo != null && permItemInfo.getId() != null) {
                        return permItemInfo.getId().toString();
                    }
                    return null;
                }
            }));
        }
        for (int i = 0; i < beenDepPermSelectSet.size(); ++i) {
            if (selectPermSet.contains(beenDepPermSelectSet.get(i))) continue;
            selectPermSet.add((String)beenDepPermSelectSet.get(i));
        }
        return selectPermSet;
    }

    public void setWindowState(WindowState4NivigationEnum windowSatate) {
        NivigationCtx.getInstance().setCurWindowState(windowSatate);
        this.curWinState = windowSatate;
    }

    @Override
    public WindowState4NivigationEnum getWindowState() {
        return this.curWinState;
    }

    @Override
    public boolean isNeedClearCache() {
        return this.needClearCache;
    }

    public boolean destroyWindow() {
        boolean result = super.destroyWindow();
        this.setWindowState(WindowState4NivigationEnum.CLOSE);
        return result;
    }

    private void processDepCheckBox(ItemEvent e) {
        block6: {
            PermItemInfo permItemInfo;
            block5: {
                KDCheckBox checkBox = (KDCheckBox)e.getSource();
                permItemInfo = (PermItemInfo)checkBox.getUserObject();
                if (!checkBox.isSelected()) break block5;
                if (!this.depPermItems.containsKey(permItemInfo.getId().toString())) break block6;
                PermItemCollection collection = (PermItemCollection)((Object)this.depPermItems.get(permItemInfo.getId().toString()));
                int size = collection.size();
                for (int i = 0; i < size; ++i) {
                    Enumeration iterator = this.grpCheckbox.getElements();
                    while (iterator.hasMoreElements()) {
                        KDCheckBox box = (KDCheckBox)iterator.nextElement();
                        PermItemInfo info = (PermItemInfo)box.getUserObject();
                        if (!info.getId().equals((Object)collection.get(i).getId())) continue;
                        box.setSelected(true);
                    }
                }
                break block6;
            }
            if (this.beenDepPermItems.containsKey(permItemInfo.getId().toString())) {
                PermItemCollection collection = (PermItemCollection)((Object)this.beenDepPermItems.get(permItemInfo.getId().toString()));
                int size = collection.size();
                for (int i = 0; i < size; ++i) {
                    Enumeration iterator = this.grpCheckbox.getElements();
                    while (iterator.hasMoreElements()) {
                        KDCheckBox box = (KDCheckBox)iterator.nextElement();
                        PermItemInfo info = (PermItemInfo)box.getUserObject();
                        if (!info.getId().equals((Object)collection.get(i).getId()) || !box.isSelected()) continue;
                        box.setSelected(false);
                    }
                }
            }
        }
    }
}

