/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.ConfigurationInfo;
import com.kingdee.eas.base.permission.DiscretePermCollection;
import com.kingdee.eas.base.permission.DiscretePermInfo;
import com.kingdee.eas.base.permission.DiscretePermissionFactory;
import com.kingdee.eas.base.permission.IDiscretePermission;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractUserDiscreteAccreditUI;
import com.kingdee.eas.base.permission.client.DiscreteAccreditManager;
import com.kingdee.eas.base.permission.client.IDiscreteAccreditProvider;
import com.kingdee.eas.base.permission.client.IDiscreteDataSelector;
import com.kingdee.eas.base.permission.client.PermItemCheckBoxGroup;
import com.kingdee.eas.base.permission.client.discreteImpl.DiscreteViewFactory;
import com.kingdee.eas.base.permission.client.discreteImpl.DiscreteViewPermissionHelper;
import com.kingdee.eas.base.permission.client.helper.OrgHelper;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.util.CacheUtil;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.uihelper.OrgTypeClientCenter;
import com.kingdee.eas.basedata.org.client.uihelper.OrgTypeClientDefaultImpl;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.StringEnum;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UserDiscreteAccreditUI
extends AbstractUserDiscreteAccreditUI {
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    public static final String BOS_OBJECT_TYPE = "bosObjectType";
    public static final String TARGET_USER_PK = "targetUserPK";
    private static final String INDEX_COLUMN_NAME = "index_" + System.currentTimeMillis();
    private BOSObjectType bizObjectType = null;
    private QueryInfo bizQuery = null;
    private IObjectPK targetUserPK = null;
    private PermItemCheckBoxGroup checkBoxGroup = new PermItemCheckBoxGroup();
    private Set authorizedBizDatas = null;
    private Set accreditBizDatas = null;
    private Map depPermItems = null;
    private Map beenDepPermItems = null;
    private Map addDiscretePerms = new HashMap();
    private Map removeDiscretePerms = new HashMap();
    private Map updateDiscretePerms = new HashMap();
    private IDiscreteAccreditProvider discreteAccreditProvider = null;
    private int virtualIndex = 0;
    boolean isFiristGetData = true;
    boolean isModify = false;
    private DiscreteViewPermissionHelper viewHelper = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadUIContext();
        this.initUI();
        this.setStatus();
    }

    private void setStatus() {
        boolean canModify = OprtState.EDIT.equals(this.getOprtState());
        this.actionSubmit.setEnabled(canModify);
        this.actionAddBizData.setVisible(canModify);
        this.actionRemoveBizData.setVisible(canModify);
        this.checkBoxGroup.setAllEnable(false);
    }

    protected void initWorkButton() {
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    private void loadUIContext() {
        if (this.getUIContext().get(BOS_OBJECT_TYPE) == null) {
            throw new IllegalArgumentException("discreteAccreditContext can not be NULL.");
        }
        this.bizObjectType = (BOSObjectType)this.getUIContext().get(BOS_OBJECT_TYPE);
        this.viewHelper = DiscreteViewFactory.create(this.bizObjectType.toString());
        this.discreteAccreditProvider = DiscreteAccreditManager.getInstace().getProvider(this.bizObjectType);
        this.bizQuery = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.discreteAccreditProvider.getQueryPK());
        this.targetUserPK = (IObjectPK)this.getUIContext().get(TARGET_USER_PK);
    }

    private void initUI() throws EASBizException, BOSException {
        this.initUserF7();
        this.initBizDataContainer();
        this.initPermItemPanel();
    }

    private void initBizDataContainer() {
        JButton btnAddBizData = this.contBizData.add((Action)((Object)this.actionAddBizData));
        JButton btnRemoveBizData = this.contBizData.add((Action)((Object)this.actionRemoveBizData));
        btnAddBizData.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        btnRemoveBizData.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.actionAddBizData.setEnabled(false);
        this.actionRemoveBizData.setEnabled(false);
        this.initTable();
    }

    private void initPermItemPanel() throws EASBizException, BOSException {
        this.pnlPermItem.setLayout((LayoutManager)new FlowLayout(3));
        this.loadPermItems();
    }

    private void loadPermItems() throws EASBizException, BOSException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        Set permItemNames = (Set)iPermission.getConfigurationInfo().getDiscretEntityPermItems().get(this.bizObjectType.toString());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", new HashSet(permItemNames), CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("enableDataPermission", (Object)new Integer(1)));
        entityViewInfo.setFilter(filterInfo);
        IPermItem iPermItem = PermItemFactory.getRemoteInstance();
        PermItemCollection permItems = iPermItem.getPermItemCollection(entityViewInfo);
        HashSet setPermItemPK = new HashSet();
        this.viewHelper.loadPermItem(permItems, this.checkBoxGroup, this.pnlPermItem, setPermItemPK);
        this.checkBoxGroup.addAllChangeListener(new CheckBoxChangeListener());
        ObjectUuidPK[] permItemPKs = setPermItemPK.toArray(new ObjectUuidPK[setPermItemPK.size()]);
        this.depPermItems = iPermItem.getDepPermItems((IObjectPK[])permItemPKs);
        this.beenDepPermItems = iPermItem.getBeenDepPermItems((IObjectPK[])permItemPKs);
    }

    protected void checkBoxChanged(ChangeEvent e) {
        if (this.table.getSelectManager().size() == 0) {
            return;
        }
        this.processDepCheckBox(e);
        try {
            Set bizDataIDs = this.getSelectedBizDataIDs();
            for (BOSUuid bizDataID : bizDataIDs) {
                if (this.getAuthorizedBizDatas().contains(bizDataID)) {
                    if (this.checkBoxGroup.hasSelected()) {
                        this.updateDiscretePerms.put(bizDataID, this.getCurrentDDPs(bizDataID, false));
                        this.removeDiscretePerms.remove(bizDataID);
                    } else {
                        this.removeDiscretePerms.put(bizDataID, this.getCurrentDDPs(bizDataID, true));
                        this.updateDiscretePerms.remove(bizDataID);
                    }
                } else if (this.checkBoxGroup.hasSelected()) {
                    this.addDiscretePerms.put(bizDataID, this.getCurrentDDPs(bizDataID, false));
                } else {
                    this.addDiscretePerms.remove(bizDataID);
                }
                if (this.isModify) continue;
                this.isModify = true;
            }
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    public boolean checkBeforeWindowClosing() {
        if (this.isModify) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                this.checkBeforeSumbit();
                try {
                    ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                    this.actionSubmit.actionPerformed(event);
                    return true;
                }
                catch (Exception exc) {
                    this.handUIException(exc);
                    return false;
                }
            }
            return result == 1;
        }
        return super.checkBeforeWindowClosing();
    }

    private void processDepCheckBox(ChangeEvent e) {
        block6: {
            PermItemInfo permItemInfo;
            block5: {
                KDCheckBox checkBox = (KDCheckBox)e.getSource();
                permItemInfo = (PermItemInfo)checkBox.getUserObject();
                if (!checkBox.isSelected()) break block5;
                if (!this.depPermItems.containsKey(permItemInfo.getId().toString())) break block6;
                PermItemCollection collection = (PermItemCollection)((Object)this.depPermItems.get(permItemInfo.getId().toString()));
                int size = collection.size();
                for (int i = 0; i < size; ++i) {
                    Iterator iterator = this.checkBoxGroup.iterator();
                    while (iterator.hasNext()) {
                        KDCheckBox box = (KDCheckBox)iterator.next();
                        PermItemInfo info = (PermItemInfo)box.getUserObject();
                        if (!info.getId().equals((Object)collection.get(i).getId())) continue;
                        box.setSelected(true);
                    }
                }
                break block6;
            }
            if (this.beenDepPermItems.containsKey(permItemInfo.getId().toString())) {
                PermItemCollection collection = (PermItemCollection)((Object)this.beenDepPermItems.get(permItemInfo.getId().toString()));
                int size = collection.size();
                for (int i = 0; i < size; ++i) {
                    Iterator iterator = this.checkBoxGroup.iterator();
                    while (iterator.hasNext()) {
                        KDCheckBox box = (KDCheckBox)iterator.next();
                        PermItemInfo info = (PermItemInfo)box.getUserObject();
                        if (!info.getId().equals((Object)collection.get(i).getId()) || !box.isSelected()) continue;
                        box.setSelected(false);
                    }
                }
            }
        }
    }

    private NewOrgViewF7PromptDialog getOrgF7() throws EASBizException, BOSException {
        OrgType orgType = OrgHelper.getBizObjectOrgType(this.bizObjectType);
        OrgTypeClientDefaultImpl clientHelper = (OrgTypeClientDefaultImpl)OrgTypeClientCenter.getInstance().getClientImp(orgType);
        NewOrgViewF7PromptDialog orgF7 = clientHelper.createNewF7ByCondition("TREETYPE_ORDINARY");
        this.pmtOrg.setSelector((KDPromptSelector)orgF7);
        this.pmtOrg.setEditable(false);
        this.viewHelper.setF7FilterInfo(orgF7, orgType, this.getSelectedUserPK());
        return orgF7;
    }

    private void initUserF7() throws BOSException, EASBizException {
        if (this.targetUserPK != null) {
            IUser iUser = UserFactory.getRemoteInstance();
            UserInfo userInfo = iUser.getUserInfo(this.targetUserPK);
            this.pmtUser.setData((Object)userInfo);
            this.pmtUser.setEnabled(false);
        } else {
            IObjectPK currentUserPK = this.getCurrentUserPK();
            this.pmtUser.setEntityViewInfo(this.getUserCondition(currentUserPK));
            this.pmtUser.setEnabledMultiSelection(false);
            this.pmtOrg.setEnabled(false);
        }
    }

    private EntityViewInfo getUserCondition(IObjectPK currentUserPK) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter = Administrator.isCUAdmin(null, currentUserPK) ? this.getAdminUserCondition(currentUserPK, true) : (Administrator.isBizAdmin(null, currentUserPK) ? this.getAdminUserCondition(currentUserPK, false) : this.getCommonUserCondition(currentUserPK));
        filter.mergeFilter(this.getAdminExceptFilter(), "and");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filter);
        return entityViewInfo;
    }

    private FilterInfo getCommonUserCondition(IObjectPK currentUserPK) {
        FilterInfo filter = new FilterInfo();
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT DISTINCT FUserID FROM T_PM_OrgRange ").append(" WHERE FOrgID IN (SELECT FOrgID FROM T_PM_OrgRange ").append(" WHERE FUserID = '").append(currentUserPK).append("' ").append(" AND FType = ").append(10).append(") ").append(" AND FType = ").append(10).append(" ").append(" AND FUserID <> '").append(currentUserPK.toString()).append("' ");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)buffer.toString(), CompareType.INNER));
        return filter;
    }

    private FilterInfo getAdminUserCondition(IObjectPK currentUserPK, boolean isCUAdmin) throws BOSException, EASBizException {
        List manageCuIDList = null;
        manageCuIDList = isCUAdmin ? PermissionRangeHelper.getUserOrgId(null, currentUserPK, OrgRangeType.BIZ_ORG_TYPE) : PermissionRangeHelper.getUserOrgId(null, currentUserPK, OrgRangeType.MANAGE_ORG_TYPE);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ToolUtils.aryToStr((List)manageCuIDList), CompareType.INNER));
        return filterInfo;
    }

    private FilterInfo getAdminExceptFilter() {
        return Administrator.getNotAdminUserFilter();
    }

    private void initTable() {
        this.contBizData.getContentPane().add((Component)this.table, "Center");
        this.table.getStyleAttributes().setLocked(true);
        this.table.getSelectManager().setSelectMode(10);
        this.table.getDataRequestManager().setDataRequestMode(1);
        this.table.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                UserDiscreteAccreditUI.this.requestRowSet(e);
            }
        });
        this.table.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                UserDiscreteAccreditUI.this.updateIndexColumn();
            }
        });
        this.fillTableHeader();
    }

    private void fillTableHeader() {
        String IS_VISIBLE_FOR_KDTABLE = "isVisibleForKDTable";
        String COL_WIDTH_IN_KDTABLE = "colWidthInKDTable";
        String DISPLAY_FORMAT = "displayFormat";
        String QUERY = "query";
        this.table.setRefresh(false);
        String testStr = null;
        this.table.setFormatXml(testStr);
        SelectorInfo selector = this.bizQuery.getSelector();
        int size = selector.getFields().size();
        QueryFieldInfo field = null;
        String[] bindContents = new String[size];
        Map exProperties = this.bizQuery.getExtendedProperties();
        for (int i = 0; i < size; ++i) {
            String colFormat;
            IColumn col = this.table.addColumn();
            field = (QueryFieldInfo)selector.getFields().get(i);
            exProperties = field.getExtendedProperties();
            bindContents[i] = field.getName();
            col.setKey(bindContents[i]);
            if (exProperties == null) continue;
            Object objectVisible = exProperties.get("isVisibleForKDTable");
            boolean visible = true;
            if (objectVisible instanceof Boolean) {
                visible = (Boolean)objectVisible;
            } else if (objectVisible instanceof String) {
                visible = objectVisible == null ? true : Boolean.valueOf((String)objectVisible);
            }
            col.getStyleAttributes().setHided(!visible);
            Object objectColWidth = exProperties.get("colWidthInKDTable");
            if (objectColWidth == null) {
                objectColWidth = "-1";
            }
            int colWidth = 100;
            if (objectColWidth instanceof Integer) {
                colWidth = (Integer)objectColWidth;
            } else if (objectColWidth instanceof String) {
                colWidth = Integer.parseInt((String)objectColWidth);
            }
            col.setWidth(colWidth);
            Object objColFormat = exProperties.get("displayFormat");
            if (!(objColFormat instanceof String) || StringUtils.isEmpty((String)(colFormat = (String)objColFormat))) continue;
            col.getStyleAttributes().setNumberFormat(colFormat);
        }
        this.table.putBindContents("query", bindContents);
        this.table.checkParsed(true);
        IRow row = this.table.addHeadRow();
        for (int i = 0; i < size; ++i) {
            field = (QueryFieldInfo)selector.getFields().get(i);
            String displayName = field.getDisplayName();
            row.getCell(i).setValue((Object)displayName);
        }
        this.table.setColumnMoveable(true);
        this.table.moveColumn(size, 0);
        this.table.getIndexColumn().getStyleAttributes().setHided(false);
        this.table.setRefresh(true);
    }

    private void updateIndexColumn() {
        int index = 1;
        int size = this.table.getBody().size();
        for (int i = 0; i < size; ++i) {
            IRow row = this.table.getRow(i);
            if (row.getStyleAttributes().isHided()) continue;
            ++index;
        }
    }

    private boolean needRequestData() {
        return this.pmtOrg.getData() != null && this.pmtUser.getData() != null;
    }

    private void refreshUI(boolean isModify) throws EASBizException, BOSException {
        boolean flag = this.getSelectedOrgPK() != null;
        this.virtualIndex = 0;
        this.isFiristGetData = true;
        this.table.removeRows(flag);
        this.actionAddBizData.setEnabled(flag);
        this.actionRemoveBizData.setEnabled(flag);
        this.checkBoxGroup.setAllSelected(false);
        this.checkBoxGroup.setAllEnable(false);
        this.authorizedBizDatas = null;
        this.accreditBizDatas = null;
        this.addDiscretePerms.clear();
        this.updateDiscretePerms.clear();
        this.removeDiscretePerms.clear();
        this.isModify = isModify;
        this.selectDefaultRow(false);
    }

    @Override
    protected void pmtUser_dataChanged(DataChangeEvent e) throws Exception {
        super.pmtUser_dataChanged(e);
        this.setOrgF7();
        this.refreshUI(false);
    }

    private void setOrgF7() throws EASBizException, BOSException {
        IObjectPK selectedUserPK = this.getSelectedUserPK();
        if (selectedUserPK != null) {
            this.lbcOrg.remove((Component)this.pmtOrg);
            this.pmtOrg = new KDBizPromptBox();
            NewOrgViewF7PromptDialog orgF7 = this.getOrgF7();
            this.pmtOrg.setSelector((KDPromptSelector)orgF7);
            this.pmtOrg.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    try {
                        UserDiscreteAccreditUI.this.refreshUI(false);
                    }
                    catch (Exception e) {
                        UserDiscreteAccreditUI.this.handUIException(e);
                    }
                }
            });
            this.lbcOrg.setBoundEditor((JComponent)this.pmtOrg);
        }
        if (OrgType.NONE.equals((Object)this.getMainBizOrgType())) {
            ObjectUuidPK sysCUPK = new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4");
            FullOrgUnitInfo sysOrg = new FullOrgUnitInfo();
            sysOrg.setId(BOSUuid.read((String)sysCUPK.toString()));
            this.pmtOrg.setEnabled(false);
            this.pmtOrg.setText("");
            this.pmtOrg.setData((Object)sysOrg);
        } else {
            this.pmtOrg.setData(null);
            this.pmtOrg.setEnabled(selectedUserPK != null);
        }
    }

    private FilterInfo getBizDataFilter(BOSObjectType objectType, IObjectPK userPK, IObjectPK orgPK, boolean isAuthorized) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        ConfigurationInfo configurationInfo = iPermission.getConfigurationInfo();
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("SELECT DISTINCT FBizDataID FROM ").append(configurationInfo.getDiscretEntityTables().get(objectType.toString())).append(" WHERE FUserID = '").append(userPK.toString()).append("' AND ( FOrgID = '").append(orgPK.toString()).append("' ").append(" OR FOrgID = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ) ");
        FilterInfo filterInfo = new FilterInfo();
        CompareType compareType = isAuthorized ? CompareType.INNER : CompareType.NOTINNER;
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)buffer.toString(), compareType));
        return filterInfo;
    }

    private String getBizDataSQL(BOSObjectType objectType, IObjectPK userPK, IObjectPK orgPK, boolean isAuthorized) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        ConfigurationInfo configurationInfo = iPermission.getConfigurationInfo();
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("SELECT DISTINCT FBizDataID FROM ").append(configurationInfo.getDiscretEntityTables().get(objectType.toString())).append(" WHERE FUserID = '").append(userPK.toString()).append("' AND ( FOrgID = '").append(orgPK.toString()).append("' ").append(" OR FOrgID = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ) ");
        return buffer.toString();
    }

    private Set getAuthorizedBizDatas() throws EASBizException, BOSException {
        if (this.authorizedBizDatas == null) {
            IDiscretePermission discretePermission = DiscretePermissionFactory.getRemoteInstance();
            this.authorizedBizDatas = discretePermission.getUserAuthorizedBizDatas(this.bizObjectType, this.getSelectedUserPK(), this.getSelectedOrgPK());
        }
        return this.authorizedBizDatas;
    }

    private Set getAccreditBizDatas() throws EASBizException, BOSException {
        if (this.accreditBizDatas == null) {
            IDiscretePermission discretePermission = DiscretePermissionFactory.getRemoteInstance();
            this.accreditBizDatas = discretePermission.getAccreditBizDatas(this.getSelectedUserPK(), this.getSelectedOrgPK(), this.discreteAccreditProvider.getAccreditPermItemName());
        }
        return this.accreditBizDatas;
    }

    private IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
    }

    private OrgUnitInfo getSelectedOrg() {
        if (this.pmtOrg.getData() == null) {
            return null;
        }
        return (OrgUnitInfo)this.pmtOrg.getData();
    }

    private IObjectPK getSelectedOrgPK() {
        if (this.getSelectedOrg() == null) {
            return null;
        }
        return new ObjectUuidPK(this.getSelectedOrg().getId());
    }

    private IObjectPK getSelectedUserPK() {
        if (this.pmtUser.getData() == null) {
            return null;
        }
        return new ObjectUuidPK(((UserInfo)this.pmtUser.getData()).getId());
    }

    private IObjectPK getSelectedBizDataPK() {
        if (this.table.getSelectManager().size() != 0) {
            int rowIndex = this.table.getSelectManager().getActiveRowIndex();
            BOSUuid bizDataID = BOSUuid.read((String)this.table.getRow(rowIndex).getCell(this.getLogicPKField(this.bizQuery)).getValue().toString());
            return new ObjectUuidPK(bizDataID);
        }
        return null;
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK) {
        IQueryExecutor queryExecutor = null;
        queryExecutor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExecutor.option().isAutoTranslateEnum = true;
        queryExecutor.option().isAutoTranslateBoolean = true;
        queryExecutor.option().isAutoIgnoreZero = true;
        return queryExecutor;
    }

    private String getLogicPKField(QueryInfo queryInfo) {
        assert (this.bizQuery.getQueryPK().getKeyPropertys().size() == 1);
        QueryFieldInfo queryFieldInfo = this.bizQuery.getQueryPK().getKeyPropertys().get(0);
        return (String)queryFieldInfo.get("name");
    }

    private void requestRowSet(RequestRowSetEvent e) {
        if (this.needRequestData()) {
            try {
                int start = (Integer)e.getParam1() - this.virtualIndex;
                int length = (Integer)e.getParam2() - start + 1;
                MetaDataPK queryPK = new MetaDataPK(this.bizQuery.getFullName());
                IQueryExecutor queryExecutor = this.getQueryExecutor((IMetaDataPK)queryPK);
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                FilterInfo filterInfo = this.getBizDataFilter(this.bizObjectType, this.getSelectedUserPK(), this.getSelectedOrgPK(), true);
                entityViewInfo.setFilter(filterInfo);
                queryExecutor.setObjectView(entityViewInfo);
                IRowSet rowSet = queryExecutor.executeQuery(start, length);
                e.setRowSet(rowSet);
                if (this.isFiristGetData) {
                    this.table.setRowCount(queryExecutor.getQueryKeys(queryExecutor.openQuery()).size() + this.virtualIndex);
                    this.isFiristGetData = false;
                }
            }
            catch (Exception e1) {
                this.handUIException(e1);
            }
        }
    }

    private DiscretePermCollection getDiscretePerms(IObjectPK bizDataPK) throws EASBizException, BOSException {
        BOSUuid id = BOSUuid.read((String)bizDataPK.toString());
        if (this.addDiscretePerms.containsKey(id)) {
            return (DiscretePermCollection)((Object)this.addDiscretePerms.get(id));
        }
        if (this.removeDiscretePerms.containsKey(id)) {
            return (DiscretePermCollection)((Object)this.removeDiscretePerms.get(id));
        }
        if (this.updateDiscretePerms.containsKey(id)) {
            return (DiscretePermCollection)((Object)this.updateDiscretePerms.get(id));
        }
        IDiscretePermission iDiscretePermission = DiscretePermissionFactory.getRemoteInstance();
        DiscretePermCollection ddps = iDiscretePermission.getUserDiscretePerms(this.bizObjectType, this.getSelectedUserPK(), this.getSelectedOrgPK(), this.getSelectedBizDataPK());
        return ddps;
    }

    @Override
    protected void table_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        super.table_activeCellChanged(e);
        this.cellChanged();
    }

    private void cellChanged() throws EASBizException, BOSException {
        this.checkBoxGroup.removeAllChangeListener();
        this.checkBoxGroup.setAllSelected(false);
        int rowIndex = this.table.getSelectManager().getActiveRowIndex();
        if (rowIndex != -1) {
            IObjectPK bizDataPK = this.getSelectedBizDataPK();
            DiscretePermCollection ddps = this.getDiscretePerms(bizDataPK);
            this.setComponentStatus(bizDataPK);
            int size = ddps.size();
            for (int i = 0; i < size; ++i) {
                DiscretePermInfo info = ddps.get(i);
                PermItemInfo permItemInfo = info.getPermItem();
                if (permItemInfo == null) continue;
                BOSUuid permItemID = permItemInfo.getId();
                this.viewHelper.setCheckBoxState(this.checkBoxGroup, permItemID);
            }
        } else {
            this.checkBoxGroup.setAllEnable(false);
        }
        this.checkBoxGroup.addAllChangeListener(new CheckBoxChangeListener());
    }

    private void setComponentStatus(IObjectPK bizDataPK) throws EASBizException, BOSException {
        String accreditPermItemName = this.discreteAccreditProvider.getAccreditPermItemName();
        if (StringUtils.isEmpty((String)accreditPermItemName)) {
            this.checkBoxGroup.setAllEnable(true);
            this.actionRemoveBizData.setEnabled(true);
        } else {
            boolean flag = this.getAccreditBizDatas().contains(bizDataPK.toString());
            this.checkBoxGroup.setAllEnable(flag);
            this.actionRemoveBizData.setEnabled(flag);
        }
    }

    @Override
    protected void table_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.table_tableSelectChanged(e);
        Set bizDataIDs = this.getSelectedBizDataIDs();
        if (bizDataIDs.size() > 1) {
            this.checkBoxGroup.removeAllChangeListener();
            this.checkBoxGroup.setAllSelected(false);
            String accreditPermItemName = this.discreteAccreditProvider.getAccreditPermItemName();
            if (StringUtils.isEmpty((String)accreditPermItemName)) {
                this.checkBoxGroup.setAllEnable(true);
                this.actionRemoveBizData.setEnabled(true);
            } else {
                boolean flag = true;
                for (BOSUuid bizDataID : bizDataIDs) {
                    if (this.getAccreditBizDatas().contains(bizDataID.toString())) continue;
                    flag = false;
                    break;
                }
                this.checkBoxGroup.setAllEnable(flag);
                this.actionRemoveBizData.setEnabled(flag);
            }
            this.checkBoxGroup.addAllChangeListener(new CheckBoxChangeListener());
        }
    }

    @Override
    protected void table_tableClicked(KDTMouseEvent e) throws Exception {
        Set bizDataIDs;
        super.table_tableClicked(e);
        int rowIndex = e.getRowIndex();
        if (rowIndex != -1 && (bizDataIDs = this.getSelectedBizDataIDs()).size() >= 1) {
            this.cellChanged();
        }
    }

    private Set getSelectedBizDataIDs() {
        HashSet<BOSUuid> bizDataIDs = new HashSet<BOSUuid>();
        String idField = this.getLogicPKField(this.bizQuery);
        int size = this.table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.table, (IBlock)this.table.getSelectManager().get(i));
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                if (j == -1 || this.table.getRow(j) == null || this.table.getRow(j).getCell(idField) == null || this.table.getRow(j).getCell(idField).getValue() == null) continue;
                String bizDataID = this.table.getRow(j).getCell(idField).getValue().toString();
                bizDataIDs.add(BOSUuid.read((String)bizDataID));
            }
        }
        return bizDataIDs;
    }

    private DiscretePermCollection getCurrentDDPs(BOSUuid bizDataID, boolean isRemoved) throws EASBizException, BOSException {
        DiscretePermCollection ddps = new DiscretePermCollection();
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)this.getSelectedUserPK().toString()));
        FullOrgUnitInfo org = new FullOrgUnitInfo();
        org.setId(BOSUuid.read((String)this.getSelectedOrgPK().toString()));
        Iterator iterator = this.checkBoxGroup.iterator();
        while (iterator.hasNext()) {
            KDCheckBox checkBox = (KDCheckBox)iterator.next();
            if (checkBox.isSelected()) {
                PermItemInfo permItemInfo = (PermItemInfo)checkBox.getUserObject();
                DiscretePermInfo discretePermInfo = new DiscretePermInfo();
                discretePermInfo.setUser(userInfo);
                discretePermInfo.setOrg(org);
                discretePermInfo.setBizDataID(bizDataID);
                discretePermInfo.setPermItemInfo(permItemInfo);
                ddps.add(discretePermInfo);
                continue;
            }
            if (!isRemoved) continue;
            DiscretePermInfo discretePermInfo = new DiscretePermInfo();
            discretePermInfo.setUser(userInfo);
            discretePermInfo.setOrg(org);
            discretePermInfo.setBizDataID(bizDataID);
            discretePermInfo.setPermItemInfo(null);
            ddps.add(discretePermInfo);
        }
        return ddps;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        String msg;
        this.checkBeforeSumbit();
        if (PermissionHelper.isAuthenticateAdminEnabled() && this.isModify && MsgBox.showConfirm2((Component)((Object)this), (String)(msg = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"USER_WILL_NEED_AUTHEN"), this.getSelectedUserNumber()))) == 2) {
            SysUtil.abort();
        }
        if (this.hasUnnecessaryBizData()) {
            int isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"hasUnnecessaryBizData"));
            if (MsgBox.isYes((int)isYes)) {
                LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
                dialog.setLongTimeTask(new ILongTimeTask(){

                    @Override
                    public Object exec() throws Exception {
                        UserDiscreteAccreditUI.this.save();
                        return "";
                    }

                    @Override
                    public void afterExec(Object result) throws Exception {
                        MsgBox.showInfo((Component)((Object)UserDiscreteAccreditUI.this), (String)EASResource.getString((String)UserDiscreteAccreditUI.RESOURCE, (String)"accreditPermSucceed"));
                        UserDiscreteAccreditUI.this.refreshUI(false);
                    }
                });
                dialog.show();
            }
        } else {
            LongTimeDialog dialog = new LongTimeDialog((Dialog)SwingUtilities.getWindowAncestor((Component)((Object)this)));
            dialog.setLongTimeTask(new ILongTimeTask(){

                @Override
                public Object exec() throws Exception {
                    UserDiscreteAccreditUI.this.save();
                    return "";
                }

                @Override
                public void afterExec(Object result) throws Exception {
                    MsgBox.showInfo((Component)((Object)UserDiscreteAccreditUI.this), (String)EASResource.getString((String)UserDiscreteAccreditUI.RESOURCE, (String)"accreditPermSucceed"));
                    UserDiscreteAccreditUI.this.refreshUI(false);
                }
            });
            dialog.show();
        }
    }

    private boolean hasUnnecessaryBizData() {
        String idField = this.getLogicPKField(this.bizQuery);
        for (int i = 0; i < this.virtualIndex; ++i) {
            String bizDataID;
            if (this.table.getRow(i).getStyleAttributes().isHided() || this.addDiscretePerms.containsKey(BOSUuid.read((String)(bizDataID = this.table.getRow(i).getCell(idField).getValue().toString())))) continue;
            return true;
        }
        return false;
    }

    private void save() throws EASBizException, BOSException {
        IDiscretePermission iDiscretePermission = DiscretePermissionFactory.getRemoteInstance();
        DiscretePermCollection[] ddps = this.getDPResult();
        Map uiMap = this.getUIContext();
        uiMap.put("CUR_ORG", this.getSelectedOrgPK().toString());
        DiscretePermCollection[] res = this.viewHelper.filterDiscretePermCol(ddps, uiMap);
        iDiscretePermission.saveDiscretePerms(this.bizObjectType, res);
        CacheUtil.clearBizCache(this.bizObjectType);
    }

    private String getSelectedUserNumber() {
        if (this.pmtUser.getData() == null) {
            return null;
        }
        return ((UserInfo)this.pmtUser.getData()).getNumber();
    }

    private DiscretePermCollection[] getDPResult() {
        DiscretePermCollection[] ddps = new DiscretePermCollection[]{new DiscretePermCollection(), new DiscretePermCollection(), new DiscretePermCollection(), new DiscretePermCollection()};
        for (DiscretePermCollection item : this.addDiscretePerms.values()) {
            ddps[0].addCollection(item);
        }
        for (DiscretePermCollection item : this.removeDiscretePerms.values()) {
            ddps[1].addCollection(item);
        }
        for (DiscretePermCollection item : this.updateDiscretePerms.values()) {
            ddps[2].addCollection(item);
        }
        if (this.table.getRowCount() > 0) {
            DiscretePermInfo discretePermInfo = new DiscretePermInfo();
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)this.getSelectedUserPK().toString()));
            FullOrgUnitInfo org = new FullOrgUnitInfo();
            org.setId(BOSUuid.read((String)this.getSelectedOrgPK().toString()));
            discretePermInfo.setUser(userInfo);
            discretePermInfo.setOrg(org);
            ddps[3].add(discretePermInfo);
        }
        return ddps;
    }

    private void checkBeforeSumbit() {
        if (this.getSelectedUserPK() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"userIsNotSelected"));
            this.abort();
        }
        if (this.getSelectedOrgPK() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"orgIsNotSelected"));
            this.abort();
        }
        if (this.noRowsInTable()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"NoBizDataRecord"));
            this.abort();
        }
        if (this.isBadSelected()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"discreteDataSelectAlert"));
            this.abort();
        }
    }

    @Override
    public void actionAddBizData_actionPerformed(ActionEvent e) throws Exception {
        Object data;
        super.actionAddBizData_actionPerformed(e);
        IDiscreteDataSelector dlg = this.getBizDataDialog();
        if (dlg instanceof KDCommonPromptDialog) {
            ((KDCommonPromptDialog)dlg).setHasHideQuichFilterPanel(true);
        }
        dlg.show();
        if (!dlg.isCanceled() && (data = dlg.getData()) != null) {
            if (data instanceof Object[]) {
                Object[] datas = (Object[])data;
                int length = datas.length;
                for (int i = 0; i < length; ++i) {
                    IObjectValue objectValue = (IObjectValue)datas[i];
                    if (this.existBizData(objectValue)) continue;
                    this.loadRowData(objectValue);
                    ++this.virtualIndex;
                    this.table.setRowCount(this.table.getRowCount() + 1);
                }
            } else {
                IObjectValue objectValue = (IObjectValue)data;
                if (!this.existBizData(objectValue)) {
                    this.loadRowData(objectValue);
                    ++this.virtualIndex;
                    this.table.setRowCount(this.table.getRowCount() + 1);
                }
            }
            this.selectDefaultRow(true);
            this.updateIndexColumn();
            this.table.reLayoutAndPaint();
        }
    }

    public void selectDefaultRow(boolean forceFireEvent) throws EASBizException, BOSException {
        if (this.table.getRowCount() > 0) {
            int count = this.table.getBody().size();
            for (int i = 0; i < count; ++i) {
                if (this.table.getRow(i).getStyleAttributes().isHided()) continue;
                this.table.getSelectManager().select(i, 0);
                if (forceFireEvent) {
                    this.cellChanged();
                }
                return;
            }
        }
    }

    private boolean noRowsInTable() {
        return this.table.getRowCount3() < 1;
    }

    private boolean isBadSelected() {
        String idField = this.getLogicPKField(this.bizQuery);
        for (int i = 0; i < this.virtualIndex; ++i) {
            String bizDataID;
            if (this.table.getRow(i).getStyleAttributes().isHided() || !this.addDiscretePerms.containsKey(BOSUuid.read((String)(bizDataID = this.table.getRow(i).getCell(idField).getValue().toString())))) continue;
            return false;
        }
        return this.virtualIndex != 0;
    }

    private boolean existBizData(IObjectValue bizData) {
        if (bizData == null || bizData.get("id") == null) {
            return false;
        }
        String idField = this.getLogicPKField(this.bizQuery);
        int count = this.table.getBody().size();
        for (int i = 0; i < count; ++i) {
            String existBizDataID;
            String bizDataID = bizData.get("id").toString();
            if (this.table.getRow(i).getStyleAttributes().isHided() || !bizDataID.equals(existBizDataID = this.table.getRow(i).getCell(idField).getValue().toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionRemoveBizData_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.actionRemoveBizData_actionPerformed(e);
        if (this.table.getRowCount() == 0 || this.table.getSelectManager().size() == 0) {
            return;
        }
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)this.getSelectedUserPK().toString()));
        FullOrgUnitInfo org = new FullOrgUnitInfo();
        org.setId(BOSUuid.read((String)this.getSelectedOrgPK().toString()));
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int size = this.table.getSelectManager().size();
        for (i = 0; i < size; ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.table, (IBlock)this.table.getSelectManager().get(i));
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                this.isModify = true;
                arrayList.add(new Integer(j));
                BOSUuid bizDataID = BOSUuid.read((String)this.table.getRow(j).getCell(this.getLogicPKField(this.bizQuery)).getValue().toString());
                if (this.getAuthorizedBizDatas().contains(bizDataID)) {
                    DiscretePermCollection collection = new DiscretePermCollection();
                    Iterator iterator = this.checkBoxGroup.iterator();
                    while (iterator.hasNext()) {
                        KDCheckBox checkBox = (KDCheckBox)iterator.next();
                        PermItemInfo permItemInfo = (PermItemInfo)checkBox.getUserObject();
                        DiscretePermInfo discretePermInfo = new DiscretePermInfo();
                        discretePermInfo.setUser(userInfo);
                        discretePermInfo.setOrg(org);
                        discretePermInfo.setPermItemInfo(permItemInfo);
                        discretePermInfo.setBizDataID(bizDataID);
                        collection.add(discretePermInfo);
                    }
                    this.removeDiscretePerms.put(bizDataID, collection);
                    this.updateDiscretePerms.remove(bizDataID);
                    continue;
                }
                this.addDiscretePerms.remove(bizDataID);
                --this.virtualIndex;
            }
        }
        this.table.setRefresh(false);
        for (i = arrayList.size() - 1; i >= 0; --i) {
            this.table.getRow(((Integer)arrayList.get(i)).intValue()).getStyleAttributes().setHided(true);
        }
        this.table.setRefresh(true);
        this.table.repaint();
        this.checkBoxGroup.setAllEnable(false);
        this.checkBoxGroup.setAllSelected(false);
    }

    private void loadRowData(IObjectValue objectValue) throws ClassNotFoundException {
        this.isModify = true;
        this.table.setRefresh(false);
        IRow row = this.table.addRow(0);
        int count = this.table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            String field = this.table.getColumnKey(i);
            if (INDEX_COLUMN_NAME.equals(field)) continue;
            DataType dataType = this.getDataType(field);
            Object fieldData = null;
            if (field.indexOf(".") != -1) {
                String[] properties = StringUtils.split((String)field, (String)".");
                fieldData = objectValue;
                int length = properties.length;
                for (int j = 0; j < length; ++j) {
                    if (fieldData == null) {
                        fieldData = null;
                        break;
                    }
                    fieldData = ((IObjectValue)fieldData).get(properties[j]);
                }
            } else {
                fieldData = objectValue.get(field);
            }
            if (DataType.BOOLEAN.equals((Object)dataType)) {
                if (fieldData != null) {
                    fieldData = TypeConversionUtils.objToBoolean((Object)fieldData);
                }
            } else if (DataType.ENUM.equals((Object)dataType) && fieldData != null) {
                Class<?> enumClass = Class.forName(this.getEnumClassName(field));
                if (fieldData instanceof String) {
                    Enum anEnum = EnumUtils.getEnum(enumClass, (String)((String)fieldData));
                    StringEnum enumByValue = EnumUtils.getEnumByValue(enumClass, (String)((String)fieldData));
                    if (anEnum == null || anEnum.getAlias() == null) {
                        if (enumByValue != null) {
                            fieldData = enumByValue.getAlias();
                        }
                    } else {
                        fieldData = anEnum.getAlias();
                    }
                } else if (fieldData instanceof Integer) {
                    fieldData = EnumUtils.getEnum(enumClass, (int)((Integer)fieldData)).getAlias();
                }
            }
            row.getCell(i).setValue(fieldData);
        }
        this.table.setRefresh(true);
    }

    private DataType getDataType(String field) {
        QueryFieldInfo queryFieldInfo = this.bizQuery.getUnits().getQueryFields().get(field);
        assert (queryFieldInfo.getPropertyRefs().size() == 1);
        SubEntityInfo subEntityInfo = queryFieldInfo.getPropertyRefs().get(0).getSubEntity();
        String propertyName = (String)queryFieldInfo.getPropertyRefs().get(0).getRefProperty().get("name");
        EntityObjectInfo entity = subEntityInfo.getEntityRef();
        PropertyCollection collection = entity.getInheritedDuplicatedProperties();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            OwnPropertyInfo ownPropertyInfo;
            PropertyInfo propertyInfo = collection.get(i);
            if (!(propertyInfo instanceof OwnPropertyInfo) || !propertyName.equals((ownPropertyInfo = (OwnPropertyInfo)propertyInfo).getName())) continue;
            return ownPropertyInfo.getDataType();
        }
        throw new IllegalArgumentException("propertyName:" + propertyName + " not found in entity:" + entity.getFullName());
    }

    private String getEnumClassName(String field) {
        QueryFieldInfo queryFieldInfo = this.bizQuery.getUnits().getQueryFields().get(field);
        assert (queryFieldInfo.getPropertyRefs().size() == 1);
        SubEntityInfo subEntityInfo = queryFieldInfo.getPropertyRefs().get(0).getSubEntity();
        String propertyName = (String)queryFieldInfo.getPropertyRefs().get(0).getRefProperty().get("name");
        EntityObjectInfo entity = subEntityInfo.getEntityRef();
        PropertyCollection collection = entity.getInheritedDuplicatedProperties();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            OwnPropertyInfo ownPropertyInfo;
            PropertyInfo propertyInfo = collection.get(i);
            if (!(propertyInfo instanceof OwnPropertyInfo) || !propertyName.equals((ownPropertyInfo = (OwnPropertyInfo)propertyInfo).getName()) || !DataType.ENUM.equals((Object)ownPropertyInfo.getDataType())) continue;
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            MetaDataPK enumPK = new MetaDataPK(ownPropertyInfo.getMetaDataRef());
            BizEnumInfo bizEnumInfo = loader.getEnum((IMetaDataPK)enumPK);
            return bizEnumInfo.getClassName();
        }
        throw new IllegalArgumentException("propertyName:" + propertyName + " not found in entity:" + entity.getFullName());
    }

    private IDiscreteDataSelector getBizDataDialog() throws Exception {
        IDiscreteDataSelector selector = this.discreteAccreditProvider.getSelector(this.getCurrentUserPK(), this.getSelectedOrgPK(), (IUIObject)this);
        String condition = null;
        if (selector.isOQLType()) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(this.getBizDataFilter(this.bizObjectType, this.getSelectedUserPK(), this.getSelectedOrgPK(), false));
            condition = entityViewInfo.toString();
        } else {
            condition = this.getBizDataSQL(this.bizObjectType, this.getSelectedUserPK(), this.getSelectedOrgPK(), false);
        }
        selector.mergeAccreditCondition(condition);
        return selector;
    }

    private class CheckBoxChangeListener
    implements ChangeListener {
        private CheckBoxChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            UserDiscreteAccreditUI.this.checkBoxChanged(e);
        }
    }
}

