/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class UserListUIHelper {
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private Logger logger = Logger.getLogger(UserListUIHelper.class);
    private List cuRangeList = null;
    private static HashMap cacheMap = new HashMap();
    private static HashMap simpleUserCacheMap = new HashMap();
    private static HashMap cacheRangeIdListMap = new HashMap();

    private String getIncludeInfo() {
        if (!Administrator.isSuperAdmin(ToolUtils.getCurrentUserPK())) {
            StringBuffer sb = new StringBuffer();
            return sb.append(" id <> '").append(ToolUtils.getCurrentUserPK().toString()).append("'  AND ").toString();
        }
        return "";
    }

    public FilterInfo getAdministrator() throws ParserException {
        boolean includeAdmin = true;
        if (includeAdmin && Administrator.isSuperCUAdmin(ToolUtils.getCurrentUserPK())) {
            StringBuffer sb = new StringBuffer();
            return new FilterInfo(sb.append(" id = '").append("00000000-0000-0000-0000-00000000000013B7DE7F").append("'").toString());
        }
        return null;
    }

    public FilterInfo getCurrentRangeUser() throws EASBizException, BOSException, UuidException, ParserException {
        StringBuffer filter = new StringBuffer();
        filter.append(this.getIncludeInfo());
        boolean manageOrgRangeByAdminOrg = Boolean.valueOf(ParamManager.getParamValue(null, null, (String)"manageOrgRangeByAdminOrg"));
        UserInfo curUserInfo = ToolUtils.getCurrentUser();
        if (manageOrgRangeByAdminOrg && !Administrator.isAdminType(curUserInfo.getType())) {
            String userId = curUserInfo.getId().toString();
            filter.append(" ((PM.isPrimary = 1 AND ADMIN.id IN( SELECT forgid FROM t_pm_orgrange WHERE fuserid = '").append(userId).append("' AND ftype = ").append(50).append(")) OR");
            filter.append(" (PM.isPrimary IS NULL AND person.gkAdmin.id IN( SELECT forgid FROM t_pm_orgrange WHERE fuserid = '").append(userId).append("' AND ftype = ").append(50).append(")))");
        } else {
            filter.append(" (CU.id IN(").append(this.getCurrentUserOrgRange()).append("))");
        }
        String filterStr = filter.toString();
        this.logger.debug((Object)("fiterStr is:" + filterStr));
        return new FilterInfo(filterStr, true);
    }

    public FilterInfo getCurrentRangeUserWith3D(int type) throws EASBizException, BOSException, UuidException, ParserException {
        StringBuffer filter = new StringBuffer();
        filter.append(this.getIncludeInfo());
        if (Administrator.isSuperCUAdmin(ToolUtils.getCurrentUserPK())) {
            filter.append(" (CU.id IN(").append(this.getCurrentUserOrgRange()).append("))");
        } else {
            filter.append(" (org.id IN(").append(this.getCurrentUserOrgRangeWith3D(type)).append("))");
        }
        String filterStr = filter.toString();
        this.logger.debug((Object)("fiterStr is:" + filterStr));
        return new FilterInfo(filterStr, true);
    }

    public FilterInfo getCurrentRangeUserAsAssociation(String userProperty) throws EASBizException, BOSException, UuidException, ParserException {
        StringBuffer filter = new StringBuffer();
        filter.append(" (").append(userProperty).append(".CU.id IN(").append(this.getCurrentUserOrgRange()).append("))");
        String filterStr = filter.toString();
        this.logger.debug((Object)("fiterStr is:" + filterStr));
        return new FilterInfo(filterStr);
    }

    public FilterInfo getCurrentRangeUserMayBeAdmin() throws EASBizException, BOSException, UuidException, ParserException {
        FilterInfo filterInfo = this.getCurrentRangeUser();
        FilterInfo adminFilterInfo = this.getAdministrator();
        if (adminFilterInfo != null) {
            filterInfo.mergeFilter(adminFilterInfo, "OR");
        }
        return filterInfo;
    }

    public FilterInfo getOtherRangeUser() throws EASBizException, BOSException, UuidException, ParserException {
        StringBuffer filter = new StringBuffer();
        filter.append(this.getIncludeInfo());
        filter.append("( CU.id NOT IN(").append(this.getCurrentUserOrgRange()).append(") AND id <>'").append("00000000-0000-0000-0000-00000000000013B7DE7F").append("'))");
        String filterStr = filter.toString();
        this.logger.debug((Object)("fiterStr is:" + filterStr));
        return new FilterInfo(filterStr);
    }

    private String getCurrentUserOrgRangeWith3D(int type) throws EASBizException, BOSException, UuidException {
        UserInfo curUserInfo = ToolUtils.getCurrentUser();
        String userId = curUserInfo.getId().toString();
        OrgRangeType orgRangeType = null;
        if (Administrator.isAdminType(curUserInfo.getType())) {
            orgRangeType = OrgRangeType.BIZ_ORG_TYPE;
        } else if (curUserInfo.isBizAdmin()) {
            orgRangeType = OrgRangeType.MANAGE_ORG_TYPE;
        }
        StringBuffer sb = new StringBuffer();
        if (curUserInfo.isBizAdmin()) {
            if (type == 10) {
                sb.append("SELECT  base.FID  FROM T_PM_ORGRANGE org LEFT OUTER JOIN T_ORG_BASEUNIT base on org.FORGID = base.FCONTROLUNITID where org.FUSERID = '");
                if (orgRangeType != null) {
                    sb.append(" and org.ftype = ").append(type);
                    sb.append(" and base.FOrgtypeStr NOT IN(';;Admin;',';Admin;',';;ControlUnit;',';ControlUnit;',';;Admin;;ControlUnit;',';;ControlUnit;;Admin;',';Admin;;ControlUnit;',';ControlUnit;;Admin;',';')");
                }
            } else {
                sb.append("SELECT base.FID FROM T_ORG_STRUCTURE stru INNER JOIN T_ORG_BASEUNIT base on base.FID = stru.FUNITID INNER JOIN T_ORG_OUPARTADMIN oup on oup.FUNITID = base.FID").append(" where (oup.FISVIRTUAL = 0 or oup.FISVIRTUAL is null) and oup.FISSEALUP = 0 and base.FCONTROLUNITID in(").append(" SELECT FORGID FROM T_PM_ORGRANGE WHERE FUSERID = '").append(userId).append("' AND FTYPE = ").append(type + ")").append(" and stru.FTREEID = '00000000-0000-0000-0000-0000000000034F2827FD'");
            }
        } else {
            sb.append("select fid from t_pm_orgrange where fuserid = '").append(userId).append("'");
            if (orgRangeType != null) {
                sb.append(" and ftype = ").append(orgRangeType.getValue());
            }
        }
        return sb.toString();
    }

    private String getCurrentUserOrgRange() throws EASBizException, BOSException, UuidException {
        UserInfo curUserInfo = ToolUtils.getCurrentUser();
        String userId = curUserInfo.getId().toString();
        OrgRangeType orgRangeType = null;
        if (Administrator.isAdminType(curUserInfo.getType())) {
            orgRangeType = OrgRangeType.BIZ_ORG_TYPE;
        } else if (curUserInfo.isBizAdmin()) {
            orgRangeType = OrgRangeType.MANAGE_ORG_TYPE;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select forgid from t_pm_orgrange where fuserid = '").append(userId).append("'");
        if (orgRangeType != null) {
            sb.append(" and ftype = ").append(orgRangeType.getValue());
        }
        return sb.toString();
    }

    private List getCurrentUserOrgRangeListByUser(UserInfo curUserInfo) {
        ArrayList<String> retList = new ArrayList<String>();
        if (curUserInfo != null && curUserInfo.getCU() != null) {
            retList.add(curUserInfo.getCU().getId().toString());
        }
        return retList;
    }

    protected List getCurentUserOrgRangeList() throws EASBizException, BOSException, UuidException {
        if (this.cuRangeList != null && !ToolUtils.getCurrentUserPK().toString().equals("00000000-0000-0000-0000-00000000000013B7DE7F")) {
            return this.cuRangeList;
        }
        UserInfo curUserInfo = ToolUtils.getCurrentUser();
        OrgRangeType orgRangeType = null;
        if (Administrator.isAdminType(curUserInfo.getType())) {
            orgRangeType = OrgRangeType.BIZ_ORG_TYPE;
        } else if (curUserInfo.isBizAdmin()) {
            orgRangeType = OrgRangeType.MANAGE_ORG_TYPE;
        }
        return UserListUIHelper.getCurUserRangeIdListByType(orgRangeType);
    }

    protected static List getCurUserRangeIdListByType(OrgRangeType orgRangeType) throws EASBizException, BOSException {
        if (orgRangeType == null) {
            return null;
        }
        List rangeIdList = null;
        if (cacheRangeIdListMap.get((Object)orgRangeType) == null) {
            rangeIdList = OrgRangeFactory.getRemoteInstance().getOrgIdByUserAndType(ToolUtils.getCurrentUserPK(), orgRangeType);
            cacheRangeIdListMap.put(orgRangeType, rangeIdList);
        } else {
            rangeIdList = (List)cacheRangeIdListMap.get((Object)orgRangeType);
        }
        return rangeIdList;
    }

    protected static UserInfo getSimpleUserInCache(String userPK) throws EASBizException, BOSException {
        if (simpleUserCacheMap.get(userPK) == null) {
            UserInfo user = ToolUtils.getSimpleUserInfo((IObjectPK)new ObjectStringPK(userPK));
            simpleUserCacheMap.put(userPK, user);
            return user;
        }
        return (UserInfo)simpleUserCacheMap.get(userPK);
    }

    protected List getSubUserOrgRangeList() throws EASBizException, BOSException, UuidException {
        ArrayList retList = new ArrayList(this.getCurentUserOrgRangeList());
        retList.remove(ToolUtils.getCurrentCUPK().toString());
        return retList;
    }

    protected String getSubUserOrgRange() throws EASBizException, BOSException, UuidException {
        List userRangeList = this.getSubUserOrgRangeList();
        return ToolUtils.aryToStr(userRangeList);
    }

    public static void UserRoleExport(Component parent, List userIdList) throws Exception {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.systemplatform.security.permission.userRole";
        param.alias = EASResource.getString((String)RESOURCE, (String)"userRole");
        param.datataskMode = 1;
        param.putContextParam((Object)"mainQueryPK", (Object)new MetaDataPK("com.kingdee.eas.base.permission.app.UserRoleOrgQuery"));
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.setFilter(ToolUtils.getUserIdInRange("userId.id", userIdList));
        param.putContextParam((Object)"mainQuery", (Object)entityView);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent(parent);
        dc.invoke(paramList, 1);
    }

    public static void UserPermExport(Component parent, List userIdList) throws Exception {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.systemplatform.security.permission.userPerm";
        param.alias = EASResource.getString((String)RESOURCE, (String)"userPerm");
        param.datataskMode = 1;
        param.putContextParam((Object)"mainQueryPK", (Object)new MetaDataPK("com.kingdee.eas.base.permission.app.UserPermQuery"));
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.setFilter(ToolUtils.getUserIdInRange("owner.id", userIdList));
        param.putContextParam((Object)"mainQuery", (Object)entityView);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent(parent);
        dc.invoke(paramList, 1);
    }

    public static void UserPermImport(Component parent) throws Exception {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.systemplatform.security.permission.userPerm";
        param.alias = EASResource.getString((String)RESOURCE, (String)"userPerm");
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent(parent);
        dc.invoke(paramList, 0);
    }

    public static void UserOrangeRangeExport(Component parent, List userIdList) throws Exception {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.systemplatform.security.permission.userOrgRange";
        param.alias = EASResource.getString((String)RESOURCE, (String)"USER_ORG_RANGE");
        param.datataskMode = 1;
        param.putContextParam((Object)"mainQueryPK", (Object)new MetaDataPK("com.kingdee.eas.base.permission.app.OrgRangeIncludeSubOrgQuery"));
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.setFilter(ToolUtils.getUserIdInRange("USER.ID", userIdList));
        param.putContextParam((Object)"mainQuery", (Object)entityView);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent(parent);
        dc.invoke(paramList, 1);
    }

    public static void clearCache() {
        cacheMap.clear();
        simpleUserCacheMap.clear();
    }

    public FilterInfo getCurrentRangeUsers() throws EASBizException, BOSException, UuidException, ParserException {
        StringBuffer filter = new StringBuffer();
        filter.append(this.getIncludeInfo());
        filter.append(" (CU.id IN(").append(this.getCurrentUserOrgRange()).append("))");
        if (ToolUtils.getCurrentUser().isBizAdmin()) {
            filter.append(" AND (bizadmin <> 1)");
        }
        String filterStr = filter.toString();
        this.logger.debug((Object)("fiterStr is:" + filterStr));
        return new FilterInfo(filterStr, true);
    }
}

