/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.client.AbstractUserLockedListUI;
import com.kingdee.eas.base.permission.client.UserListUIHelper;
import com.kingdee.eas.base.permission.util.LogNamesHelper;
import com.kingdee.eas.base.permission.util.LogProxy;
import com.kingdee.eas.base.permission.util.MyEntityInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.log4j.Logger;

public class UserLockedListUI
extends AbstractUserLockedListUI {
    private static final int USER_ID_INDEX = 0;
    private static final int USER_NUMBER_INDEX = 1;
    private static final int USER_TYPE = 2;
    private static final int CU_ID_INDEX = 15;
    private static final Logger logger = CoreUIObject.getLogger(UserLockedListUI.class);

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected boolean initDefaultFilter() {
        return false;
    }

    @Override
    public void actionUnlock_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnlock_actionPerformed(e);
        this.processUserLock(false);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return UserFactory.getRemoteInstance();
    }

    private UserInfo getUserInfoFromTable(IRow iRow) {
        Object object = iRow.getCell(0).getValue();
        UserInfo info = new UserInfo();
        info.setId(BOSUuid.read((String)object.toString()));
        CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
        ctrlUnitInfo.setId(BOSUuid.read((String)iRow.getCell(15).getValue().toString()));
        info.setCU(ctrlUnitInfo);
        info.setNumber(iRow.getCell(1).getValue().toString());
        BizEnumValueInfo bizInfo = (BizEnumValueInfo)iRow.getCell(2).getValue();
        info.setType(UserType.getEnum(bizInfo.getInt()));
        return info;
    }

    private void processUserLock(boolean isLock) throws Exception, BOSException {
        UserCollection userCol = new UserCollection();
        ArrayList<ObjectUuidPK> arrayList = new ArrayList<ObjectUuidPK>();
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                Object object = this.tblMain.getRow(j).getCell(0).getValue();
                ObjectUuidPK iObjectPK = new ObjectUuidPK(object.toString());
                UserInfo info = this.getUserInfoFromTable(this.tblMain.getRow(j));
                userCol.add(info);
                arrayList.add(iObjectPK);
            }
        }
        IObjectPK[] userPKs = new IObjectPK[arrayList.size()];
        int length = userPKs.length;
        for (int i = 0; i < length; ++i) {
            userPKs[i] = (IObjectPK)arrayList.get(i);
        }
        IUser iUser = (IUser)this.getBizInterface();
        LogProxy logProxy = new LogProxy();
        logProxy.beginLog(null, MyEntityInfo.getMethodAlias(null, iUser.getType(), "lockUsers"), iUser.getType(), null, this.getforbidDetail(userCol, "lockUser", isLock));
        iUser.lockUsers(userPKs, isLock);
        logProxy.end();
        this.refreshList();
    }

    private String getforbidDetail(UserCollection userCol, String pmtStr, boolean isForbidden) {
        Locale locale = SysContext.getSysContext().getLocale();
        if (userCol == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer("");
        sb.append(pmtStr + ":" + isForbidden);
        sb.append("\n " + LogNamesHelper.getLogName("userNumber4Log", locale) + " is (");
        int size = userCol.size();
        for (int i = 0; i < size; ++i) {
            sb.append(userCol.get(i).getNumber()).append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.mainQuery != null) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("isLocked", (Object)"1"));
            filterInfo.getFilterItems().add(new FilterItemInfo("isDelete", (Object)"0"));
            if (this.mainQuery.getFilter() != null) {
                this.mainQuery.getFilter().mergeFilter(filterInfo, "AND");
            } else {
                this.mainQuery.setFilter(filterInfo);
            }
            UserListUIHelper helper = new UserListUIHelper();
            FilterInfo userFilterInfo = helper.getCurrentRangeUser();
            userFilterInfo.mergeFilter(helper.getAdministrator(), "OR");
            userFilterInfo.mergeFilter(Administrator.getNotAuUserFilter(), "AND");
            this.mainQuery.getFilter().mergeFilter(userFilterInfo, "AND");
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }
}

