/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermFacadeFactory;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.client.AbstractUserOrgPermRelationDetailUI;
import com.kingdee.eas.base.permission.client.RuleSelectUI;
import com.kingdee.eas.base.permission.client.UserListUIHelper;
import com.kingdee.eas.base.permission.client.UserOrgPermRelationFilterUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserOrgPermRelationDetailUI
extends AbstractUserOrgPermRelationDetailUI {
    private static final Logger logger = Logger.getLogger(UserOrgPermRelationDetailUI.class);
    protected IMetaDataPK mainQueryPk = null;
    private static final int MAX_ROW_TO_EXPORT = 10000;
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    protected UserOrgPermRelationFilterUI defaultFilterUI = null;
    private IUIWindow currOrgTreeDialog;
    private HashMap ctx = new HashMap();
    private UserListUIHelper helper = new UserListUIHelper();
    private BOSUuid solutionId = null;

    public UserOrgPermRelationDetailUI(IUIObject owner, HashMap map) throws Exception {
        this.ctx.put("Owner", owner);
    }

    public void show() {
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            this.currOrgTreeDialog = uiFactory.create(UserOrgPermRelationDetailUI.class.getName(), (Map)this.ctx);
            this.currOrgTreeDialog.show();
        }
        catch (BOSException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public UserOrgPermRelationDetailUI() throws Exception {
        this.mainQueryPk = new MetaDataPK("com.kingdee.eas.ma.budget", "BgElementQuery");
    }

    public IMetaDataPK getQueryPk() {
        return this.mainQueryPk;
    }

    public BOSUuid getSolutionId() {
        return this.solutionId;
    }

    public void setSolutionId(BOSUuid solutionId) {
        this.solutionId = solutionId;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btDataPermission.setIcon(EASResource.getIcon((String)"imgTbtn_unforbidPerm"));
        SorterItemCollection sortCol = new SorterItemCollection();
        sortCol.add(new SorterItemInfo("owner.number"));
        this.mainQuery.setSorter(sortCol);
    }

    protected String getQueryMainName() {
        return UserOrgPermRelationDetailUI.class.getName();
    }

    protected UserOrgPermRelationFilterUI getFilterUI() {
        if (this.defaultFilterUI == null) {
            try {
                this.defaultFilterUI = new UserOrgPermRelationFilterUI((Object)this);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                this.handleException(ex);
            }
        }
        return this.defaultFilterUI;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        dialog.addUserPanel((KDPanel)this.getFilterUI());
        dialog.setMaxReturnCountVisible(true);
        dialog.setShowFilter(true);
        dialog.setShowSorter(true);
        return dialog;
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    @Override
    public void actionDataPermission_actionPerformed(ActionEvent e) throws Exception {
        super.actionDataPermission_actionPerformed(e);
        int[] rowIds = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rowIds.length > 0) {
            String permItemId;
            String orgId;
            IRow currentRow = this.tblMain.getRow(rowIds[0]);
            String userId = currentRow.getCell("owner.id").getValue().toString();
            UserOrgPermInfo userOrgPermInfo = this.getUserOrgPermInfo(userId, orgId = currentRow.getCell("org.id").getValue().toString(), permItemId = currentRow.getCell("permItem.id").getValue().toString());
            String ruleStructure = userOrgPermInfo.getRuleStructure() == null ? "" : userOrgPermInfo.getRuleStructure();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ruleStructure", (Object)ruleStructure);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RuleSelectUI.class.getName(), (Map)uiContext);
            uiWindow.show();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"pleaseSelectDataFirst"));
        }
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"owner.name", "owner.number", "permItem.name", "org.displayName", "defOrgUnit.displayName", "org.number"};
        return locateNames;
    }

    private FilterInfo getDefaultFilter() throws ParserException {
        FilterInfo filterInfo = new FilterInfo();
        try {
            if (SysContext.getSysContext().getCurrentUserInfo().isBizAdmin()) {
                filterInfo = this.helper.getCurrentRangeUserAsAssociation("owner");
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handleException((Exception)((Object)e));
        }
        return filterInfo;
    }

    protected void processFilter() throws BOSException, ParserException {
        if (this.mainQuery.getFilter() == null || this.mainQuery.getFilter().getFilterItems().size() == 0) {
            this.mainQuery.setFilter(this.getDefaultFilter());
        } else {
            this.mainQuery.getFilter().mergeFilter(this.getDefaultFilter(), "AND");
        }
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        try {
            this.processFilter();
            super.tblMain_doRequestRowSet(e);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        catch (ParserException e1) {
            this.handUIException(e1);
        }
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() > 10000) {
            String msg = EASResource.getString((String)RESOURCE, (String)"RODATA_TOO_MUCH");
            MsgBox.showWarning((String)MessageFormat.format(msg, String.valueOf(10000)));
            SysUtil.abort();
        }
        super.actionExport_actionPerformed(e);
    }

    protected UserOrgPermInfo getUserOrgPermInfo(String userId, String orgId, String permId) throws BOSException, EASBizException {
        UserOrgPermInfo userOrgPermInfo = new UserOrgPermInfo();
        UserOrgPermCollection col = UserOrgPermFacadeFactory.getRemoteInstance().getUserOrgPerms(userId, orgId, permId);
        if (col.size() >= 1) {
            userOrgPermInfo = col.get(0);
        }
        return userOrgPermInfo;
    }
}

