/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractUserOrgPermRelationFilterUI;
import com.kingdee.eas.base.permission.client.helper.PermissionOrgF7Factory;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.OUUnionF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class UserOrgPermRelationFilterUI
extends AbstractUserOrgPermRelationFilterUI {
    private static final Logger logger = Logger.getLogger(UserOrgPermRelationFilterUI.class);
    protected Object ui = null;
    private static final String USER_ID = "owner.id";
    private static final String ORG_ID = "org.id";
    private static final String PERM_ID = "permItem.id";

    public UserOrgPermRelationFilterUI() throws Exception {
    }

    public UserOrgPermRelationFilterUI(Object ui) throws Exception {
        this.ui = ui;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        try {
            this.initUser();
            this.initOrgUnit();
            this.initPerm();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void initPerm() throws Exception {
        this.prmtPerm.setQueryInfo("com.kingdee.eas.base.permission.app.PermItemQuery");
        this.prmtPerm.setDisplayFormat("$alias$");
        this.prmtPerm.setEditFormat("$name$");
        this.prmtPerm.setEditable(true);
        this.prmtPerm.setCommitFormat("$name$");
        this.prmtPerm.setData(null);
    }

    protected void initUser() throws Exception {
        this.prmtUser.setQueryInfo("com.kingdee.eas.base.permission.app.UserListQuery");
        this.prmtUser.setDisplayFormat("$name$");
        this.prmtUser.setEditFormat("$number$");
        this.prmtUser.setEditable(true);
        this.prmtUser.setCommitFormat("$number$");
        this.prmtUser.setData((Object)SysContext.getSysContext().getCurrentUserInfo());
    }

    protected void initOrgUnit() throws Exception {
        IObjectPK currentUserPK = ToolUtils.getCurrentUserPK();
        List bizUserCUOrgRange = PermissionRangeHelper.getBizUserCUOrgRange(null, currentUserPK);
        boolean isAdmin = Administrator.isCUAdmin(null, currentUserPK);
        OUUnionF7 orgF7 = PermissionOrgF7Factory.getOUUnionF7((IUIObject)this, new HashSet(), false, "00000000-0000-0000-0000-000000000000CCE7AED4", bizUserCUOrgRange, isAdmin, bizUserCUOrgRange);
        this.prmtOrgUnit.setDisplayFormat("$name$");
        this.prmtOrgUnit.setEditFormat("$number$");
        this.prmtOrgUnit.setCommitFormat("$number$");
        this.prmtOrgUnit.setEditable(true);
        orgF7.setMultiSelect(false);
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgF7);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo fInfo = new FilterInfo();
        Object ob = null;
        if (this.prmtUser.getData() != null) {
            fInfo.getFilterItems().add(new FilterItemInfo(USER_ID, (Object)((UserInfo)this.prmtUser.getData()).getId(), CompareType.EQUALS));
        }
        if (this.prmtOrgUnit.getData() != null && (ob = this.prmtOrgUnit.getData()) instanceof FullOrgUnitInfo) {
            fInfo.getFilterItems().add(new FilterItemInfo(ORG_ID, (Object)((FullOrgUnitInfo)this.prmtOrgUnit.getData()).getId(), CompareType.EQUALS));
        }
        if (this.prmtPerm.getData() != null) {
            fInfo.getFilterItems().add(new FilterItemInfo(PERM_ID, (Object)((PermItemInfo)this.prmtPerm.getData()).getId(), CompareType.EQUALS));
        }
        return fInfo;
    }

    public void clear() {
        try {
            this.prmtOrgUnit.setData(null);
            this.prmtUser.setData(null);
            this.prmtPerm.setData(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void loadData(EntityViewInfo v) {
        try {
            this.onLoad();
            super.loadData(v);
            FilterInfo filter = v.getFilter();
            FilterItemCollection itemCol = filter == null ? new FilterItemCollection() : filter.getFilterItems();
            for (int i = itemCol.size() - 1; i >= 0; --i) {
                FilterItemInfo itemInfo = itemCol.get(i);
                String prop = itemInfo.getPropertyName();
                String compareValue = itemInfo.getCompareValue().toString();
                ObjectStringPK pk = new ObjectStringPK(compareValue);
                if (USER_ID.equals(prop)) {
                    UserInfo user = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)pk, this.getSelector());
                    this.prmtUser.setData((Object)user);
                    continue;
                }
                if (ORG_ID.equals(prop)) {
                    FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)pk, this.getSelector());
                    orgInfo.setNumber(compareValue);
                    this.prmtOrgUnit.setData((Object)orgInfo);
                    continue;
                }
                if (!PERM_ID.equals(prop)) continue;
                PermItemInfo roleInfo = PermItemFactory.getRemoteInstance().getPermItemInfo((IObjectPK)pk, this.getPermSelector());
                roleInfo.setNumber(compareValue);
                this.prmtPerm.setData((Object)roleInfo);
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection col = new SelectorItemCollection();
        col.add(new SelectorItemInfo("name"));
        col.add(new SelectorItemInfo("number"));
        return col;
    }

    private SelectorItemCollection getPermSelector() {
        SelectorItemCollection col = new SelectorItemCollection();
        col.add(new SelectorItemInfo("name"));
        col.add(new SelectorItemInfo("alias"));
        return col;
    }
}

