/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.ConfigurationInfo;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IPermissionManager;
import com.kingdee.eas.base.permission.IPermissionRangeFacade;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionManagerFactory;
import com.kingdee.eas.base.permission.PermissionRangeFacadeFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.client.AbstractUserPermViewUI;
import com.kingdee.eas.base.permission.client.RulePanel;
import com.kingdee.eas.base.permission.client.UserDiscretePermViewUI;
import com.kingdee.eas.base.permission.client.UserFieldAccessViewUI;
import com.kingdee.eas.base.permission.client.helper.OrgHelper;
import com.kingdee.eas.base.permission.client.tree.IPermissionTreeBuilder;
import com.kingdee.eas.base.permission.client.tree.PermissionTreeBuilderFactory;
import com.kingdee.eas.base.permission.client.util.UIUtil;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.client.f7.NewOUUnionF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class UserPermViewUI
extends AbstractUserPermViewUI {
    private static final String permissionResource = "com.kingdee.eas.base.permission.PermissionResource";
    private KDTreeNode branch;
    private boolean isShowRule = false;
    private RulePanel rulePanel = null;
    private static final int AUTHORIZATION_INDEX = 0;
    private static final int NORMAL_INDEX = 1;
    private static final int FORBIDDEN_INDEX = 2;
    private UserInfo targetUser = null;
    private Map userOrgs = null;
    private IPermissionTreeBuilder builder = null;
    private ConfigurationInfo configurationInfo = null;

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.put("CurrentUserPK", (Object)ToolUtils.getCurrentUserPK());
            request.put("TargetUserPK", (Object)this.getTargetUserPK());
            String orgIdStr = StringUtils.cnulls(this.getUIContext().get("SELECT_ORG_ID"));
            if (!StringUtils.isEmpty((String)orgIdStr)) {
                request.put("orgIdStr", (Object)new ObjectStringPK(orgIdStr));
            }
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    private void initUI() throws Exception {
        this.rulePanel = new RulePanel();
        this.rulePanel.setStatus(this.getOprtState() == null ? OprtState.VIEW : this.getOprtState());
        this.add((Component)((Object)this.rulePanel), null);
        this.rulePanel.setBounds(new Rectangle(0, 345, 630, 170));
        this.btnShowRule.setVisible(!this.isShowRule);
        this.btnHideRule.setVisible(this.isShowRule);
        this.btnDiscretePerm.setVisible(false);
        this.btnFieldAccessAccredit.setVisible(false);
        this.tHelper.getDisabledTables().add(this.rulePanel.getTable());
    }

    private void addPopupMenu() {
        UIUtil.addStandardPopupMenu(this.treeAuthorizedPerm);
        UIUtil.addStandardPopupMenu(this.treeNormalPerm);
        UIUtil.addStandardPopupMenu(this.treeForbiddenPerm);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        if (Administrator.isCUAdmin(null, this.getTargetUserPK())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)permissionResource, (String)"adminCanNotViewPerm"));
            this.abort();
        }
        this.setUserOrgs();
        this.setUserInfo();
        this.initTrees();
        this.initOrgF7();
        this.initTab();
        this.selectDefOrg();
        this.loadConfigurationInfo();
    }

    private void loadConfigurationInfo() throws EASBizException, BOSException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        this.configurationInfo = iPermission.getConfigurationInfo();
    }

    private void selectDefOrg() throws EASBizException, BOSException {
        String orgIdStr = StringUtils.cnulls(this.getUIContext().get("SELECT_ORG_ID"));
        FullOrgUnitInfo defOrgUnit = this.targetUser.getDefOrgUnit();
        if (StringUtils.isEmpty((String)orgIdStr)) {
            defOrgUnit = this.targetUser.getDefOrgUnit();
        } else {
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
            defOrgUnit = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(orgIdStr));
        }
        if (defOrgUnit != null && this.userOrgs.containsKey(defOrgUnit.getId().toString())) {
            this.pmtOrg.setData((Object)defOrgUnit);
        }
    }

    private void setUserInfo() throws EASBizException, BOSException {
        this.targetUser = this.getUserInfo(this.getTargetUserPK());
        this.txtUser.setText(this.targetUser.getNumber() + "(" + this.targetUser.getName() + ")");
    }

    private void setUserOrgs() throws EASBizException, BOSException {
        IPermissionRangeFacade iPermissionRangeFaade = PermissionRangeFacadeFactory.getRemoteInstance();
        Collection interOrgCol = iPermissionRangeFaade.getOrgRange(ToolUtils.getCurrentUserPK(), this.getTargetUserPK());
        this.userOrgs = ToolUtils.trans2Map(interOrgCol);
    }

    private void initOrgF7() throws EASBizException, BOSException {
        NewOUUnionF7 ouF7 = new NewOUUnionF7();
        OrgHelper.setF7ByUser(ouF7, this.getTargetUserPK());
        ouF7.setNeedAddOrgRange(false);
        ouF7.setDisplayMaintain(true);
        ouF7.disableTheOUWhichIsOnlyAdmin();
        ouF7.setMultiSelect(false);
        ouF7.setShowAssistantOrg(true);
        ouF7.setContainSealUp(true);
        this.pmtOrg.setSelector((KDPromptSelector)ouF7);
    }

    private void initTrees() throws Exception {
        this.builder = PermissionTreeBuilderFactory.getUserOrgPermTreeBuilder();
        this.createTreeBranch();
        this.addPopupMenu();
        this.clearAllTrees();
    }

    private void createTreeBranch() throws Exception {
        this.branch = this.builder.createTreeBranch();
    }

    private void clearAllTrees() {
        ((DefaultTreeModel)this.treeAuthorizedPerm.getModel()).setRoot(null);
        ((DefaultTreeModel)this.treeNormalPerm.getModel()).setRoot(null);
        ((DefaultTreeModel)this.treeForbiddenPerm.getModel()).setRoot(null);
    }

    private void initTab() throws EASBizException, BOSException {
        if (!this.targetUser.isBizAdmin()) {
            this.tabAssign.setEnabledAt(0, false);
        }
        this.tabAssign.setSelectedIndex(1);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.showRulePanel(this.isShowRule);
    }

    private void showRulePanel(boolean isVisible) {
        this.rulePanel.setVisible(isVisible);
        IUIWindow win = this.getUIWindow();
        if (isVisible) {
            if (win instanceof UIModelDialog) {
                ((UIModelDialog)win).setSize(636, 600);
            } else if (win instanceof Frame) {
                ((Frame)win).setSize(636, 600);
            }
        } else if (win instanceof UIModelDialog) {
            ((UIModelDialog)win).setSize(636, 452);
        } else if (win instanceof Frame) {
            ((Frame)win).setSize(636, 452);
        }
    }

    private void buildAllTrees() throws Exception {
        UserOrgPermCollection userOrgPerms = null;
        IPermissionManager iPermissionManager = PermissionManagerFactory.getRemoteInstance();
        userOrgPerms = (UserOrgPermCollection)iPermissionManager.getAllPerms(this.getTargetUserPK(), this.getSelectedOrgPK());
        ArrayList list = PermissionCommonUtil.assortPerms(userOrgPerms);
        this.buildAuthorizationTree((UserOrgPermCollection)((Object)list.get(0)));
        this.buildNormalTree((UserOrgPermCollection)((Object)list.get(1)));
        this.buildForbiddenTree((UserOrgPermCollection)((Object)list.get(2)));
    }

    private void buildAuthorizationTree(UserOrgPermCollection userOrgPerms) throws Exception {
        KDTreeNode root = this.builder.buildTreeRoot(this.branch, (IObjectCollection)userOrgPerms);
        ((DefaultTreeModel)this.treeAuthorizedPerm.getModel()).setRoot((TreeNode)root);
    }

    private void buildNormalTree(UserOrgPermCollection userOrgPerms) throws Exception {
        KDTreeNode root = this.builder.buildTreeRoot(this.branch, (IObjectCollection)userOrgPerms);
        ((DefaultTreeModel)this.treeNormalPerm.getModel()).setRoot((TreeNode)root);
        this.builder.setDataRuleIcon(root);
    }

    private void buildForbiddenTree(UserOrgPermCollection userOrgPerms) throws Exception {
        KDTreeNode root = this.builder.buildTreeRoot(this.branch, (IObjectCollection)userOrgPerms);
        this.builder.setForbiddenIcon(root);
        ((DefaultTreeModel)this.treeForbiddenPerm.getModel()).setRoot((TreeNode)root);
    }

    @Override
    protected void pmtOrg_dataChanged(DataChangeEvent e) throws Exception {
        super.pmtOrg_dataChanged(e);
        FullOrgUnitInfo org = this.getSelectedOrgInfo();
        if (org != null) {
            this.rulePanel.setCtrlUnitPK((IObjectPK)new ObjectUuidPK(org.getCU().getId()));
            this.buildAllTrees();
        } else {
            this.clearAllTrees();
        }
        this.btnFieldAccessAccredit.setVisible(org != null);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnShowRule.setIcon(EASResource.getIcon((String)"imgTbtn_dataaccredit"));
        this.btnHideRule.setIcon(EASResource.getIcon((String)"imgTbtn_hiderule"));
        this.btnDiscretePerm.setIcon(EASResource.getIcon((String)"imgTbtn_scatterpurview"));
        this.btnFieldAccessAccredit.setIcon(EASResource.getIcon((String)"imgTbtn_fieldpurview"));
    }

    private FullOrgUnitInfo getSelectedOrgInfo() {
        if (this.pmtOrg.getData() == null) {
            return null;
        }
        if (this.pmtOrg.getData() instanceof FullOrgUnitInfo) {
            return (FullOrgUnitInfo)this.pmtOrg.getData();
        }
        return null;
    }

    private IObjectPK getSelectedOrgPK() {
        if (this.getSelectedOrgInfo() == null) {
            return null;
        }
        return new ObjectUuidPK(this.getSelectedOrgInfo().getId());
    }

    private IObjectPK getTargetUserPK() {
        Object object = this.getUIContext().get("targetID");
        if (object == null) {
            return new ObjectUuidPK(this.getCurrentUser().getId());
        }
        return new ObjectUuidPK((String)this.getUIContext().get("targetID"));
    }

    private UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    private CtrlUnitInfo getCurrentCU() {
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private IObjectPK getCurrentCUPK() {
        return new ObjectUuidPK(this.getCurrentCU().getId());
    }

    private UserInfo getUserInfo(IObjectPK userPK) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bizAdmin"));
        sic.add(new SelectorItemInfo("defOrgUnit.id"));
        sic.add(new SelectorItemInfo("defOrgUnit.number"));
        sic.add(new SelectorItemInfo("defOrgUnit.name"));
        sic.add(new SelectorItemInfo("defOrgUnit.CU.id"));
        IUser iUser = UserFactory.getRemoteInstance();
        return iUser.getUserInfo(userPK, sic);
    }

    @Override
    public void actionHideRule_actionPerformed(ActionEvent e) throws Exception {
        super.actionHideRule_actionPerformed(e);
        this.isShowRule = false;
        this.btnShowRule.setVisible(!this.isShowRule);
        this.btnHideRule.setVisible(this.isShowRule);
        this.showRulePanel(this.isShowRule);
        this.rulePanel.refresh();
    }

    @Override
    public void actionShowRule_actionPerformed(ActionEvent e) throws Exception {
        super.actionShowRule_actionPerformed(e);
        this.isShowRule = true;
        this.btnShowRule.setVisible(!this.isShowRule);
        this.btnHideRule.setVisible(this.isShowRule);
        this.showRulePanel(this.isShowRule);
        this.rulePanel.refresh();
    }

    @Override
    protected void treeNormalPerm_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeNormalPerm_valueChanged(e);
        if (e.getNewLeadSelectionPath() != null && e.getNewLeadSelectionPath().getLastPathComponent() != null) {
            this.loadRule((KDTreeNode)e.getNewLeadSelectionPath().getLastPathComponent());
        }
        this.setDiscreteButtonStatus(e);
    }

    private void setDiscreteButtonStatus(TreeSelectionEvent e) {
        BOSObjectType objectType;
        KDTreeNode node;
        Object old;
        if (e.getNewLeadSelectionPath() != null && (old = e.getNewLeadSelectionPath().getLastPathComponent()) != null && this.enableDataPermission(node = (KDTreeNode)old) && (objectType = this.getRuleObjectType(node)) != null) {
            this.btnDiscretePerm.setVisible(this.configurationInfo.getDiscretEntityTables().containsKey(objectType.toString()));
            return;
        }
        this.btnDiscretePerm.setVisible(false);
    }

    private boolean enableDataPermission(KDTreeNode node) {
        if (node.isLeaf()) {
            UserOrgPermInfo info = (UserOrgPermInfo)node.getUserObject();
            String objectType = info.getPermItem().getObjectType();
            if (!StringUtils.isEmpty((String)objectType) && info.getPermItem().isEnableDataPermission()) {
                return true;
            }
        } else {
            int size = node.getChildCount();
            for (int i = 0; i < size; ++i) {
                UserOrgPermInfo info;
                String objectType;
                KDTreeNode child = (KDTreeNode)node.getChildAt(i);
                if (!child.isLeaf() || StringUtils.isEmpty((String)(objectType = (info = (UserOrgPermInfo)child.getUserObject()).getPermItem().getObjectType())) || !info.getPermItem().isEnableDataPermission()) continue;
                return true;
            }
        }
        return false;
    }

    private BOSObjectType getRuleObjectType(KDTreeNode node) {
        if (node.isLeaf()) {
            UserOrgPermInfo info = (UserOrgPermInfo)node.getUserObject();
            String objectType = info.getPermItem().getObjectType();
            if (!StringUtils.isEmpty((String)objectType)) {
                return BOSObjectType.create((String)objectType);
            }
        } else {
            int size = node.getChildCount();
            for (int i = 0; i < size; ++i) {
                UserOrgPermInfo info;
                String objectType;
                KDTreeNode child = (KDTreeNode)node.getChildAt(i);
                if (!child.isLeaf() || StringUtils.isEmpty((String)(objectType = (info = (UserOrgPermInfo)child.getUserObject()).getPermItem().getObjectType()))) continue;
                return BOSObjectType.create((String)objectType);
            }
        }
        return null;
    }

    private void loadRule(KDTreeNode node) throws EASBizException, ParserException, BOSException {
        if (node == null) {
            this.rulePanel.reset();
        } else {
            UserOrgPermInfo info = (UserOrgPermInfo)node.getUserObject();
            if (info.getPermItem().isIsLeaf() && !StringUtils.isEmpty((String)info.getPermItem().getObjectType()) && info.getPermItem().isEnableDataPermission()) {
                this.rulePanel.setBizObjectType(BOSObjectType.create((String)info.getPermItem().getObjectType()));
                String ruleStructure = info.getRuleStructure();
                this.rulePanel.setRuleStructure(ruleStructure);
                this.rulePanel.refresh();
            } else {
                this.rulePanel.reset();
            }
        }
    }

    @Override
    public void actionDiscretePerm_actionPerformed(ActionEvent e) throws Exception {
        BOSObjectType objectType;
        super.actionDiscretePerm_actionPerformed(e);
        Object obj = this.treeNormalPerm.getLastSelectedPathComponent();
        if (obj != null && (objectType = this.getRuleObjectType((KDTreeNode)obj)) != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"bosObjectType", (Object)objectType);
            uiContext.put((Object)"targetUserPK", (Object)this.getTargetUserPK());
            uiContext.put((Object)"targetOrgPK", (Object)this.getSelectedOrgPK());
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(UserDiscretePermViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            window.show();
        }
    }

    @Override
    public boolean isPrepareActionFieldAccessAccredit() {
        return true;
    }

    @Override
    public RequestContext prepareActionFieldAccessAccredit(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
        }
        return request;
    }

    @Override
    public void actionFieldAccessAccredit_actionPerformed(ActionEvent e) throws Exception {
        super.actionFieldAccessAccredit_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"userPK", (Object)this.getTargetUserPK());
        uiContext.put((Object)"orgPK", (Object)this.getSelectedOrgPK());
        uiContext.put((Object)"targetUserInfo", (Object)this.getTargetUser());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(UserFieldAccessViewUI.class.getName(), (Map)uiContext, null, null);
        window.show();
    }

    public UserInfo getTargetUser() {
        return this.targetUser;
    }
}

