/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class NewUserAccreditTreeHelper {
    public static final int AUTHORIZATION_INDEX = 0;
    public static final int NORMAL_INDEX = 1;
    public static final int FORBIDDEN_INDEX = 2;
    private static final Icon ICON_NORNAL = EASResource.getIcon((String)"imgTbtn_unforbidPerm");
    private static final Icon ICON_FORBID = EASResource.getIcon((String)"imgTbtn_forbidPerm");
    private static final Icon ICON_DATARULE = EASResource.getIcon((String)"imgTbtn_dataaccredit");
    private static final Icon ICON_LEAF_ADVICE = EASResource.getIcon((String)"imgTree_folder_leafpick");
    private static final Icon ICON_FOLDER_OPEN_ADVICE = EASResource.getIcon((String)"imgTree_folder_openpick");
    private static final Icon ICON_FOLDER_CLOSE_ADVICE = EASResource.getIcon((String)"imgTree_folder_closepick");

    private TreeModel buildTreeModel(KDTreeNode root) {
        return new DefaultTreeModel((TreeNode)root){

            @Override
            public boolean isLeaf(Object node) {
                return NewUserAccreditTreeHelper.this.isLeaf((KDTreeNode)node);
            }
        };
    }

    public void buildLevelTargetTree(KDTreeNode parent, IObjectCollection childs, int permType, boolean sourceFlag) {
        if (childs == null) {
            return;
        }
        for (UserOrgPermInfo uop : childs) {
            uop.setExtendedProperty("sourceFlag", String.valueOf(sourceFlag));
            uop.setExtendedProperty("expended", "false");
            PermItemInfo permItemInfo = uop.getPermItem();
            if (permItemInfo == null) continue;
            KDTreeNode sourceNode = this.findNode(parent, permItemInfo.getId());
            if (sourceNode != null) {
                this.setExpended(sourceNode, "false");
                if (!sourceFlag) continue;
                this.setSourceFlag(sourceNode, String.valueOf(sourceFlag));
                continue;
            }
            KDTreeNode node = new KDTreeNode((Object)uop);
            switch (permType) {
                case 30: {
                    this.setDefaultIcon(node);
                    break;
                }
                case 10: {
                    this.setDataRuleIcon(node);
                    break;
                }
                case 20: {
                    this.setForbiddenIcon(node);
                }
            }
            node.setText(permItemInfo.getAlias());
            parent.add((MutableTreeNode)node);
        }
        UserOrgPermInfo uopParent = (UserOrgPermInfo)parent.getUserObject();
        uopParent.setExtendedProperty("expended", "true");
    }

    public void buildLevelSourceTree(KDTreeNode parent, IObjectCollection childs, Set targetUOPs) {
        for (UserOrgPermInfo uop : childs) {
            uop.setExtendedProperty("sourceFlag", "true");
            uop.setExtendedProperty("expended", "false");
            PermItemInfo permItemInfo = uop.getPermItem();
            if (permItemInfo == null) continue;
            KDTreeNode node = new KDTreeNode((Object)uop);
            node.setText(permItemInfo.getAlias());
            parent.add((MutableTreeNode)node);
            if (targetUOPs == null || !targetUOPs.contains(permItemInfo.getId().toString())) continue;
            this.setAdviceIcon(node);
        }
        UserOrgPermInfo uopParent = (UserOrgPermInfo)parent.getUserObject();
        uopParent.setExtendedProperty("expended", "true");
    }

    public void buildLevelSourceTree(KDTreeNode parent, IObjectCollection childs) throws EASBizException, BOSException {
        PermItemInfo parentPermInfo = (PermItemInfo)parent.getUserObject();
        for (PermItemInfo permItemInfo : childs) {
            if (permItemInfo == null) continue;
            KDTreeNode node = new KDTreeNode((Object)permItemInfo);
            node.setText(permItemInfo.getAlias());
            parent.add((MutableTreeNode)node);
        }
    }

    public TreeModel getSourceTreeModel(IObjectCollection childs) throws Exception {
        Iterator iterator = childs.iterator();
        KDTreeNode root = null;
        HashMap<BOSUuid, KDTreeNode> mapPerms = new HashMap<BOSUuid, KDTreeNode>();
        while (iterator.hasNext()) {
            UserOrgPermInfo uop = (UserOrgPermInfo)iterator.next();
            uop.setExtendedProperty("sourceFlag", "true");
            PermItemInfo permItemInfo = uop.getPermItem();
            if (permItemInfo == null) continue;
            String flag = permItemInfo.getExtendedProperty("flag");
            if (permItemInfo.getParent() == null) {
                uop.setExtendedProperty("expended", "true");
                root = new KDTreeNode((Object)uop);
                if ("1".equals(flag)) {
                    this.setAdviceIcon(root);
                }
                root.setText(permItemInfo.getAlias());
                mapPerms.put(permItemInfo.getId(), root);
                continue;
            }
            Object parent = mapPerms.get(permItemInfo.getParent().getId());
            if (parent == null) continue;
            uop.setExtendedProperty("expended", "false");
            KDTreeNode node = new KDTreeNode((Object)uop);
            if ("1".equals(flag)) {
                this.setAdviceIcon(node);
            }
            node.setText(permItemInfo.getAlias());
            KDTreeNode parentNode = (KDTreeNode)parent;
            parentNode.add((MutableTreeNode)node);
            mapPerms.put(permItemInfo.getId(), node);
        }
        return this.buildTreeModel(root);
    }

    public void buildTopSourceTree(KDTree tree, IObjectCollection childs, Set targetUOPs) throws Exception {
        Iterator iterator = childs.iterator();
        KDTreeNode root = null;
        HashMap<BOSUuid, KDTreeNode> mapPerms = new HashMap<BOSUuid, KDTreeNode>();
        while (iterator.hasNext()) {
            UserOrgPermInfo uop = (UserOrgPermInfo)iterator.next();
            uop.setExtendedProperty("sourceFlag", "true");
            PermItemInfo permItemInfo = uop.getPermItem();
            if (permItemInfo == null) continue;
            if (permItemInfo.getParent() == null) {
                uop.setExtendedProperty("expended", "true");
                root = new KDTreeNode((Object)uop);
                if (targetUOPs != null && targetUOPs.contains(permItemInfo.getId().toString())) {
                    this.setAdviceIcon(root);
                }
                root.setText(permItemInfo.getAlias());
                mapPerms.put(permItemInfo.getId(), root);
                continue;
            }
            Object parent = mapPerms.get(permItemInfo.getParent().getId());
            if (parent == null) continue;
            uop.setExtendedProperty("expended", "false");
            KDTreeNode node = new KDTreeNode((Object)uop);
            if (targetUOPs != null && targetUOPs.contains(permItemInfo.getId().toString())) {
                this.setAdviceIcon(node);
            }
            node.setText(permItemInfo.getAlias());
            KDTreeNode parentNode = (KDTreeNode)parent;
            parentNode.add((MutableTreeNode)node);
            mapPerms.put(permItemInfo.getId(), node);
        }
        if (root != null && root.getChildCount() > 0) {
            tree.setModel(this.buildTreeModel(root));
        }
    }

    public void buildTopSourceTree(KDTree tree, IObjectCollection childs) throws EASBizException, BOSException {
        Iterator iterator = childs.iterator();
        KDTreeNode root = null;
        HashMap<BOSUuid, KDTreeNode> mapPerms = new HashMap<BOSUuid, KDTreeNode>();
        String parentId = null;
        PermItemCollection checkedPermItemCol = new PermItemCollection();
        while (iterator.hasNext()) {
            PermItemInfo permitemInfo = (PermItemInfo)iterator.next();
            if (permitemInfo == null) continue;
            if (permitemInfo.getParent() == null) {
                root = new KDTreeNode((Object)permitemInfo);
                root.setText(permitemInfo.getAlias());
                root.setCheckBoxVisible(true);
                mapPerms.put(permitemInfo.getId(), root);
                parentId = permitemInfo.getId().toString();
                if (checkedPermItemCol == null || checkedPermItemCol.size() <= 0) continue;
                root.setChecked(true);
                continue;
            }
            Object parent = mapPerms.get(permitemInfo.getParent().getId());
            if (parent == null) continue;
            KDTreeNode node = new KDTreeNode((Object)permitemInfo);
            node.setText(permitemInfo.getAlias());
            KDTreeNode parentNode = (KDTreeNode)parent;
            parentNode.add((MutableTreeNode)node);
            Iterator it = checkedPermItemCol.iterator();
            while (it.hasNext()) {
                PermItemInfo checkedPermitem = (PermItemInfo)it.next();
                if (!checkedPermitem.getId().toString().equals(permitemInfo.getId().toString())) continue;
                node.setChecked(true);
                break;
            }
            mapPerms.put(permitemInfo.getId(), node);
        }
        if (root != null && root.getChildCount() > 0) {
            tree.setModel(this.buildTreeModel(root));
        }
    }

    public void buildTopTargetTree(KDTree tree, IObjectCollection childs) throws Exception {
        Iterator iterator = childs.iterator();
        KDTreeNode root = null;
        HashMap<BOSUuid, KDTreeNode> mapPerms = new HashMap<BOSUuid, KDTreeNode>();
        while (iterator.hasNext()) {
            UserOrgPermInfo uop = (UserOrgPermInfo)iterator.next();
            uop.setExtendedProperty("sourceFlag", "false");
            PermItemInfo permItemInfo = uop.getPermItem();
            if (permItemInfo == null) continue;
            if (permItemInfo.getParent() == null) {
                uop.setExtendedProperty("expended", "true");
                root = new KDTreeNode((Object)uop);
                root.setText(permItemInfo.getAlias());
                mapPerms.put(permItemInfo.getId(), root);
                continue;
            }
            Object parent = mapPerms.get(permItemInfo.getParent().getId());
            if (parent == null) continue;
            uop.setExtendedProperty("expended", "false");
            KDTreeNode node = new KDTreeNode((Object)uop);
            node.setText(permItemInfo.getAlias());
            KDTreeNode parentNode = (KDTreeNode)parent;
            parentNode.add((MutableTreeNode)node);
            mapPerms.put(permItemInfo.getId(), node);
        }
        if (root != null && root.getChildCount() > 0) {
            tree.setModel(this.buildTreeModel(root));
        } else {
            ((DefaultTreeModel)tree.getModel()).setRoot(null);
        }
    }

    public void setFolderCloseIcon(KDTreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        treeNode.setCustomIcon(ICON_FOLDER_CLOSE_ADVICE);
    }

    public void setFolderOpenIcon(KDTreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        treeNode.setCustomIcon(ICON_FOLDER_OPEN_ADVICE);
    }

    public void setNormalIcon(KDTreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        treeNode.setCustomIcon(ICON_NORNAL);
    }

    public void setForbiddenIcon(KDTreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        UserOrgPermInfo uop = (UserOrgPermInfo)treeNode.getUserObject();
        PermItemInfo permItemInfo = uop.getPermItem();
        if (permItemInfo != null && permItemInfo.isIsLeaf()) {
            treeNode.setCustomIcon(ICON_FORBID);
        } else {
            treeNode.setCustomIcon(null);
        }
    }

    public void setDataRuleIcon(KDTreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        UserOrgPermInfo uop = (UserOrgPermInfo)treeNode.getUserObject();
        PermItemInfo permItemInfo = uop.getPermItem();
        if (permItemInfo == null) {
            return;
        }
        if (!StringUtils.isEmpty((String)permItemInfo.getObjectType()) && permItemInfo.isEnableDataPermission()) {
            treeNode.setCustomIcon(ICON_DATARULE);
        } else if (permItemInfo.isIsLeaf()) {
            treeNode.setCustomIcon(ICON_NORNAL);
        } else {
            treeNode.setCustomIcon(null);
        }
    }

    public void setDefaultIcon(KDTreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        treeNode.setCustomIcon(null);
    }

    public void setAdviceIcon(KDTreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        UserOrgPermInfo uop = (UserOrgPermInfo)treeNode.getUserObject();
        PermItemInfo permItemInfo = uop.getPermItem();
        if (permItemInfo == null) {
            return;
        }
        if (permItemInfo.isIsLeaf()) {
            treeNode.setCustomIcon(ICON_LEAF_ADVICE);
        } else {
            treeNode.setCustomIcon(ICON_FOLDER_OPEN_ADVICE);
        }
    }

    public Set getExpendedNodes(KDTree tree) {
        HashSet<KDTreeNode> setNode = new HashSet<KDTreeNode>();
        if (tree == null || tree.getModel() == null || tree.getModel().getRoot() == null) {
            return setNode;
        }
        Enumeration enumeration = ((KDTreeNode)tree.getModel().getRoot()).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            KDTreeNode node = (KDTreeNode)enumeration.nextElement();
            TreePath nodePath = new TreePath(node.getPath());
            if (!tree.isExpanded(nodePath)) continue;
            setNode.add(node);
        }
        return setNode;
    }

    public void addNodes(KDTree tree, KDTreeNode[] treeNodes, Set extendedNodes) throws CloneNotSupportedException {
        int i;
        assert (tree != null && treeNodes != null);
        boolean rootNullFlag = false;
        KDTreeNode root = (KDTreeNode)tree.getModel().getRoot();
        if (root == null) {
            rootNullFlag = true;
        }
        Set targetExpenedNodes = this.getExpendedNodes(tree);
        extendedNodes.addAll(targetExpenedNodes);
        HashSet<String> selectedPermitemIdSet = new HashSet<String>();
        int size = treeNodes.length;
        for (i = 0; i < size; ++i) {
            selectedPermitemIdSet.add(((UserOrgPermInfo)treeNodes[i].getUserObject()).getPermItem().getId().toString());
        }
        int length = treeNodes.length;
        for (i = 0; i < length; ++i) {
            KDTreeNode node = (KDTreeNode)ObjectUtils.createCopy((Object)treeNodes[i]);
            root = this.createRootForAdd(root, node, selectedPermitemIdSet);
        }
        if (root != null && rootNullFlag) {
            tree.setModel(this.buildTreeModel(root));
        }
        ((DefaultTreeModel)tree.getModel()).setRoot((TreeNode)root);
        HashMap<BOSUuid, KDTreeNode> existPermItems = new HashMap<BOSUuid, KDTreeNode>();
        Enumeration enumTarget = ((KDTreeNode)tree.getModel().getRoot()).breadthFirstEnumeration();
        while (enumTarget.hasMoreElements()) {
            KDTreeNode nodeTarget = (KDTreeNode)enumTarget.nextElement();
            existPermItems.put(this.getPermItem(nodeTarget).getId(), nodeTarget);
        }
        for (KDTreeNode treeNode : extendedNodes) {
            BOSUuid permItemID = this.getPermItem(treeNode).getId();
            if (!existPermItems.containsKey(permItemID)) continue;
            TreePath treePath = new TreePath(((KDTreeNode)existPermItems.get(permItemID)).getPath());
            tree.expandPath(treePath);
        }
        BOSUuid selectedPermItemID = this.getPermItem(treeNodes[0]).getId();
        KDTreeNode selectedTreeNode = (KDTreeNode)existPermItems.get(selectedPermItemID);
        tree.setSelectionPath(new TreePath(selectedTreeNode.getPath()));
    }

    public void removeNodes(KDTree tree, KDTreeNode[] treeNodes) {
        assert (treeNodes != null);
        KDTreeNode root = (KDTreeNode)tree.getModel().getRoot();
        int length = treeNodes.length;
        for (int i = 0; i < length; ++i) {
            KDTreeNode foundNode = this.findNode(root, this.getPermItem(treeNodes[i]).getId());
            if (foundNode == null) continue;
            KDTreeNode parent = (KDTreeNode)foundNode.getParent();
            if (parent != null) {
                KDTreeNode removeNode = this.findNode(root, this.getPermItem(treeNodes[i]).getId());
                ((DefaultTreeModel)tree.getModel()).removeNodeFromParent((MutableTreeNode)removeNode);
                while (parent != null && parent.getChildCount() == 0) {
                    KDTreeNode node = parent;
                    if ((parent = (KDTreeNode)node.getParent()) == null) continue;
                    removeNode = this.findNode(root, this.getPermItem(node).getId());
                    ((DefaultTreeModel)tree.getModel()).removeNodeFromParent((MutableTreeNode)removeNode);
                }
                continue;
            }
            root = null;
            break;
        }
        if (root == null || root.getChildCount() == 0) {
            ((DefaultTreeModel)tree.getModel()).setRoot(null);
        }
    }

    public void expand(KDTree tree, Set expendNodes) {
        HashMap<BOSUuid, KDTreeNode> existPermItems = new HashMap<BOSUuid, KDTreeNode>();
        if (tree == null || tree.getModel() == null || tree.getModel().getRoot() == null) {
            return;
        }
        Enumeration enumeration = ((KDTreeNode)tree.getModel().getRoot()).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            KDTreeNode node = (KDTreeNode)enumeration.nextElement();
            existPermItems.put(this.getPermItem(node).getId(), node);
        }
        for (KDTreeNode treeNode : expendNodes) {
            BOSUuid permItemID = this.getPermItem(treeNode).getId();
            if (!existPermItems.containsKey(permItemID)) continue;
            KDTreeNode temp = (KDTreeNode)existPermItems.get(permItemID);
            TreePath treePath = new TreePath(temp.getPath());
            tree.expandPath(treePath);
        }
        tree.updateUI();
    }

    private KDTreeNode findNode(KDTreeNode node, BOSUuid permItemID) {
        boolean isFound = false;
        if (node == null) {
            return null;
        }
        Enumeration enumTarget = node.breadthFirstEnumeration();
        while (enumTarget.hasMoreElements()) {
            KDTreeNode nodeTarget = (KDTreeNode)enumTarget.nextElement();
            PermItemInfo piTarget = this.getPermItem(nodeTarget);
            if (!piTarget.getId().equals((Object)permItemID)) continue;
            isFound = true;
            return nodeTarget;
        }
        if (!isFound) {
            return this.findNode((KDTreeNode)node.getParent(), permItemID);
        }
        return null;
    }

    private KDTreeNode createRootForAdd(KDTreeNode root, KDTreeNode addNode, Set selectedPermitemIdSet) {
        UserOrgPermInfo uop;
        PermItemInfo pIAdd;
        Map mapRoot = this.getNodeMap(root);
        if (mapRoot.containsKey((pIAdd = (uop = (UserOrgPermInfo)addNode.getUserObject()).getPermItem()).getId())) {
            if (pIAdd.isIsLeaf()) {
                return root;
            }
            KDTreeNode node = (KDTreeNode)mapRoot.get(pIAdd.getId());
            UserOrgPermInfo userOrgPerm = (UserOrgPermInfo)node.getUserObject();
            userOrgPerm.setExtendedProperty("sourceFlag", "true");
            this.mergeNode(addNode, mapRoot);
            root = (KDTreeNode)node.getRoot();
        } else {
            KDTreeNode parent = (KDTreeNode)addNode.getParent();
            if (parent == null) {
                root = addNode;
            } else {
                KDTreeNode parentInRoot = null;
                while (parent != null) {
                    this.removeExcludeChilds(parent, addNode);
                    PermItemInfo piParent = this.getPermItem(parent);
                    if (!selectedPermitemIdSet.contains(piParent.getId().toString())) {
                        ((UserOrgPermInfo)parent.getUserObject()).setExtendedProperty("sourceFlag", "false");
                    }
                    if (mapRoot.containsKey(piParent.getId())) {
                        parentInRoot = (KDTreeNode)mapRoot.get(piParent.getId());
                        parentInRoot.add((MutableTreeNode)addNode);
                        break;
                    }
                    addNode = parent;
                    parent = (KDTreeNode)addNode.getParent();
                }
                root = (KDTreeNode)addNode.getRoot();
            }
        }
        return root;
    }

    private Map getNodeMap(KDTreeNode node) {
        if (node == null) {
            return new HashMap();
        }
        HashMap<BOSUuid, KDTreeNode> mapTarget = new HashMap<BOSUuid, KDTreeNode>();
        Enumeration enumTarget = node.breadthFirstEnumeration();
        while (enumTarget.hasMoreElements()) {
            KDTreeNode nodeTarget = (KDTreeNode)enumTarget.nextElement();
            PermItemInfo piTarget = this.getPermItem(nodeTarget);
            mapTarget.put(piTarget.getId(), nodeTarget);
        }
        return mapTarget;
    }

    public PermItemInfo getPermItem(KDTreeNode treeNode) {
        UserOrgPermInfo uop = (UserOrgPermInfo)treeNode.getUserObject();
        return uop.getPermItem();
    }

    private void mergeNode(KDTreeNode addNode, Map mapRoot) {
        PermItemInfo piAdd = this.getPermItem(addNode);
        KDTreeNode nodeInRoot = (KDTreeNode)mapRoot.get(piAdd.getId());
        UserOrgPermInfo uop = (UserOrgPermInfo)addNode.getUserObject();
        if ("false".equals(uop.getExtendedProperty("expended"))) {
            UserOrgPermInfo tuop = (UserOrgPermInfo)nodeInRoot.getUserObject();
            tuop.setExtendedProperty("sourceFlag", "true");
            tuop.setExtendedProperty("expended", "false");
        }
        for (int i = addNode.getChildCount() - 1; i >= 0; --i) {
            KDTreeNode childAdd = (KDTreeNode)addNode.getChildAt(i);
            PermItemInfo piChildAdd = this.getPermItem(childAdd);
            if (piChildAdd.isIsLeaf()) {
                if (mapRoot.containsKey(piChildAdd.getId())) continue;
                nodeInRoot.add((MutableTreeNode)childAdd);
                continue;
            }
            if (mapRoot.containsKey(piChildAdd.getId())) {
                this.mergeNode(childAdd, mapRoot);
                continue;
            }
            nodeInRoot.add((MutableTreeNode)childAdd);
        }
    }

    private void removeExcludeChilds(KDTreeNode parent, KDTreeNode leftChild) {
        assert (leftChild != null);
        PermItemInfo piLeftChild = this.getPermItem(leftChild);
        if (parent != null) {
            Enumeration childs = parent.children();
            HashSet<KDTreeNode> setRemove = new HashSet<KDTreeNode>();
            while (childs.hasMoreElements()) {
                KDTreeNode child = (KDTreeNode)childs.nextElement();
                PermItemInfo piChild = this.getPermItem(child);
                if (piLeftChild.getId().equals((Object)piChild.getId())) continue;
                setRemove.add(child);
            }
            for (KDTreeNode nodeRemove : setRemove) {
                parent.remove((MutableTreeNode)nodeRemove);
            }
        }
    }

    public boolean isLeaf(KDTreeNode node) {
        boolean ret = false;
        PermItemInfo piInfo = null;
        if (node != null) {
            if (node.getUserObject() instanceof UserOrgPermInfo) {
                UserOrgPermInfo uop = (UserOrgPermInfo)node.getUserObject();
                piInfo = uop.getPermItem();
            } else {
                piInfo = (PermItemInfo)node.getUserObject();
            }
            if (piInfo != null) {
                ret = piInfo.isIsLeaf();
            }
        }
        return ret;
    }

    public boolean isExpended(KDTreeNode node) {
        boolean ret = false;
        if (node != null) {
            if (node.getUserObject() instanceof UserOrgPermInfo) {
                UserOrgPermInfo uop = (UserOrgPermInfo)node.getUserObject();
                ret = "true".equals(uop.getExtendedProperty("expended"));
            } else if (node.getUserObject() instanceof PermItemInfo) {
                PermItemInfo permItem = (PermItemInfo)node.getUserObject();
                ret = permItem.isIsLeaf();
            }
        }
        return ret;
    }

    public void setExpended(KDTreeNode node, String expended) {
        if (node != null) {
            UserOrgPermInfo uop = (UserOrgPermInfo)node.getUserObject();
            uop.setExtendedProperty("expended", expended);
        }
    }

    public boolean isSourceFlag(KDTreeNode node) {
        boolean ret = false;
        if (node != null) {
            UserOrgPermInfo uop = (UserOrgPermInfo)node.getUserObject();
            ret = "true".equals(uop.getExtendedProperty("sourceFlag"));
        }
        return ret;
    }

    public void setSourceFlag(KDTreeNode node, String sourceFlag) {
        if (node != null) {
            UserOrgPermInfo uop = (UserOrgPermInfo)node.getUserObject();
            uop.setExtendedProperty("sourceFlag", sourceFlag);
        }
    }

    public UserOrgPermCollection getUserOrgPermFromTree(KDTree tree, IObjectPK targetUserPK, IObjectPK targetOrgPK, PermType permType) {
        Object object;
        UserOrgPermCollection userOrgPerms = new UserOrgPermCollection();
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)targetUserPK.toString()));
        FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
        if (targetOrgPK != null) {
            fullOrgUnitInfo.setId(BOSUuid.read((String)targetOrgPK.toString()));
        }
        if ((object = tree.getModel().getRoot()) != null) {
            KDTreeNode root = (KDTreeNode)object;
            Enumeration enumAuthorization = root.breadthFirstEnumeration();
            while (enumAuthorization.hasMoreElements()) {
                KDTreeNode treeNode = (KDTreeNode)enumAuthorization.nextElement();
                UserOrgPermInfo userOrgPermInfo = (UserOrgPermInfo)treeNode.getUserObject();
                if (!userOrgPermInfo.getPermItem().isIsLeaf() && this.isExpended(treeNode)) continue;
                userOrgPermInfo.setOwner(userInfo);
                userOrgPermInfo.setPermType(permType);
                userOrgPermInfo.setOrg(fullOrgUnitInfo);
                userOrgPermInfo.setCtrlUnit(ToolUtils.getCurrentCU());
                userOrgPerms.add(userOrgPermInfo);
            }
        }
        return userOrgPerms;
    }

    public boolean isEmpty(UserOrgPermCollection[] uops) {
        boolean ret = true;
        for (int i = 0; i < uops.length; ++i) {
            if (uops[i].isEmpty()) continue;
            ret = false;
            break;
        }
        return ret;
    }

    public boolean contains(Set targetUOPs, String longNumber) {
        boolean ret = false;
        Iterator iterator = targetUOPs.iterator();
        while (iterator.hasNext()) {
            String targetLongNumber = iterator.next() + "!";
            if (targetLongNumber.indexOf(longNumber + "!") == -1) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public UserOrgPermCollection getNewUserOrgPermFromTree(KDTree tree, IObjectPK targetUserPK, IObjectPK targetOrgPK, PermType permType) {
        Object object;
        UserOrgPermCollection userOrgPerms = new UserOrgPermCollection();
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)targetUserPK.toString()));
        FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
        if (targetOrgPK != null) {
            fullOrgUnitInfo.setId(BOSUuid.read((String)targetOrgPK.toString()));
        }
        if ((object = tree.getModel().getRoot()) != null) {
            KDTreeNode root = (KDTreeNode)object;
            Enumeration enumAuthorization = root.breadthFirstEnumeration();
            while (enumAuthorization.hasMoreElements()) {
                KDTreeNode treeNode = (KDTreeNode)enumAuthorization.nextElement();
                UserOrgPermInfo userOrgPermInfo = (UserOrgPermInfo)treeNode.getUserObject();
                if (!userOrgPermInfo.getPermItem().isIsLeaf()) continue;
                userOrgPermInfo.setOwner(userInfo);
                userOrgPermInfo.setPermType(permType);
                userOrgPermInfo.setOrg(fullOrgUnitInfo);
                userOrgPermInfo.setCtrlUnit(ToolUtils.getCurrentCU());
                userOrgPerms.add(userOrgPermInfo);
            }
        }
        return userOrgPerms;
    }

    public void refreshCustomIcon(DefaultKingdeeTreeNode sourceRoot, DefaultKingdeeTreeNode targetRoot) {
        if (sourceRoot == null) {
            return;
        }
        Map<Object, Object> keyMapNode = new HashMap();
        if (targetRoot != null) {
            keyMapNode = this.getKeyMapNodeAndRefresh(targetRoot);
        }
        Enumeration enumeration = sourceRoot.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            UserOrgPermInfo userOrgPermInfo;
            PermItemInfo permItemInfo;
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)enumeration.nextElement();
            boolean flag = false;
            Object userObject = node.getUserObject();
            if (userObject instanceof UserOrgPermInfo && (permItemInfo = (userOrgPermInfo = (UserOrgPermInfo)userObject).getPermItem()) != null && permItemInfo.getId() != null && keyMapNode.containsKey(permItemInfo.getId().toString())) {
                this.setAdviceIcon(node);
                flag = true;
            }
            if (flag) continue;
            this.setNoAdviceIcon(node);
        }
    }

    private Map<String, DefaultKingdeeTreeNode> getKeyMapNodeAndRefresh(DefaultKingdeeTreeNode rootNode) {
        HashMap<String, DefaultKingdeeTreeNode> hashMap = new HashMap<String, DefaultKingdeeTreeNode>();
        if (rootNode != null) {
            Enumeration enumeration = rootNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                UserOrgPermInfo userOrgPermInfo;
                PermItemInfo permItemInfo;
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)enumeration.nextElement();
                this.setNoAdviceIcon(node);
                Object userObject = node.getUserObject();
                if (!(userObject instanceof UserOrgPermInfo) || (permItemInfo = (userOrgPermInfo = (UserOrgPermInfo)userObject).getPermItem()) == null || permItemInfo.getId() == null) continue;
                hashMap.put(permItemInfo.getId().toString(), node);
            }
        }
        return hashMap;
    }

    public void setAdviceIcon(DefaultKingdeeTreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        if (treeNode.isLeaf()) {
            treeNode.setCustomIcon(ICON_LEAF_ADVICE);
        } else {
            treeNode.setCustomIcon(ICON_FOLDER_OPEN_ADVICE);
        }
    }

    public void setNoAdviceIcon(DefaultKingdeeTreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        if (treeNode.isLeaf()) {
            treeNode.setCustomIcon(null);
        } else {
            treeNode.setCustomIcon(null);
        }
    }
}

