/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IPermissionRangeFacade;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionRangeFacadeFactory;
import com.kingdee.eas.base.permission.service.OrgRangeService;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.OrgF7PromptDialog;
import com.kingdee.eas.basedata.org.client.OuF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewOUUnionF7;
import com.kingdee.eas.basedata.org.client.service.OrgCommonCilentUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class OrgHelper {
    private static Logger logger = Logger.getLogger(OrgHelper.class);

    public static OrgType getBizObjectOrgType(BOSObjectType bizObjectType) {
        String ORG_TYPE = "OrgType";
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = loader.getEntity(bizObjectType);
        if (StringUtils.isEmpty((String)entity.getExtendedProperty("OrgType"))) {
            return OrgType.NONE;
        }
        return OrgType.getEnum((String)entity.getExtendedProperty("OrgType"));
    }

    public static OrgF7PromptDialog getF7ByOrgType(IUIObject owner, BOSObjectType bizObjectType) {
        OrgF7PromptDialog orgF7 = null;
        OrgType orgType = OrgHelper.getBizObjectOrgType(bizObjectType);
        orgF7 = OrgCommonCilentUtils.createF7((IUIObject)owner, (OrgType)orgType);
        return orgF7;
    }

    public static void setF7ByUser(OrgF7PromptDialog orgF7, IObjectPK targetUserPK) throws EASBizException, BOSException {
        HashMap<String, Boolean> accreditOrgs = new HashMap<String, Boolean>();
        IPermissionRangeFacade iPermissionRangeFacade = PermissionRangeFacadeFactory.getRemoteInstance();
        Collection col = iPermissionRangeFacade.getOrgRange(targetUserPK, ToolUtils.getCurrentUserPK());
        if (col != null) {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                accreditOrgs.put(it.next().toString(), Boolean.FALSE);
            }
        }
        List cuIdList = OrgRangeService.getTopCUOrgRange(null, ToolUtils.getCurrentUserPK());
        try {
            orgF7.setRootUnitIDList(cuIdList);
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
        }
        orgF7.setMultiRootUnits(true);
        orgF7.disablePerm(accreditOrgs);
        orgF7.setIsShowSub(true);
    }

    public static void setF7ByUser(OuF7PromptDialog orgF7, IObjectPK targetUserPK) throws EASBizException, BOSException {
        HashMap<String, Boolean> accreditOrgs = new HashMap<String, Boolean>();
        IPermissionRangeFacade iPermissionRangeFacade = PermissionRangeFacadeFactory.getRemoteInstance();
        Collection col = iPermissionRangeFacade.getOrgRange(targetUserPK, ToolUtils.getCurrentUserPK());
        if (col != null) {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                accreditOrgs.put(it.next().toString(), Boolean.FALSE);
            }
        }
        List cuIdList = OrgRangeService.getTopCUOrgRange(null, ToolUtils.getCurrentUserPK());
        try {
            orgF7.setCuIdList(cuIdList);
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
        }
        orgF7.setMultiCUs(true);
        orgF7.setShowSub(true);
        orgF7.setMultiSelect(true);
        orgF7.useFilter(accreditOrgs);
    }

    public static void setF7ByUser(OrgF7PromptDialog orgF7) throws EASBizException, BOSException {
        IObjectPK curUserPK = ToolUtils.getCurrentUserPK();
        orgF7.setIsCUFilter(false, false);
        orgF7.setMultiRootUnits(true);
        try {
            orgF7.setRootUnitIDList(OrgRangeService.getTopCUOrgRange(null, curUserPK));
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new IllegalArgumentException("argument is not right !");
        }
        orgF7.setContainSealUp(false);
        if (!Administrator.isCUAdmin(null, curUserPK)) {
            List userOrgRangeList = PermissionRangeHelper.getUserOrgId(null, curUserPK, OrgRangeType.BIZ_ORG_TYPE);
            orgF7.disablePerm(ToolUtils.trans2Map(userOrgRangeList));
        }
    }

    public static void setF7ByUser(NewOrgViewF7PromptDialog orgF7) throws EASBizException, BOSException {
        IObjectPK curUserPK = ToolUtils.getCurrentUserPK();
        String orgRangeSQL = PermissionRangeHelper.getUserOrgIdRangeSQL(null, curUserPK, OrgRangeType.BIZ_ORG_TYPE);
        orgF7.setMultiRootUnitsSQL(orgRangeSQL);
        orgF7.setNeedAddSealUp(true);
        if (!Administrator.isCUAdmin(null, curUserPK)) {
            orgF7.setNeedAddOrgRange(false);
            StringBuffer sql = new StringBuffer();
            sql.append("\"BASEUNIT\"").append(".FID IN (").append(orgRangeSQL).append(")");
            orgF7.setExtraTreeFilters(sql.toString());
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.id in (" + orgRangeSQL + ")"));
            orgF7.setOuterFilterInfo(filter);
        }
    }

    public static void setF7ByUser(NewOUUnionF7 orgF7, IObjectPK targetUserPK) throws EASBizException, BOSException {
        orgF7.setMultiRootUnitsSQL(PermissionRangeHelper.getBizUserCUOrgRangeSQL(null, ToolUtils.getCurrentUserPK()));
        orgF7.setShowSub(true);
        orgF7.setMultiSelect(true);
        IPermissionRangeFacade iPermissionRangeFacade = PermissionRangeFacadeFactory.getRemoteInstance();
        String extraSQL = iPermissionRangeFacade.getOrgRangeSql(targetUserPK, ToolUtils.getCurrentUserPK());
        StringBuffer extraTreeFilter = new StringBuffer();
        extraTreeFilter.append("\"BASEUNIT\"").append(".FID IN (").append(extraSQL).append(")");
        orgF7.setExtraTreeFilters(extraTreeFilter.toString());
        try {
            FilterInfo outerFilter = new FilterInfo("unit.id in (" + extraSQL + ")");
            orgF7.setOuterFilterInfo(outerFilter);
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        orgF7.setNeedConsiderFaultTree(true);
    }
}

