/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.client.UserAccreditUI;
import com.kingdee.eas.base.permission.util.LogNamesHelper;
import com.kingdee.eas.base.permission.util.LogProxy;
import com.kingdee.eas.base.permission.util.MyEntityInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class UserAccreditLogHelper {
    private Logger logger = Logger.getLogger(UserAccreditLogHelper.class);
    private UserAccreditUI userAccreditUI;

    public UserAccreditLogHelper(UserAccreditUI userAccreditUI) {
        this.userAccreditUI = userAccreditUI;
    }

    public List doLog(UserOrgPermCollection[] results) throws BOSException {
        ArrayList<LogProxy> retList = new ArrayList<LogProxy>();
        LogProxy logProxy = new LogProxy();
        BOSObjectType bosType = this.userAccreditUI.getBizInterface().getType();
        logProxy.beginLog(null, MyEntityInfo.getMethodAlias(null, bosType, "saveUserOrgPerms"), bosType, null, this.getLogDetail(results));
        retList.add(logProxy);
        return retList;
    }

    private String getLogDetail(UserOrgPermCollection[] results) {
        if (results == null || results.length == 0) {
            this.logger.info((Object)"results is null or length is 0");
            return "";
        }
        StringBuffer sb = new StringBuffer("");
        sb.append(this.getOrgNumerAndUserNumber());
        sb.append(this.getPermInfo(results));
        return sb.toString();
    }

    private String getPermInfo(UserOrgPermCollection[] results) {
        Locale locale = SysContext.getSysContext().getLocale();
        if (results == null || results.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer("");
        sb.append("\n " + LogNamesHelper.getLogName("add4Log", locale) + "(").append(this.getPermInfo(results[0])).append(")");
        sb.append("\n " + LogNamesHelper.getLogName("del4Log", locale) + "(").append(this.getPermInfo(results[1])).append(")");
        sb.append("\n " + LogNamesHelper.getLogName("add4Log", locale) + "(").append(this.getPermInfo(results[2])).append(")");
        return sb.toString();
    }

    private String getPermInfo(UserOrgPermCollection userOrgPermInfo) {
        Locale locale = SysContext.getSysContext().getLocale();
        if (userOrgPermInfo == null || userOrgPermInfo.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer("");
        int size = userOrgPermInfo.size();
        for (int i = 0; i < size; ++i) {
            UserOrgPermInfo userOrgPerm = userOrgPermInfo.get(i);
            sb.append("\n [" + LogNamesHelper.getLogName("permName4Log", locale) + ":").append(userOrgPerm.getPermItem().getAlias());
            sb.append("," + LogNamesHelper.getLogName("permType4Log", locale) + ":").append(userOrgPerm.getPermType().getAlias());
            sb.append("," + LogNamesHelper.getLogName("dataRule4Log", locale) + ":").append(StringUtils.cnulls((String)userOrgPerm.getRuleExpr()));
            sb.append("],");
        }
        return sb.toString();
    }

    private String getOrgNumerAndUserNumber() {
        Locale locale = SysContext.getSysContext().getLocale();
        return LogNamesHelper.getLogName("userNumber4Log", locale) + ":" + this.userAccreditUI.getTargetUser().getNumber() + "\n " + LogNamesHelper.getLogName("orgNumber4Log", locale) + ":" + this.userAccreditUI.getSelectedOrgNumber();
    }

    public void doLogEnd(List logList) {
        if (logList == null || logList.isEmpty()) {
            return;
        }
        int size = logList.size();
        for (int i = 0; i < size; ++i) {
            LogProxy logProxy = (LogProxy)logList.get(i);
            logProxy.end();
        }
    }
}

