/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.PermDebugHelper;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.RoleInfoWithNumber;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.helper.RoleHelper;
import com.kingdee.eas.base.permission.client.helper.UserRoleAssignHelper;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CtrlF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import org.apache.log4j.Logger;

public class UserRoleBatchAssignHelper {
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static final Logger logger = Logger.getLogger(UserRoleAssignHelper.class);
    private CoreUI parentWin = null;
    private KDTabbedPane rolePanel = null;
    private KDList lstAll = null;
    private KDList lstGrant = null;
    private KDList lstAssign = null;
    private DefaultListModel assignRolesCopy = new DefaultListModel();
    private UserCollection targetUserCol = null;
    private static final int AUTHORIZATION_INDEX = 1;
    private boolean isModified = false;

    private UserRoleBatchAssignHelper(Component parentWin, KDTabbedPane rolePanel, KDList lstAll, KDList lstGrant, KDList lstAssign, UserCollection targetUserCol) {
        this.rolePanel = rolePanel;
        this.lstAll = lstAll;
        this.lstGrant = lstGrant;
        this.lstAssign = lstAssign;
        this.targetUserCol = targetUserCol;
        rolePanel.setEnabledAt(1, this.isAllCUAdmin(targetUserCol));
    }

    private boolean isAllCUAdmin(UserCollection targetUserCol) {
        Iterator it = targetUserCol.iterator();
        while (it.hasNext()) {
            UserInfo userInfo;
            Object userObj = it.next();
            if (!(userObj instanceof UserInfo) || (userInfo = (UserInfo)userObj).isBizAdmin()) continue;
            return false;
        }
        return true;
    }

    public static UserRoleBatchAssignHelper getHelper(Component parentWin, KDTabbedPane rolePanel, KDList lstAll, KDList lstGrant, KDList lstAssign, UserCollection targetUserCol) {
        return new UserRoleBatchAssignHelper(parentWin, rolePanel, lstAll, lstGrant, lstAssign, targetUserCol);
    }

    public void loadLists(RoleCollection toAccreditedRoles, RoleCollection[] userRoles, RoleCollection authorizedRole) throws CloneNotSupportedException {
        int i;
        logger.debug((Object)PermissionResUtil.getResource("res_72"));
        this.isModified = false;
        if (authorizedRole == null) {
            authorizedRole = toAccreditedRoles;
        }
        HashSet<BOSUuid> idSet = new HashSet<BOSUuid>();
        int size = authorizedRole.size();
        for (int i2 = 0; i2 < size; ++i2) {
            idSet.add(authorizedRole.get(i2).getId());
        }
        DefaultListModel<RoleInfoWithNumber> authorizedModel = new DefaultListModel<RoleInfoWithNumber>();
        DefaultListModel<RoleInfoWithNumber> assignModel = new DefaultListModel<RoleInfoWithNumber>();
        DefaultListModel<RoleInfoWithNumber> grantModel = new DefaultListModel<RoleInfoWithNumber>();
        this.assignRolesCopy = new DefaultListModel();
        String field = "name";
        try {
            String param = ParamManager.getParamValue(null, null, (String)"RoleDefaultSortingOrder");
            PermDebugHelper.logInfo("param RoleDefaultSortingOrder value: " + field);
            if ("1".equals(param)) {
                field = "number";
            }
            PermDebugHelper.logInfo("Assin role default sorting field is: " + field);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        RoleCollection sortedAuthorizedRoles = this.sortRoleCollection(toAccreditedRoles, field);
        RoleCollection sortedAssignRoles = this.sortRoleCollection(userRoles[0], field);
        RoleCollection sortedGrantRoles = this.sortRoleCollection(userRoles[1], field);
        int size2 = sortedAuthorizedRoles.size();
        for (i = 0; i < size2; ++i) {
            authorizedModel.addElement(UserRoleBatchAssignHelper.toRoleInfoWithNumber(sortedAuthorizedRoles.get(i)));
        }
        size2 = sortedAssignRoles.size();
        for (i = 0; i < size2; ++i) {
            assignModel.addElement(UserRoleBatchAssignHelper.toRoleInfoWithNumber(sortedAssignRoles.get(i)));
        }
        size2 = sortedGrantRoles.size();
        for (i = 0; i < size2; ++i) {
            grantModel.addElement(UserRoleBatchAssignHelper.toRoleInfoWithNumber(sortedGrantRoles.get(i)));
        }
        this.assignRolesCopy = this.lstAssign.getModel() != null ? (DefaultListModel)ObjectUtils.createCopy(assignModel) : null;
        this.lstAll.setModel(authorizedModel);
        this.lstAssign.setModel(assignModel);
        this.lstGrant.setModel(grantModel);
    }

    public static RoleInfoWithNumber toRoleInfoWithNumber(RoleInfo role) {
        RoleInfoWithNumber ret = new RoleInfoWithNumber();
        ret.setName(role.getName());
        ret.setNumber(role.getNumber());
        ret.setId(role.getId());
        ret.setSimpleName(role.getSimpleName());
        return ret;
    }

    private RoleCollection sortRoleCollection(RoleCollection roleCol, final String orderParam) {
        ArrayList<RoleInfo> roleList = new ArrayList<RoleInfo>();
        int size = roleCol.size();
        for (int i = 0; i < size; ++i) {
            roleList.add(roleCol.get(i));
        }
        Collections.sort(roleList, new Comparator(){

            public int compare(Object o1, Object o2) {
                String value1 = UserRoleBatchAssignHelper.this.getHexString(StringUtils.cnulls((Object)((RoleInfo)o1).get(orderParam)), "GB2312");
                String value2 = UserRoleBatchAssignHelper.this.getHexString(StringUtils.cnulls((Object)((RoleInfo)o2).get(orderParam)), "GB2312");
                return value1.compareTo(value2);
            }
        });
        RoleCollection retRoleCol = new RoleCollection();
        int size2 = roleList.size();
        for (int i = 0; i < size2; ++i) {
            retRoleCol.add((RoleInfo)roleList.get(i));
        }
        return retRoleCol;
    }

    private String getHexString(String s, String charset) {
        if (StringUtils.isEmpty((String)s)) {
            return "";
        }
        byte[] b = new byte[1];
        StringBuffer sb = new StringBuffer();
        try {
            b = s.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"", (Throwable)e);
            return "";
        }
        for (int i = 0; i < b.length; ++i) {
            sb.append(Integer.toHexString(b[i] & 0xFF));
        }
        return sb.toString();
    }

    public void clearLists() {
        logger.debug((Object)PermissionResUtil.getResource("res_73"));
        this.lstAll.setModel(new DefaultListModel());
        this.lstAssign.setModel(new DefaultListModel());
        this.lstGrant.setModel(new DefaultListModel());
    }

    private boolean isAssignRoleExists(RoleInfo roleInfo) {
        int size = this.getSelectedRolePanel().getModel().getSize();
        for (int i = 0; i < size; ++i) {
            RoleInfo info = (RoleInfo)this.getSelectedRolePanel().getModel().getElementAt(i);
            if (!info.getId().equals((Object)roleInfo.getId())) continue;
            return true;
        }
        return false;
    }

    public KDList getSelectedRolePanel() {
        if (this.rolePanel.getSelectedIndex() == 1) {
            return this.lstGrant;
        }
        return this.lstAssign;
    }

    public void addSingleRole() {
        logger.debug((Object)PermissionResUtil.getResource("res_74"));
        if (this.lstAll.getSelectedIndex() == -1) {
            return;
        }
        Object[] objects = this.lstAll.getSelectedValues();
        int length = objects.length;
        for (int i = 0; i < length; ++i) {
            RoleInfo roleInfo = (RoleInfo)objects[i];
            if (this.isAssignRoleExists(roleInfo)) continue;
            ((DefaultListModel)this.getSelectedRolePanel().getModel()).addElement(objects[i]);
            this.isModified = true;
        }
        int currentSize = ((DefaultListModel)this.lstAll.getModel()).getSize();
        int selectedIndex = this.getSelectedRolePanel().getSelectedIndex();
        int nextSelectedIndex = selectedIndex;
        if (nextSelectedIndex <= currentSize - 1) {
            this.lstAll.setSelectedIndex(nextSelectedIndex);
        } else {
            this.lstAll.setSelectedIndex(currentSize - 1);
        }
    }

    public void addAllRole() {
        logger.debug((Object)PermissionResUtil.getResource("res_75"));
        int size = this.lstAll.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            RoleInfo roleInfo = (RoleInfo)this.lstAll.getModel().getElementAt(i);
            if (this.isAssignRoleExists(roleInfo)) continue;
            this.getSelectedRolePanel().addElement((Object)roleInfo);
            this.isModified = true;
        }
    }

    public void delSingleRole() {
        logger.debug((Object)PermissionResUtil.getResource("res_76"));
        if (this.getSelectedRolePanel().getSelectedIndex() == -1) {
            return;
        }
        int selectedIndex = this.getSelectedRolePanel().getSelectedIndex();
        if (selectedIndex != -1) {
            this.removeRole();
        } else {
            MsgBox.showWarning((Component)this.parentWin, (String)EASResource.getString((String)RESOURCE, (String)"roleIsNotSelected"));
        }
    }

    private void removeRole() {
        this.isModified = true;
        Object[] objects = this.getSelectedRolePanel().getSelectedValues();
        int length = objects.length;
        for (int i = 0; i < length; ++i) {
            ((DefaultListModel)this.getSelectedRolePanel().getModel()).removeElement(objects[i]);
        }
    }

    public void delAllRole() {
        logger.debug((Object)PermissionResUtil.getResource("res_77"));
        this.isModified = true;
        HashSet<RoleInfo> set = new HashSet<RoleInfo>();
        int n = this.getSelectedRolePanel().getModel().getSize();
        for (int i = 0; i < n; ++i) {
            RoleInfo roleInfo = (RoleInfo)this.getSelectedRolePanel().getModel().getElementAt(i);
            set.add(roleInfo);
        }
        for (Object e : set) {
            this.getSelectedRolePanel().removeElement(e);
        }
    }

    public void addRoleByClicked() {
    }

    public void delRoleByClicked() {
    }

    public List getSelectedAssignRoleIdList() {
        return this.getRoleIdList(this.lstAssign);
    }

    public List getSelectedGrantRoleIdList() {
        return this.getRoleIdList(this.lstGrant);
    }

    private List getRoleIdList(KDList list) {
        ArrayList<String> retList = new ArrayList<String>();
        if (list != null && list.getModel() != null) {
            int size = list.getModel().getSize();
            for (int i = 0; i < size; ++i) {
                RoleInfo roleInfo = (RoleInfo)list.getModel().getElementAt(i);
                if (roleInfo == null) continue;
                retList.add(roleInfo.getId().toString());
            }
        }
        return retList;
    }

    public List getSelectedRoleList() {
        return this.getRoleCol(this.lstAssign);
    }

    public List getSelectedGrantRoleList() {
        return this.getRoleCol(this.lstGrant);
    }

    private List getRoleCol(KDList list) {
        ArrayList<RoleInfo> retList = new ArrayList<RoleInfo>();
        if (list != null && list.getModel() != null) {
            int size = list.getModel().getSize();
            for (int i = 0; i < size; ++i) {
                RoleInfo roleInfo = (RoleInfo)list.getModel().getElementAt(i);
                retList.add(roleInfo);
            }
        }
        return retList;
    }

    public void checkRoleIsSelected() {
        if (this.lstAll.getSelectedValue() == null) {
            MsgBox.showWarning((Component)this.parentWin, (String)EASResource.getString((String)RESOURCE, (String)"viewRolePermWarning"));
            SysUtil.abort();
        }
    }

    public boolean isModify() {
        int sizeB;
        logger.debug((Object)PermissionResUtil.getResource("res_78"));
        if (this.isModified) {
            return true;
        }
        if (this.lstAssign.getModel() == null || this.assignRolesCopy == null) {
            return this.lstAssign.getModel() != null || this.assignRolesCopy != null;
        }
        int sizeA = this.lstAssign.getModel().getSize();
        if (sizeA == (sizeB = this.assignRolesCopy.getSize())) {
            int i;
            HashSet<BOSUuid> setA = new HashSet<BOSUuid>();
            for (i = 0; i < sizeA; ++i) {
                setA.add(((RoleInfo)this.lstAssign.getModel().getElementAt(i)).getId());
            }
            for (i = 0; i < sizeB; ++i) {
                if (setA.contains(((RoleInfo)this.assignRolesCopy.getElementAt(i)).getId())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static FilterInfo getRoleFilter4BizAdmin() {
        return UserRoleBatchAssignHelper.getRoleListFilter4BizAdmin("id");
    }

    public static FilterInfo getRoleListFilter4BizAdmin(String fieldName) {
        FilterInfo fInfo = new FilterInfo();
        fInfo.getFilterItems().add(new FilterItemInfo(fieldName, (Object)("Select FRoleID From T_PM_GrantUserRoleOrg Where FUserID = '" + ToolUtils.getCurrentUserPK().toString() + "' "), CompareType.INNER));
        fInfo.getFilterItems().add(new FilterItemInfo("creator.id", (Object)ToolUtils.getCurrentUserPK().toString()));
        fInfo.setMaskString("#0 or #1");
        return fInfo;
    }

    public static FilterInfo getRoleFilter4BizAdmin(String fieldName) {
        FilterInfo fInfo = new FilterInfo();
        fInfo.getFilterItems().add(new FilterItemInfo(fieldName, (Object)("Select FRoleID From T_PM_GrantUserRoleOrg Where FUserID = '" + ToolUtils.getCurrentUserPK().toString() + "' "), CompareType.INNER));
        return fInfo;
    }

    public static FilterInfo getRoleFilter4OrgF7(String roleId) {
        FilterInfo fInfo = new FilterInfo();
        fInfo.getFilterItems().add(new FilterItemInfo("id", (Object)("Select FOrgID From T_PM_GrantUserRoleOrg Where FRoleID = '" + roleId + "' And FUserID = '" + ToolUtils.getCurrentUserPK().toString() + "' "), CompareType.INNER));
        return fInfo;
    }

    public static FilterInfo getCURangeFilterInfo(String filedName) throws EASBizException, BOSException {
        FilterInfo defFilter = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo(filedName + " in (" + RoleHelper.getCUOrgRangeSQL() + ")");
        defFilter.getFilterItems().add(filterItemInfo);
        defFilter.getFilterItems().add(new FilterItemInfo(filedName, (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        defFilter.setMaskString("#0 or #1");
        return defFilter;
    }

    public static CtrlF7 getCtrlF7(IUIObject parent, IObjectPK currentUserPK) {
        CtrlF7 ctrlF7 = new CtrlF7(parent);
        try {
            List managedCuList = PermissionRangeHelper.getManagedCUIDList(null, currentUserPK);
            HashMap displayCUMap = new HashMap();
            int size = managedCuList.size();
            for (int i = 0; i < size; ++i) {
                displayCUMap.put(managedCuList.get(i), Boolean.FALSE);
            }
            ctrlF7.disablePerm(displayCUMap);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        ctrlF7.setMultiSelect(false);
        ctrlF7.setShowAssistantOrg(true);
        ctrlF7.setIsShowContainSealUp(true);
        return ctrlF7;
    }

    public static RoleCollection filterByCU(RoleCollection roleCol, CtrlUnitInfo cu) {
        if (cu == null) {
            return roleCol;
        }
        RoleCollection ret = new RoleCollection();
        String cuID = StringUtils.cnulls((Object)cu.getId());
        int size = roleCol.size();
        for (int i = 0; i < size; ++i) {
            RoleInfo role = roleCol.get(i);
            String roleCuID = StringUtils.cnulls((Object)role.getCU().getId());
            if (!cuID.equals(roleCuID)) continue;
            ret.add(role);
        }
        return ret;
    }
}

