/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.machine;

import com.kingdee.eas.base.permission.client.machine.IHardwareInfoCollector;
import com.kingdee.eas.base.permission.client.machine.LinuxHardwareInfoCollector;
import com.kingdee.eas.base.uiframe.client.VersionUtil;
import com.kingdee.eas.util.client.EASResource;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import org.apache.log4j.Logger;

public class HardwareInfoCollector
implements IHardwareInfoCollector {
    private static String RESOURCE_NAME = "com.kingdee.eas.base.permission.PermissionResource";
    private static Logger logger = Logger.getLogger(HardwareInfoCollector.class);
    private String dllName = "HardwareInfoCollector.dll";
    private static IHardwareInfoCollector collector = null;

    public static IHardwareInfoCollector getCollector() {
        if (collector == null) {
            if (VersionUtil.isWindowsPlatform()) {
                collector = new HardwareInfoCollector();
            } else {
                if (VersionUtil.isMacOSPlatform()) {
                    throw new UnsupportedOperationException(EASResource.getString((String)RESOURCE_NAME, (String)"COMPUTE_MACHINE"));
                }
                collector = new LinuxHardwareInfoCollector();
            }
        }
        return collector;
    }

    private HardwareInfoCollector() {
        String clientRoot = System.getProperty("easclient.root");
        String dllFullPath = this.dllName;
        dllFullPath = clientRoot.endsWith(File.separator) ? clientRoot + this.dllName : clientRoot + File.separator + this.dllName;
        System.load(dllFullPath);
    }

    @Override
    public native String getHardDriverID();

    @Override
    public native String getCPUID();

    @Override
    public String getMACAddress() {
        String macAddress = "mac_error";
        try {
            macAddress = HardwareInfoCollector.windowsParseMacAddress(HardwareInfoCollector.windowsRunIpConfigCommand());
        }
        catch (ParseException ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        return macAddress;
    }

    private static final String windowsParseMacAddress(String ipConfigResponse) throws ParseException {
        String localHost = null;
        try {
            localHost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new ParseException(ex.getMessage(), 0);
        }
        String lastMacAddress = null;
        String[] resultLines = ipConfigResponse.split("\n");
        for (int i = 0; i < resultLines.length; ++i) {
            String macAddressCandidate;
            if (resultLines[i].indexOf(localHost) >= 0 && lastMacAddress != null) {
                return lastMacAddress;
            }
            int macAddressPosition = resultLines[i].indexOf(":");
            if (macAddressPosition <= 0 || !HardwareInfoCollector.windowsIsMacAddress(macAddressCandidate = resultLines[i].substring(macAddressPosition + 1).trim())) continue;
            lastMacAddress = macAddressCandidate;
        }
        ParseException ex = new ParseException("cannot read MAC address from [" + ipConfigResponse + "]", 0);
        logger.error((Object)ex.getMessage(), (Throwable)ex);
        throw ex;
    }

    private static final boolean windowsIsMacAddress(String macAddressCandidate) {
        return macAddressCandidate.length() == 17;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String windowsRunIpConfigCommand() {
        Process process = null;
        BufferedReader bufferedReader = null;
        StringBuffer buffer = new StringBuffer();
        try {
            process = Runtime.getRuntime().exec("ipconfig /all");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                buffer.append(line);
                buffer.append("\n");
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
            bufferedReader = null;
            process = null;
        }
        return buffer.toString();
    }

    public static void main(String[] args) {
    }
}

