/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.plugin;

import com.kingdee.eas.base.permission.client.plugin.DemoFingerprint;
import com.kingdee.eas.base.permission.client.plugin.IFingerprint;
import com.kingdee.eas.base.security.ISecurityAuthParamManager;
import com.kingdee.eas.base.security.SecurityAuthParamManagerFactory;
import com.kingdee.eas.base.security.fingerprint.FingerprintConfigInfo;
import com.kingdee.util.StringUtils;
import java.awt.Window;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class FingerprintFactory {
    private static final Logger logger = Logger.getLogger(FingerprintFactory.class);

    public static IFingerprint getInstance() {
        IFingerprint fingerprint = null;
        try {
            ISecurityAuthParamManager manger = SecurityAuthParamManagerFactory.getRemoteInstance();
            FingerprintConfigInfo configInfo = manger.getFingerprintConfigInfo();
            if (configInfo != null) {
                String fingerPrintClassName = configInfo.getFingerprintSupplierClass();
                fingerprint = !StringUtils.isEmpty((String)fingerPrintClassName) ? (IFingerprint)Class.forName(fingerPrintClassName).newInstance() : new DemoFingerprint();
            }
        }
        catch (Exception e) {
            fingerprint = new DemoFingerprint();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return fingerprint;
    }

    public static HashMap getContext(Window owner) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String path = System.getProperty("easclient.root");
        path = path + "/";
        hashMap.put("filePath", path);
        hashMap.put("owner", owner);
        return hashMap;
    }

    public static boolean isFingerLoginEnable() {
        boolean isFingerLoginEnable = false;
        try {
            ISecurityAuthParamManager manger = SecurityAuthParamManagerFactory.getRemoteInstance();
            isFingerLoginEnable = manger.isEnableFingerprintAuth();
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
        }
        return isFingerLoginEnable;
    }

    public static String dealUserNumber(String userNumber) {
        if (StringUtils.isEmpty((String)userNumber)) {
            return userNumber;
        }
        int _RPos = userNumber.lastIndexOf("_R");
        if (_RPos == -1) {
            return userNumber;
        }
        return userNumber.substring(0, _RPos);
    }
}

