/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.MachineRegisterCollection;
import com.kingdee.eas.base.permission.MachineRegisterFactory;
import com.kingdee.eas.base.permission.MachineRegisterInfo;
import com.kingdee.eas.base.permission.MachineValidataUserManagerFactory;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.client.machine.MachineCodeUtil;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class MachineRegisterUtil {
    private static final Logger logger = Logger.getLogger(MachineRegisterUtil.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionUIResource";
    private static boolean isRegistered = false;

    public static boolean handleMachineRegister(Object parentUI) {
        boolean result = true;
        try {
            if (PermissionCommonUtil.isMachineRegisterEnabled(null)) {
                boolean isWithUser = PermissionCommonUtil.IsMachineRegisterWithUser(null);
                MachineRegisterInfo info = null;
                if (isWithUser) {
                    String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                    String type = ParamManager.getParamValue(null, null, (String)"BOSBAS_002");
                    if ("0".equalsIgnoreCase(type) && MachineRegisterUtil.isInExclude(userID) || "1".equalsIgnoreCase(type) && !MachineRegisterUtil.isInExclude(userID)) {
                        return true;
                    }
                    info = (MachineRegisterInfo)MachineRegisterUtil.getRegisterInfoByMachineCodeByUserId(MachineCodeUtil.getMachineCode(null), userID);
                } else {
                    info = MachineRegisterFactory.getRemoteInstance().getRegisterInfoByMachineCode(MachineCodeUtil.getMachineCode(null));
                }
                if (info == null || !info.isIsRegistered() || info.getInValidDate().getTime() < System.currentTimeMillis() || info.getValidDate().getTime() > System.currentTimeMillis()) {
                    String msgInfo = "isNeedMachineRegistered";
                    if (info != null) {
                        msgInfo = "infoIsInformNow";
                    }
                    if (0 == MsgBox.showConfirm2((Component)((Component)parentUI), (String)EASResource.getString((String)RESOURCE, (String)msgInfo))) {
                        HashMap<String, Object> hm = new HashMap<String, Object>();
                        if (info != null) {
                            hm.put("InitDataObject", info);
                        }
                        hm.put("Owner", parentUI);
                        UITools.showUI("com.kingdee.eas.base.permission.client.MachineRegisterEditUI", hm);
                    }
                    result = false;
                    UserMonitorFactory.getRemoteInstance().deleteSessionAndUserMonitorInfo(SysContext.getSysContext().getSessionID(), Boolean.valueOf(false));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        isRegistered = result;
        return result;
    }

    private static IObjectValue getRegisterInfoByMachineCodeByUserId(String machineCode, String UserId) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("machineCode", (Object)machineCode));
        filter.getFilterItems().add(new FilterItemInfo("creator.id", (Object)UserId));
        filter.getFilterItems().add(new FilterItemInfo("validDate", (Object)new Date(), CompareType.LESS));
        filter.getFilterItems().add(new FilterItemInfo("inValidDate", (Object)new Date(), CompareType.GREATER));
        evi.setFilter(filter);
        evi.getSelector().add("creator.*");
        evi.getSelector().add("CU.*");
        evi.getSelector().add("*");
        MachineRegisterCollection machineRegisterCollection = MachineRegisterFactory.getRemoteInstance().getMachineRegisterCollection(evi);
        IObjectValue object = null;
        if (machineRegisterCollection.size() > 0) {
            object = machineRegisterCollection.getObject(0);
        }
        return object;
    }

    private static boolean isInExclude(String UserId) throws BOSException, EASBizException {
        return MachineValidataUserManagerFactory.getRemoteInstance().exists("where user.id='" + UserId + "'");
    }
}

