/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.QueryHelperInfo;
import com.kingdee.eas.base.permission.client.util.QueryUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jfree.util.Log;

public class TableHelper {
    private static final Logger logger = Logger.getLogger((String)TableHelper.class.getName());
    private static final String INDEX_COLUMN_NAME = "index_" + System.currentTimeMillis();
    boolean isModify = false;
    private boolean needRequestData = false;
    private KDTable table;
    private int virtualIndex = 0;
    private boolean isFiristGetData = true;
    private QueryHelperInfo queryHelperInfo = null;
    private QueryInfo bizQuery = null;

    public TableHelper(QueryHelperInfo queryHelperInfo, KDTable table) {
        this.table = table;
        this.queryHelperInfo = queryHelperInfo;
        this.bizQuery = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(queryHelperInfo.getIMetaDataPK());
        this.deal();
    }

    public void setFilterInfo(FilterInfo filterInfo) {
        this.queryHelperInfo.setFilterInfo(filterInfo);
    }

    public FilterInfo getFilterInfo() {
        return this.queryHelperInfo.getFilterInfo();
    }

    public void deal() {
        this.table.getStyleAttributes().setLocked(true);
        this.table.getSelectManager().setSelectMode(10);
        this.table.getDataRequestManager().setDataRequestMode(1);
        this.table.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                TableHelper.this.requestRowSet(e);
            }
        });
        this.table.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
            }
        });
    }

    private void requestRowSet(RequestRowSetEvent e) {
        if (this.isNeedRequestData()) {
            IMetaDataPK queryPK = this.queryHelperInfo.getIMetaDataPK();
            IQueryExecutor queryExecutor = this.getQueryExecutor(queryPK);
            FilterInfo filterInfo = this.getFilterInfo();
            if (filterInfo != null) {
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                entityViewInfo.setFilter(filterInfo);
                queryExecutor.setObjectView(entityViewInfo);
            }
            try {
                IRowSet rowSet = queryExecutor.executeQuery();
                e.setRowSet(rowSet);
                if (this.isFiristGetData) {
                    this.table.setRowCount(queryExecutor.getQueryKeys(queryExecutor.openQuery()).size() + this.virtualIndex);
                    this.isFiristGetData = false;
                }
            }
            catch (BOSException e1) {
                logger.error((Object)"", (Throwable)e1);
            }
        }
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK) {
        IQueryExecutor queryExecutor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExecutor.option().isAutoTranslateEnum = true;
        queryExecutor.option().isAutoTranslateBoolean = true;
        queryExecutor.option().isAutoIgnoreZero = true;
        return queryExecutor;
    }

    private void setColFormatter(IColumn col, Map fieldTypeMap, QueryFieldInfo field) {
        if (col == null || fieldTypeMap == null || fieldTypeMap.isEmpty() || field == null) {
            return;
        }
        DataType dataType = (DataType)fieldTypeMap.get(field.getName());
        if (dataType == null) {
            return;
        }
        if (DataType.BOOLEAN.equals((Object)dataType)) {
            col.getStyleAttributes().setNumberFormat("@" + DataType.BOOLEAN.getAlias() + "-" + field.getName());
        } else if (DataType.ENUM.equals((Object)dataType)) {
            col.getStyleAttributes().setNumberFormat("@" + DataType.ENUM.getAlias() + "-" + QueryUtils.getEnumClassName(this.bizQuery, field.getName()));
        }
    }

    public void fillTableHeader() {
        String IS_VISIBLE_FOR_KDTABLE = "isVisibleForKDTable";
        String COL_WIDTH_IN_KDTABLE = "ColWidthInKDTable";
        String DISPLAY_FORMAT = "displayFormat";
        String QUERY = "mainQuery";
        this.table.setRefresh(false);
        SelectorInfo selector = this.bizQuery.getSelector();
        int size = selector.getFields().size();
        QueryFieldInfo field = null;
        String[] bindContents = new String[size];
        Map exProperties = this.bizQuery.getExtendedProperties();
        for (int i = 0; i < size; ++i) {
            String colFormat;
            IColumn col = this.table.addColumn();
            field = (QueryFieldInfo)selector.getFields().get(i);
            exProperties = field.getExtendedProperties();
            bindContents[i] = field.getName();
            col.setKey(bindContents[i]);
            if (exProperties == null) continue;
            Object objectVisible = exProperties.get("isVisibleForKDTable");
            boolean visible = true;
            if (objectVisible instanceof Boolean) {
                visible = (Boolean)objectVisible;
            } else if (objectVisible instanceof String) {
                visible = objectVisible == null ? true : Boolean.valueOf((String)objectVisible);
            }
            col.getStyleAttributes().setHided(!visible);
            Object objectColWidth = exProperties.get("ColWidthInKDTable");
            int colWidth = 100;
            if (objectColWidth instanceof Integer) {
                colWidth = (Integer)objectColWidth;
            } else if (objectColWidth instanceof String) {
                colWidth = Integer.parseInt((String)objectColWidth);
            }
            col.setWidth(colWidth);
            Object objColFormat = exProperties.get("displayFormat");
            if (!(objColFormat instanceof String) || StringUtils.isEmpty((String)(colFormat = (String)objColFormat))) continue;
            col.getStyleAttributes().setNumberFormat(colFormat);
        }
        this.table.putBindContents("mainQuery", bindContents);
        this.table.checkParsed(true);
        IRow row = this.table.addHeadRow();
        for (int i = 0; i < size; ++i) {
            field = (QueryFieldInfo)selector.getFields().get(i);
            String displayName = field.getDisplayName();
            row.getCell(i).setValue((Object)displayName);
        }
        this.table.setRefresh(true);
    }

    public void fillTableHeaderDiscrete() {
        String IS_VISIBLE_FOR_KDTABLE = "isVisibleForKDTable";
        String COL_WIDTH_IN_KDTABLE = "ColWidthInKDTable";
        String DISPLAY_FORMAT = "displayFormat";
        String QUERY = "mainQuery";
        this.table.setRefresh(false);
        this.table.getMergeManager().setMergeMode(1);
        SelectorInfo selector = this.bizQuery.getSelector();
        int size = selector.getFields().size();
        QueryFieldInfo field = null;
        ArrayList<String> bindContentsList = new ArrayList<String>();
        ArrayList<String> nameList = new ArrayList<String>();
        bindContentsList.add("fuserNumber");
        nameList.add(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionResource", (String)"user"));
        IColumn firstCol = this.table.addColumn();
        firstCol.setKey("fuserNumber");
        firstCol.setGroup(true);
        firstCol.setMergeable(true);
        bindContentsList.add("forgName");
        nameList.add(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionResource", (String)"orgName"));
        IColumn orgCol = this.table.addColumn();
        orgCol.setKey("forgName");
        orgCol.setGroup(true);
        orgCol.setMergeable(true);
        Map exProperties = this.bizQuery.getExtendedProperties();
        Map fieldTypeMap = QueryUtils.getDataTypeMap(this.bizQuery);
        for (int i = 0; i < size; ++i) {
            String colFormat;
            IColumn col = this.table.addColumn();
            field = (QueryFieldInfo)selector.getFields().get(i);
            exProperties = field.getExtendedProperties();
            bindContentsList.add(field.getName());
            nameList.add(field.getDisplayName());
            col.setKey(field.getName());
            this.setColFormatter(col, fieldTypeMap, field);
            if (exProperties == null) continue;
            Object objectVisible = exProperties.get("isVisibleForKDTable");
            boolean visible = true;
            if (objectVisible instanceof Boolean) {
                visible = (Boolean)objectVisible;
            } else if (objectVisible instanceof String) {
                visible = objectVisible == null ? true : Boolean.valueOf((String)objectVisible);
            }
            col.getStyleAttributes().setHided(!visible);
            Object objectColWidth = exProperties.get("ColWidthInKDTable");
            int colWidth = 100;
            if (objectColWidth instanceof Integer) {
                colWidth = (Integer)objectColWidth;
            } else if (objectColWidth instanceof String) {
                colWidth = Integer.parseInt((String)objectColWidth);
            }
            col.setWidth(colWidth);
            Object objColFormat = exProperties.get("displayFormat");
            if (!(objColFormat instanceof String) || StringUtils.isEmpty((String)(colFormat = (String)objColFormat))) continue;
            col.getStyleAttributes().setNumberFormat(colFormat);
        }
        IColumn lastCol = this.table.addColumn();
        lastCol.setKey("fpermItemName");
        bindContentsList.add("fpermItemName");
        nameList.add(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionResource", (String)"permName"));
        String[] bindContentsAry = new String[bindContentsList.size()];
        bindContentsList.toArray(bindContentsAry);
        this.table.putBindContents("mainQuery", bindContentsAry);
        this.table.checkParsed(true);
        IRow row = this.table.addHeadRow();
        for (int i = 0; i < nameList.size(); ++i) {
            row.getCell(i).setValue(nameList.get(i));
        }
        this.table.setRefresh(true);
    }

    public void fillTableHeaderDiscreteRole() {
        String IS_VISIBLE_FOR_KDTABLE = "isVisibleForKDTable";
        String COL_WIDTH_IN_KDTABLE = "ColWidthInKDTable";
        String DISPLAY_FORMAT = "displayFormat";
        String QUERY = "query";
        this.table.setRefresh(false);
        this.table.getMergeManager().setMergeMode(1);
        SelectorInfo selector = this.bizQuery.getSelector();
        int size = selector.getFields().size();
        QueryFieldInfo field = null;
        ArrayList<String> bindContentsList = new ArrayList<String>();
        ArrayList<String> nameList = new ArrayList<String>();
        bindContentsList.add("fdRoelName");
        nameList.add(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionResource", (String)"role"));
        IColumn orgCol = this.table.addColumn();
        orgCol.setKey("fdRoelName");
        orgCol.setMergeable(true);
        Map fieldTypeMap = QueryUtils.getDataTypeMap(this.bizQuery);
        Map exProperties = this.bizQuery.getExtendedProperties();
        for (int i = 0; i < size; ++i) {
            String colFormat;
            IColumn col = this.table.addColumn();
            field = (QueryFieldInfo)selector.getFields().get(i);
            exProperties = field.getExtendedProperties();
            bindContentsList.add(field.getName());
            nameList.add(field.getDisplayName());
            col.setKey(field.getName());
            this.setColFormatter(col, fieldTypeMap, field);
            if (exProperties == null) continue;
            Object objectVisible = exProperties.get("isVisibleForKDTable");
            boolean visible = true;
            if (objectVisible instanceof Boolean) {
                visible = (Boolean)objectVisible;
            } else if (objectVisible instanceof String) {
                visible = objectVisible == null ? true : Boolean.valueOf((String)objectVisible);
            }
            col.getStyleAttributes().setHided(!visible);
            Object objectColWidth = exProperties.get("ColWidthInKDTable");
            int colWidth = 100;
            if (objectColWidth instanceof Integer) {
                colWidth = (Integer)objectColWidth;
            } else if (objectColWidth instanceof String) {
                colWidth = Integer.parseInt((String)objectColWidth);
            }
            col.setWidth(colWidth);
            Object objColFormat = exProperties.get("displayFormat");
            if (!(objColFormat instanceof String) || StringUtils.isEmpty((String)(colFormat = (String)objColFormat))) continue;
            col.getStyleAttributes().setNumberFormat(colFormat);
        }
        IColumn lastCol = this.table.addColumn();
        lastCol.setKey("fpermItemName");
        bindContentsList.add("fpermItemName");
        nameList.add(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionResource", (String)"permName"));
        String[] bindContentsAry = new String[bindContentsList.size()];
        bindContentsList.toArray(bindContentsAry);
        this.table.putBindContents("query", bindContentsAry);
        this.table.checkParsed(true);
        IRow row = this.table.addHeadRow();
        for (int i = 0; i < nameList.size(); ++i) {
            row.getCell(i).setValue(nameList.get(i));
        }
        this.table.setRefresh(true);
    }

    public boolean existBizData(IObjectValue bizData) {
        if (bizData == null || bizData.get("id") == null) {
            return false;
        }
        String idField = this.getLogicPKField(this.bizQuery);
        int count = this.table.getBody().size();
        for (int i = 0; i < count; ++i) {
            String existBizDataID;
            String bizDataID = bizData.get("id").toString();
            if (this.table.getRow(i).getStyleAttributes().isHided() || !bizDataID.equals(existBizDataID = this.table.getRow(i).getCell(idField).getValue().toString())) continue;
            return true;
        }
        return false;
    }

    public void addRow(Object data) throws ClassNotFoundException {
        if (data != null) {
            if (data instanceof Object[]) {
                Object[] datas = (Object[])data;
                int length = datas.length;
                for (int i = 0; i < length; ++i) {
                    IObjectValue objectValue = (IObjectValue)datas[i];
                    if (this.existBizData(objectValue)) continue;
                    this.loadRowData(objectValue);
                    this.table.setRowCount(this.table.getRowCount() + 1);
                }
            } else {
                IObjectValue objectValue = (IObjectValue)data;
                if (!this.existBizData(objectValue)) {
                    this.loadRowData(objectValue);
                    this.table.setRowCount(this.table.getRowCount() + 1);
                }
            }
            this.table.reLayoutAndPaint();
        }
    }

    private DataType getDataType(String field) {
        return QueryUtils.getDataType(this.bizQuery, field);
    }

    private void loadRowData(IObjectValue objectValue) throws ClassNotFoundException {
        this.isModify = true;
        this.table.setRefresh(false);
        IRow row = this.table.addRow(0);
        Map fieldRefEntityPropertyMap = QueryUtils.getEntityFieldMap(this.bizQuery);
        int count = this.table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            String field = this.table.getColumnKey(i);
            if (INDEX_COLUMN_NAME.equals(field)) continue;
            DataType dataType = this.getDataType(field);
            Object fieldData = null;
            String entityPropertyName = (String)fieldRefEntityPropertyMap.get(field);
            if (StringUtils.isEmpty((String)entityPropertyName)) continue;
            if (entityPropertyName.indexOf(".") != -1) {
                String[] properties = StringUtils.split((String)entityPropertyName, (String)".");
                fieldData = objectValue;
                int length = properties.length;
                for (int j = 0; j < length; ++j) {
                    if (fieldData == null) {
                        fieldData = null;
                        break;
                    }
                    fieldData = ((IObjectValue)fieldData).get(properties[j]);
                }
            } else {
                fieldData = objectValue.get(entityPropertyName);
            }
            if (DataType.BOOLEAN.equals((Object)dataType)) {
                if (fieldData != null) {
                    fieldData = TypeConversionUtils.objToBoolean((Object)fieldData);
                }
            } else if (DataType.ENUM.equals((Object)dataType) && fieldData != null) {
                Class<?> enumClass = Class.forName(this.getEnumClassName(entityPropertyName));
                if (fieldData instanceof String) {
                    fieldData = EnumUtils.getEnum(enumClass, (String)((String)fieldData)).getAlias();
                } else if (fieldData instanceof Integer) {
                    fieldData = EnumUtils.getEnum(enumClass, (int)((Integer)fieldData)).getAlias();
                }
            }
            row.getCell(i).setValue(fieldData);
        }
        this.table.setRefresh(true);
    }

    private String getEnumClassName(String field) {
        return QueryUtils.getEnumClassName(this.bizQuery, field);
    }

    private String getLogicPKField(QueryInfo queryInfo) {
        assert (this.bizQuery.getQueryPK().getKeyPropertys().size() == 1);
        QueryFieldInfo queryFieldInfo = this.bizQuery.getQueryPK().getKeyPropertys().get(0);
        return (String)queryFieldInfo.get("name");
    }

    public void removeRow(ActionEvent e) {
        for (int i = this.table.getSelectManager().size() - 1; i >= 0; --i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.table, (IBlock)this.table.getSelectManager().get(i));
            int size1 = selectBlock.getTop();
            for (int j = selectBlock.getBottom(); j >= size1; --j) {
                this.table.removeRow(j);
            }
        }
    }

    public boolean isNeedRequestData() {
        return this.needRequestData;
    }

    public void setNeedRequestData(boolean needRequestData) {
        this.needRequestData = needRequestData;
    }

    public Set getSelectedBizDataIDs() {
        HashSet<BOSUuid> bizDataIDs = new HashSet<BOSUuid>();
        String idField = this.getLogicPKField(this.bizQuery);
        int size = this.table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.table, (IBlock)this.table.getSelectManager().get(i));
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                String bizDataID = this.table.getRow(j).getCell(idField).getValue().toString();
                bizDataIDs.add(BOSUuid.read((String)bizDataID));
            }
        }
        return bizDataIDs;
    }

    public Set getAllBizDataIDs() {
        HashSet<BOSUuid> bizDataIDs = new HashSet<BOSUuid>();
        String idField = this.getLogicPKField(this.bizQuery);
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            String bizDataID = this.table.getRow(i).getCell(idField).getValue().toString();
            bizDataIDs.add(BOSUuid.read((String)bizDataID));
        }
        return bizDataIDs;
    }

    public Set getAllUserOrRoleIDs(boolean isUser) {
        HashSet<String> bizDataIDs = new HashSet<String>();
        String idField = this.getLogicPKField(this.bizQuery);
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            String bizDataID = this.table.getRow(i).getCell(idField).getValue().toString();
            Log.info((Object)this.bizQuery.getSelector().getFields().toString());
            Object bizDatanumber = null;
            if (this.table.getRow(i) == null) continue;
            bizDatanumber = isUser ? this.table.getRow(i).getCell(((QueryFieldInfo)this.bizQuery.getSelector().getFields().get(1)).toString()).getValue() : this.table.getRow(i).getCell(((QueryFieldInfo)this.bizQuery.getSelector().getFields().get(1)).toString()).getValue();
            bizDataIDs.add(BOSUuid.read((String)bizDataID) + " " + (bizDatanumber == null ? "" : bizDatanumber.toString()));
        }
        return bizDataIDs;
    }
}

