/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.service.helper;

import com.kingdee.eas.base.permission.UsbKeyException;
import com.kingdee.eas.base.permission.service.helper.DefaultUsbKeyBaseOperator;
import com.kingdee.eas.base.permission.service.helper.IUsbKeyBaseOperator;
import com.kingdee.eas.base.permission.service.helper.IUsbKeyControlExtern;
import com.kingdee.eas.base.permission.service.helper.ekey.EUsbKeyBaseOperatorImpl;
import org.apache.log4j.Logger;

public class UsbKeyControlImpl
implements IUsbKeyControlExtern {
    private static Logger logger = Logger.getLogger((String)UsbKeyControlImpl.class.getName());
    private IUsbKeyBaseOperator iMyKey = null;
    private int fileNo = 9;

    @Override
    public void setUsbKeyBaseOperator(IUsbKeyBaseOperator myKey) {
        this.iMyKey = myKey;
    }

    @Override
    public void setFileNo(int fileNo) {
        this.fileNo = fileNo;
    }

    @Override
    public boolean isKeyLogin() throws UsbKeyException {
        return this.iMyKey.isKeyLogin();
    }

    @Override
    public void write(String contentStr) throws UsbKeyException {
        try {
            this.init();
            this.ensureFileExist();
            this.iMyKey.connectionDevice();
            this.iMyKey.writeFile(contentStr);
            logger.info((Object)("write str right over! str is:" + contentStr));
        }
        catch (UsbKeyException ue) {
            logger.error((Object)"UsbKeyException error!", (Throwable)((Object)ue));
            throw new UsbKeyException(UsbKeyException.USB_WRITE_ERROR);
        }
        finally {
            if (this.iMyKey != null) {
                this.iMyKey.closeDevice();
            }
        }
    }

    private void ensureFileExist() throws UsbKeyException {
        try {
            this.iMyKey.connectionDevice();
            try {
                this.iMyKey.openFile(this.fileNo);
                this.iMyKey.deleteFile();
            }
            catch (UsbKeyException e) {
                logger.error((Object)"del file error !", (Throwable)((Object)e));
            }
            try {
                this.iMyKey.createFile(this.fileNo);
            }
            catch (UsbKeyException e) {
                logger.error((Object)"create file error!", (Throwable)((Object)e));
                throw new UsbKeyException(UsbKeyException.USB_WRITE_ERROR);
            }
        }
        catch (UsbKeyException ue) {
            logger.error((Object)"ensureFileExist error!", (Throwable)((Object)ue));
            throw new UsbKeyException(UsbKeyException.USB_INIT_ERROR);
        }
        finally {
            if (this.iMyKey != null) {
                this.iMyKey.closeDevice();
            }
        }
    }

    private void init() throws UsbKeyException {
        try {
            if (this.iMyKey == null) {
                this.iMyKey = DefaultUsbKeyBaseOperator.getInstance();
            }
            this.iMyKey.init();
            logger.info((Object)"CreateContext succeeded\n");
        }
        catch (Throwable e) {
            logger.error((Object)"init error!please install driver!", e);
            throw new UsbKeyException(UsbKeyException.USB_INIT_ERROR);
        }
    }

    @Override
    public String read(int length) throws UsbKeyException {
        try {
            this.init();
            this.iMyKey.connectionDevice();
            logger.info((Object)"OpenDevice succeeded, found first this.iMyKey\n");
            this.iMyKey.openFile(this.fileNo);
            String string = this.iMyKey.readFile(length);
            return string;
        }
        catch (UsbKeyException ue) {
            logger.error((Object)"UsbKeyException fail!", (Throwable)((Object)ue));
            throw new UsbKeyException(UsbKeyException.USB_INIT_ERROR);
        }
        finally {
            if (this.iMyKey != null) {
                this.iMyKey.closeDevice();
            }
        }
    }

    public void test() throws UsbKeyException {
        logger.info((Object)("fileNo is:" + this.fileNo));
        this.ensureFileExist();
    }

    public static void main(String[] args) {
        try {
            UsbKeyControlImpl usbKeyProxy = new UsbKeyControlImpl();
            usbKeyProxy.setFileNo(9);
            EUsbKeyBaseOperatorImpl iUsbKey = new EUsbKeyBaseOperatorImpl();
            usbKeyProxy.setUsbKeyBaseOperator(iUsbKey);
            String testStr = "";
            usbKeyProxy.verifyPwd(testStr);
        }
        catch (UsbKeyException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void verifyPwd(String content) throws UsbKeyException {
        try {
            this.iMyKey.connectionDevice();
            this.iMyKey.verifyPwd(content);
        }
        finally {
            try {
                if (this.iMyKey != null) {
                    this.iMyKey.closeDevice();
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    @Override
    public String getKeyNumber() throws UsbKeyException {
        try {
            this.iMyKey.connectionDevice();
            String string = this.iMyKey.getNo();
            return string;
        }
        finally {
            try {
                if (this.iMyKey != null) {
                    this.iMyKey.closeDevice();
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    @Override
    public String isUsbKeyExistent() throws UsbKeyException {
        try {
            this.iMyKey.connectionDevice();
            String string = this.iMyKey.isUsbKeyExistent();
            return string;
        }
        finally {
            try {
                if (this.iMyKey != null) {
                    this.iMyKey.closeDevice();
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }
}

