/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PasswordType;
import com.kingdee.eas.base.permission.SecurityException;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.base.permission.helper.SecurityValidatorHelper;
import com.kingdee.eas.base.permission.util.SecurityValidator;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class SecurityConsoleValidator {
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static final String REGEX = "[a-zA-Z]+\\d+|\\d+[a-zA-Z]+|\\d+[\\W_]+[a-zA-Z]+|[a-zA-Z]+[\\W_]+\\d+";
    private static final String REGEX_WITH_SPECIAL_CHAR = "[\\W_]+";
    private static Logger log = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.util.SecurityValidator");
    private Connection conn;
    private UserInfo userInfo;

    public SecurityConsoleValidator(Connection conn, String userNumber) throws UserException {
        this.conn = conn;
        this.userInfo = this.getUserInfoByNumber(userNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserInfo getUserInfoByNumber(String userNumber) throws UserException {
        UserInfo userInfo;
        block14: {
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT U.FID, U.FNumber,U.FpwdHisStr, U.FPasswordType,").append(" Security.FID AS FSecurityID, ").append(" Security.FNumber AS FSecurityNumber, ").append(" Security.FPasswordLength AS FPasswordLength, ").append(" Security.FPasswordForever AS FPasswordForever, Security.FNeedLocked AS FNeedLocked, ").append(" Security.FLockCount AS FLockCount, Security.FPasswordCanChg AS FPasswordCanChg, ").append(" Security.FPasswordCycle AS FPasswordCycle, Security.FForewarnDay AS FForewarnDay, ").append(" Security.FIsComplex AS FIsComplex, Security.FIsRequireChgPW AS FIsRequireChgPW, Security.fenablerepeatpw,Security.fRepeatTimes,").append(" Security.FRequireSpecialChar AS FRequireSpecialChar, Security.FExpiredPassCanChg as FExpiredPassCanChg,").append(" Security.FLockTime, Security.FLockUpdatePwCount, Security.FNeedUpdatePwLocked,Security.FLockUpdatePwTime,").append(" Security.FRequireUpChar, Security.FRequireLowChar, Security.FRequireNotIncludeNumber,Security.FRequireWeakPw").append(" FROM T_PM_User U ").append(" LEFT OUTER JOIN T_PM_Security Security ON Security.FID = U.FSecurityID ").append(" WHERE UPPER(U.FNumber) =  ? AND U.FIsDelete = 0 ");
            PreparedStatement ps = null;
            userInfo = new UserInfo();
            try {
                ps = this.conn.prepareStatement(sql.toString());
                ps.setObject(1, userNumber.toUpperCase());
                ResultSet rowSet = ps.executeQuery();
                if (rowSet.next()) {
                    userInfo.setId(BOSUuid.read((String)rowSet.getString("FID")));
                    userInfo.setNumber(rowSet.getString("FNumber"));
                    userInfo.setPwdHisStr(rowSet.getString("FpwdHisStr"));
                    userInfo.setPasswordType(PasswordType.getEnum(rowSet.getInt("FPasswordType")));
                    String securityID = rowSet.getString("FSecurityID");
                    if (!StringUtils.isEmpty((String)securityID)) {
                        SecurityInfo securityInfo = new SecurityInfo();
                        securityInfo.setNumber(rowSet.getString("FSecurityNumber"));
                        securityInfo.setPasswordLength(rowSet.getInt("FPasswordLength"));
                        securityInfo.setPasswordForever(rowSet.getInt("FPasswordForever") == 1);
                        securityInfo.setNeedLocked(rowSet.getInt("FNeedLocked") == 1);
                        securityInfo.setLockCount(rowSet.getInt("FLockCount"));
                        securityInfo.setPasswordCanChg(rowSet.getInt("FPasswordCanChg") == 1);
                        securityInfo.setPasswordCycle(rowSet.getInt("FPasswordCycle"));
                        securityInfo.setForewarnDay(rowSet.getInt("FForewarnDay"));
                        securityInfo.setComplex(rowSet.getInt("FIsComplex") == 1);
                        securityInfo.setRequireChgPW(rowSet.getInt("FIsRequireChgPW") == 1);
                        securityInfo.setExpiredPassCanChg(rowSet.getInt("FExpiredPassCanChg") == 1);
                        securityInfo.setRequireSpecialChar(rowSet.getInt("FRequireSpecialChar") == 1);
                        securityInfo.setLockTime(rowSet.getInt("FLockTime"));
                        securityInfo.setLockUpdatePwCount(rowSet.getInt("FLockUpdatePwCount"));
                        securityInfo.setLockUpdatePwTime(rowSet.getInt("FLockUpdatePwTime"));
                        securityInfo.setNeedUpdatePwLocked(rowSet.getInt("FNeedUpdatePwLocked") == 1);
                        securityInfo.setRequireLowChar(rowSet.getInt("FRequireLowChar") == 1);
                        securityInfo.setRequireUpChar(rowSet.getInt("FRequireUpChar") == 1);
                        securityInfo.setRequireNotIncludeNumber(rowSet.getInt("FRequireNotIncludeNumber") == 1);
                        securityInfo.setRequireWeakPw(rowSet.getInt("FRequireWeakPw") == 1);
                        securityInfo.setEnableRepeatPw(rowSet.getInt("fenablerepeatpw") == 1);
                        securityInfo.setRepeatTimes(rowSet.getInt("fRepeatTimes"));
                        userInfo.setSecurity(securityInfo);
                    }
                    break block14;
                }
                throw new UserException(UserException.USER_NOT_EXIST);
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException throwables) {
                        throwables.printStackTrace();
                    }
                }
            }
        }
        return userInfo;
    }

    public void validate(String password) throws EASBizException {
        Matcher matcher;
        int passwordLength;
        SecurityInfo securityInfo = this.userInfo.getSecurity();
        if (password == null) {
            password = "";
        }
        if ((passwordLength = password.trim().length()) < securityInfo.getPasswordLength()) {
            log.info((Object)"password length is shorter than security policy sets!");
            throw new SecurityException(SecurityException.SHORT_PASSWORD, new Object[]{securityInfo.getPasswordLength()});
        }
        Pattern pattern = null;
        if (securityInfo.isComplex() && !(matcher = (pattern = Pattern.compile(REGEX)).matcher(password)).find()) {
            log.info((Object)"regexpress is:[a-zA-Z]+\\d+|\\d+[a-zA-Z]+|\\d+[\\W_]+[a-zA-Z]+|[a-zA-Z]+[\\W_]+\\d+");
            throw new SecurityException(SecurityException.PASSWORD_TOO_SIMPLE);
        }
        if (securityInfo.isRequireSpecialChar()) {
            log.info((Object)"security policy requires special char!");
            pattern = Pattern.compile(REGEX_WITH_SPECIAL_CHAR);
            matcher = pattern.matcher(password);
            if (!matcher.find()) {
                log.info((Object)"regexpress is:[a-zA-Z]+\\d+|\\d+[a-zA-Z]+|\\d+[\\W_]+[a-zA-Z]+|[a-zA-Z]+[\\W_]+\\d+");
                throw new SecurityException(SecurityException.PASSWORD_SPECIAL_CHAR);
            }
        }
        if (securityInfo.isRequireUpChar()) {
            log.info((Object)"security policy requires up char!");
            if (!SecurityValidatorHelper.hasUpChar(password)) {
                throw new SecurityException(SecurityException.PASSWORD_UPCHAR);
            }
        }
        if (securityInfo.isRequireLowChar()) {
            log.info((Object)"security policy requires up char!");
            if (!SecurityValidatorHelper.hasLowChar(password)) {
                throw new SecurityException(SecurityException.PASSWORD_LOWCHAR);
            }
        }
        if (securityInfo.isRequireNotIncludeNumber()) {
            log.info((Object)"security policy requires not include userNumber");
            if (password.contains(this.userInfo.getNumber())) {
                throw new SecurityException(SecurityException.PASSWORD_NOT_INCLUDE_NUMBER);
            }
        }
        if (securityInfo.isRequireWeakPw()) {
            log.info((Object)"security policy requires not include weak Password ");
            if (!this.checkWeakPassword(password)) {
                throw new SecurityException(SecurityException.PASSWORD_WEAKPW);
            }
        }
        this.checkPwSameBefore(this.userInfo, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkWeakPassword(String password) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT Fpassword from t_pm_weakPwLib");
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement(sql.toString());
            ResultSet rowSet = ps.executeQuery();
            if (rowSet.next() && password.contains(rowSet.getString("Fpassword"))) {
                boolean bl = false;
                return bl;
            }
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException throwables) {
                    throwables.printStackTrace();
                }
            }
        }
        return true;
    }

    public String getSecurityPolicy() {
        SecurityInfo securityInfo = this.userInfo.getSecurity();
        int passwordLength = securityInfo.getPasswordLength();
        String pwdTip = "";
        if (securityInfo != null) {
            pwdTip = EASResource.getString((String)RESOURCE, (String)"pwdTip") + " ";
            pwdTip = pwdTip + EASResource.getString((String)RESOURCE, (String)"pwdLength") + passwordLength + "; ";
            if (securityInfo.isComplex()) {
                pwdTip = pwdTip + EASResource.getString((String)RESOURCE, (String)"pwdComplex") + "; ";
            }
            if (securityInfo.isRequireSpecialChar()) {
                pwdTip = pwdTip + EASResource.getString((String)RESOURCE, (String)"pwdSpecialChar") + "; ";
            }
            if (securityInfo.isRequireUpChar()) {
                pwdTip = pwdTip + com.kingdee.bos.util.EASResource.getString((String)RESOURCE, (String)"requireUpChar") + "; ";
            }
            if (securityInfo.isRequireLowChar()) {
                pwdTip = pwdTip + com.kingdee.bos.util.EASResource.getString((String)RESOURCE, (String)"requireLowChar") + "; ";
            }
            if (securityInfo.isRequireNotIncludeNumber()) {
                pwdTip = pwdTip + com.kingdee.bos.util.EASResource.getString((String)RESOURCE, (String)"requireNotIncludeNumber") + "; ";
            }
            if (securityInfo.isRequireWeakPw()) {
                pwdTip = pwdTip + com.kingdee.bos.util.EASResource.getString((String)RESOURCE, (String)"requireWeakPw") + "; ";
            }
        }
        return pwdTip;
    }

    private void checkPwSameBefore(UserInfo userInfo, String userPassword) throws EASBizException {
        userPassword = PermissionUtil.encrypt((String)userInfo.getId().toString(), (String)userPassword, (PasswordType)PasswordType.SHA256);
        SecurityInfo securityInfo = userInfo.getSecurity();
        if (securityInfo == null) {
            return;
        }
        if (securityInfo != null && securityInfo.isEnableRepeatPw()) {
            if (this.isSameBeforePw(securityInfo.getRepeatTimes(), userInfo.getPwdHisStr(), userPassword)) {
                throw new UserException(UserException.PW_SAME_BEFORE, new Object[]{securityInfo.getRepeatTimes()});
            }
            this.savePwHis(userInfo, securityInfo.getRepeatTimes(), securityInfo.isEnableRepeatPw(), userPassword);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePwHis(UserInfo userInfo, int time, boolean enableRepeat, String newPwd) {
        if (!enableRepeat) {
            userInfo.setPwdHisStr("");
        }
        String hisPwdStr = StringUtils.isEmpty((String)userInfo.getPwdHisStr()) ? newPwd : newPwd + "," + userInfo.getPwdHisStr();
        String[] hisPwdAry = StringUtils.split((String)hisPwdStr, (String)",");
        userInfo.setPwdHisStr(ToolUtils.aryToStr(hisPwdAry, time));
        String updateHisPwSql = " update t_pm_user set FpwdHisStr ='" + ToolUtils.aryToStr(hisPwdAry, time) + "' where fid='" + userInfo.getId().toString() + "'";
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement(updateHisPwSql);
            ps.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean isSameBeforePw(int time, String hisPwStr, String nowPw) {
        if (time < 1) {
            return false;
        }
        if (StringUtils.isEmpty((String)hisPwStr)) {
            return false;
        }
        String[] pwStr = StringUtils.split((String)hisPwStr, (String)",");
        if (time > pwStr.length) {
            if (hisPwStr.indexOf(nowPw) != -1) {
                return true;
            }
        } else {
            for (int i = 0; i < time; ++i) {
                if (!pwStr[i].equals(nowPw)) continue;
                return true;
            }
        }
        return false;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void updatePassAndLoginNumber(Connection conn, int dbType, String userNumber, String password, String loginNumber, String adminId) throws Exception {
        SecurityValidator.checkUserUpdatePw(adminId, password);
        Statement ps = null;
        try {
            ps = conn.prepareStatement("update t_pm_user set fpassword=?,floginnumber=?,FIsLocked = 0,FPWEffectiveDate = ?,fpasswordType=?,FIsChangedPW = 0 where fid='" + adminId + "'");
            ps.setString(1, PermissionUtil.encrypt((String)adminId, (String)password, (PasswordType)PasswordType.SHA256));
            ps.setString(2, loginNumber);
            ps.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            ps.setInt(4, 2);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

