/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util.file;

import com.kingdee.eas.base.permission.util.PermSafeInfoUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import org.apache.log4j.Logger;

public class DerbyDB {
    private static final Logger logger = Logger.getLogger(DerbyDB.class);
    private static Connection conn = null;

    public static Connection getConnection(String derbyDBPath) throws Exception {
        if (conn == null) {
            conn = DerbyDB.connection(derbyDBPath);
        } else {
            String select_sql = "select 1 from sys.systables";
            try {
                PreparedStatement pstmt2 = conn.prepareStatement(select_sql);
                pstmt2.executeQuery();
            }
            catch (SQLException e) {
                logger.warn((Object)"a new connection is created!");
                conn = DerbyDB.connection(derbyDBPath);
            }
        }
        return conn;
    }

    public static boolean checkConnIsValid(Connection conn) {
        if (conn == null) {
            return false;
        }
        String select_sql = "select 1 from sys.systables";
        try {
            PreparedStatement pstmt2 = conn.prepareStatement(select_sql);
            pstmt2.executeQuery();
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection connection(String derbyDBPath) throws Exception {
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        derbyDBPath = derbyDBPath.substring(0, derbyDBPath.length() - 1);
        String dp = PermSafeInfoUtil.getProperties("BOS_BAS.DerbyDB.connection");
        String dbUrl = "jdbc:derby:" + derbyDBPath + ";create=true;user=jta;password=" + dp + ";territory=zh_CN;codeset=utf8";
        if (new File(derbyDBPath).exists()) {
            dbUrl = "jdbc:derby:" + derbyDBPath + ";user=jta;password=" + dp + ";territory=zh_CN;codeset=utf8";
        }
        try {
            conn = DriverManager.getConnection(dbUrl);
        }
        catch (SQLTimeoutException e) {
            int timeout = DriverManager.getLoginTimeout();
            logger.error((Object)("getConnection timeout error time:" + timeout + "s, now retry once by more time:300s..."));
            try {
                DriverManager.setLoginTimeout(300);
                conn = DriverManager.getConnection(dbUrl);
            }
            finally {
                DriverManager.setLoginTimeout(timeout);
            }
        }
        catch (SQLException e) {
            logger.warn((Object)" Another instance of Derby may have already booted the database!!", (Throwable)e);
            logger.error((Object)"", (Throwable)e);
        }
        logger.info((Object)"create and connect to consoledb");
        conn.setAutoCommit(true);
        return conn;
    }

    public static boolean isColNotExistError(Exception ex) {
        SQLSyntaxErrorException e;
        return SQLSyntaxErrorException.class.isInstance(ex) ? (e = (SQLSyntaxErrorException)ex).getErrorCode() == 30000 : SQLSyntaxErrorException.class.isInstance(ex.getCause()) && (e = (SQLSyntaxErrorException)ex.getCause()).getErrorCode() == 30000;
    }

    public static void main(String[] args) throws Exception {
        String path = "W:" + File.separator + "eas" + File.separator + "Server" + File.separator + "server" + File.separator + "properties" + File.separator + "license" + File.separator + "syncresultdb" + File.separator;
        Connection conn = DerbyDB.connection(path);
        try {
            DriverManager.getConnection("jdbc:derby:" + path + ";shutdown=true");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        System.out.println(conn.isClosed());
        conn = DerbyDB.connection(path);
        System.out.println(conn.isClosed());
        System.out.println(path);
    }
}

