/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.permission.AuthenRecordInfo;
import com.kingdee.eas.base.permission.AuthenStatusEnum;
import com.kingdee.eas.base.permission.OprtTypeEnum;
import com.kingdee.eas.base.permission.PermChangeRecordFactory;
import com.kingdee.eas.base.permission.PermChangeRecordInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.IAuthenRecordAuthen;
import com.kingdee.eas.base.uiframe.MainFunctionMenuFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractBaseAuthenRecordAuthen
implements IAuthenRecordAuthen {
    private static Logger logger = Logger.getLogger(AbstractBaseAuthenRecordAuthen.class);

    protected abstract String getDescription();

    protected abstract ResultSet queryNeedAuthenResultSet(Connection var1, String var2) throws BOSException;

    protected abstract Map getInformation(ResultSet var1) throws BOSException;

    protected abstract Set getPassSet(Map var1, String var2);

    protected abstract Set getNoPassSet(Map var1, String var2);

    protected abstract void updatePassData(Connection var1, Set var2, Map var3, String var4) throws BOSException;

    protected abstract void updateNoPassData(Connection var1, Set var2, Map var3, String var4) throws BOSException;

    private void updateRecord(Connection conn, AuthenStatusEnum status, String currentUserId, String permChangeId) throws BOSException {
        PreparedStatement updateRecordStatement = null;
        try {
            StringBuffer updateRecordSql = new StringBuffer();
            updateRecordSql.append("update t_pm_authenrecord ").append("set fauthenstatus = ?, ").append("fauthentime = now()").append("where fpermchangeid = ? and ").append("fauthentorid = ?");
            updateRecordStatement = conn.prepareStatement(updateRecordSql.toString());
            updateRecordStatement.setString(1, status.getValue());
            updateRecordStatement.setString(2, permChangeId);
            updateRecordStatement.setString(3, currentUserId);
            updateRecordStatement.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(updateRecordStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)updateRecordStatement);
    }

    protected void cleanData(Connection conn, String permChangeId) throws BOSException {
        PreparedStatement updateStatusStatement = null;
        PreparedStatement cleanDataStatement = null;
        try {
            StringBuffer updateStatusSql = new StringBuffer();
            updateStatusSql.append("update t_pm_authenrecord ").append("set fauthenstatus = ?").append("where fpermchangeid = ? and ").append("fauthenstatus = ?");
            updateStatusStatement = conn.prepareStatement(updateStatusSql.toString());
            updateStatusStatement.setString(1, "50");
            updateStatusStatement.setString(2, permChangeId);
            updateStatusStatement.setString(3, "10");
            updateStatusStatement.executeUpdate();
            StringBuffer cleanDataSql = new StringBuffer();
            cleanDataSql.append("delete from t_pm_authenschemesnapview ").append("where fpermchangerecordid = ?");
            cleanDataStatement = conn.prepareStatement(cleanDataSql.toString());
            cleanDataStatement.setString(1, permChangeId);
            cleanDataStatement.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(updateStatusStatement);
                SQLUtils.cleanup(cleanDataStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)updateStatusStatement);
        SQLUtils.cleanup((Statement)cleanDataStatement);
    }

    private void cleanMenuCache(Context ctx) throws BOSException {
        try {
            MainFunctionMenuFactory.getLocalInstance((Context)ctx).updateMenuCache("");
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
    }

    @Override
    public final void passAuthen(Context ctx, AuthenRecordInfo authenRecordInfo) throws BOSException, EASBizException {
        Connection conn = null;
        ResultSet resultSetFirst = null;
        ResultSet resultSetSecond = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            String permChangeId = authenRecordInfo.getPermChange().getId().toString();
            resultSetFirst = this.queryNeedAuthenResultSet(conn, permChangeId);
            Map information = this.getInformation(resultSetFirst);
            Set passSet = this.getPassSet(information, currentUserId);
            this.updatePassData(conn, passSet, information, permChangeId);
            this.updateRecord(conn, AuthenStatusEnum.AuthenSuccess, currentUserId, permChangeId);
            resultSetSecond = this.queryNeedAuthenResultSet(conn, permChangeId);
            if (!resultSetSecond.next()) {
                this.cleanData(conn, permChangeId);
            }
            this.cleanMenuCache(ctx);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)conn);
                this.cleanResultSetAndStatement(resultSetFirst);
                this.cleanResultSetAndStatement(resultSetSecond);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        this.cleanResultSetAndStatement(resultSetFirst);
        this.cleanResultSetAndStatement(resultSetSecond);
    }

    @Override
    public final void noPassAuthen(Context ctx, AuthenRecordInfo authenRecordInfo, String reasonText) throws BOSException, EASBizException {
        Connection conn = null;
        ResultSet resultSetFirst = null;
        ResultSet resultSetSecond = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            String permChangeId = authenRecordInfo.getPermChange().getId().toString();
            resultSetFirst = this.queryNeedAuthenResultSet(conn, permChangeId);
            Map information = this.getInformation(resultSetFirst);
            Set noPassSet = this.getNoPassSet(information, currentUserId);
            this.updateNoPassData(conn, noPassSet, information, permChangeId);
            this.updateRecord(conn, AuthenStatusEnum.AuthenFail, currentUserId, permChangeId);
            resultSetSecond = this.queryNeedAuthenResultSet(conn, permChangeId);
            if (!resultSetSecond.next()) {
                this.cleanData(conn, permChangeId);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)conn);
                this.cleanResultSetAndStatement(resultSetFirst);
                this.cleanResultSetAndStatement(resultSetSecond);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        this.cleanResultSetAndStatement(resultSetFirst);
        this.cleanResultSetAndStatement(resultSetSecond);
    }

    private void cleanResultSetAndStatement(ResultSet resultSet) {
        try {
            Statement statement = null;
            if (resultSet != null) {
                statement = resultSet.getStatement();
            }
            SQLUtils.cleanup((ResultSet)resultSet, (Statement)statement);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
    }

    public final String toString() {
        return this.getDescription();
    }

    protected String createPermChangeRecord(Context ctx, UserInfo currentUserInfo, OprtTypeEnum operateType, UserInfo userInfo) throws BOSException, EASBizException {
        PermChangeRecordInfo info = new PermChangeRecordInfo();
        info.setAssigner(currentUserInfo);
        info.setOperType(operateType);
        info.setAssignedObjectName(userInfo.getName());
        info.setAssignedObjectNumber(userInfo.getNumber());
        info.setAssignedObjectType("\u89d2\u8272");
        info.setChangeTime(new Timestamp(System.currentTimeMillis()));
        return PermChangeRecordFactory.getLocalInstance(ctx).addnew(info).toString();
    }
}

