/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.GrantUserFieldInfo;
import com.kingdee.eas.base.permission.app.AbstractGrantUserFieldControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class GrantUserFieldControllerBean
extends AbstractGrantUserFieldControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.GrantUserFieldControllerBean");

    @Override
    protected Set _getGrantedFields(Context ctx, IObjectPK userPK, IObjectPK orgPK, BOSObjectType bosObjectType) throws BOSException, EASBizException {
        HashSet<String> ret = new HashSet<String>();
        String sql = "select FFieldName from t_pm_grantuserfield where fuserid=''{0}'' and forgid=''{1}'' and FBizObjectType=''{2}''";
        Object[] args = new String[]{userPK.toString(), orgPK.toString(), bosObjectType.toString()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)MessageFormat.format(sql, args));
        try {
            while (rs.next()) {
                ret.add(rs.getString("FFieldName"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"_getGrantedFields", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    @Override
    protected void _save(Context ctx, IObjectPK userPK, IObjectPK orgPK, BOSObjectType bosObjectType, Set grantFields) throws BOSException, EASBizException {
        this.deleteOld(ctx, userPK, orgPK, bosObjectType);
        this.insertNew(ctx, userPK, orgPK, bosObjectType, grantFields);
    }

    private void deleteOld(Context ctx, IObjectPK userPK, IObjectPK orgPK, BOSObjectType bosObjectType) throws BOSException, EASBizException {
        String sql = "delete from t_pm_grantuserfield where fuserid=''{0}'' and forgid=''{1}'' and FBizObjectType=''{2}''";
        Object[] arg = new String[]{userPK.toString(), orgPK.toString(), bosObjectType.toString()};
        DbUtil.execute((Context)ctx, (String)MessageFormat.format(sql, arg));
    }

    private void insertNew(Context ctx, IObjectPK userPK, IObjectPK orgPK, BOSObjectType bosObjectType, Set grantFields) throws BOSException, EASBizException {
        String sql = "insert into t_pm_grantuserfield(fid,fuserid,forgid,fbizobjecttype,FFieldName) values(?,?,?,?,?)";
        Connection con = null;
        BOSObjectType bosType = new GrantUserFieldInfo().getBOSType();
        PreparedStatement ps = null;
        try {
            con = this.getConnection(ctx);
            ps = con.prepareStatement(sql);
            for (String field : grantFields) {
                ps.setString(1, BOSUuid.create((BOSObjectType)bosType).toString());
                ps.setString(2, userPK.toString());
                ps.setString(3, orgPK.toString());
                ps.setString(4, bosObjectType.toString());
                ps.setString(5, field);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"insertNew", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
    }

    @Override
    protected Set _getUserAndRoleGrantedFields(Context ctx, IObjectPK userPK, IObjectPK orgPK, BOSObjectType bosObjectType) throws BOSException, EASBizException {
        HashSet<String> ret = new HashSet<String>();
        String sql = "select FFieldName from t_pm_grantuserfield where fuserid=''{0}'' and forgid=''{1}'' and FBizObjectType=''{2}''  union select distinct a.FFieldName from t_pm_grantrolefield a join t_pm_userroleorg b on a.froleid=b.froleid where  b.fuserid=''{3}'' and b.forgid=''{4}'' and a.FBizObjectType = ''{5}''";
        Object[] args = new String[]{userPK.toString(), orgPK.toString(), bosObjectType.toString(), userPK.toString(), orgPK.toString(), bosObjectType.toString()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)MessageFormat.format(sql, args));
        try {
            while (rs.next()) {
                ret.add(rs.getString("FFieldName"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"_getUserAndRoleGrantedFields", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return ret;
    }
}

