/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.SecurityCollection;
import com.kingdee.eas.base.permission.SecurityException;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.app.AbstractSecurityControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;

public class SecurityControllerBean
extends AbstractSecurityControllerBean {
    private static final String[] CANNOT_DELETE_ARR = new String[]{"00000000-0000-0000-0000-0000000000013EE2C673", "00000000-0000-0000-0000-0000000000023EE2C673", "00000000-0000-0000-0000-0000000000033EE2C673", "TPsTSg3uRne281OgfCFCRz7ixnM=", "Xmnk3JU7TXivwVIe4wJk7j7ixnM="};

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SecurityInfo securityInfo = (SecurityInfo)model;
        this.checkValidity(ctx, pk.toString(), securityInfo);
        super._addnew(ctx, pk, (IObjectValue)securityInfo);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SecurityInfo securityInfo = (SecurityInfo)model;
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.create((BOSObjectType)this.getBOSType()));
        this.checkValidity(ctx, pk.toString(), securityInfo);
        super._addnew(ctx, (IObjectPK)pk, (IObjectValue)securityInfo);
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SecurityInfo securityInfo = (SecurityInfo)model;
        this.checkCanModify(ctx, (IObjectValue)securityInfo);
        this.checkValidity(ctx, pk.toString(), securityInfo);
        super._update(ctx, pk, (IObjectValue)securityInfo);
    }

    private void checkValidity(Context ctx, String ID, SecurityInfo securityInfo) throws BOSException, EASBizException {
        this.checkNumberOrNameNull(securityInfo);
        this.checkNumberDup(ctx, ID, securityInfo);
        this.checkAliasDup(ctx, ID, securityInfo);
        this.checkOther(securityInfo);
    }

    private void checkNumberOrNameNull(SecurityInfo securityInfo) throws DataBaseException {
        String number = securityInfo.getNumber();
        String name = securityInfo.getAlias();
        if (number == null || number.equals("")) {
            throw new DataBaseException(DataBaseException.NUMBERNOTNULL);
        }
        if (name == null || name.equals("")) {
            throw new DataBaseException(DataBaseException.NAMENOTNULL);
        }
    }

    private void checkNumberDup(Context ctx, String id, SecurityInfo securityInfo) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)securityInfo.getNumber());
        filter.getFilterItems().add(filterItem);
        if (id != null) {
            filterItem = new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        if (this.exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{securityInfo.getNumber()});
        }
    }

    private void checkAliasDup(Context ctx, String id, SecurityInfo securityInfo) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("alias", (Object)securityInfo.getAlias());
        filter.getFilterItems().add(filterItem);
        if (id != null) {
            filterItem = new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        if (this.exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{securityInfo.getAlias()});
        }
    }

    private void checkOther(SecurityInfo securityInfo) throws EASBizException {
        if (!securityInfo.isPasswordForever() && securityInfo.getPasswordCycle() < 1) {
            throw new SecurityException(SecurityException.NEED_PASSDAYS);
        }
        if (securityInfo.isNeedLocked() && securityInfo.getLockCount() < 1) {
            throw new SecurityException(SecurityException.NEED_LOCKCOUNT);
        }
        if (securityInfo.isNeedUpdatePwLocked() && securityInfo.getLockUpdatePwCount() < 1) {
            throw new SecurityException(SecurityException.NEED_UPDATE_PW_LOCKCOUNT);
        }
        int length = 0;
        if (securityInfo.isRequireSpecialChar()) {
            ++length;
        }
        if (securityInfo.isComplex()) {
            length += 2;
            if (securityInfo.isRequireUpChar() && securityInfo.isRequireLowChar()) {
                ++length;
            }
        } else {
            if (securityInfo.isRequireUpChar()) {
                ++length;
            }
            if (securityInfo.isRequireLowChar()) {
                ++length;
            }
        }
        if (securityInfo.getPasswordLength() < length) {
            throw new SecurityException(SecurityException.COMPLEX_SECURITY_PASSWORD_LENGTH, new Object[]{length});
        }
    }

    private void checkCanModify(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SecurityInfo info = (SecurityInfo)model;
        if (!info.getCU().getId().equals((Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId())) {
            Object[] params = new Object[]{info.getNumber()};
            throw new PermissionException(PermissionException.CAN_NOT_MODIFY_OTHER_CU_DATA, params);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        for (int i = 0; i < CANNOT_DELETE_ARR.length; ++i) {
            if (!CANNOT_DELETE_ARR[i].equals(pk.toString())) continue;
            throw new PermissionException(PermissionException.CAN_NOT_DELETE_INTERNAL_SECURITY);
        }
        SecurityInfo info = this.getSecurityInfo(ctx, pk);
        this.checkCanModify(ctx, (IObjectValue)info);
        super._delete(ctx, pk);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SecurityInfo securityInfo = this.getSecurityInfo(ctx, pk);
        return securityInfo.getNumber() + " " + securityInfo.getAlias();
    }

    @Override
    protected void _setDefualtSecurity(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        String deleteSql = "update T_PM_Security set fisDefault = 0";
        String sql = "update T_PM_Security set fisDefault = 1 where fid = ?";
        DbUtil.execute((Context)ctx, (String)deleteSql);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
    }

    @Override
    protected IObjectValue _getDefualtSecurity(Context ctx) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isDefault", (Object)1, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        SecurityCollection securityCollection = this.getSecurityCollection(ctx, entityViewInfo);
        if (securityCollection.size() == 0) {
            return null;
        }
        return securityCollection.get(0);
    }
}

