/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.DynamicCardStateEnum;
import com.kingdee.eas.base.permission.DynamicCardUserCollection;
import com.kingdee.eas.base.permission.DynamicCardUserFactory;
import com.kingdee.eas.base.permission.DynamicCardUserInfo;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.UsbKeyUserMapCollection;
import com.kingdee.eas.base.permission.UsbKeyUserMapFactory;
import com.kingdee.eas.base.permission.UsbKeyUserMapInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserUSBKeyStateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.UuidException;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class UserControllerHelper {
    private static Logger logger = Logger.getLogger(UserControllerHelper.class);
    private static UserControllerHelper helper = null;

    private UserControllerHelper() {
    }

    public static UserControllerHelper getHelper() {
        if (helper == null) {
            helper = new UserControllerHelper();
        }
        return helper;
    }

    private void deleteAuthorWay(Context ctx, String idStr) throws BOSException {
        StringBuffer sql = new StringBuffer("DELETE FROM T_PM_DynamicCardUser WHERE FUserID in (").append(idStr).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer("DELETE FROM T_PM_UsbKeyUserMap WHERE FUserID in (").append(idStr).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private StringBuffer getIDString(List userIDSet) {
        StringBuffer strIds = new StringBuffer();
        Iterator it = userIDSet.iterator();
        while (it.hasNext()) {
            String userID = it.next().toString();
            if (strIds.length() > 0) {
                strIds.append(",");
            }
            strIds.append("'" + userID + "'");
        }
        return strIds;
    }

    private void updateLoginWay(Context ctx, LoginAuthorWayEnum authWay, StringBuffer strIds) throws BOSException {
        StringBuffer sql = new StringBuffer("UPDATE T_PM_User SET FLoginAuthorWay = " + authWay.getValue() + " WHERE FID in (");
        sql.append(strIds).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    void handleUsbKeyUser(Context ctx, List userIDSet, LoginAuthorWayEnum authWay) throws BOSException, EASBizException {
        StringBuffer strIds = this.getIDString(userIDSet);
        this.updateLoginWay(ctx, authWay, strIds);
        this.deleteAuthorWay(ctx, strIds.toString());
        UsbKeyUserMapCollection userUsbKeyCol = this.convert2UsbkeyUserCollection(userIDSet);
        UsbKeyUserMapFactory.getLocalInstance(ctx).addnewMany(userUsbKeyCol);
    }

    private UsbKeyUserMapCollection convert2UsbkeyUserCollection(List userIDSet) throws UuidException {
        UsbKeyUserMapCollection userUsbKeyCol = new UsbKeyUserMapCollection();
        Iterator it = userIDSet.iterator();
        while (it.hasNext()) {
            UserInfo user = new UserInfo();
            user.setId(BOSUuid.read((String)it.next().toString()));
            UsbKeyUserMapInfo usbUser = new UsbKeyUserMapInfo();
            usbUser.setState(UserUSBKeyStateEnum.NOTINIT);
            usbUser.setUser(user);
            userUsbKeyCol.add(usbUser);
        }
        return userUsbKeyCol;
    }

    void handleDynCardUser(Context ctx, List userIDSet, LoginAuthorWayEnum authWay) throws BOSException, EASBizException {
        StringBuffer strIds = this.getIDString(userIDSet);
        this.updateLoginWay(ctx, authWay, strIds);
        this.deleteAuthorWay(ctx, strIds.toString());
        DynamicCardUserCollection dynCardUserCol = this.convert2DynCardUserCollection(userIDSet);
        DynamicCardUserFactory.getLocalInstance(ctx).addnewMany(dynCardUserCol);
    }

    private DynamicCardUserCollection convert2DynCardUserCollection(List userIdSet) throws UuidException {
        DynamicCardUserCollection dynCardUserCol = new DynamicCardUserCollection();
        Iterator it = userIdSet.iterator();
        while (it.hasNext()) {
            UserInfo user = new UserInfo();
            user.setId(BOSUuid.read((String)it.next().toString()));
            DynamicCardUserInfo dynUser = new DynamicCardUserInfo();
            dynUser.setDynamicState(DynamicCardStateEnum.init);
            dynUser.setUser(user);
            dynCardUserCol.add(dynUser);
        }
        return dynCardUserCol;
    }

    void setCertifyRegistration(Context ctx, List userIDSet, boolean isCertified) throws BOSException {
        String sql = "UPDATE T_PM_User SET FIsRegister = " + (isCertified ? 1 : 0) + " WHERE FID in (" + this.getIDString(userIDSet) + ")";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    public void handleNormalUser(Context ctx, List userIDSet, LoginAuthorWayEnum authWay) throws BOSException {
        StringBuffer strIds = this.getIDString(userIDSet);
        this.updateLoginWay(ctx, authWay, strIds);
        this.deleteAuthorWay(ctx, strIds.toString());
    }
}

