/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.IUserGroupGFacade;
import com.kingdee.eas.base.permission.Locale;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgInfo;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserGroupGFacadeFactory;
import com.kingdee.eas.base.permission.UserGroupInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.app.helper.UserDataOrgExportInputHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class UserDataTransmission
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger(UserDataTransmission.class);
    private java.util.Locale l1 = new java.util.Locale("L1");
    private java.util.Locale l2 = new java.util.Locale("L2");
    private java.util.Locale l3 = new java.util.Locale("L3");
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private Map dataCache = new HashMap(100);
    private static final int CASE_EXIST_NUMBER = 0;
    private static final int CASE_IN_CURRENT_USER_ORGRANGE = 1;
    private Map<String, Set<String>> userGroupMap = new HashMap<String, Set<String>>();

    private String getKey(String filedName, String number) {
        return filedName + "_" + number;
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return UserFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new TaskExternalException("getController():", (Throwable)e);
        }
    }

    private UserInfo getUserInfo(Context ctx, String number) throws TaskExternalException {
        try {
            IUser iUser = (IUser)this.getController(ctx);
            boolean hasNumber = iUser.haveThisNumber(number);
            if (hasNumber) {
                String oql = "SELECT *, security.*, person.id, group.*, defOrgUnit.*, customerID, supplierID, orgRange.*, orgRange.org.*,orgRangeIncludeSubOrg.*, CU.* WHERE number = '" + number + "'";
                UserInfo userInfo = iUser.getUserInfo(oql);
                return userInfo;
            }
            return null;
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new TaskExternalException("getUserInfo():", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new TaskExternalException("getUserInfo():", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String SupplierID;
        String mail = (String)((DataToken)hsData.get((Object)"FEmail")).data;
        String number = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        if (StringUtils.isEmpty((String)number)) {
            String objectName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(new UserInfo().getBOSType()).getAlias();
            Object[] params = new Object[]{objectName, number};
            String msg = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"numberNotFound", (java.util.Locale)ctx.getLocale()), params);
            throw new TaskExternalException(msg);
        }
        UserInfo userInfo = this.getUserInfo(ctx, number);
        if (userInfo == null) {
            userInfo = new UserInfo();
            userInfo.setNumber(number);
        } else if (!this.isSltImportUpdate()) {
            throw new TaskExternalException(new UserException(UserException.NUMBER_REPEAT).getMessage());
        }
        String name_l1 = (String)((DataToken)hsData.get((Object)"FName_L1")).data;
        String name_l2 = (String)((DataToken)hsData.get((Object)"FName_L2")).data;
        String name_l3 = (String)((DataToken)hsData.get((Object)"FName_L3")).data;
        String strUserType = (String)((DataToken)hsData.get((Object)"FType")).data;
        int inputType = Integer.parseInt(strUserType);
        if (StringUtils.isEmpty((String)name_l2) && inputType != 20 && inputType != 30 && inputType != 40) {
            String objectName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(new UserInfo().getBOSType()).getAlias();
            Object[] params = new Object[]{objectName, name_l2};
            String msg = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"RealNameNotFound", (java.util.Locale)ctx.getLocale()), params);
            throw new TaskExternalException(msg);
        }
        if (inputType == 20) {
            String PersonId = (String)((DataToken)hsData.get((Object)"FPersonID")).data;
            if (StringUtils.isEmpty((String)PersonId)) {
                String objectName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(new UserInfo().getBOSType()).getAlias();
                Object[] params = new Object[]{objectName, PersonId};
                String msg = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"PersonIDnotfound", (java.util.Locale)ctx.getLocale()), params);
                throw new TaskExternalException(msg);
            }
        } else if (inputType == 30) {
            String CustomerID = (String)((DataToken)hsData.get((Object)"FCustomerID")).data;
            if (StringUtils.isEmpty((String)CustomerID)) {
                String objectName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(new UserInfo().getBOSType()).getAlias();
                Object[] params = new Object[]{objectName, CustomerID};
                String msg = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"CustomerIDnotfound", (java.util.Locale)ctx.getLocale()), params);
                throw new TaskExternalException(msg);
            }
        } else if (inputType == 40 && StringUtils.isEmpty((String)(SupplierID = (String)((DataToken)hsData.get((Object)"FSupplierID")).data))) {
            String objectName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(new UserInfo().getBOSType()).getAlias();
            Object[] params = new Object[]{objectName, SupplierID};
            String msg = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"SupplierIDnotfound", (java.util.Locale)ctx.getLocale()), params);
            throw new TaskExternalException(msg);
        }
        UserType userType = UserType.getEnum(Integer.parseInt(strUserType));
        String cell = (String)((DataToken)hsData.get((Object)"FCell")).data;
        String personNumber = (String)((DataToken)hsData.get((Object)"FPersonID")).data;
        PersonInfo personInfo = (PersonInfo)this.getValue(ctx, new PersonInfo().getBOSType(), personNumber, 0, "FPersonID");
        IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        String customerID = (String)((DataToken)hsData.get((Object)"FCustomerID")).data;
        IObjectValue customerInfo = null;
        try {
            if (!StringUtils.isEmpty((String)customerID)) {
                customerInfo = BOSUuid.isValid((String)customerID, (boolean)true) ? dynamicObject.getValue(BOSObjectType.create((String)"BF0C040E"), customerID) : this.getValue(ctx, BOSObjectType.create((String)"BF0C040E"), customerID, 0, "FCustomerID");
            }
        }
        catch (BOSException boe) {
            logger.error((Object)("get customer error,id:" + customerID));
            throw new TaskExternalException("get customer error", (Throwable)boe);
        }
        String supplierID = (String)((DataToken)hsData.get((Object)"FSupplierID")).data;
        IObjectValue supplierInfo = null;
        try {
            if (!StringUtils.isEmpty((String)supplierID)) {
                supplierInfo = BOSUuid.isValid((String)supplierID, (boolean)true) ? dynamicObject.getValue(BOSObjectType.create((String)"37C67DFC"), supplierID) : this.getValue(ctx, BOSObjectType.create((String)"37C67DFC"), supplierID, 0, "FSupplierID");
            }
        }
        catch (BOSException boe) {
            logger.error((Object)("get supplier error,id:" + customerID));
            throw new TaskExternalException("get supplier error", (Throwable)boe);
        }
        String groupNumber = (String)((DataToken)hsData.get((Object)"FGroupID")).data;
        UserGroupInfo userGroupInfo = (UserGroupInfo)this.getValue(ctx, new UserGroupInfo().getBOSType(), groupNumber, 0, "FGroupID");
        String securityNumber = (String)((DataToken)hsData.get((Object)"FSecurityId")).data;
        SecurityInfo securityInfo = (SecurityInfo)this.getValue(ctx, new SecurityInfo().getBOSType(), securityNumber, 0, "FSecurityId");
        Timestamp effectiveDate = this.getTimestamp((String)((DataToken)hsData.get((Object)"FEffectiveDate")).data);
        if (effectiveDate == null) {
            throw new TaskExternalException(new UserException(UserException.FEFFECTIVEDATECANTBENULL).getMessage());
        }
        Timestamp invalidationDate = this.getTimestamp((String)((DataToken)hsData.get((Object)"FInvalidationDate")).data);
        String password = (String)((DataToken)hsData.get((Object)"FPassword")).data;
        if (password != null && !StringUtils.isEmpty((String)password.trim())) {
            try {
                password = PermissionCommonUtil.encrypt(number, password);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                throw new TaskExternalException("encrypt()", (Throwable)e);
            }
        }
        String cuNumber = (String)((DataToken)hsData.get((Object)"FControlUnitID")).data;
        CtrlUnitInfo ctrlUnitInfo = (CtrlUnitInfo)this.getValue(ctx, new CtrlUnitInfo().getBOSType(), cuNumber, 0, "FControlUnitID");
        boolean isForbidden = this.booleanValue((String)((DataToken)hsData.get((Object)"FForbidden")).data);
        boolean isLocked = this.booleanValue((String)((DataToken)hsData.get((Object)"FIslocked")).data);
        boolean changePW = this.booleanValue((String)((DataToken)hsData.get((Object)"FChangedPW")).data);
        Locale defaultLocale = Locale.getEnum((String)((DataToken)hsData.get((Object)"FDefaultLocale")).data);
        String defaultOrgUnitNumber = (String)((DataToken)hsData.get((Object)"FDefaultOrgUnitID")).data;
        FullOrgUnitInfo defaultOrgUnit = (FullOrgUnitInfo)this.getValue(ctx, new FullOrgUnitInfo().getBOSType(), defaultOrgUnitNumber, 0, "FDefaultOrgUnitID");
        boolean isBizAdmin = this.booleanValue((String)((DataToken)hsData.get((Object)"FIsBizAdmin")).data);
        Timestamp pwEffectiveDate = this.getTimestamp((String)((DataToken)hsData.get((Object)"FPWEffectiveDate")).data);
        String description_l1 = (String)((DataToken)hsData.get((Object)"FDescription_L1")).data;
        String description_l2 = (String)((DataToken)hsData.get((Object)"FDescription_L2")).data;
        String description_l3 = (String)((DataToken)hsData.get((Object)"FDescription_L3")).data;
        String orgNumber = (String)((DataToken)hsData.get((Object)"FOrgID")).data;
        if (!Administrator.isSuperCUAdmin(ctx.getCaller())) {
            this.getValue(ctx, new FullOrgUnitInfo().getBOSType(), orgNumber, 1, "FOrgID");
        }
        String orgTreeNumber = (String)((DataToken)hsData.get((Object)"FOrgTreeNumber")).data;
        String orgTreeDate = (String)((DataToken)hsData.get((Object)"FOrgTreeDate")).data;
        UserDataOrgExportInputHelper helper = new UserDataOrgExportInputHelper();
        FullOrgUnitInfo fullOrgUnitInfo = null;
        try {
            fullOrgUnitInfo = helper.getOrgInfo(ctx, orgNumber, orgTreeNumber, orgTreeDate);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        String strOrgRangeType = (String)((DataToken)hsData.get((Object)"FOrgRangeType")).data;
        OrgRangeType orgRangeType = OrgRangeType.getEnum(Integer.parseInt(strOrgRangeType));
        if (orgRangeType == null) {
            throw new TaskExternalException(new UserException(UserException.ORG_RANGE_TYPE_ERROR).getMessage());
        }
        userInfo.setName(name_l1, this.l1);
        userInfo.setName(name_l2, this.l2);
        userInfo.setName(name_l3, this.l3);
        userInfo.setType(userType);
        if (personInfo != null && inputType == 20) {
            userInfo.setPerson(personInfo);
            userInfo.setName(personInfo.getName(this.l1), this.l1);
            userInfo.setName(personInfo.getName(this.l2), this.l2);
            userInfo.setName(personInfo.getName(this.l3), this.l3);
        }
        if (customerInfo != null && inputType == 30) {
            userInfo.setCustomerID(customerInfo.get("id").toString());
            userInfo.setName(StringUtils.cnulls((Object)customerInfo.get("name", this.l1)), this.l1);
            userInfo.setName(StringUtils.cnulls((Object)customerInfo.get("name", this.l2)), this.l2);
            userInfo.setName(StringUtils.cnulls((Object)customerInfo.get("name", this.l3)), this.l3);
        }
        if (supplierInfo != null && inputType == 40) {
            userInfo.setSupplierID(supplierInfo.get("id").toString());
            userInfo.setName(StringUtils.cnulls((Object)supplierInfo.get("name", this.l1)), this.l1);
            userInfo.setName(StringUtils.cnulls((Object)supplierInfo.get("name", this.l2)), this.l2);
            userInfo.setName(StringUtils.cnulls((Object)supplierInfo.get("name", this.l3)), this.l3);
        }
        userInfo.setGroup(userGroupInfo);
        userInfo.setSecurity(securityInfo);
        userInfo.setEffectiveDate(effectiveDate);
        userInfo.setInvalidationDate(invalidationDate);
        userInfo.setPassword(password);
        userInfo.setCU(ctrlUnitInfo);
        userInfo.setIsForbidden(isForbidden);
        userInfo.setIsLocked(isLocked);
        userInfo.setIsDelete(false);
        userInfo.setChangedPW(changePW);
        userInfo.setDefLocale(defaultLocale);
        userInfo.setDefOrgUnit(defaultOrgUnit);
        userInfo.setBizAdmin(isBizAdmin);
        userInfo.setIsRegister(true);
        userInfo.setErrCount(0);
        userInfo.setPWEffectiveDate(pwEffectiveDate);
        userInfo.setDescription(description_l1, this.l1);
        userInfo.setDescription(description_l2, this.l2);
        userInfo.setDescription(description_l3, this.l3);
        userInfo.setCell(cell);
        if (!StringUtils.isEmpty((String)cell)) {
            String[] globalMap = ToolUtils.getGLObalMapCell(cell);
            userInfo.setGlobalRoaming(globalMap[0]);
            userInfo.setNCell(globalMap[1]);
        }
        userInfo.setEmail(mail);
        OrgRangeInfo orgRangeInfo = null;
        OrgRangeIncludeSubOrgInfo orgRangeIncludeSubOrgInfo = null;
        if (fullOrgUnitInfo != null) {
            orgRangeInfo = new OrgRangeInfo();
            orgRangeInfo.setUser(userInfo);
            orgRangeInfo.setOrg(fullOrgUnitInfo);
            orgRangeInfo.setType(orgRangeType);
            orgRangeIncludeSubOrgInfo = new OrgRangeIncludeSubOrgInfo();
            orgRangeIncludeSubOrgInfo.setUser(userInfo);
            orgRangeIncludeSubOrgInfo.setOrg(fullOrgUnitInfo);
            orgRangeIncludeSubOrgInfo.setType(orgRangeType);
            orgRangeIncludeSubOrgInfo.setIsIncludeSubOrg(false);
        }
        if (orgRangeInfo != null && !this.existOrgRange(userInfo, orgRangeInfo)) {
            userInfo.getOrgRange().add(orgRangeInfo);
            userInfo.getOrgRangeIncludeSubOrg().add(orgRangeIncludeSubOrgInfo);
        }
        return userInfo;
    }

    private boolean existOrgRange(UserInfo userInfo, OrgRangeInfo orgRangeInfo) {
        int size = userInfo.getOrgRange().size();
        for (int i = 0; i < size; ++i) {
            OrgRangeInfo info = userInfo.getOrgRange().get(i);
            if (orgRangeInfo.getOrg() == null || !info.getOrg().getNumber().equals(orgRangeInfo.getOrg().getNumber()) || !info.getType().equals((Object)orgRangeInfo.getType())) continue;
            return true;
        }
        return false;
    }

    private IObjectValue getValue(Context ctx, BOSObjectType objectType, String number, int caseWhere, String filedName) throws TaskExternalException {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        try {
            String key = this.getKey(filedName, number);
            if (this.dataCache.containsKey(key)) {
                return (IObjectValue)this.dataCache.get(key);
            }
            StringBuffer oql = new StringBuffer();
            switch (caseWhere) {
                case 0: {
                    oql.append("WHERE number = '" + number + "'");
                    break;
                }
                case 1: {
                    oql.append("WHERE number = '").append(number).append("'");
                    try {
                        oql.append(" and CU.id in (select og.forgid from T_PM_ORGRANGE og where  ");
                        oql.append(" og.ftype ='").append(Administrator.isCUAdmin(ctx, ctx.getCaller()) ? 10 : 30).append("' and ");
                        oql.append(" og.fuserid='" + ctx.getCaller().toString() + "') ");
                        break;
                    }
                    catch (EASBizException e) {
                        logger.error((Object)"Administrator.isCUAdmin()", (Throwable)e);
                        throw new TaskExternalException("Administrator.isCUAdmin()", (Throwable)e);
                    }
                }
            }
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            if (iDynamicObject.exists(objectType, oql.toString())) {
                IObjectValue objectValue = iDynamicObject.getValue(objectType, oql.toString());
                this.dataCache.put(key, objectValue);
                return objectValue;
            }
            String objectName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(objectType).getAlias();
            Object[] params = new Object[]{objectName, number};
            String msg = "";
            switch (caseWhere) {
                case 0: {
                    msg = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"numberNotFound", (java.util.Locale)ctx.getLocale()), params);
                    break;
                }
                case 1: {
                    msg = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"currentUserNoExistOrgRange", (java.util.Locale)ctx.getLocale()), params);
                    break;
                }
            }
            throw new TaskExternalException(msg);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new TaskExternalException("getValue():", (Throwable)e);
        }
    }

    private boolean booleanValue(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        return "Y".equalsIgnoreCase(string);
    }

    private String booleanToStr(boolean b) {
        return b ? "Y" : "N";
    }

    private Timestamp getTimestamp(String str) throws TaskExternalException {
        try {
            return new Timestamp(DateTimeUtils.parseDate((String)str).getTime());
        }
        catch (ParseException e) {
            logger.error((Object)e);
            throw new TaskExternalException("getTimestamp()", (Throwable)e);
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            ResultSetMetaData mt = rs.getMetaData();
            StringBuffer sb = new StringBuffer();
            int counts = mt.getColumnCount();
            sb.append("count: ").append(counts);
            sb.append(" AK  ");
            for (int i = 1; i <= counts; ++i) {
                sb.append(i).append(ResourceBase.getString((String)"com.kingdee.eas.base.permission.PERMISSIONAutoGenerateResource", (String)"2_UserDataTransmission", (java.util.Locale)ctx.getLocale())).append(mt.getColumnName(i)).append("**");
            }
            String number = rs.getString("NUMBER");
            String name_l1 = ctx.getLocale().equals(this.l1) ? rs.getString("NAME") : "";
            String name_l2 = ctx.getLocale().equals(this.l2) ? rs.getString("NAME") : "";
            String name_l3 = ctx.getLocale().equals(this.l3) ? rs.getString("NAME") : "";
            String type = String.valueOf(rs.getInt("TYPE"));
            String personNumber = rs.getString("PERSON.NUMBER") != null ? rs.getString("PERSON.NUMBER") : "";
            String customerID = rs.getString("CUSTOMER.NUMBER") != null ? rs.getString("CUSTOMER.NUMBER") : "";
            String supplierID = rs.getString("SUPPLIER.NUMBER") != null ? rs.getString("SUPPLIER.NUMBER") : "";
            String groupNumber = rs.getString("GROUP.NUMBER") != null ? rs.getString("GROUP.NUMBER") : "";
            String securityNumber = rs.getString("SECURITY.NUMBER");
            String effectiveDate = DateTimeUtils.format((Date)rs.getTimestamp("EFFECTIVEDATE"), (String)"yyyy-MM-dd HH:mm:ss");
            String invaildationDate = DateTimeUtils.format((Date)rs.getTimestamp("INVALIDATIONDATE"), (String)"yyyy-MM-dd HH:mm:ss");
            effectiveDate = this.formatNationalTime(ctx, rs.getTimestamp("EFFECTIVEDATE"));
            invaildationDate = this.formatNationalTime(ctx, rs.getTimestamp("INVALIDATIONDATE"));
            String password = "";
            String cuNumber = rs.getString("CU.NUMBER");
            String forbidden = this.booleanToStr(rs.getBoolean("ISFORBIDDEN"));
            String locked = this.booleanToStr(rs.getBoolean("ISLOCKED"));
            String changePW = this.booleanToStr(rs.getBoolean("changedPW"));
            String defOUNumber = rs.getString("DEFORGUNIT.NUMBER");
            String defLocale = rs.getString("DEFLOCALE");
            String bizAdmin = this.booleanToStr(rs.getBoolean("BIZADMIN"));
            String pwEffectiveDate = this.formatNationalTime(ctx, rs.getDate("PWEFFECTIVEDATE"));
            String description_l1 = ctx.getLocale().equals(this.l1) ? rs.getString("DESCRIPTION") : "";
            String description_l2 = ctx.getLocale().equals(this.l2) ? rs.getString("DESCRIPTION") : "";
            String description_l3 = ctx.getLocale().equals(this.l3) ? rs.getString("DESCRIPTION") : "";
            String orgId = rs.getString("org.id");
            String orgNumber = rs.getString("ORG.NUMBER");
            String orgRangeType = String.valueOf(rs.getInt("ORGRANGE.TYPE"));
            if (StringUtils.isEmpty((String)orgNumber)) {
                orgRangeType = "";
            }
            String cell = rs.getString("cell");
            String mail = rs.getString("email");
            result.put("FEmail", mail == null ? "" : mail);
            result.put("FCell", cell == null ? "" : cell);
            result.put("FNumber", number);
            result.put("FName_L1", name_l1 == null ? "" : name_l1);
            result.put("FName_L2", name_l2 == null ? "" : name_l2);
            result.put("FName_L3", name_l3 == null ? "" : name_l3);
            result.put("FType", StringUtils.cnulls((String)type));
            result.put("FPersonID", StringUtils.cnulls((String)personNumber));
            result.put("FCustomerID", StringUtils.cnulls((String)customerID));
            result.put("FSupplierID", StringUtils.cnulls((String)supplierID));
            result.put("FGroupID", StringUtils.cnulls((String)groupNumber));
            result.put("FSecurityId", StringUtils.cnulls((String)securityNumber));
            result.put("FEffectiveDate", StringUtils.cnulls((String)effectiveDate));
            result.put("FInvalidationDate", StringUtils.cnulls((String)invaildationDate));
            result.put("FPassword", StringUtils.cnulls((String)password));
            result.put("FControlUnitID", StringUtils.cnulls((String)cuNumber));
            result.put("FForbidden", StringUtils.cnulls((String)forbidden));
            result.put("FIslocked", StringUtils.cnulls((String)locked));
            result.put("FChangedPW", StringUtils.cnulls((String)changePW));
            result.put("FDefaultOrgUnitID", StringUtils.cnulls((String)defOUNumber));
            result.put("FDefaultLocale", StringUtils.cnulls((String)defLocale));
            result.put("FIsBizAdmin", StringUtils.cnulls((String)bizAdmin));
            result.put("FPWEffectiveDate", StringUtils.cnulls((String)pwEffectiveDate));
            result.put("FDescription_L1", description_l1 == null ? "" : description_l1);
            result.put("FDescription_L2", description_l2 == null ? "" : description_l2);
            result.put("FDescription_L3", description_l3 == null ? "" : description_l3);
            result.put("FOrgID", StringUtils.cnulls((String)orgNumber));
            result.put("FOrgRangeType", StringUtils.cnulls((String)orgRangeType));
            UserDataOrgExportInputHelper helper = new UserDataOrgExportInputHelper();
            OrgTreeInfo orgTreeInfo = helper.getOrgTreeInfoByOrgId(ctx, orgId);
            if (orgTreeInfo != null) {
                result.put("FOrgTreeNumber", StringUtils.cnulls((String)orgTreeInfo.getNumber()));
                result.put("FOrgTreeDate", StringUtils.cnulls((Object)orgTreeInfo.getStartDate()));
            } else {
                result.put("FOrgTreeNumber", "");
                result.put("FOrgTreeDate", "");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new TaskExternalException("exportTransmit():", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.base.permission.app.UserExportDataQuery";
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo.getId() == null || !this.getController(ctx).exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                UserInfo info = (UserInfo)coreBaseInfo;
                boolean updatePassWord = false;
                if (!StringUtils.isEmpty((String)info.getPassword())) {
                    updatePassWord = true;
                }
                IUser iUser = (IUser)this.getController(ctx);
                iUser.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), (IObjectValue)coreBaseInfo, updatePassWord, true);
                UserInfo updatePWEffectiveDate = new UserInfo();
                updatePWEffectiveDate.setId(info.getId());
                updatePWEffectiveDate.setPWEffectiveDate(info.getPWEffectiveDate());
                updatePWEffectiveDate.setChangedPW(info.isChangedPW());
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("PWEffectiveDate"));
                sic.add(new SelectorItemInfo("changedPW"));
                iUser.updatePartial((CoreBaseInfo)updatePWEffectiveDate, sic);
                if (info.getGroup() != null && info.getGroup().getId() != null) {
                    IUserGroupGFacade iUserGroupGFacade = UserGroupGFacadeFactory.getLocalInstance(ctx);
                    String userId = info.getId().toString();
                    Set<String> groupSet = this.userGroupMap.get(userId);
                    if (groupSet == null) {
                        groupSet = new HashSet<String>();
                    }
                    groupSet.add(info.getGroup().getId().toString());
                    this.userGroupMap.put(userId, groupSet);
                    iUserGroupGFacade.update((IObjectPK)new ObjectUuidPK(userId), groupSet);
                }
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private String formatNationalTime(Context ctx, Object dateStr) {
        if (dateStr == null) {
            return "";
        }
        HashMap nationmap = null;
        try {
            nationmap = NantionalServiceFacadeFactory.getLocalInstance((Context)ctx).getNationalConfig(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString(), ctx.getLocale().toString());
            SimpleDateFormat dtformat = null;
            if (dateStr instanceof Timestamp) {
                dtformat = (SimpleDateFormat)nationmap.get("dateTimeFormat");
            } else if (dateStr instanceof Date) {
                dtformat = (SimpleDateFormat)nationmap.get("dateFormat");
            }
            return dtformat.format(dateStr);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected boolean checkMobilePhone(UserType type, String mobilePhone) throws UserException {
        if (StringUtils.isEmpty((String)mobilePhone)) {
            if (type.equals((Object)UserType.SYSTEM)) {
                return true;
            }
            throw new UserException(UserException.CELL_NULL);
        }
        Pattern p = Pattern.compile("^[1]\\d{10}$");
        Matcher m = p.matcher(mobilePhone);
        return m.matches();
    }

    protected boolean checkMailAddress(String email) {
        Pattern p = Pattern.compile("\\w+@(\\w+.)+[a-z]{2,3}");
        Matcher m = p.matcher(email);
        return m.matches();
    }
}

