/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.alibaba.fastjson.JSONObject;
import com.google.zxing.BarcodeFormat;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.QRCodeUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.ControlPolicy;
import com.kingdee.eas.base.license.ErpUserStatusEnum;
import com.kingdee.eas.base.license.ICloudRegistSrv;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.LoginAndLogout;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFindPassParam;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserLockTypeEnum;
import com.kingdee.eas.base.permission.app.AbstractUserFindPassFacadeControllerBean;
import com.kingdee.eas.base.permission.app.util.UserInfoUtils;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.util.CloudActiveParamsUtil;
import com.kingdee.eas.cp.eip.sso.util.TransferUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class UserFindPassFacadeControllerBean
extends AbstractUserFindPassFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.UserFindPassFacadeControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionFindPassResource";

    @Override
    protected void _checkCanFindPass(Context ctx, String userNumber) throws BOSException, EASBizException {
        int goneMinutes;
        int lockedMinutes;
        if (StringUtils.isEmpty((String)userNumber)) {
            throw new UserException(UserException.NUMBER_NOT_NULL);
        }
        if ("administrator".equalsIgnoreCase(userNumber)) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"FINDPASS_ADMIN_CANNOT", (Locale)ctx.getLocale()));
        }
        if ("authenadmin".equalsIgnoreCase(userNumber)) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"FINDPASS_AUTHENADMIN_CANNOT", (Locale)ctx.getLocale()));
        }
        if ("auditadmin".equalsIgnoreCase(userNumber)) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"FINDPASS_AUDITADMIN_CANNOT", (Locale)ctx.getLocale()));
        }
        if ("sscAdmin".equalsIgnoreCase(userNumber)) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"FINDPASS_SSCADMIN_CANNOT", (Locale)ctx.getLocale()));
        }
        if ("user".equalsIgnoreCase(userNumber)) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"FINDPASS_USER_CANNOT", (Locale)ctx.getLocale()));
        }
        try {
            userNumber = this.checkLoginType(ctx, userNumber);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        UserInfo userInfo = UserInfoUtils.getUserInfo4LoinModule(ctx, userNumber);
        if (userInfo == null) {
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select 1 from T_PM_User U WHERE UPPER(U.FNumber)=?", (Object[])new Object[]{userNumber.toUpperCase()});
                if (rs.next()) {
                    throw new UserException(UserException.USER_BEEN_INVALID);
                }
                return;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (userInfo.isIsForbidden()) {
            throw new UserException(UserException.USER_BEEN_INVALID);
        }
        if (userInfo.isIsLocked() && (lockedMinutes = UserLockTypeEnum.UPDATE_PASSWORD.equals((Object)userInfo.getLockType()) ? userInfo.getSecurity().getLockUpdatePwTime() : userInfo.getSecurity().getLockTime()) - (goneMinutes = (int)((System.currentTimeMillis() - userInfo.getLockedTime().getTime()) / 60000L)) > 0) {
            throw new UserException(UserException.USER_IS_LOCKED_BY_FORGETPW, new Object[]{String.valueOf(lockedMinutes - goneMinutes)});
        }
        Date currentDate = new Date(System.currentTimeMillis());
        if (DateTimeUtils.dayAfter((Date)userInfo.getEffectiveDate(), (Date)currentDate)) {
            throw new UserException(UserException.USER_BEEN_INVALID);
        }
        if (DateTimeUtils.dayAfter((Date)currentDate, (Date)userInfo.getInvalidationDate())) {
            throw new UserException(UserException.USER_BEEN_INVALID);
        }
        ErpUserStatusEnum status = null;
        try {
            ICloudRegistSrv cloudRegistSrv = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx);
            status = ControlPolicy.isBySubscriptionRegOnline((Context)ctx) ? cloudRegistSrv.getErpUserStatus(userNumber, userInfo.getCell(), userInfo.getEmail()) : cloudRegistSrv.getErpUserStatus(userNumber);
        }
        catch (LicenseException e) {
            throw new BOSException((Throwable)e);
        }
        if (ErpUserStatusEnum.NOT_ENABLED.equals((Object)status)) {
            throw new UserException(UserException.CLOUDUSER_FORBIDDEN);
        }
        if (ErpUserStatusEnum.NO_CLOUND_PASSPORT.equals((Object)status)) {
            throw new UserException(UserException.CLOUDUSER_NREGISTER);
        }
        if (ErpUserStatusEnum.NOT_ACTIVATED.equals((Object)status)) {
            throw new UserException(UserException.NOT_ACTIVATED);
        }
        if (LoginAuthorWayEnum.DYNAMIC.equals((Object)userInfo.getLoginAuthorWay()) || LoginAuthorWayEnum.FINGERPRINT.equals((Object)userInfo.getLoginAuthorWay()) || LoginAuthorWayEnum.USBKEY.equals((Object)userInfo.getLoginAuthorWay())) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"FINDPASS_USER_CANNOT_LOGINTYPE", (Locale)ctx.getLocale()));
        }
        String userAuthen = CloudActiveParamsUtil.getAuthPattern();
        if (!"BaseDB".equalsIgnoreCase(userAuthen)) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"FINDPASS_USER_CANNOT_LOGINTYPE", (Locale)ctx.getLocale()));
        }
    }

    private String checkLoginType(Context ctx, String originUserName) throws BOSException, SQLException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fnumber from t_pm_user where upper(fnumber)=?", (Object[])new Object[]{originUserName.toUpperCase()});
        if (rs.next() && !StringUtils.isEmpty((String)rs.getString(1))) {
            return rs.getString("fnumber");
        }
        rs = DbUtil.executeQuery((Context)ctx, (String)"select fnumber from t_pm_user where fcell=?", (Object[])new Object[]{originUserName});
        if (rs.next() && !StringUtils.isEmpty((String)rs.getString(1))) {
            if (rs.size() != 1) {
                return originUserName;
            }
            return rs.getString("fnumber");
        }
        rs = DbUtil.executeQuery((Context)ctx, (String)"select fnumber from t_pm_user where femail=?", (Object[])new Object[]{originUserName});
        if (rs.next() && !StringUtils.isEmpty((String)rs.getString(1))) {
            if (rs.size() != 1) {
                return originUserName;
            }
            return rs.getString("fnumber");
        }
        return originUserName;
    }

    @Override
    protected JSONObject _sendVcode(Context ctx, String userNumber, String phoneOrEmail) throws BOSException, EASBizException {
        JSONObject result = null;
        try {
            if (StringUtils.isEmpty((String)phoneOrEmail)) {
                throw new Exception(EASResource.getString((String)RESOURCE, (String)"FINDPASS_PHONR_OR_EMAIL_NOTEMPTY", (Locale)ctx.getLocale()));
            }
            this._checkCanFindPass(ctx, userNumber);
            UserInfo userInfo = UserInfoUtils.getUserInfo4LoinModule(ctx, userNumber);
            if (userInfo == null) {
                throw new BOSException(EASResource.getString((String)RESOURCE, (String)"FINDPASS_PHONE_ERROR", (Locale)ctx.getLocale()));
            }
            String email = "";
            String phone = "";
            boolean isPhone = false;
            if (phoneOrEmail.indexOf("@") > 0) {
                email = phoneOrEmail;
            } else {
                phone = phoneOrEmail;
                isPhone = true;
            }
            if (isPhone && (userInfo == null || !phone.equals(userInfo.getCell()))) {
                throw new BOSException(EASResource.getString((String)RESOURCE, (String)"FINDPASS_PHONE_ERROR", (Locale)ctx.getLocale()));
            }
            if (!(isPhone || userInfo != null && email.equalsIgnoreCase(userInfo.getEmail()))) {
                throw new BOSException(EASResource.getString((String)RESOURCE, (String)"FINDPASS_EMAIL_ERROR", (Locale)ctx.getLocale()));
            }
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
            LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
            result = EasCloud.getActiveCode((String)userInfo.getUid(), (String)baseInfo.getProductInstanceID(), (String)phone, (String)email);
            if (result.getInteger("errcode") == 0) {
                this.logGetCodeFindPass(ctx, userNumber);
            }
            if (result.getInteger("errcode") == 400) {
                result.put(EasCloud.DESCRIPTION_CN, (Object)EASResource.getString((String)RESOURCE, (String)"YOUR_PHONE_OR_EMAIL_NO_SYNC", (Locale)ctx.getLocale()));
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)new IOException(EASResource.getString((String)RESOURCE, (String)"NETWORK_CANNOT_CONNECT_TO_KINGDEECLOUD")));
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private void logGetCodeFindPass(Context ctx, String userNumber) {
        try {
            UserInfo userInfo4LoinModule = null;
            if (ctx.get((Object)"UserInfo") == null) {
                userInfo4LoinModule = UserInfoUtils.getUserInfo4LoinModule(ctx, userNumber);
                ContextUtil.setCurrentUserInfo((Context)ctx, (UserInfo)userInfo4LoinModule);
            }
            if (ContextUtil.getCurrentCtrlUnit((Context)ctx) == null) {
                if (userInfo4LoinModule == null) {
                    userInfo4LoinModule = UserInfoUtils.getUserInfo4LoinModule(ctx, userNumber);
                }
                ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)userInfo4LoinModule.getCU());
            }
            String description = ResourceBase.getString((String)RESOURCE, (String)"log_getCodeFindPass", (Locale)ctx.getLocale());
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)description, (BOSObjectType)new LoginAndLogout().getType(), null, (String)description, (String)"UserLoginLog");
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean _verifyVCode(Context ctx, UserFindPassParam params) throws BOSException, EASBizException {
        try {
            UserInfo userInfo = UserInfoUtils.getUserInfo4LoinModule(ctx, params.getUserNumber());
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
            LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
            String wholePhone = "";
            String email = "";
            if (params.isUsePhone()) {
                wholePhone = params.getPhone();
            } else {
                email = params.getEmail();
            }
            boolean isPhone = params.isUsePhone();
            if (isPhone && (wholePhone == null || !wholePhone.equals(userInfo.getCell()))) {
                throw new BOSException(EASResource.getString((String)RESOURCE, (String)"FINDPASS_PHONE_ERROR", (Locale)ctx.getLocale()));
            }
            if (!(isPhone || email != null && email.equalsIgnoreCase(userInfo.getEmail()))) {
                throw new BOSException(EASResource.getString((String)RESOURCE, (String)"FINDPASS_EMAIL_ERROR", (Locale)ctx.getLocale()));
            }
            if (params.isOffineLine()) {
                JSONObject rs = EasCloud.verifyCode((String)userInfo.getUid(), (String)baseInfo.getProductInstanceID(), (String)wholePhone, (String)email, (String)params.getVcode());
                if (rs.getInteger("errcode") != 0) {
                    logger.error((Object)rs);
                    String error = null;
                    error = "l1".equalsIgnoreCase(ctx.getLocale().toString()) ? rs.getString(EasCloud.DESCRIPTION) : rs.getString(EasCloud.DESCRIPTION_CN);
                    throw new BOSException(error);
                }
            } else {
                boolean isMatch = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx).checkErpUserSecurityCode(params.getUserNumber(), params.getVcode());
                if (!isMatch) {
                    throw new BOSException(EASResource.getString((String)RESOURCE, (String)"FINDPASS_VCODE_ERROR", (Locale)ctx.getLocale()));
                }
            }
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    @Override
    protected byte[] _generatorOfflineQrcode(Context ctx, String userNumber, int size) throws BOSException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            String url = EasCloud.OFFLINE_QRCODE_URL;
            ICloudRegistSrv crs = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx);
            String vcode = crs.getErpUserActiveCode(userNumber);
            String prod_inst_code = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getLicenseBaseInfo().getProductInstanceID();
            String wholePhone = crs.getCloudRegistUserInfo(userNumber).getPhone();
            Date date = new Date();
            String time = String.valueOf(date.getTime() / 1000L);
            String signiture = TransferUtil.sha1((String)(EasCloud.CLIENT_ID + EasCloud.CLIENT_SECRET + prod_inst_code + wholePhone + vcode + time));
            StringBuilder sb = new StringBuilder();
            sb.append(url).append("?").append("client_id=").append(EasCloud.CLIENT_ID).append("&prod_inst_code=").append(prod_inst_code).append("&vcode=").append(vcode).append("&phone=").append(wholePhone).append("&timestamp=").append(time).append("&signiture=").append(signiture);
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("barcode", sb.toString());
            config.put("height", String.valueOf(size));
            config.put("width", String.valueOf(size));
            QRCodeUtils.generateBarcodePicture((OutputStream)out, (BarcodeFormat)BarcodeFormat.QR_CODE, config);
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return out.toByteArray();
    }
}

