/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUserGroup;
import com.kingdee.eas.base.permission.UserGroupFactory;
import com.kingdee.eas.base.permission.UserGroupInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class UserGroupDataTransmission
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger(UserGroupDataTransmission.class);
    private Locale l1 = new Locale("L1");
    private Locale l2 = new Locale("L2");
    private Locale l3 = new Locale("L3");
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return UserGroupFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new TaskExternalException("getController():", (Throwable)e);
        }
    }

    private UserGroupInfo getUserGroupInfo(Context ctx, String number) throws TaskExternalException {
        try {
            IUserGroup iUserGroup = (IUserGroup)this.getController(ctx);
            String oql = "SELECT *, parent.* WHERE number = '" + number + "'";
            if (iUserGroup.exists(oql)) {
                return iUserGroup.getUserGroupInfo(oql);
            }
            return null;
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new TaskExternalException("getUserGroupInfo():", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new TaskExternalException("getUserGroupInfo():", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        UserGroupInfo parentUserGroupInfo;
        String number = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        if (StringUtils.isEmpty((String)number)) {
            String objectName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(new UserGroupInfo().getBOSType()).getAlias();
            Object[] params = new Object[]{objectName, number};
            String msg = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"numberNotFound", (Locale)ctx.getLocale()), params);
            throw new TaskExternalException(msg);
        }
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        UserGroupInfo userGroupInfo = this.getUserGroupInfo(ctx, number);
        if (userGroupInfo == null) {
            userGroupInfo = new UserGroupInfo();
            userGroupInfo.setNumber(number);
        } else if (datataskMode == 8) {
            String objectName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(new UserGroupInfo().getBOSType()).getAlias();
            Object[] params = new Object[]{objectName, number};
            String msg = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"numberAlreadyExist", (Locale)ctx.getLocale()), params);
            throw new TaskExternalException(msg);
        }
        String parentNumber = (String)((DataToken)hsData.get((Object)"FParentID")).data;
        String name_l1 = (String)((DataToken)hsData.get((Object)"FName_L1")).data;
        String name_l2 = (String)((DataToken)hsData.get((Object)"FName_L2")).data;
        String name_l3 = (String)((DataToken)hsData.get((Object)"FName_L3")).data;
        String description_l1 = (String)((DataToken)hsData.get((Object)"FDescription_L1")).data;
        String description_l2 = (String)((DataToken)hsData.get((Object)"FDescription_L2")).data;
        String description_l3 = (String)((DataToken)hsData.get((Object)"FDescription_L3")).data;
        userGroupInfo.setName(name_l1, this.l1);
        userGroupInfo.setName(name_l2, this.l2);
        userGroupInfo.setName(name_l3, this.l3);
        userGroupInfo.setDescription(description_l1, this.l1);
        userGroupInfo.setDescription(description_l2, this.l2);
        userGroupInfo.setDescription(description_l3, this.l3);
        CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
        ctrlUnitInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
        userGroupInfo.setCU(ctrlUnitInfo);
        if (!StringUtils.isEmpty((String)parentNumber) && (parentUserGroupInfo = this.getUserGroupInfo(ctx, parentNumber)) != null) {
            userGroupInfo.setParent(parentUserGroupInfo);
        }
        return userGroupInfo;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            String number = rs.getString("NUMBER");
            String parentNumber = rs.getString("PARENT.NUMBER") == null ? "" : rs.getString("PARENT.NUMBER");
            String name_l1 = ctx.getLocale().equals(this.l1) ? rs.getString("NAME") : "";
            String name_l2 = ctx.getLocale().equals(this.l2) ? rs.getString("NAME") : "";
            String name_l3 = ctx.getLocale().equals(this.l3) ? rs.getString("NAME") : "";
            String description_l1 = ctx.getLocale().equals(this.l1) ? rs.getString("DESCRIPTION") : "";
            String description_l2 = ctx.getLocale().equals(this.l2) ? rs.getString("DESCRIPTION") : "";
            String description_l3 = ctx.getLocale().equals(this.l3) ? rs.getString("DESCRIPTION") : "";
            result.put("FNumber", number);
            result.put("FParentID", parentNumber);
            result.put("FName_L1", name_l1 == null ? "" : name_l1);
            result.put("FName_L2", name_l2 == null ? "" : name_l2);
            result.put("FName_L3", name_l3 == null ? "" : name_l3);
            result.put("FDescription_L1", description_l1 == null ? "" : description_l1);
            result.put("FDescription_L2", description_l2 == null ? "" : description_l2);
            result.put("FDescription_L3", description_l3 == null ? "" : description_l3);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new TaskExternalException("exportTransmit():", (Throwable)e);
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.base.permission.app.UserGroupExportDataQuery";
    }
}

