/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.adapter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.service.IBatchServiceAdaptor;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.base.permission.app.adapter.BatchPermInto;
import com.kingdee.eas.base.permission.app.adapter.PermissionServiceAdapter;
import com.kingdee.eas.base.permission.app.adapter.PermissionServiceAdapterHelper;
import com.kingdee.eas.base.permission.app.cache.IPermItemCache;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.base.permission.app.util.BizObjectOrgHelper;
import com.kingdee.eas.base.permission.app.util.BizObjectOrgUtil;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PermissionBatchServiceAdapter
extends PermissionServiceAdapter
implements IBatchServiceAdaptor {
    private Logger logger = Logger.getLogger((String)PermissionBatchServiceAdapter.class.getName());

    public void batchExecute(IServiceContext[] arrServiceContext) throws BOSException {
        try {
            if (arrServiceContext == null || arrServiceContext.length == 0) {
                return;
            }
            Context ctx = this.getContext(arrServiceContext);
            String[] permItemNameAry = this.getPermItemNameFromCtx(arrServiceContext);
            if (permItemNameAry == null || permItemNameAry.length == 0) {
                return;
            }
            Map permItemName2InfoMap = this.getPermItemName2InfoMap(ctx, permItemNameAry);
            Map allBizObjIdPerm2OrgMap = this.getBizObjPerm2OrgMap(arrServiceContext, permItemNameAry, permItemName2InfoMap);
            IPermission iPermission = PermissionFactory.getLocalInstance(ctx);
            for (int ctxIndex = 0; ctxIndex < arrServiceContext.length; ++ctxIndex) {
                try {
                    for (int permItemIndex = 0; permItemIndex < permItemNameAry.length; ++permItemIndex) {
                        PermItemInfo permItemInfo = (PermItemInfo)permItemName2InfoMap.get(permItemNameAry[permItemIndex]);
                        if (StringUtils.isEmpty((String)permItemInfo.getObjectType()) || !permItemInfo.isEnableDataPermission()) {
                            IObjectPK orgPK = (IObjectPK)allBizObjIdPerm2OrgMap.get(permItemNameAry[permItemIndex]);
                            iPermission.checkFunctionPermission(ctx.getCaller(), orgPK, permItemNameAry[permItemIndex]);
                            continue;
                        }
                        BOSUuid bosuuid = this.getBOSUuidFromCtx(arrServiceContext[ctxIndex], BOSObjectType.create((String)permItemInfo.getObjectType()));
                        if (bosuuid == null) continue;
                        IObjectPK orgPK = (IObjectPK)allBizObjIdPerm2OrgMap.get(permItemNameAry[permItemIndex] + bosuuid.toString());
                        iPermission.checkDataPermission(ctx.getCaller(), orgPK, permItemNameAry[permItemIndex], (IObjectPK)new ObjectStringPK(bosuuid.toString()));
                    }
                    continue;
                }
                catch (PermissionException pe) {
                    arrServiceContext[ctxIndex].setServiceResult("PERMISSION_ITEMS", (Object)pe);
                }
            }
        }
        catch (EASBizException e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new PermissionServiceException(e.getMessage());
        }
    }

    private Map getPermItemName2InfoMap(Context ctx, String[] permItemNameAry) throws EASBizException, BOSException {
        IPermItemCache permItemCache = PermissionCacheFactory.getPermItemCache(ctx);
        HashMap<String, PermItemInfo> retMap = new HashMap<String, PermItemInfo>();
        for (int i = 0; i < permItemNameAry.length; ++i) {
            retMap.put(permItemNameAry[i], permItemCache.getPermItem(ctx, permItemNameAry[i]));
        }
        return retMap;
    }

    private Map getBizObjPerm2OrgMap(IServiceContext[] arrServiceContext, String[] permItemNameAry, Map permItemName2InfoMap) throws EASBizException, BOSException {
        HashMap<String, IObjectPK> retMap = new HashMap<String, IObjectPK>();
        Context ctx = arrServiceContext[0].getContext();
        for (int i = 0; i < permItemNameAry.length; ++i) {
            PermItemInfo permItemInfo = (PermItemInfo)permItemName2InfoMap.get(permItemNameAry[i]);
            if (permItemInfo == null || StringUtils.isEmpty((String)permItemInfo.getObjectType())) {
                IObjectPK orgPK = PermissionUtil.getPermissionOrgPK(arrServiceContext[0].getContext(), permItemInfo.getOrgRelation(), null, null);
                retMap.put(permItemNameAry[i], orgPK);
                continue;
            }
            BOSUuid[] bosUuid = this.getBizObjPKFromCtx(arrServiceContext, BOSObjectType.create((String)permItemInfo.getObjectType()));
            BatchPermInto[] batchPermInfo = this.getBizMainOrg(ctx, bosUuid);
            this.put2MapValue(retMap, permItemNameAry[i], batchPermInfo);
        }
        return retMap;
    }

    private void put2MapValue(Map retMap, String permItemNameStr, BatchPermInto[] batchPermInfo) {
        if (batchPermInfo == null) {
            return;
        }
        for (int i = 0; i < batchPermInfo.length; ++i) {
            retMap.put(permItemNameStr + batchPermInfo[i].getBizObjPK().toString(), batchPermInfo[i].getOrgPK());
        }
    }

    private String[] getPermItemNameFromCtx(IServiceContext[] arrServiceContext) {
        return (String[])arrServiceContext[0].getServiceParameter("PERMISSION_SERVICE", "PERMISSION_ITEMS");
    }

    private BatchPermInto[] getBizMainOrg(Context ctx, BOSUuid[] bizObjPKAry) throws BOSException, EASBizException {
        try {
            if (bizObjPKAry == null || bizObjPKAry.length == 0) {
                return null;
            }
            BOSUuid oneId = bizObjPKAry[0];
            BizObjectOrgHelper bizObjHelper = new BizObjectOrgHelper();
            String bizObjPropertyName = bizObjHelper.getBizObjOrgPropertyName(ctx, oneId.getType());
            String oql = " select *," + bizObjPropertyName + ".* where id in (" + ToolUtils.aryToStr(bizObjPKAry, true) + ")";
            IObjectCollection bizCol = BizObjectOrgUtil.getBizCollection(ctx, oneId.getType(), oql);
            if (bizCol == null || bizCol.isEmpty()) {
                return null;
            }
            ArrayList<BatchPermInto> retList = new ArrayList<BatchPermInto>();
            for (int i = 0; i < bizCol.size(); ++i) {
                IObjectValue iObjectValue = bizCol.getObject(i);
                BatchPermInto retPermInfo = new BatchPermInto();
                String bizPKStr = StringUtils.cnulls((Object)iObjectValue.get(iObjectValue.getPKField()));
                if (StringUtils.isEmpty((String)bizPKStr)) break;
                retPermInfo.setBizObjPK(BOSUuid.read((String)bizPKStr));
                IObjectPK orgPK = bizObjHelper.getMainOrgObjValueInfo(ctx, new ObjectStringPK(bizPKStr), bizObjPropertyName + ".id");
                if (orgPK == null) break;
                retPermInfo.setOrgPK(orgPK);
                retList.add(retPermInfo);
            }
            BatchPermInto[] retInfo = new BatchPermInto[retList.size()];
            for (int i = 0; i < retList.size(); ++i) {
                retInfo[i] = (BatchPermInto)retList.get(i);
            }
            return retInfo;
        }
        catch (UuidException e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private Context getContext(IServiceContext[] arrServiceContext) {
        return arrServiceContext[0].getContext();
    }

    private BOSUuid[] getBizObjPKFromCtx(IServiceContext[] arrServiceContext, BOSObjectType bosObjectType) {
        ArrayList<BOSUuid> bosuuidList = new ArrayList<BOSUuid>();
        for (int i = 0; i < arrServiceContext.length; ++i) {
            BOSUuid oneUuid = this.getBOSUuidFromCtx(arrServiceContext[i], bosObjectType);
            if (oneUuid == null) continue;
            bosuuidList.add(oneUuid);
        }
        BOSUuid[] retUuid = new BOSUuid[bosuuidList.size()];
        for (int i = 0; i < bosuuidList.size(); ++i) {
            retUuid[i] = (BOSUuid)bosuuidList.get(i);
        }
        return retUuid;
    }

    private BOSUuid getBOSUuidFromCtx(IServiceContext serviceContext, BOSObjectType bosObjectType) {
        IObjectPK objPK = PermissionServiceAdapterHelper.getObjectPK(serviceContext, bosObjectType);
        if (objPK != null) {
            return BOSUuid.create((String)objPK.toString());
        }
        Object[] params = serviceContext.getOperationParameters();
        for (int i = 0; i < params.length; ++i) {
            if (!(params[i] instanceof IObjectPK)) continue;
            try {
                if (!bosObjectType.equals((Object)BOSUuid.read((String)params[i].toString()).getType())) continue;
                return BOSUuid.read((String)StringUtils.cnulls((Object)params[i]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

