/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.adapter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.service.AbstractServiceAdapter;
import com.kingdee.bos.service.IServiceAdapter;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.OperationType;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.base.permission.app.adapter.MutiOrgPermissionServiceAdapter;
import com.kingdee.eas.base.permission.app.adapter.PermissionServiceAdapterHelper;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.base.permission.app.config.PermissionFilterConfiguration;
import com.kingdee.eas.base.permission.app.start.PermissionServiceStartManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PermissionServiceAdapter
extends AbstractServiceAdapter
implements IServiceAdapter {
    private static Logger logger = Logger.getLogger(PermissionServiceAdapter.class);
    protected static final String PERMISSION_ITEMS = "PERMISSION_ITEMS";
    private static final String DISABLE_DATA_PERM = "DISABLE_DATA_PERM";
    private static final int PERMISSION_PRIORITY = 100;
    private static final String IGNORREPERM_CONFIG = System.getProperties().getProperty("EAS_HOME") + File.separator + "properties" + File.separator + "bos_ignore_permission_verify.xml";
    private static Map<String, Boolean> ignorePermItemMap;

    public PermissionServiceAdapter() {
        try {
            PermissionServiceStartManager.exec();
        }
        catch (Exception e) {
            logger.error((Object)"\u670d\u52a1\u542f\u52a8\u6743\u9650\u6a21\u5757PermissionInitManager.exec()\u6267\u884c\u9519\u8bef\uff01", (Throwable)e);
        }
    }

    public int getPriority() {
        return 100;
    }

    public String getName() {
        return "PERMISSION_SERVICE";
    }

    public void execute(IServiceContext serviceContext) throws BOSException {
        LowTimer lowTimer = new LowTimer();
        long beginTime = lowTimer.msValue();
        Context context = serviceContext.getContext();
        Object objForKScript = context.get((Object)"disablePermissionForKScript");
        if (objForKScript != null && objForKScript instanceof Boolean && ((Boolean)objForKScript).booleanValue()) {
            return;
        }
        try {
            if (serviceContext.getExecutionMode() == 0) {
                this.initPermItems();
                this.handleServiceBefore(serviceContext);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"Permission Service", (Throwable)e);
            throw new PermissionServiceException(e.getMessage());
        }
        if (logger.isDebugEnabled()) {
            long endTime = lowTimer.msValue();
            logger.debug((Object)("execute():  " + (endTime - beginTime)));
        }
    }

    private synchronized void initPermItems() {
        if (ignorePermItemMap != null) {
            return;
        }
        ignorePermItemMap = new HashMap<String, Boolean>();
        File configFile = new File(IGNORREPERM_CONFIG);
        if (!configFile.exists()) {
            return;
        }
        SAXReader reader = new SAXReader();
        Element root = null;
        try {
            Document document = reader.read(configFile);
            root = document.getRootElement();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        List nodes = root.elements("permission");
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            List items = ((Element)it.next()).elements("item");
            for (Element element : items) {
                ignorePermItemMap.put(element.attributeValue("permItemName"), Boolean.valueOf(element.attributeValue("ignore")));
            }
        }
    }

    private void ignorePermItems(IServiceContext serviceContext, String[] permItemNames) throws EASBizException, BOSException {
        if (ignorePermItemMap.size() == 0) {
            return;
        }
        for (int i = 0; i < permItemNames.length; ++i) {
            PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(serviceContext.getContext()).getPermItem(serviceContext.getContext(), permItemNames[i]);
            if (!ignorePermItemMap.containsKey(permItemInfo.getName()) || !ignorePermItemMap.get(permItemInfo.getName()).booleanValue()) continue;
            permItemNames[i] = null;
        }
    }

    public boolean enableDataPermFromContext(IServiceContext serviceContext) {
        boolean defaultVaue = true;
        if (serviceContext == null || serviceContext.getContext() == null) {
            return defaultVaue;
        }
        String disableDataPerm = StringUtils.cnulls((Object)serviceContext.getContext().get((Object)DISABLE_DATA_PERM));
        if (disableDataPerm.equalsIgnoreCase("true")) {
            return !defaultVaue;
        }
        return defaultVaue;
    }

    private void handleServiceBefore(IServiceContext serviceContext) throws EASBizException, BOSException {
        String[] permItemNames = this.getPermItemNames(serviceContext);
        if (permItemNames == null || permItemNames.length == 0) {
            return;
        }
        this.ignorePermItems(serviceContext, permItemNames);
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance(serviceContext.getContext());
        boolean isEnableDataPermFromContext = this.enableDataPermFromContext(serviceContext);
        boolean isEnableDataPermission = provider.isEnableDataPermission();
        for (int i = 0; i < permItemNames.length; ++i) {
            try {
                if (permItemNames[i] == null) continue;
                if (isEnableDataPermission && isEnableDataPermFromContext) {
                    this.handleWithEnableDataPermision(serviceContext, permItemNames[i]);
                    continue;
                }
                this.handleWithoutEnableDataPermision(serviceContext, permItemNames[i]);
                continue;
            }
            catch (EASBizException e) {
                if (e instanceof PermissionException) {
                    try {
                        Object[] params;
                        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(serviceContext.getContext()).getPermItem(serviceContext.getContext(), permItemNames[i]);
                        BOSObjectType objectTYpe = BOSObjectType.create((String)permItemInfo.getObjectType());
                        IObjectPK objectPK = this.getObjectPK(serviceContext, objectTYpe);
                        String objectPKString = StringUtils.cnulls((Object)objectPK);
                        logger.debug((Object)("isIgnoreAndAssigned:objectPKString:" + objectPKString));
                        if (StringUtils.isEmpty((String)objectPKString) && (params = serviceContext.getOperationParameters()).length == 2) {
                            String idString = null;
                            if (params[1] != null) {
                                idString = params[1].toString();
                            }
                            if (idString != null && idString.indexOf("'") > 0 && idString.indexOf("'") < idString.lastIndexOf("'")) {
                                objectPKString = idString.substring(idString.indexOf("'") + 1, idString.lastIndexOf("'"));
                            }
                            if (!BOSUuid.isValid((String)objectPKString, (boolean)true)) {
                                objectPKString = "";
                            }
                        }
                        if (!StringUtils.isEmpty((String)objectPKString)) {
                            try {
                                Class<?> class1 = Class.forName("com.kingdee.bos.workflow.biz.PermissionIgnoreWorkFlow");
                                Object obj = class1.newInstance();
                                Method method = class1.getMethod("isIgnorePermission", Context.class, OperationType.class, String.class, String.class);
                                boolean isIgnore = (Boolean)method.invoke(obj, new Object[]{serviceContext.getContext(), permItemInfo.getOperationType(), serviceContext.getContext().getCaller().toString(), objectPKString});
                                if (isIgnore) {
                                    return;
                                }
                                throw e;
                            }
                            catch (Exception e1) {
                                if (!(e1 instanceof PermissionException)) {
                                    logger.error((Object)"\u3010inovke WorkFlow failed\u3011", (Throwable)e1);
                                }
                                throw e;
                            }
                        }
                        throw e;
                    }
                    catch (Exception e1) {
                        throw e;
                    }
                }
                throw e;
            }
        }
    }

    private boolean isFacadeObject(IServiceContext serviceContext) {
        return serviceContext.getMetaType() != null ? serviceContext.getMetaType() == MetaDataTypeList.FACADE : false;
    }

    private boolean isEntityObject(IServiceContext serviceContext) {
        return serviceContext.getMetaType() != null ? serviceContext.getMetaType() == MetaDataTypeList.ENTITY : false;
    }

    private boolean isQueryObject(IServiceContext serviceContext) {
        return serviceContext.getMetaType() != null ? serviceContext.getMetaType() == MetaDataTypeList.BASEQUERY : false;
    }

    private void bindPermissionContext(IServiceContext serviceContext, String rule) throws EASBizException, BOSException {
        PermissionServiceAdapterHelper.bindPermissionContext(serviceContext, rule);
    }

    private String[] getPermItemNames(IServiceContext serviceContext) {
        return (String[])serviceContext.getServiceParameter("PERMISSION_SERVICE", PERMISSION_ITEMS);
    }

    private IObjectPK getMainBizOrgPK(IServiceContext serviceContext, PermItemInfo permItemInfo) throws EASBizException, BOSException {
        return PermissionServiceAdapterHelper.getMainBizOrgPK(serviceContext, permItemInfo);
    }

    private void handleWithoutEnableDataPermision(IServiceContext serviceContext, String permItemName) throws EASBizException, BOSException {
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(serviceContext.getContext()).getPermItem(serviceContext.getContext(), permItemName);
        if (this.isFacadeObject(serviceContext) || this.isEntityObject(serviceContext)) {
            this.handleMethodFunctionPermission(serviceContext, permItemInfo);
        } else if (this.isQueryObject(serviceContext)) {
            this.handleQueryFunctionPermission(serviceContext, permItemInfo);
        }
    }

    private void handleMethodFunctionPermission(IServiceContext serviceContext, PermItemInfo permItemInfo) throws EASBizException, BOSException {
        Context context = serviceContext.getContext();
        IObjectPK userPK = context.getCaller();
        IObjectPK orgPK = this.getMainBizOrgPK(serviceContext, permItemInfo);
        IPermission iPermission = PermissionFactory.getLocalInstance(serviceContext.getContext());
        iPermission.checkFunctionPermission(userPK, orgPK, permItemInfo.getName());
    }

    private boolean hasFunctionPermission(IServiceContext serviceContext, PermItemInfo permItemInfo) throws EASBizException, BOSException {
        Context context = serviceContext.getContext();
        IObjectPK userPK = context.getCaller();
        IObjectPK orgPK = this.getMainBizOrgPK(serviceContext, permItemInfo);
        IPermission iPermission = PermissionFactory.getLocalInstance(serviceContext.getContext());
        return iPermission.hasFunctionPermission(userPK, orgPK, permItemInfo.getName());
    }

    private void handleQueryFunctionPermission(IServiceContext serviceContext, PermItemInfo permItemInfo) throws EASBizException, BOSException {
        if (!this.hasFunctionPermission(serviceContext, permItemInfo)) {
            this.bindPermissionContext(serviceContext, this.getNoRightRuleInfo(permItemInfo.getName()));
        }
    }

    private void handleMethodDataPermission(IServiceContext serviceContext, PermItemInfo permItemInfo) throws EASBizException, BOSException {
        Context context = serviceContext.getContext();
        IObjectPK userPK = context.getCaller();
        IObjectPK orgPK = this.getMainBizOrgPK(serviceContext, permItemInfo);
        IPermission iPermission = PermissionFactory.getLocalInstance(serviceContext.getContext());
        if (StringUtils.isEmpty((String)permItemInfo.getObjectType()) || !permItemInfo.isEnableDataPermission()) {
            iPermission.checkFunctionPermission(userPK, orgPK, permItemInfo.getName());
        } else {
            BOSObjectType objectType = BOSObjectType.create((String)permItemInfo.getObjectType());
            OperationType oprtType = permItemInfo.getOperationType();
            if (oprtType.equals((Object)OperationType.ADDNEW) || oprtType.equals((Object)OperationType.UPDATE)) {
                IObjectValue objectValue = this.getObjectValue(serviceContext, objectType);
                if (objectValue != null) {
                    iPermission.checkDataPermission(userPK, orgPK, permItemInfo.getName(), objectValue);
                } else {
                    iPermission.checkFunctionPermission(userPK, orgPK, permItemInfo.getName());
                }
            } else if (oprtType.equals((Object)OperationType.READ)) {
                boolean IsEntityView = PermissionServiceAdapterHelper.paramsIsEntityView(serviceContext, objectType);
                if (!IsEntityView) {
                    IObjectPK objectPK = this.getObjectPK(serviceContext, objectType);
                    if (objectPK != null) {
                        iPermission.checkDataPermission(userPK, orgPK, permItemInfo.getName(), objectPK);
                    } else {
                        iPermission.checkFunctionPermission(userPK, orgPK, permItemInfo.getName());
                    }
                }
                this.setMethodService(permItemInfo, serviceContext, userPK, orgPK);
            } else if (oprtType.equals((Object)OperationType.DELETE) || oprtType.equals((Object)OperationType.EXECUTE) || oprtType.equals((Object)OperationType.OTHER)) {
                IObjectPK objectPK = this.getObjectPK(serviceContext, objectType);
                if (objectPK != null) {
                    iPermission.checkDataPermission(userPK, orgPK, permItemInfo.getName(), objectPK);
                } else {
                    iPermission.checkFunctionPermission(userPK, orgPK, permItemInfo.getName());
                }
            }
        }
    }

    private void setMethodService(PermItemInfo permItemInfo, IServiceContext serviceContext, IObjectPK userPK, IObjectPK orgPK) throws BOSException, EASBizException {
        IPermissionServiceProvider provider;
        String rule;
        if (!StringUtils.isEmpty((String)permItemInfo.getObjectType()) && permItemInfo.isEnableDataPermission() && !StringUtils.isEmpty((String)(rule = (provider = PermissionServiceProviderFactory.getLocalInstance(serviceContext.getContext())).getPermissionRule(userPK, orgPK, permItemInfo.getName())))) {
            try {
                EntityViewInfo resultEvi = new EntityViewInfo(rule);
                serviceContext.setServiceResult("PERMISSION_SERVICE", (Object)resultEvi.getFilter());
                logger.debug((Object)("resultEntityViewInfo is:" + resultEvi));
                serviceContext.getContext().put((Object)this.getMethodPK(serviceContext), (Object)resultEvi);
            }
            catch (ParserException e) {
                logger.error((Object)(" rule: " + rule), (Throwable)e);
                throw new PermissionException(PermissionException.CHECK_PERMISSION_FAIL, e);
            }
        }
    }

    private String getMethodPK(IServiceContext serviceContext) {
        String methodNamePK = serviceContext.getOperationPK().getName();
        IMetaDataLoader iMetaDataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)serviceContext.getContext());
        BusinessObjectInfo entity = iMetaDataLoader.getBusinessObject(serviceContext.getBoType());
        MethodCollection methodCol = entity.getAllMethodsRuntime();
        String methodName = "";
        int size = methodCol.size();
        for (int i = 0; i < size; ++i) {
            MethodInfo methodInfo = methodCol.get(i);
            logger.debug((Object)("innerId is:" + methodInfo.getInnerID()));
            if (!methodInfo.getInnerID().equals(methodNamePK)) continue;
            methodName = methodInfo.getName();
            break;
        }
        Object[] obj = serviceContext.getOperationParameters();
        String pk = ImplUtils.buildPermissionServiceKey((BOSObjectType)serviceContext.getBoType(), (String)methodName, (Object[])obj);
        logger.debug((Object)(" methodPK is:" + pk));
        return pk;
    }

    private void handleQueryDataPermission(IServiceContext serviceContext, PermItemInfo permItemInfo) throws EASBizException, BOSException {
        if (!this.hasFunctionPermission(serviceContext, permItemInfo)) {
            this.bindPermissionContext(serviceContext, this.getNoRightRuleInfo(permItemInfo.getName()));
        } else if (!StringUtils.isEmpty((String)permItemInfo.getObjectType()) && permItemInfo.isEnableDataPermission()) {
            String permName;
            Context context = serviceContext.getContext();
            IObjectPK userPK = context.getCaller();
            IObjectPK orgPK = this.getMainBizOrgPK(serviceContext, permItemInfo);
            IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance(serviceContext.getContext());
            String rule = provider.getPermissionRule(userPK, orgPK, permName = permItemInfo.getName());
            if (!StringUtils.isEmpty((String)rule)) {
                this.bindPermissionContext(serviceContext, rule);
            }
        }
    }

    private String getNoRightRuleInfo(String strKey) {
        return PermissionFilterConfiguration.getList().getFilterString(strKey);
    }

    private void handleWithEnableDataPermision(IServiceContext serviceContext, String permItemName) throws EASBizException, BOSException {
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(serviceContext.getContext()).getPermItem(serviceContext.getContext(), permItemName);
        if (this.isFacadeObject(serviceContext) || this.isEntityObject(serviceContext)) {
            this.handleMethodDataPermission(serviceContext, permItemInfo);
        } else if (this.isQueryObject(serviceContext)) {
            MutiOrgPermissionServiceAdapter adapter = new MutiOrgPermissionServiceAdapter();
            if (adapter.isMutiOrgPerm(serviceContext)) {
                adapter.handleQueryDataPermission(serviceContext, permItemInfo);
            } else {
                this.handleQueryDataPermission(serviceContext, permItemInfo);
            }
        }
    }

    private IObjectPK getObjectPK(IServiceContext serviceContext, BOSObjectType objectType) {
        return PermissionServiceAdapterHelper.getObjectPK(serviceContext, objectType);
    }

    private IObjectValue getObjectValue(IServiceContext serviceContext, BOSObjectType objectType) {
        return PermissionServiceAdapterHelper.getObjectValue(serviceContext, objectType);
    }
}

