/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.adapter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.OperationType;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.util.Set;
import org.apache.log4j.Logger;

public class PermissionServiceAdapterHelper {
    private static Logger logger = Logger.getLogger((String)PermissionServiceAdapterHelper.class.getName());

    public static void bindPermissionContext(IServiceContext serviceContext, String rule) throws EASBizException, BOSException {
        try {
            EntityViewInfo resultEntityViewInfo = new EntityViewInfo(rule);
            serviceContext.setServiceResult("PERMISSION_SERVICE", (Object)resultEntityViewInfo);
        }
        catch (ParserException e) {
            logger.error((Object)("rule: " + rule), (Throwable)e);
            throw new PermissionException(PermissionException.CHECK_PERMISSION_FAIL, e);
        }
    }

    public static void bindPermissionContext(IServiceContext serviceContext, FilterInfo filterInfo) throws EASBizException, BOSException {
        EntityViewInfo resultEntityViewInfo = new EntityViewInfo();
        resultEntityViewInfo.setFilter(filterInfo);
        serviceContext.setServiceResult("PERMISSION_SERVICE", (Object)resultEntityViewInfo);
    }

    public static void bindPermissionContext(IServiceContext serviceContext, EntityViewInfo resultEntityViewInfo) throws EASBizException, BOSException {
        if (resultEntityViewInfo != null) {
            serviceContext.setServiceResult("PERMISSION_SERVICE", (Object)resultEntityViewInfo);
        }
    }

    public static IObjectPK getObjectPK(IServiceContext serviceContext, BOSObjectType objectType) {
        Object[] params = serviceContext.getOperationParameters();
        if (params != null) {
            int n = params.length;
            for (int i = 0; i < n; ++i) {
                String[] strPK;
                BOSUuid objectID;
                ObjectUuidPK objectPK;
                if (params[i] == null) continue;
                if (params[i] instanceof ObjectUuidPK) {
                    objectPK = (ObjectUuidPK)params[i];
                    if (objectType.equals((Object)objectPK.getObjectType())) {
                        return objectPK;
                    }
                } else if (params[i] instanceof BOSUuid) {
                    BOSUuid objectID2 = (BOSUuid)params[i];
                    if (objectType.equals((Object)objectID2.getType())) {
                        return new ObjectUuidPK(objectID2);
                    }
                } else if (params[i] instanceof CoreBaseInfo) {
                    CoreBaseInfo model = (CoreBaseInfo)params[i];
                    objectID = model.getId();
                    return objectID == null ? null : new ObjectUuidPK(objectID);
                }
                if (IObjectPK.class.isAssignableFrom(params[i].getClass())) {
                    objectPK = (IObjectPK)params[i];
                    objectID = null;
                    try {
                        objectID = BOSUuid.read((String)objectPK.toString());
                    }
                    catch (Exception e) {
                        logger.error((Object)" type is not right !", (Throwable)e);
                    }
                    if (objectID == null || !objectType.equals((Object)objectID.getType())) continue;
                    return new ObjectUuidPK(objectPK.toString());
                }
                if (IObjectPK[].class.isAssignableFrom(params[i].getClass())) {
                    IObjectPK[] objectUuidPKAry = (IObjectPK[])params[i];
                    if (objectUuidPKAry != null && objectUuidPKAry.length > 1) {
                        return null;
                    }
                    IObjectPK objectPK2 = objectUuidPKAry[0];
                    if (!(objectPK2 instanceof ObjectUuidPK) || !objectType.equals((Object)((ObjectUuidPK)objectPK2).getObjectType())) continue;
                    return objectPK2;
                }
                if (BOSUuid[].class.isAssignableFrom(params[i].getClass())) {
                    BOSUuid[] bOSUuidAry = (BOSUuid[])params[i];
                    if (bOSUuidAry.length > 1 && bOSUuidAry[1] != null || bOSUuidAry[0] == null) {
                        return null;
                    }
                    objectID = bOSUuidAry[0];
                    if (!objectType.equals((Object)objectID.getType())) continue;
                    return new ObjectUuidPK(objectID);
                }
                if (params[i] instanceof Set) {
                    Set strSet = (Set)params[i];
                    if (strSet.isEmpty() || strSet.size() != 1) {
                        return null;
                    }
                    return PermissionServiceAdapterHelper.getPKFromStringAry(objectType, strSet.iterator().next().toString());
                }
                if (params[i] instanceof String) {
                    strPK = (String[])params[i];
                    ObjectUuidPK pk = PermissionServiceAdapterHelper.getPKFromStringAry(objectType, (String)strPK);
                    if (pk == null) {
                        try {
                            EntityViewInfo viewInfo = new EntityViewInfo((String)strPK);
                            return PermissionServiceAdapterHelper.getPKFromCondition(objectType, params, viewInfo);
                        }
                        catch (Exception e) {
                            return null;
                        }
                    }
                    return pk;
                }
                if (params[i] instanceof EntityViewInfo) {
                    return PermissionServiceAdapterHelper.getPKFromCondition(objectType, params, params[i]);
                }
                if (!params[i].getClass().isAssignableFrom(String[].class)) continue;
                strPK = (String[])params[i];
                if (strPK.length > 1 && strPK[1] != null || strPK[0] == null) {
                    return null;
                }
                return PermissionServiceAdapterHelper.getPKFromStringAry(objectType, strPK[0]);
            }
        }
        return null;
    }

    public static boolean paramsIsEntityView(IServiceContext serviceContext, BOSObjectType objectType) {
        Object[] params = serviceContext.getOperationParameters();
        if (params != null && params.length > 0) {
            int n = params.length;
            for (int i = 0; i < n; ++i) {
                if (!(params[i] instanceof EntityViewInfo)) continue;
                return true;
            }
        }
        return false;
    }

    private static ObjectUuidPK getPKFromStringAry(BOSObjectType objectType, String strPK) {
        block4: {
            if (!StringUtils.isEmpty((String)strPK)) {
                try {
                    BOSUuid objectID = BOSUuid.read((String)strPK);
                    if (objectType.equals((Object)objectID.getType())) {
                        return new ObjectUuidPK(objectID);
                    }
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)e);
                }
            }
        }
        return null;
    }

    public static IObjectPK getMainBizOrgPK(IServiceContext serviceContext, PermItemInfo permItemInfo) throws EASBizException, BOSException {
        Object bizData = null;
        OperationType oprtType = permItemInfo.getOperationType();
        if (!StringUtils.isEmpty((String)permItemInfo.getObjectType())) {
            bizData = OperationType.ADDNEW.equals((Object)oprtType) || OperationType.UPDATE.equals((Object)oprtType) ? PermissionServiceAdapterHelper.getObjectValue(serviceContext, BOSObjectType.create((String)permItemInfo.getObjectType())) : PermissionServiceAdapterHelper.getObjectPK(serviceContext, BOSObjectType.create((String)permItemInfo.getObjectType()));
        }
        return PermissionUtil.getPermissionOrgPK(serviceContext.getContext(), permItemInfo.getOrgRelation(), null, bizData);
    }

    public static IObjectValue getObjectValue(IServiceContext serviceContext, BOSObjectType objectType) {
        Object[] params = serviceContext.getOperationParameters();
        if (params != null) {
            int length = params.length;
            for (int i = 0; i < length; ++i) {
                IObjectValue objectValue;
                if (!(params[i] instanceof IObjectValue) || !(objectValue = (IObjectValue)params[i]).getBOSType().equals((Object)objectType)) continue;
                return objectValue;
            }
        }
        return null;
    }

    private static ObjectUuidPK getPKFromCondition(BOSObjectType objectType, Object[] allParams, Object param) {
        ObjectUuidPK objectPK = null;
        Context ctx = null;
        int n = allParams.length;
        for (int k = 0; k < n; ++k) {
            if (!(allParams[k] instanceof Context)) continue;
            ctx = (Context)allParams[k];
            break;
        }
        if (ctx != null) {
            CoreBaseCollection coll = null;
            try {
                EntityViewInfo ev = null;
                if (param instanceof EntityViewInfo) {
                    ev = new EntityViewInfo();
                    ev.setFilter(((EntityViewInfo)param).getFilter());
                } else if (param instanceof String) {
                    try {
                        ev = new EntityViewInfo((String)param);
                    }
                    catch (ParserException e) {
                        logger.error((Object)("get objectID,parse oql error: " + param));
                        e.printStackTrace();
                    }
                }
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                ev.setSelector(selector);
                ev.setTopCount(1);
                ev.setBaseOnSelector(true);
                coll = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(objectType).getCollection(ev);
                if (coll != null && coll.size() > 0) {
                    CoreBaseInfo info = coll.get(0);
                    objectPK = new ObjectUuidPK(info.getId());
                }
            }
            catch (BOSException e) {
                logger.error((Object)"get objectID error ");
                e.printStackTrace();
            }
        }
        return objectPK;
    }
}

