/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.adapter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.workflow.security.IPermissionProvider;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.basedata.org.INewOrgUnitFacade;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class WfPermissionProvider
implements IPermissionProvider {
    private static Logger logger = Logger.getLogger(WfPermissionProvider.class);

    public boolean checkPermission(Context ctx, String userId, int orgType, String orgId, PermissionItemInfo permissionItem) throws BOSException {
        assert (userId != null);
        if (permissionItem == null) {
            return true;
        }
        ObjectUuidPK userPK = new ObjectUuidPK(userId);
        ObjectUuidPK orgPK = orgId == null ? null : new ObjectUuidPK(orgId);
        try {
            String permItemName = permissionItem.getName();
            IPermission iPermission = PermissionFactory.getLocalInstance(ctx);
            return iPermission.hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, permItemName);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public boolean checkPermission(Context ctx, String userId, int orgType, String orgId, PermissionItemCollection permissionItems) throws BOSException {
        assert (userId != null);
        if (permissionItems == null || permissionItems.size() == 0) {
            return true;
        }
        ObjectUuidPK userPK = new ObjectUuidPK(userId);
        ObjectUuidPK orgPK = orgId == null ? null : new ObjectUuidPK(orgId);
        try {
            IPermission iPermission = PermissionFactory.getLocalInstance(ctx);
            int size = permissionItems.size();
            for (int i = 0; i < size; ++i) {
                String permItemName = permissionItems.get(i).getName();
                boolean flag = iPermission.hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, permItemName);
                if (flag) continue;
                return false;
            }
            return true;
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public String[] getPermissionOwners(Context ctx, int orgType, String orgId, PermissionItemInfo permissionItem) throws BOSException {
        if (permissionItem == null) {
            return new String[0];
        }
        ObjectUuidPK orgPK = null;
        Collection userIDs = new HashSet();
        try {
            if (orgId != null) {
                PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(ctx).getPermItem(ctx, permissionItem.getName());
                INewOrgUnitFacade iOrg = NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx);
                OrgUnitInfo orgUnitInfo = iOrg.getDelegateUnit(orgId, permItemInfo.getOrgRelation());
                if (orgUnitInfo == null || orgUnitInfo.getId() == null) {
                    if (!permItemInfo.getOrgRelation().equals((Object)OrgType.NONE)) {
                        return new String[0];
                    }
                    orgPK = new ObjectUuidPK(orgId);
                } else {
                    orgPK = new ObjectUuidPK(orgId);
                }
            }
            IPermission iPermission = PermissionFactory.getLocalInstance(ctx);
            userIDs = iPermission.getAuthorizedUsers((IObjectPK)orgPK, permissionItem.getName());
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return userIDs.toArray(new String[userIDs.size()]);
    }

    public String[] getPermissionOwners(Context ctx, int orgType, String orgId, PermissionItemCollection permissionItems) throws BOSException {
        if (permissionItems == null || permissionItems.size() == 0) {
            return new String[0];
        }
        HashSet result = new HashSet();
        ObjectUuidPK orgPK = null;
        try {
            INewOrgUnitFacade iOrg = NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx);
            IPermission iPermission = PermissionFactory.getLocalInstance(ctx);
            int size = permissionItems.size();
            for (int i = 0; i < size; ++i) {
                if (orgId != null) {
                    PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(ctx).getPermItem(ctx, permissionItems.get(i).getName());
                    OrgUnitInfo orgUnitInfo = iOrg.getDelegateUnit(orgId, permItemInfo.getOrgRelation());
                    orgPK = orgUnitInfo == null || orgUnitInfo.getId() == null ? new ObjectUuidPK(orgId) : new ObjectUuidPK(orgUnitInfo.getId());
                }
                Collection userIDs = iPermission.getAuthorizedUsers((IObjectPK)orgPK, permissionItems.get(i).getName());
                result.addAll(userIDs);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getUserIdByName(Context ctx, String number) throws BOSException {
        assert (StringUtils.isEmpty((String)number));
        IUser iUser = UserFactory.getLocalInstance(ctx);
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT id WHERE number = '").append(number).append("'");
        String oql = buffer.toString();
        try {
            if (iUser.exists(oql)) {
                return iUser.getUserInfo(oql).getId().toString();
            }
            return null;
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public PermissionItemCollection getPermissionItemCol(Context ctx) throws BOSException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        PermissionInfo permissionInfo = loader.getPermission();
        PermissionItemCollection itemCol = permissionInfo.getPermissionItems();
        return itemCol;
    }

    public Set checkPermission(Context ctx, String userId, int orgType, String[] orgIds, String permItemName) throws BOSException {
        ObjectStringPK userPK = new ObjectStringPK(userId);
        IObjectPK[] orgPKs = new IObjectPK[orgIds.length];
        for (int i = 0; i < orgIds.length; ++i) {
            orgPKs[i] = new ObjectStringPK(orgIds[i]);
        }
        IPermission permission = PermissionFactory.getLocalInstance(ctx);
        try {
            return permission.checkBatchPermission((IObjectPK)userPK, orgPKs, permItemName);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

