/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.cache;

import com.kingdee.bos.Context;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.eas.base.permission.app.cache.IOrgCache;
import com.kingdee.eas.base.permission.app.cache.IPermItemCache;
import com.kingdee.eas.base.permission.app.cache.OrgCache;
import com.kingdee.eas.base.permission.app.cache.PermItemCache;

public class PermissionCacheFactory {
    private static final String CONFIG_ITEM_MESSAGE = "permCache";
    private static IPermItemCache iPermItemCache = null;
    private static IOrgCache iOrgCache = null;

    private PermissionCacheFactory() {
    }

    public static IPermItemCache getPermItemCache(Context ctx) {
        if (iPermItemCache == null) {
            ORMServiceLocation loc = new ORMServiceLocation(CONFIG_ITEM_MESSAGE);
            iPermItemCache = loc.isLocal() ? new PermItemCache() : PermissionCacheFactory.getInstance(loc.getServiceURL());
        }
        return iPermItemCache;
    }

    public static IOrgCache getOrgCache(Context ctx) {
        if (iOrgCache == null) {
            ORMServiceLocation loc = new ORMServiceLocation(CONFIG_ITEM_MESSAGE);
            iOrgCache = loc.isLocal() ? new OrgCache() : PermissionCacheFactory.getInstance4Org(loc.getServiceURL());
        }
        return iOrgCache;
    }

    private static IOrgCache getInstance4Org(String url) {
        IORMModel sender = RPCEngineFactory.getEngine((String)url).createObject(OrgCache.class.getName(), IOrgCache.class);
        return (IOrgCache)sender;
    }

    private static IPermItemCache getInstance(String url) {
        IORMModel sender = RPCEngineFactory.getEngine((String)url).createObject(PermItemCache.class.getName(), IPermItemCache.class);
        return (IPermItemCache)sender;
    }
}

