/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.clear;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.permission.IPermClearStrategy;
import com.kingdee.eas.base.permission.IPermClearTask;
import com.kingdee.eas.base.permission.PermClearException;
import com.kingdee.eas.base.permission.PermClearStrategyFactory;
import com.kingdee.eas.base.permission.PermClearStrategyInfo;
import com.kingdee.eas.base.permission.PermClearTaskCollection;
import com.kingdee.eas.base.permission.PermClearTaskFactory;
import com.kingdee.eas.base.permission.PermClearTaskInfo;
import com.kingdee.eas.base.permission.PermClearTaskStatusEnum;
import com.kingdee.eas.base.permission.PermClearTaskType;
import com.kingdee.eas.base.permission.app.clear.PermClearScanManager;
import com.kingdee.eas.base.permission.app.clear.common.PermClearUtils;
import com.kingdee.eas.base.permission.app.clear.scan.IPermClearStrategyScan;
import com.kingdee.eas.base.permission.app.clear.scan.PermClearScan;
import com.kingdee.eas.base.permission.app.clear.scan.PermClearStrategyScanBean;
import com.kingdee.eas.base.permission.app.clear.scan.idleuser.IdleUserScan;
import com.kingdee.eas.base.permission.app.clear.scan.invaliddata.InvalidDataScan;
import com.kingdee.eas.base.permission.app.clear.scan.permrank.PermRankScan;
import com.kingdee.eas.base.permission.app.clear.scan.permrank.PermRankScanUnit;
import com.kingdee.eas.base.permission.app.clear.scan.permrepeat.PermRepeatScan;
import com.kingdee.eas.base.permission.app.clear.scan.permrepeat.PermRepeatScanUnit;
import com.kingdee.eas.base.permission.app.clear.task.PermClearSchedulerManager;
import com.kingdee.eas.base.permission.app.clear.task.PermClearTaskDisplayBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PermClearTaskManager {
    private static final String TaskContent = "TaskContent";
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    public static void createUserUnitTask(Context ctx, String strategyId, String taskContent, List<String> userIds) throws BOSException, EASBizException {
        if (userIds == null || userIds.isEmpty()) {
            return;
        }
        if (!PermClearTaskManager.isNeedSubmitTask(ctx, strategyId, userIds)) {
            throw new PermClearException(PermClearException.NO_DATA_CLEAR_ERROR);
        }
        IPermClearStrategy iPermClearStrategy = PermClearStrategyFactory.getLocalInstance(ctx);
        PermClearStrategyInfo permClearStrategyInfo = iPermClearStrategy.getPermClearStrategyInfo((IObjectPK)new ObjectStringPK(strategyId));
        if (permClearStrategyInfo == null) {
            return;
        }
        PermClearTaskInfo permClearTaskInfo = new PermClearTaskInfo();
        permClearTaskInfo.setTaskNumber(String.valueOf(System.currentTimeMillis()));
        permClearTaskInfo.setStrategy(permClearStrategyInfo);
        permClearTaskInfo.setTaskStatus(PermClearTaskStatusEnum.unsubmitted);
        permClearTaskInfo.setTaskType(PermClearTaskType.InnerTask);
        ArrayList users = new ArrayList();
        for (String userId : userIds) {
            HashMap<String, String> user = new HashMap<String, String>();
            user.put("ClearPermUserId", userId);
            users.add(user);
        }
        HashMap<String, Object> preConditionClearResult = new HashMap<String, Object>();
        preConditionClearResult.put("ClearPermUsers", users);
        preConditionClearResult.put(TaskContent, taskContent);
        permClearTaskInfo.setPreConditionClearResult(new Gson().toJson(preConditionClearResult));
        PermClearTaskFactory.getLocalInstance(ctx).addnew(permClearTaskInfo);
    }

    public static void createPermRankUserTask(Context ctx, String strategyId, String taskContent, List<String> userIds) throws BOSException, EASBizException {
        PermClearTaskManager.createUserUnitTask(ctx, strategyId, taskContent, userIds);
    }

    public static void createPermRepeatTask(Context ctx, String strategyId, String taskContent, List<String> userIds) throws BOSException, EASBizException {
        PermClearTaskManager.createUserUnitTask(ctx, strategyId, taskContent, userIds);
    }

    public static void createIdleUser(Context ctx, String strategyId, String taskContent, List<String> userIds) throws BOSException, EASBizException {
        PermClearTaskManager.createUserUnitTask(ctx, strategyId, taskContent, userIds);
    }

    public static void createInvalidDataTask(Context ctx, String taskContent, String strategyId) throws BOSException, EASBizException {
        IPermClearStrategy iPermClearStrategy = PermClearStrategyFactory.getLocalInstance(ctx);
        PermClearStrategyInfo permClearStrategyInfo = iPermClearStrategy.getPermClearStrategyInfo((IObjectPK)new ObjectStringPK(strategyId));
        if (permClearStrategyInfo == null) {
            return;
        }
        PermClearTaskInfo permClearTaskInfo = new PermClearTaskInfo();
        permClearTaskInfo.setTaskNumber(String.valueOf(System.currentTimeMillis()));
        permClearTaskInfo.setStrategy(permClearStrategyInfo);
        permClearTaskInfo.setTaskStatus(PermClearTaskStatusEnum.unsubmitted);
        permClearTaskInfo.setTaskType(PermClearTaskType.InnerTask);
        HashMap<String, String> preConditionClearResult = new HashMap<String, String>();
        preConditionClearResult.put(TaskContent, taskContent);
        permClearTaskInfo.setPreConditionClearResult(new Gson().toJson(preConditionClearResult));
        PermClearTaskFactory.getLocalInstance(ctx).addnew(permClearTaskInfo);
    }

    public static void submitTask(Context ctx, String taskId, String planExecTime) throws EASBizException, BOSException {
        IPermClearTask iPermClearTask = PermClearTaskFactory.getLocalInstance(ctx);
        PermClearTaskInfo permClearTaskInfo = iPermClearTask.getPermClearTaskInfo((IObjectPK)new ObjectStringPK(taskId));
        if (permClearTaskInfo.getTaskStatus() != PermClearTaskStatusEnum.unsubmitted) {
            throw new BOSException(ResourceBase.getString((String)RESOURCE, (String)"CURRENT_STATUS_CANT_SUBMIT", (Locale)ctx.getLocale()));
        }
        Timestamp timestamp = null;
        try {
            timestamp = PermClearUtils.getTimestamp(planExecTime);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        DbUtil.execute((Context)ctx, (String)"update T_PM_PermClearTask set ftaskStatus=?,fplanExecTime=? where fid = ?", (Object[])new Object[]{PermClearTaskStatusEnum.submitted.getValue(), timestamp, taskId});
        permClearTaskInfo = iPermClearTask.getPermClearTaskInfo("select * ,strategy.* where id = '" + taskId + "'");
        PermClearSchedulerManager.tryLoadJob(ctx, permClearTaskInfo);
    }

    public static String deleteTask(Context ctx, String[] taskIds) throws EASBizException, BOSException {
        IPermClearTask iPermClearTask = PermClearTaskFactory.getLocalInstance(ctx);
        StringBuilder msgBuilder = new StringBuilder();
        for (int i = 0; i < taskIds.length; ++i) {
            PermClearTaskInfo permClearTaskInfo = iPermClearTask.getPermClearTaskInfo((IObjectPK)new ObjectStringPK(taskIds[i]));
            if (permClearTaskInfo.getTaskStatus() == PermClearTaskStatusEnum.execing) {
                msgBuilder.append(permClearTaskInfo.getTaskNumber() + ",");
                continue;
            }
            iPermClearTask.delete((IObjectPK)new ObjectStringPK(taskIds[i]));
        }
        if (msgBuilder.length() != 0) {
            return msgBuilder.deleteCharAt(msgBuilder.length()).toString() + ResourceBase.getString((String)RESOURCE, (String)"EXECUTE_STATUS_CANT_DELETE", (Locale)ctx.getLocale());
        }
        return "";
    }

    public static List<PermClearTaskDisplayBean> queryTasks(Context ctx, int page, int limit, String strategyId, String taskStatus, String queryStr) throws BOSException, EASBizException {
        PermClearTaskCollection permClearTaskCollection = PermClearTaskManager.queryPermClearTaskCollection(ctx, (page - 1) * limit, limit, strategyId, taskStatus, queryStr);
        ArrayList<PermClearTaskDisplayBean> datas = new ArrayList<PermClearTaskDisplayBean>();
        for (int i = 0; i < permClearTaskCollection.size(); ++i) {
            PermClearTaskInfo permClearTaskInfo = permClearTaskCollection.get(i);
            PermClearTaskDisplayBean permClearTaskDisplayBean = new PermClearTaskDisplayBean();
            permClearTaskDisplayBean.setTaskId(permClearTaskInfo.getId().toString());
            permClearTaskDisplayBean.setTaskNumber(permClearTaskInfo.getTaskNumber());
            permClearTaskDisplayBean.setStrategyName(permClearTaskInfo.getStrategy().getName());
            String preConditionClearResult = permClearTaskInfo.getPreConditionClearResult();
            Map map = (Map)new Gson().fromJson(preConditionClearResult, Map.class);
            if (map != null) {
                permClearTaskDisplayBean.setTaskContent((String)map.get(TaskContent));
            }
            permClearTaskDisplayBean.setTaskStatus(permClearTaskInfo.getTaskStatus().getAlias());
            if (permClearTaskInfo.getPlanExecTime() != null) {
                permClearTaskDisplayBean.setPlanDate(permClearTaskInfo.getPlanExecTime().toString());
            }
            permClearTaskDisplayBean.setExternalTaskTitle("/");
            permClearTaskDisplayBean.setCreateTime(permClearTaskInfo.getCreateTime().toString());
            datas.add(permClearTaskDisplayBean);
        }
        return datas;
    }

    private static PermClearTaskCollection queryPermClearTaskCollection(Context ctx, int offset, int limit, String strategyNumber, String taskStatus, String queryStr) throws BOSException {
        EntityViewInfo evInfo = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        FilterInfo filterInfo = new FilterInfo();
        evInfo.setTopCount(limit);
        evInfo.setOffset(offset);
        evInfo.setSelector(selector);
        evInfo.setFilter(filterInfo);
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("strategy.*"));
        if (!StringUtils.isEmpty((String)strategyNumber)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("strategy.number", (Object)strategyNumber, CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((String)taskStatus)) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(taskStatus);
            filterInfo.getFilterItems().add(new FilterItemInfo("taskStatus", hashSet, CompareType.INCLUDE));
        }
        if (!StringUtils.isEmpty((String)queryStr)) {
            FilterInfo queryFilter = new FilterInfo();
            queryFilter.getFilterItems().add(new FilterItemInfo("taskNumber", (Object)("%" + queryStr + "%"), CompareType.LIKE));
            queryFilter.getFilterItems().add(new FilterItemInfo("preConditionClearResult", (Object)("%" + queryStr + "%"), CompareType.LIKE));
            queryFilter.setMaskString("(#0 or #1)");
            filterInfo.mergeFilter(queryFilter, "and");
        }
        try {
            SorterItemCollection sort = new SorterItemCollection("order by createTime desc");
            evInfo.setSorter(sort);
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        return PermClearTaskFactory.getLocalInstance(ctx).getPermClearTaskCollection(evInfo);
    }

    public static boolean isNeedSubmitTask(Context ctx, String strategyId, List<String> userIds) throws EASBizException, BOSException {
        PermClearScan queryMostScanInfo = PermClearScanManager.queryMostScanInfo(ctx);
        List<PermClearStrategyScanBean> strategyScanList = queryMostScanInfo.getStrategyScanList();
        for (int i = 0; i < strategyScanList.size(); ++i) {
            PermClearStrategyScanBean permClearStrategyScanBean = strategyScanList.get(i);
            if (!strategyId.equals(permClearStrategyScanBean.getStrategyId())) continue;
            IPermClearStrategyScan permClearStrategyScan = permClearStrategyScanBean.getPermClearStrategyScan();
            if (permClearStrategyScan instanceof PermRankScan) {
                PermRankScan permRankScan = (PermRankScan)permClearStrategyScan;
                return PermClearTaskManager.permRankScanIsSubmitTask(userIds, permRankScan);
            }
            if (permClearStrategyScan instanceof PermRepeatScan) {
                PermRepeatScan permRankScan = (PermRepeatScan)permClearStrategyScan;
                return PermClearTaskManager.permRepeatScanIsSubmitTask(userIds, permRankScan);
            }
            if (permClearStrategyScan instanceof IdleUserScan && userIds.size() > 0) {
                return true;
            }
            if (!(permClearStrategyScan instanceof InvalidDataScan)) continue;
            IdleUserScan idleUserScan = (IdleUserScan)permClearStrategyScan;
            return idleUserScan.getScanOrgCounts() > 0 || idleUserScan.getScanPermCounts() > 0 || idleUserScan.getScanRoleCounts() > 0 || idleUserScan.getScanUsersCounts() > 0;
        }
        return false;
    }

    private static boolean permRankScanIsSubmitTask(List<String> userIds, PermRankScan permRankScan) {
        HashSet<String> userIdsSet = new HashSet<String>(userIds);
        List<PermRankScanUnit> scanUsers = permRankScan.getScanUsers();
        for (PermRankScanUnit scanUnit : scanUsers) {
            if (!userIdsSet.contains(scanUnit.getUserId()) || scanUnit.getScanPermCounts() <= 0) continue;
            return true;
        }
        return false;
    }

    private static boolean permRepeatScanIsSubmitTask(List<String> userIds, PermRepeatScan permRepeatScan) {
        HashSet<String> userIdsSet = new HashSet<String>(userIds);
        List<PermRepeatScanUnit> scanUsers = permRepeatScan.getScanUsers();
        for (PermRepeatScanUnit scanUnit : scanUsers) {
            if (!userIdsSet.contains(scanUnit.getUserId()) || scanUnit.getScanPermCounts() <= 0) continue;
            return true;
        }
        return false;
    }
}

