/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.daq.impl;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.app.daq.IDataAcquisitionService;
import com.kingdee.eas.base.permission.app.daq.timer.DataAcquisitionTaskManager;
import com.kingdee.eas.base.permission.app.daq.util.DataAcquisitionUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ModuleUseStatsServiceImpl
extends AbstractBOSObject
implements IDataAcquisitionService {
    private static final Logger logger = Logger.getLogger(ModuleUseStatsServiceImpl.class);
    private static Map<String, Map<String, List<String>>> cache = new HashMap<String, Map<String, List<String>>>();
    private static List<String[]> tmpList = new ArrayList<String[]>();
    private static boolean flag = true;
    Context ctx = new Context();

    public ModuleUseStatsServiceImpl() {
    }

    public ModuleUseStatsServiceImpl(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public void record(String dataCenter, String userPK, String module) {
        DataAcquisitionTaskManager.checkTaskStart();
        if (flag) {
            this.insert(dataCenter, userPK, module);
        } else {
            this.insertTmpCache(dataCenter, userPK, module);
        }
    }

    @Override
    public void insertTable() throws EASBizException, BOSException {
        flag = false;
        Calendar currentTime = Calendar.getInstance();
        currentTime.setTime(new Date());
        try {
            for (String dataCenter : cache.keySet()) {
                Map<String, List<String>> data = cache.get(dataCenter);
                Context ctx = DataAcquisitionUtil.buildContext(dataCenter, null);
                this.insertByDataCenter(ctx, data);
            }
        }
        catch (BOSException e) {
            throw e;
        }
        finally {
            cache.clear();
            flag = true;
            this.dealTmpCache();
            tmpList.clear();
        }
    }

    private void insertByDataCenter(Context ctx, Map<String, List<String>> data) throws BOSException {
        String sql = "INSERT INTO T_PM_ModuleUseStats(FID,FUserId,FModuleNumber,FDataAcqTime) VALUES(newbosid('B9BE6B98'),?,?,?)";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String userId : data.keySet()) {
            List<String> list = data.get(userId);
            this.buildParam(userId, list, params);
        }
        logger.error((Object)("\u6570\u636e\u4e2d\u5fc3" + ctx.getAIS() + "\u6a21\u5757\u4f7f\u7528\u6570\u91cf\uff1a" + params.size()));
        DbUtil.executeBatch((Context)ctx, (String)sql, params);
    }

    private void buildParam(String userId, List<String> list, List<Object[]> params) {
        Calendar currentTime = Calendar.getInstance();
        currentTime.setTime(new Date());
        if (list.size() < 1) {
            return;
        }
        Timestamp tt = DataAcquisitionUtil.getTime(new Date());
        for (int i = 0; i < list.size(); ++i) {
            params.add(new Object[]{userId, list.get(i), tt});
            logger.error((Object)("\u63d2\u5165\u8868\u7528\u6237\u540d\uff1a" + userId + ";\u6a21\u5757\uff1a" + list.get(i)));
        }
    }

    private void dealTmpCache() {
        for (int i = 0; i < tmpList.size(); ++i) {
            String[] param = tmpList.get(i);
            this.insert(param[0], param[1], param[2]);
        }
    }

    private void init(String dataCenter, String userPK, String module) {
        HashMap dataMap = new HashMap();
        ArrayList<String> moduleList = new ArrayList<String>();
        moduleList.add(module);
        dataMap.put(userPK, moduleList);
        cache.put(dataCenter, dataMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(String dataCenter, String userPK, String module) {
        Map<String, Map<String, List<String>>> map = cache;
        synchronized (map) {
            Map<String, List<String>> data;
            List<String> list;
            if (cache.get(dataCenter) == null) {
                this.init(dataCenter, userPK, module);
            }
            if ((list = (data = cache.get(dataCenter)).get(userPK)) == null) {
                list = new ArrayList<String>();
                list.add(module);
                data.put(userPK, list);
            } else if (!list.contains(module)) {
                list.add(module);
            }
        }
    }

    private void insertTmpCache(String dataCenter, String userPK, String module) {
        tmpList.add(new String[]{dataCenter, userPK, module});
    }

    public BOSObjectType getType() {
        return null;
    }

    public static void clearCache() {
        cache.clear();
    }

    @Override
    public boolean startTask() {
        return DataAcquisitionTaskManager.checkTaskStart();
    }
}

