/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.helper;

import com.kingdee.eas.base.permission.app.helper.IFindable;
import com.kingdee.eas.base.permission.app.helper.IFinder;
import com.kingdee.eas.base.permission.app.helper.PermissionFileFindable;
import com.kingdee.eas.base.permission.app.helper.PermissionJarFindable;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;

public class PermFileSearch
implements IFinder {
    private static Logger logger = Logger.getLogger(PermFileSearch.class);

    public Map<String, Collection<String>> search(Collection<String> numberCol) {
        String metaDataPath = System.getProperty("metadata.path");
        HashMap<String, Collection<String>> ret = new HashMap();
        try {
            ret = this.search(metaDataPath, numberCol);
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return ret;
    }

    public Map<String, Collection<String>> search(String metaDataPath, Collection<String> numberCol) throws IOException {
        HashMap<String, Collection<String>> numberPathsMap = new HashMap<String, Collection<String>>();
        Collection<IFindable> permissionFiles = PermFileSearch.getPermFilesFromMetaPath(metaDataPath);
        for (IFindable findable : permissionFiles) {
            findable.setNumCol(numberCol);
            Map<String, Collection<String>> permPathMap = findable.accept(this);
            PermFileSearch.joinMap(numberPathsMap, permPathMap);
        }
        return numberPathsMap;
    }

    private static Map<String, Collection<String>> joinMap(Map<String, Collection<String>> source, Map<String, Collection<String>> toAdd) {
        for (String key : toAdd.keySet()) {
            Collection<String> value = toAdd.get(key);
            if (source.containsKey(key)) {
                Collection<String> sourceValue = source.get(key);
                sourceValue.addAll(value);
                source.put(key, sourceValue);
                continue;
            }
            source.put(key, value);
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Collection<String>> findJarPermissionFile(File permissionJarFile, Collection<String> numberCol) throws IOException {
        HashMap<String, Collection<String>> ret = new HashMap<String, Collection<String>>();
        JarFile permissionJar = null;
        try {
            permissionJar = new JarFile(permissionJarFile);
            Enumeration<JarEntry> entries = permissionJar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (entry.isDirectory() || !entryName.matches("\\w++.permission")) continue;
                Collection<String> containedNumbers = PermFileSearch.getContainedNumbers(permissionJar, entry, numberCol);
                for (String number : containedNumbers) {
                    String path = permissionJar.getName() + ":" + entry.getName();
                    if (ret.containsKey(number)) {
                        ((Collection)ret.get(number)).add(path);
                        continue;
                    }
                    ArrayList<String> paths = new ArrayList<String>();
                    paths.add(path);
                    ret.put(number, paths);
                }
            }
        }
        finally {
            if (permissionJar != null) {
                try {
                    permissionJar.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return ret;
    }

    private static Collection<String> getContainedNumbers(JarFile jar, JarEntry entry, Collection<String> numberCol) throws IOException {
        InputStream is = jar.getInputStream(entry);
        return PermFileSearch.getContainedNumbers(is, numberCol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<String> getContainedNumbers(InputStream is, Collection<String> numberCol) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = br.readLine()) != null) {
                for (String number : numberCol) {
                    String fullName = "<name>" + number + "</name>";
                    if (!fullName.equals(line.trim())) continue;
                    ret.add(number);
                }
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return ret;
    }

    private static Collection<IFindable> getPermFilesFromMetaPath(String metaPath) {
        String[] dirs;
        if (StringUtils.isEmpty((String)metaPath)) {
            return new HashSet<IFindable>();
        }
        HashSet<IFindable> ret = new HashSet<IFindable>();
        for (String dir : dirs = metaPath.split(";")) {
            Collection<IFindable> permissionJars = PermFileSearch.getPermissionFiles(dir);
            ret.addAll(permissionJars);
        }
        return ret;
    }

    private static Collection<IFindable> getPermissionFiles(String dirName) {
        ArrayList<IFindable> ret = new ArrayList<IFindable>();
        File file = new File(dirName);
        if (file.isDirectory()) {
            for (String filename : file.list()) {
                String fullFilename = dirName + File.separator + filename;
                ret.addAll(PermFileSearch.getPermissionFiles(fullFilename));
            }
        } else {
            String fileName = file.getName();
            if (PermFileSearch.isPermissionJar(fileName)) {
                ret.add(new PermissionJarFindable(file));
            } else if (PermFileSearch.isPermissionFile(fileName)) {
                ret.add(new PermissionFileFindable(file));
            }
        }
        return ret;
    }

    private static boolean isPermissionJar(String fileName) {
        return fileName.matches("permission_\\w++-metas.jar");
    }

    private static boolean isPermissionFile(String fileName) {
        return fileName.matches("\\w++.permission");
    }

    public static void main(String[] args) {
        ArrayList<String> numbers = new ArrayList<String>();
        numbers.add("BAS_CR_Templet_View");
        numbers.add("BAS_FW_Item_View");
        numbers.add("eqm_analysis_workordercost_01view");
        try {
            Map<String, Collection<String>> map = new PermFileSearch().search("W:" + File.separator + "eas" + File.separator + "Server" + File.separator + "server" + File.separator + "metas", numbers);
            for (Map.Entry<String, Collection<String>> entry : map.entrySet()) {
                System.out.print("number:" + entry.getKey() + "   in file paths: ");
                Collection<String> paths = entry.getValue();
                Iterator<String> pathsItr = paths.iterator();
                while (pathsItr.hasNext()) {
                    System.out.println(pathsItr.next());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, Collection<String>> findPermissionFile(File permissionFile, Collection<String> numberCol) throws IOException {
        FileInputStream is = new FileInputStream(permissionFile);
        Collection<String> containedNumCol = PermFileSearch.getContainedNumbers(is, numberCol);
        HashMap<String, Collection<String>> ret = new HashMap<String, Collection<String>>();
        for (String key : containedNumCol) {
            HashSet<String> pathCol = new HashSet<String>();
            pathCol.add(permissionFile.getCanonicalPath());
            ret.put(key, pathCol);
        }
        return ret;
    }
}

