/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.service.multiorg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.base.permission.app.config.ConfigurationLoader;
import com.kingdee.eas.base.permission.app.service.multiorg.IMultiOrgDataPermissionService;
import com.kingdee.eas.base.permission.app.service.multiorg.MultiOrgCommonDataPermissionService;
import com.kingdee.eas.base.permission.app.service.multiorg.MultiOrgDataPermissionMap;
import com.kingdee.eas.base.permission.app.service.multiorg.MultiOrgDiscretePermissionService;
import com.kingdee.eas.base.permission.app.service.multiorg.MultiOrgPermissionUtils;
import com.kingdee.eas.base.permission.app.service.multiorg.MultiOrgSpecialDataPermissionService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.LowTimer;
import java.util.Collection;
import org.apache.log4j.Logger;

public class MultiOrgDataPermissionService
implements IMultiOrgDataPermissionService {
    private static Logger logger = Logger.getLogger(MultiOrgDataPermissionService.class);
    private Context context = null;

    public MultiOrgDataPermissionService(Context context) {
        this.context = context;
    }

    @Override
    public String getPermissionRule(IObjectPK userPK, Collection orgCollection, String permItemName, String orgFieldName) throws BOSException, EASBizException {
        assert (userPK != null && permItemName != null);
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        if (orgCollection == null || orgCollection.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)PermissionResUtil.getResource("res_11"));
                endTime = lowTimer.msValue();
                logger.debug((Object)("getPermissionRule():  " + (endTime - beginTime)));
            }
            throw new PermissionException(PermissionException.CHECK_PERMISSION_FAIL);
        }
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
        MultiOrgDataPermissionMap dataPermissionMap = this.getCommonDataRule(userPK, orgCollection, permItemName);
        String discreteDataPermRule = this.getDiscreteDataRule(userPK, orgCollection, permItemName);
        String dataPermRule = null;
        dataPermRule = this.isSpecialEntity(permItemInfo.getObjectType()) ? this.getSpecialDataRule(userPK, orgCollection, orgFieldName, permItemInfo, dataPermissionMap) : dataPermissionMap.getDataPermissionRule(orgFieldName);
        dataPermRule = MultiOrgPermissionUtils.mergeOQL(dataPermRule, discreteDataPermRule);
        if (logger.isDebugEnabled()) {
            endTime = lowTimer.msValue();
            logger.debug((Object)(PermissionResUtil.getResource("res_12") + dataPermRule));
            logger.debug((Object)("getPermissionRule():  " + (endTime - beginTime)));
        }
        return dataPermRule;
    }

    private boolean isSpecialEntity(String entityType) {
        return ConfigurationLoader.getInstance().getConfigurationInfo().getSpecialEntityTypes().contains(entityType);
    }

    private MultiOrgDataPermissionMap getCommonDataRule(IObjectPK userPK, Collection orgCollection, String permItemName) throws BOSException, EASBizException {
        return MultiOrgCommonDataPermissionService.getService(this.context).getPermissionRule(userPK, orgCollection, permItemName);
    }

    private String getDiscreteDataRule(IObjectPK userPK, Collection orgCollection, String permItemName) throws EASBizException, BOSException {
        return MultiOrgDiscretePermissionService.getService(this.context).getDiscretePermissionRule(userPK, orgCollection, permItemName);
    }

    private String getSpecialDataRule(IObjectPK userPK, Collection orgCollection, String orgFieldName, PermItemInfo permItemInfo, MultiOrgDataPermissionMap dataPermissionMap) throws BOSException, EASBizException {
        return MultiOrgSpecialDataPermissionService.getService(this.context).getPermissionRule(userPK, orgCollection, orgFieldName, permItemInfo, dataPermissionMap);
    }
}

