/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.Locale;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.PasswordType;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserGroupInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserLockTypeEnum;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class UserInfoUtils {
    private static Logger logger = Logger.getLogger(UserInfoUtils.class);

    public static UserInfo getUserInfo4LoinModule(Context context, String userNumber) throws EASBizException {
        UserInfo userInfo = null;
        try {
            Object[] params = new Object[]{userNumber.toUpperCase()};
            String nameField = MultiLangHelper.getFieldName("FName", context.getLocale());
            String descriptionField = MultiLangHelper.getFieldName("FDescription", context.getLocale());
            String aliasField = MultiLangHelper.getFieldName("FAlias", context.getLocale());
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT U.FID, U.FNumber, ").append(" U.").append(nameField).append(", ").append(" U.FPassword, U.FType, U.FIsLocked, U.FIsDelete, U.FForbidden, ").append(" U.FIsRegister, U.FGroupID, U.FPersonId, U.FSecurityID, U.FEffectiveDate, U.FInvalidationDate, ").append(" U.FDefaultLocale, U.FErrCount, U.FPWEffectiveDate, U.FLockedTime, U.FType, U.FDefOrgUnitID, ").append(" U.FLoginNumber, U.FErrUpdatePwCount, U.FErrUpdatePwLastTime, U.FLockType,").append(" U.FControlUnitID, CtrlUnit.FNumber AS FCtrlUnitNumber, ").append(" CtrlUnit.").append(nameField).append(" AS FCtrlUnitName, ").append(" U.FIsBizAdmin, U.FIsChangedPW,U.FLoginAuthorWay, U.FUID,U.FCell,U.FEmail,U.FPasswordType, ").append(" U.").append(descriptionField).append(", ").append(" Person.FNumber AS FPersonNumber, ").append("Person.").append(nameField).append(" AS FPersonName, ").append(" Person.FOfficePhone AS FOfficePhone, ").append(" Security.FID AS SecurityID, ").append(" Security.FNumber AS FSecurityNumber, ").append(" Security.").append(aliasField).append(" AS FSecurityAlias, ").append(" Security.FPasswordLength AS FPasswordLength, ").append(" Security.FPasswordForever AS FPasswordForever, Security.FNeedLocked AS FNeedLocked, ").append(" Security.FLockCount AS FLockCount, Security.FPasswordCanChg AS FPasswordCanChg, ").append(" Security.FPasswordCycle AS FPasswordCycle, Security.FForewarnDay AS FForewarnDay, ").append(" Security.FIsComplex AS FIsComplex, Security.FIsRequireChgPW AS FIsRequireChgPW, ").append(" Security.FRequireSpecialChar AS FRequireSpecialChar, Security.FExpiredPassCanChg as FExpiredPassCanChg,").append(" Security.FLockTime, Security.FLockUpdatePwCount, Security.FNeedUpdatePwLocked,Security.FLockUpdatePwTime,").append(" Security.FRequireUpChar, Security.FRequireLowChar, Security.FRequireNotIncludeNumber,Security.FRequireWeakPw,").append(" BaseUnit.FNumber AS FDefOrgUnitNumber, ").append(" BaseUnit.").append(nameField).append(" AS FDefOrgUnitName, ").append(" BaseUnit.FIsCU, BaseUnit.FIsCompanyOrgUnit, BaseUnit.FIsSaleOrgUnit, BaseUnit.FIsCostOrgUnit,").append(" BaseUnit.FIsPurchaseOrgUnit,\tBaseUnit.FIsStorageOrgUnit, BaseUnit.FIsHROrgUnit, BaseUnit.FIsTransportOrgUnit, BaseUnit.FIsQualityOrgUnit,").append(" U.FCustomerID, ").append(" U.FSupplierID  ").append(" FROM T_PM_User U ").append(" LEFT OUTER JOIN T_BD_Person Person ON Person.FID = U.FPersonId ").append(" LEFT OUTER JOIN T_PM_Security Security ON Security.FID = U.FSecurityID ").append(" LEFT OUTER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = U.FDefOrgUnitID ").append(" LEFT OUTER JOIN T_ORG_CtrlUnit CtrlUnit ON CtrlUnit.FID = U.FControlUnitID ").append(" WHERE UPPER(U.FNumber) =  ? AND U.FIsDelete = 0 ");
            IRowSet rowSet = DbUtil.executeQuery((Context)context, (String)sql.toString(), (Object[])params);
            if (rowSet.next()) {
                String supplierID;
                String customerID;
                String ctrlUnitID;
                String securityID;
                String personID;
                userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)rowSet.getString("FID")));
                userInfo.setNumber(rowSet.getString("FNumber"));
                String nameValue = rowSet.getString(nameField);
                userInfo.setName(nameValue, context.getLocale());
                userInfo.put("name", nameValue);
                userInfo.setPassword(rowSet.getString("FPassword"));
                userInfo.setType(UserType.getEnum(rowSet.getInt("FType")));
                userInfo.setIsLocked(rowSet.getInt("FIsLocked") == 1);
                userInfo.setIsDelete(rowSet.getInt("FIsDelete") == 1);
                userInfo.setIsForbidden(rowSet.getInt("FForbidden") == 1);
                userInfo.setIsRegister(rowSet.getInt("FIsRegister") == 1);
                userInfo.setBizAdmin(rowSet.getInt("FIsBizAdmin") == 1);
                userInfo.setChangedPW(rowSet.getInt("FIsChangedPW") == 1);
                userInfo.setLoginAuthorWay(LoginAuthorWayEnum.getEnum(rowSet.getInt("FLoginAuthorWay")));
                userInfo.setUid(rowSet.getString("FUID"));
                userInfo.setCell(rowSet.getString("FCell"));
                userInfo.setEmail(rowSet.getString("FEmail"));
                userInfo.setLoginNumber(rowSet.getString("FLoginNumber"));
                userInfo.setErrUpdatePwCount(rowSet.getInt("FErrUpdatePwCount"));
                userInfo.setErrUpdatePwLastTime(rowSet.getTimestamp("FErrUpdatePwLastTime"));
                userInfo.setLockType(UserLockTypeEnum.getEnum(rowSet.getInt("FLockType")));
                String desValue = rowSet.getString(descriptionField);
                userInfo.setDescription(desValue, context.getLocale());
                userInfo.put("description", desValue);
                userInfo.setPasswordType(PasswordType.getEnum(rowSet.getInt("FPasswordType")));
                String groupID = rowSet.getString("FGroupID");
                if (!StringUtils.isEmpty((String)groupID)) {
                    UserGroupInfo groupInfo = new UserGroupInfo();
                    groupInfo.setId(BOSUuid.read((String)groupID));
                    userInfo.setGroup(groupInfo);
                }
                if (!StringUtils.isEmpty((String)(personID = rowSet.getString("FPersonId")))) {
                    String personNumber = rowSet.getString("FPersonNumber");
                    String personName = rowSet.getString("FPersonName");
                    String officePhone = rowSet.getString("FOfficePhone");
                    PersonInfo personInfo = new PersonInfo();
                    personInfo.setId(BOSUuid.read((String)personID));
                    personInfo.setNumber(personNumber);
                    personInfo.setName(personName, context.getLocale());
                    personInfo.put("name", (Object)personName);
                    personInfo.setOfficePhone(officePhone);
                    userInfo.setPerson(personInfo);
                }
                if (!StringUtils.isEmpty((String)(securityID = rowSet.getString("FSecurityID")))) {
                    SecurityInfo securityInfo = new SecurityInfo();
                    securityInfo.setId(BOSUuid.read((String)rowSet.getString("SecurityID")));
                    securityInfo.setNumber(rowSet.getString("FSecurityNumber"));
                    String aliasValue = rowSet.getString("FSecurityAlias");
                    securityInfo.setAlias(aliasValue, context.getLocale());
                    securityInfo.put("alias", aliasValue);
                    securityInfo.setPasswordLength(rowSet.getInt("FPasswordLength"));
                    securityInfo.setPasswordForever(rowSet.getInt("FPasswordForever") == 1);
                    securityInfo.setNeedLocked(rowSet.getInt("FNeedLocked") == 1);
                    securityInfo.setLockCount(rowSet.getInt("FLockCount"));
                    securityInfo.setPasswordCanChg(rowSet.getInt("FPasswordCanChg") == 1);
                    securityInfo.setPasswordCycle(rowSet.getInt("FPasswordCycle"));
                    securityInfo.setForewarnDay(rowSet.getInt("FForewarnDay"));
                    securityInfo.setComplex(rowSet.getInt("FIsComplex") == 1);
                    securityInfo.setRequireChgPW(rowSet.getInt("FIsRequireChgPW") == 1);
                    securityInfo.setExpiredPassCanChg(rowSet.getInt("FExpiredPassCanChg") == 1);
                    securityInfo.setRequireSpecialChar(rowSet.getInt("FRequireSpecialChar") == 1);
                    securityInfo.setLockTime(rowSet.getInt("FLockTime"));
                    securityInfo.setLockUpdatePwCount(rowSet.getInt("FLockUpdatePwCount"));
                    securityInfo.setLockUpdatePwTime(rowSet.getInt("FLockUpdatePwTime"));
                    securityInfo.setNeedUpdatePwLocked(rowSet.getInt("FNeedUpdatePwLocked") == 1);
                    securityInfo.setRequireLowChar(rowSet.getInt("FRequireLowChar") == 1);
                    securityInfo.setRequireUpChar(rowSet.getInt("FRequireUpChar") == 1);
                    securityInfo.setRequireNotIncludeNumber(rowSet.getInt("FRequireNotIncludeNumber") == 1);
                    securityInfo.setRequireWeakPw(rowSet.getInt("FRequireWeakPw") == 1);
                    userInfo.setSecurity(securityInfo);
                }
                if (!StringUtils.isEmpty((String)(ctrlUnitID = rowSet.getString("FControlUnitID")))) {
                    String ctrlUnitNumber = rowSet.getString("FCtrlUnitNumber");
                    String ctrlUnitName = rowSet.getString("FCtrlUnitName");
                    CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
                    ctrlUnitInfo.setId(BOSUuid.read((String)ctrlUnitID));
                    ctrlUnitInfo.setNumber(ctrlUnitNumber);
                    ctrlUnitInfo.setName(ctrlUnitName, context.getLocale());
                    ctrlUnitInfo.put("name", (Object)ctrlUnitName);
                    userInfo.setCU(ctrlUnitInfo);
                }
                userInfo.setEffectiveDate(rowSet.getTimestamp("FEffectiveDate"));
                userInfo.setInvalidationDate(rowSet.getTimestamp("FInvalidationDate"));
                userInfo.setDefLocale(Locale.getEnum(rowSet.getString("FDefaultLocale")));
                userInfo.setErrCount(rowSet.getInt("FErrCount"));
                userInfo.setPWEffectiveDate(rowSet.getDate("FPWEffectiveDate"));
                userInfo.setLockedTime(rowSet.getTime("FLockedTime"));
                userInfo.setType(UserType.getEnum(rowSet.getInt("FType")));
                String defOrgUnitID = rowSet.getString("FDefOrgUnitID");
                if (!StringUtils.isEmpty((String)defOrgUnitID)) {
                    String defOrgUnitNumber = rowSet.getString("FDefOrgUnitNumber");
                    String defOrgUnitName = rowSet.getString("FDefOrgUnitName");
                    FullOrgUnitInfo defOrgUnit = new FullOrgUnitInfo();
                    defOrgUnit.setId(BOSUuid.read((String)defOrgUnitID));
                    defOrgUnit.setNumber(defOrgUnitNumber);
                    defOrgUnit.setName(defOrgUnitName, context.getLocale());
                    defOrgUnit.put("name", (Object)defOrgUnitName);
                    defOrgUnit.setIsCU(rowSet.getInt("FIsCU") == 1);
                    defOrgUnit.setIsCompanyOrgUnit(rowSet.getInt("FIsCompanyOrgUnit") == 1);
                    defOrgUnit.setIsSaleOrgUnit(rowSet.getInt("FIsSaleOrgUnit") == 1);
                    defOrgUnit.setIsPurchaseOrgUnit(rowSet.getInt("FIsPurchaseOrgUnit") == 1);
                    defOrgUnit.setIsStorageOrgUnit(rowSet.getInt("FIsStorageOrgUnit") == 1);
                    defOrgUnit.setIsHROrgUnit(rowSet.getInt("FIsHROrgUnit") == 1);
                    defOrgUnit.setIsCostOrgUnit(rowSet.getInt("FIsCostOrgUnit") == 1);
                    defOrgUnit.setIsTransportOrgUnit(rowSet.getInt("FIsTransportOrgUnit") == 1);
                    defOrgUnit.setIsQualityOrgUnit(rowSet.getInt("FIsQualityOrgUnit") == 1);
                    userInfo.setDefOrgUnit(defOrgUnit);
                }
                if (!StringUtils.isEmpty((String)(customerID = rowSet.getString("FCustomerID")))) {
                    userInfo.setCustomerID(customerID);
                }
                if (!StringUtils.isEmpty((String)(supplierID = rowSet.getString("FSupplierID")))) {
                    userInfo.setSupplierID(supplierID);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new UserException(UserException.GET_USER_INFO_FAIL, e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            if ("CONFIG_EXCEPTION".equals(e.getMessage())) {
                throw new PermissionException(PermissionException.SERVER_CONFIGURE_ERROR, e);
            }
            throw new UserException(UserException.GET_USER_INFO_FAIL, e);
        }
        return userInfo;
    }

    public static boolean isManager(Context ctx, String personId) throws BOSException {
        if (!UserInfoUtils.isBeginToUseSHR(ctx)) {
            return false;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String currentDateStr = format.format(new Date());
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 e.fpersonid ").append("from T_HR_EmpOrgRelation e").append(" inner join t_org_position p1 on p1.fid = e.fpositionid ").append(" where e.FEFFDT<=to_date('").append(currentDateStr).append("')").append(" and e.FLEFFDT>to_date('").append(currentDateStr).append("')").append(" and e.fpersonid = ?").append(" and (").append(" p1.fisrespposition = 1").append(" or p1.fid in (select fparentid from t_org_position) ").append(")");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{personId});
        }
        catch (BOSException e) {
            e.printStackTrace();
            return false;
        }
        return rs.size() > 0;
    }

    public static boolean isLeader(Context ctx, String personId) throws BOSException {
        if (!UserInfoUtils.isBeginToUseSHR(ctx)) {
            return false;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select fpersonid ").append("from t_hr_personposition ").append(" where fpersonid = ?").append(" and fisleader=1 ");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{personId});
        }
        catch (BOSException e) {
            e.printStackTrace();
            return false;
        }
        return rs.size() > 0;
    }

    public static boolean isBeginToUseSHR(Context ctx) throws BOSException {
        boolean isStartSHR = false;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select * from t_hr_hrinit where FKEY = 'IS_SHRSYSTEM_UPDATE'");
        try {
            if (rs.next()) {
                isStartSHR = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return isStartSHR;
    }

    public static UserInfo getCurrentUser(Context ctx) throws BOSException, EASBizException {
        UserInfo currentUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (currentUser == null) {
            IUser iUser = UserFactory.getLocalInstance(ctx);
            currentUser = ctx.getCaller() != null ? iUser.getUserInfo(ctx.getCaller()) : iUser.getUserInfo("00000000-0000-0000-0000-00000000000013B7DE7F");
        }
        return currentUser;
    }
}

