/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.service.helper.ekey;

import com.kingdee.eas.base.permission.UsbKeyException;
import com.kingdee.eas.base.permission.service.helper.AbstractUsbKeyBaseOperator;
import com.kingdee.eas.base.permission.service.helper.ekey.EkeyNativeImpl;
import com.kingdee.eas.base.permission.service.helper.ekey.ExceptionMap;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class EUsbKeyBaseOperatorImpl
extends AbstractUsbKeyBaseOperator {
    private static Logger logger = Logger.getLogger((String)EUsbKeyBaseOperatorImpl.class.getName());
    private EkeyNativeImpl ekeyImpl = new EkeyNativeImpl();

    private String dealRes(String res, String info) throws UsbKeyException {
        logger.info((Object)(info + "res is:" + res));
        if (!StringUtils.isEmpty((String)res) && res.startsWith("0x") && !res.equalsIgnoreCase("0x00000000")) {
            this.dealException(res);
        }
        return res;
    }

    private String dealRes(String res) throws UsbKeyException {
        return this.dealRes(res, " no info");
    }

    @Override
    public void changePwd(String oldPwd, String newPwd) throws UsbKeyException {
        this.dealRes(this.ekeyImpl.changePwd(oldPwd, newPwd), "changePwd");
    }

    @Override
    public void closeDevice() throws UsbKeyException {
        this.dealRes(this.ekeyImpl.closeDevice(), "closeDevice");
    }

    @Override
    public void connectionDevice() throws UsbKeyException {
        this.dealRes(this.ekeyImpl.connectionDevice(), "connectionDevice");
    }

    @Override
    public void createFile(int fileNo) throws UsbKeyException {
        this.dealRes(this.ekeyImpl.createFile(fileNo), "createFile");
    }

    @Override
    public void deleteFile() throws UsbKeyException {
        this.dealRes(this.ekeyImpl.deleteFile(), "deleteFile");
    }

    @Override
    public void openFile(int fileNo) throws UsbKeyException {
        this.dealRes(this.ekeyImpl.openFile(fileNo), "openFile");
    }

    @Override
    public String readFile(int fileSize) throws UsbKeyException {
        return this.dealRes(this.ekeyImpl.readFile(fileSize), "readFile");
    }

    @Override
    public String getNo() throws UsbKeyException {
        return this.dealRes(this.ekeyImpl.getNo(), "read ekey number ");
    }

    private void dealException(String res) throws UsbKeyException {
        logger.info((Object)("verifypwd res is:" + res));
        if (!StringUtils.isEmpty((String)res) && res.startsWith("0x") && !res.equalsIgnoreCase("0x00000000")) {
            UsbKeyException usbKeyException = ExceptionMap.getInstance().getUsbKeyException(res);
            if (usbKeyException != null) {
                throw usbKeyException;
            }
            throw new UsbKeyException(UsbKeyException.USB_ERROR, new Object[]{res});
        }
    }

    @Override
    public void verifyPwd(String newPwd) throws UsbKeyException {
        if (newPwd == null || newPwd.trim().length() == 0) {
            throw new UsbKeyException(UsbKeyException.USB_PWD_ERROR);
        }
        this.dealException(this.ekeyImpl.verifyPwd(newPwd));
    }

    @Override
    public void writeFile(String str) throws UsbKeyException {
        this.dealRes(this.ekeyImpl.writeFile(str), "writeFile");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        try {
            EUsbKeyBaseOperatorImpl ekeyImpl = new EUsbKeyBaseOperatorImpl();
            int fileNo = 9;
            ekeyImpl.connectionDevice();
            try {
                ekeyImpl.openFile(fileNo);
                ekeyImpl.deleteFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ekeyImpl.createFile(fileNo);
            String writeContent = "wangtest";
            ekeyImpl.writeFile(writeContent);
            String content = ekeyImpl.readFile(writeContent.length());
            content = ekeyImpl.getNo();
            ekeyImpl.closeDevice();
            if (!writeContent.equals(content)) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

