/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.base.permission.util.IObjectCol2Map;
import com.kingdee.eas.base.permission.util.PermissionOrgTypeUtils;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ToolUtils {
    public static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    public static List objAryToList(Object[] obj) {
        if (obj == null || obj.length == 0) {
            return new ArrayList();
        }
        ArrayList<String> retList = new ArrayList<String>();
        int size = obj.length;
        for (int i = 0; i < size; ++i) {
            retList.add(StringUtils.cnulls((Object)obj[i]));
        }
        return retList;
    }

    public static Set objAryToSet(Collection obj) {
        if (obj == null || obj.isEmpty()) {
            return new HashSet();
        }
        HashSet<String> retSet = new HashSet<String>();
        Iterator ita = obj.iterator();
        while (ita.hasNext()) {
            retSet.add(StringUtils.cnulls(ita.next()));
        }
        return retSet;
    }

    public static String aryToStr(String[] idAry) {
        return ToolUtils.aryToStr(idAry, true);
    }

    public static String aryToStr(String[] idAry, boolean needSeperate) {
        if (idAry == null || idAry.length == 0) {
            return ToolUtils.aryToStr(new ArrayList());
        }
        ArrayList<String> retList = new ArrayList<String>();
        int size = idAry.length;
        for (int i = 0; i < size; ++i) {
            retList.add(idAry[i]);
        }
        return ToolUtils.aryToStr(retList, needSeperate);
    }

    public static String aryToStr(String[] idAry, int number) {
        if (idAry == null || idAry.length == 0) {
            return ToolUtils.aryToStr(new ArrayList());
        }
        ArrayList<String> retList = new ArrayList<String>();
        int lastAryPos = number;
        if (number >= idAry.length) {
            lastAryPos = idAry.length;
        }
        int size = lastAryPos;
        for (int i = 0; i < size; ++i) {
            retList.add(idAry[i]);
        }
        return ToolUtils.aryToStr(retList, false);
    }

    public static String aryToStr(Object[] idAry, boolean needSeperate) {
        if (idAry == null || idAry.length == 0) {
            return ToolUtils.aryToStr(new ArrayList());
        }
        ArrayList<String> retList = new ArrayList<String>();
        int size = idAry.length;
        for (int i = 0; i < size; ++i) {
            if (idAry[i] == null) continue;
            retList.add(idAry[i].toString());
        }
        return ToolUtils.aryToStr(retList, needSeperate);
    }

    public static String aryToStr(Object[] idAry) {
        return ToolUtils.aryToStr(idAry, true);
    }

    public static String aryToStr(Collection col) {
        if (col == null || col.isEmpty()) {
            return "''";
        }
        List valueList = ToolUtils.objAryToList(col.toArray());
        return ToolUtils.aryToStr(valueList);
    }

    public static String aryToStr(Collection col, boolean addChar) {
        if (col == null || col.isEmpty()) {
            return "''";
        }
        List valueList = ToolUtils.objAryToList(col.toArray());
        return ToolUtils.aryToStr(valueList, addChar);
    }

    public static String aryToStr(List idList, boolean addChar) {
        if (idList == null || idList.isEmpty()) {
            return "''";
        }
        StringBuffer receivers = new StringBuffer();
        for (Object obj : idList) {
            if (obj == null) break;
            if (addChar) {
                receivers.append("'").append(obj.toString()).append("',");
                continue;
            }
            receivers.append(obj.toString()).append(",");
        }
        String users = receivers.toString();
        if (users != null && users.trim().length() != 0 && users.endsWith(",") && users.trim().length() > 0) {
            users = users.substring(0, users.length() - 1);
        }
        return users;
    }

    public static String aryToStr(List idList) {
        return ToolUtils.aryToStr(idList, true);
    }

    public static SelectorItemCollection getEditSelectors() {
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("*");
        selectorItemCollection.add("security.*");
        selectorItemCollection.add("person.id");
        selectorItemCollection.add("person.number");
        selectorItemCollection.add("person.name");
        selectorItemCollection.add("group.id");
        selectorItemCollection.add("group.number");
        selectorItemCollection.add("group.name");
        selectorItemCollection.add("defOrgUnit.id");
        selectorItemCollection.add("defOrgUnit.number");
        selectorItemCollection.add("defOrgUnit.name");
        selectorItemCollection.add("customerID");
        selectorItemCollection.add("supplierID");
        selectorItemCollection.add("CU.*");
        selectorItemCollection.add("adNumber");
        return selectorItemCollection;
    }

    public static SelectorItemCollection getSelectors() {
        return ToolUtils.getSimpleSelectors();
    }

    public static SelectorItemCollection getSimpleSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bizAdmin"));
        sic.add(new SelectorItemInfo("defOrgUnit.id"));
        sic.add(new SelectorItemInfo("defOrgUnit.number"));
        sic.add(new SelectorItemInfo("defOrgUnit.name"));
        sic.add(new SelectorItemInfo("defOrgUnit.CU.id"));
        sic.add(new SelectorItemInfo("type"));
        sic.add(new SelectorItemInfo("loginAuthorWay"));
        sic.add(new SelectorItemInfo("CU.*"));
        return sic;
    }

    public static SelectorItemCollection getOrgIdSelectors() {
        return ToolUtils.getSimpleSelectors();
    }

    public static UserInfo getUserForOrgId(Context ctx, String userPK) throws BOSException, EASBizException, UuidException {
        return ToolUtils.getUserInfo(ctx, userPK, ToolUtils.getOrgIdSelectors());
    }

    public static UserInfo getUserInfo(Context ctx, String userPK, SelectorItemCollection selectors) throws BOSException, EASBizException, UuidException {
        IUser iUser = null;
        iUser = ctx == null ? UserFactory.getRemoteInstance() : UserFactory.getLocalInstance(ctx);
        return iUser.getUserInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)userPK)), selectors);
    }

    public static void updateSimpleUserInfoInCache(Context ctx, String userPK) throws BOSException, EASBizException {
    }

    public static UserInfo getSimpleUserInfo(IObjectPK userPK) throws EASBizException, BOSException {
        IUser iUser = UserFactory.getRemoteInstance();
        return iUser.getUserInfo(userPK, ToolUtils.getSimpleSelectors());
    }

    public static IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(ToolUtils.getCurrentUser().getId());
    }

    public static UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    public static CtrlUnitInfo getCurrentCU() {
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    public static IObjectPK getCurrentCUPK() {
        return new ObjectUuidPK(ToolUtils.getCurrentCU().getId());
    }

    public static Map sortByPermType(UserOrgPermCollection perms) {
        if (perms == null || perms.isEmpty()) {
            return new HashMap();
        }
        HashMap retMap = new HashMap();
        int size = perms.size();
        for (int i = 0; i < size; ++i) {
            List<PermItemInfo> keyValueList;
            UserOrgPermInfo onePerm = perms.get(i);
            if (onePerm == null || onePerm.getPermType() == null || onePerm.getPermItem() == null || onePerm.getPermItem().getId() == null) continue;
            String keyStr = "" + onePerm.getPermType().getValue();
            PermItemInfo valueStr = onePerm.getPermItem();
            if (retMap.containsKey(keyStr)) {
                keyValueList = (List)retMap.get(keyStr);
                keyValueList.add(valueStr);
                continue;
            }
            keyValueList = new ArrayList();
            keyValueList.add(valueStr);
            retMap.put(keyStr, keyValueList);
        }
        return retMap;
    }

    public static List orgCol2List(FullOrgUnitCollection fullOrgCol) {
        ArrayList<String> retList = new ArrayList<String>();
        if (fullOrgCol == null || fullOrgCol.isEmpty()) {
            return retList;
        }
        HashSet<String> alreadySet = new HashSet<String>();
        int size = fullOrgCol.size();
        for (int i = 0; i < size; ++i) {
            String keyStr = fullOrgCol.get(i).getId().toString();
            if (alreadySet.contains(keyStr)) continue;
            retList.add(keyStr);
            alreadySet.add(keyStr);
        }
        return retList;
    }

    public static boolean addSysOrgId(List orgIdList) {
        if (orgIdList == null) {
            orgIdList = new ArrayList<String>();
        }
        if (!orgIdList.contains("11111111-1111-1111-1111-111111111111CCE7AED4")) {
            orgIdList.add("11111111-1111-1111-1111-111111111111CCE7AED4");
            return true;
        }
        return false;
    }

    public static List transCol2ListByPeroperty(List iObjectCol, IObjectCol2List iObjectList) {
        if (iObjectCol == null || iObjectCol.isEmpty()) {
            return new ArrayList();
        }
        if (iObjectList == null) {
            throw new IllegalArgumentException("IObjectCol2List must be implement, is not is null");
        }
        ArrayList<String> idStrList = new ArrayList<String>();
        int size = iObjectCol.size();
        for (int i = 0; i < size; ++i) {
            Object obj = iObjectCol.get(i);
            String value = iObjectList.getList(obj);
            if (StringUtils.isEmpty((String)value)) continue;
            idStrList.add(value);
        }
        return idStrList;
    }

    public static Map transCol2ListByPeroperty(List iObjectCol, IObjectCol2Map iObjectMap) {
        if (iObjectCol == null || iObjectCol.isEmpty()) {
            return new HashMap();
        }
        if (iObjectMap == null) {
            throw new IllegalArgumentException("IObjectCol2List must be implement, is not is null");
        }
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        int size = iObjectCol.size();
        for (int i = 0; i < size; ++i) {
            Object obj = iObjectCol.get(i);
            String keyStr = iObjectMap.getKey(obj);
            Object value = iObjectMap.getList(obj);
            if (StringUtils.isEmpty((String)keyStr) || value == null) continue;
            myMap.put(keyStr, value);
        }
        return myMap;
    }

    public static Map transCol2ListByPeroperty(IObjectCollection iObjectCol, IObjectCol2Map iObjectMap) {
        if (iObjectCol == null || iObjectCol.isEmpty()) {
            return new HashMap();
        }
        if (iObjectMap == null) {
            throw new IllegalArgumentException("IObjectCol2List must be implement, is not is null");
        }
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        int size = iObjectCol.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue obj = iObjectCol.getObject(i);
            String keyStr = iObjectMap.getKey(obj);
            Object value = iObjectMap.getList(obj);
            if (StringUtils.isEmpty((String)keyStr) || value == null) continue;
            myMap.put(keyStr, value);
        }
        return myMap;
    }

    public static List transCol2ListByPeroperty(IObjectCollection iObjectCol, IObjectCol2List iObjectList) {
        if (iObjectCol == null || iObjectCol.isEmpty()) {
            return new ArrayList();
        }
        if (iObjectList == null) {
            throw new IllegalArgumentException("IObjectCol2List must be implement, is not is null");
        }
        ArrayList<String> idStrList = new ArrayList<String>();
        int size = iObjectCol.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue obj = iObjectCol.getObject(i);
            String value = iObjectList.getList(obj);
            if (StringUtils.isEmpty((String)value)) continue;
            idStrList.add(value);
        }
        return idStrList;
    }

    public static FullOrgUnitInfo[] transFromOrgUnitInfo(OrgUnitInfo[] orgUnitInfo) {
        if (orgUnitInfo == null || orgUnitInfo.length == 0) {
            return null;
        }
        int size = orgUnitInfo.length;
        FullOrgUnitInfo[] fullUnitInfo = new FullOrgUnitInfo[size];
        for (int i = 0; i < size; ++i) {
            fullUnitInfo[i] = orgUnitInfo[i].castToFullOrgUnitInfo();
        }
        return fullUnitInfo;
    }

    public static Collection filterSameObj(Collection col) {
        if (col == null || col.size() == 0) {
            return new ArrayList();
        }
        Iterator it = col.iterator();
        HashSet alreadySet = new HashSet();
        ArrayList retList = new ArrayList();
        while (it.hasNext()) {
            Object obj = it.next();
            if (alreadySet.contains(obj)) continue;
            retList.add(obj);
            alreadySet.add(obj);
        }
        return retList;
    }

    public static FullOrgUnitCollection filterSameOrg(FullOrgUnitCollection col) {
        if (col == null || col.isEmpty()) {
            return new FullOrgUnitCollection();
        }
        HashSet<String> alreadySet = new HashSet<String>();
        FullOrgUnitCollection retCol = new FullOrgUnitCollection();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            String keyStr = StringUtils.cnulls((Object)col.get(i).getId());
            if (alreadySet.contains(keyStr)) continue;
            retCol.add(col.get(i));
            alreadySet.add(keyStr);
        }
        return retCol;
    }

    public static List trans2List(Collection col) {
        ArrayList retList = new ArrayList();
        if (col == null || col.isEmpty()) {
            return retList;
        }
        Iterator it = col.iterator();
        while (it.hasNext()) {
            retList.add(it.next());
        }
        return retList;
    }

    public static boolean isCanBeDefOrg(FullOrgUnitInfo fullOrgUnitInfo) {
        return PermissionOrgTypeUtils.isCanBeDefOrg(fullOrgUnitInfo);
    }

    public static EntityObjectInfo getEntity(Context ctx, BOSObjectType objectType) {
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        return loader.getEntity(objectType);
    }

    public static FilterInfo getCURangeFilterInfo(String filedName) throws EASBizException, BOSException {
        FilterInfo defFilter = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo(filedName, (Object)ToolUtils.aryToStr(PermissionRangeHelper.getCUOrgRange(null), false), CompareType.INCLUDE);
        defFilter.getFilterItems().add(filterItemInfo);
        return defFilter;
    }

    public static FilterInfo getUserIdInRange(String fieldName, List idList) throws EASBizException, BOSException {
        FilterInfo defFilter = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo(fieldName, (Object)ToolUtils.aryToStr(idList, false), CompareType.INCLUDE);
        defFilter.getFilterItems().add(filterItemInfo);
        return defFilter;
    }

    public static boolean isNullList(Collection col) {
        return col == null || col.isEmpty();
    }

    public static HashMap trans2Map(Collection userOrgRangeList) {
        HashMap<String, Boolean> retMap = new HashMap<String, Boolean>();
        if (userOrgRangeList == null || userOrgRangeList.isEmpty()) {
            return retMap;
        }
        for (Object obj : userOrgRangeList) {
            retMap.put(StringUtils.cnulls(obj), Boolean.FALSE);
        }
        return retMap;
    }

    public static Set trans2Set(Collection col) {
        HashSet<String> retMap = new HashSet<String>();
        if (col == null || col.isEmpty()) {
            return retMap;
        }
        for (Object obj : col) {
            retMap.add(StringUtils.cnulls(obj));
        }
        return retMap;
    }

    public static void debugInfo(Logger logger, String debugInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)debugInfo);
        }
    }

    public static void setTableAutoSort(KDTable tblMain) {
        KDTSortManager sm = new KDTSortManager(tblMain);
        sm.setSortAuto(true);
        for (int index = 0; index < tblMain.getColumnCount(); ++index) {
            tblMain.getColumn(index).setSortable(true);
        }
    }

    public static FilterInfo mergerFilter(FilterInfo mainFilter, FilterInfo nextFilterInfo) throws BOSException {
        if (mainFilter == null && nextFilterInfo == null) {
            return null;
        }
        if (mainFilter == null || mainFilter.getFilterItems().size() == 0) {
            return nextFilterInfo;
        }
        if (nextFilterInfo == null || nextFilterInfo.getFilterItems().size() == 0) {
            return mainFilter;
        }
        mainFilter.mergeFilter(nextFilterInfo, "OR");
        return mainFilter;
    }

    public static boolean equalObject(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null && o2 != null) {
            return o1.equals(o2);
        }
        return false;
    }

    public static List tranColToList(IObjectCollection col) {
        ArrayList<IObjectValue> ret = new ArrayList<IObjectValue>();
        for (int i = 0; i < col.size(); ++i) {
            ret.add(col.getObject(i));
        }
        return ret;
    }

    public static String[] getGLObalMapCell(String cell) {
        String[] gm = new String[2];
        if (StringUtils.isEmpty((String)cell)) {
            return gm;
        }
        int index = cell.indexOf("-");
        if (index < 0) {
            gm[0] = "+86";
            gm[1] = cell;
            return gm;
        }
        String global = cell.substring(0, index);
        gm[0] = StringUtils.isEmpty((String)global) ? "+86" : (global.startsWith("+") ? global : "+" + global);
        gm[1] = cell.substring(index + 1);
        return gm;
    }

    public static void sqlCheck(String sql) throws BOSException {
        String[] dangerMark = new String[]{".", ":", "#", "--", "(", ")", "<", ">", "or", "delete"};
        if (ToolUtils.containDangerKey(sql, dangerMark, "I")) {
            throw new BOSException("\u672a\u901a\u8fc7\u9488\u5bf9\u7279\u6b8a\u5b57\u7b26\u6821\u9a8c\u6821\u9a8c\uff0c\u672a\u901a\u8fc7\u503c\u4e3a : " + sql);
        }
    }

    public static boolean containDangerKey(String sql, String[] dangerArr, String regex) {
        for (int i = 0; i < dangerArr.length; ++i) {
            String key = dangerArr[i];
            if (!sql.contains(key)) continue;
            return true;
        }
        return false;
    }
}

