/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util.cloud;

import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class HttpsClientUtil {
    private static final Logger logger = Logger.getLogger(HttpsClientUtil.class);

    public static void downloadFile(String url, String filePath) throws Exception {
        OutputStream out = null;
        InputStream in = null;
        HttpURLConnection conn = null;
        try {
            URL realUrl = new URL(url);
            conn = (HttpsURLConnection)realUrl.openConnection();
            HttpsClientUtil.compatibleIgnore((HttpsURLConnection)conn);
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(3600000);
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("Accept-Charset", "UTF-8");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            conn.connect();
            try {
                in = conn.getInputStream();
                out = new FileOutputStream(filePath);
                byte[] b = new byte[8096];
                int i = 0;
                while ((i = in.read(b)) != -1) {
                    out.write(b, 0, i);
                    out.flush();
                }
            }
            catch (IOException e1) {
                logger.error((Object)("HttpsClientUtil.downloadFile exception:" + e1.getMessage()));
            }
            if (conn.getContentType().contains("text")) {
                throw new Exception("download fail");
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25" + e));
            throw e;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url) {
        String entityStr = null;
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            httpClient = HttpsClientUtil.getHttpClientForHttps();
            HttpGet httpGet = new HttpGet(url);
            httpGet.addHeader("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.7.6)");
            httpGet.addHeader("Content-Type", "application/x-www-form-urlencoded");
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            entityStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (ClientProtocolException e) {
            logger.error((Object)"Http\u534f\u8bae\u51fa\u73b0\u95ee\u9898", (Throwable)e);
        }
        catch (ParseException e) {
            logger.error((Object)"\u89e3\u6790\u9519\u8bef", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"IO\u5f02\u5e38", (Throwable)e);
        }
        catch (KeyManagementException e) {
            logger.error((Object)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"\u91ca\u653e\u8fde\u63a5\u51fa\u9519", (Throwable)e);
            }
        }
        return entityStr;
    }

    public static String post(String url, List<NameValuePair> params) throws Exception {
        String entityStr = null;
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            httpClient = HttpsClientUtil.getHttpClientForHttps();
            HttpPost httpPost = new HttpPost(url);
            UrlEncodedFormEntity entityParam = new UrlEncodedFormEntity(params, "UTF-8");
            httpPost.setEntity((HttpEntity)entityParam);
            httpPost.addHeader("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.7.6)");
            httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            entityStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (ClientProtocolException e) {
            logger.error((Object)"Http\u534f\u8bae\u51fa\u73b0\u95ee\u9898", (Throwable)e);
            throw e;
        }
        catch (ParseException e) {
            logger.error((Object)"\u89e3\u6790\u9519\u8bef", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            logger.error((Object)"IO\u5f02\u5e38", (Throwable)e);
            throw e;
        }
        catch (KeyManagementException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e);
            throw e;
        }
        finally {
            if (null != response) {
                try {
                    response.close();
                    httpClient.close();
                }
                catch (IOException e) {
                    logger.error((Object)"\u91ca\u653e\u8fde\u63a5\u51fa\u9519", (Throwable)e);
                }
            }
        }
        return entityStr;
    }

    public static CloseableHttpClient getHttpClientForHttps() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslcontext = HttpsClientUtil.createIgnoreVerifySSL();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        CloseableHttpClient client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
        return client;
    }

    public static void compatibleIgnore(HttpsURLConnection conn) {
        try {
            SSLContext sslContext = HttpsClientUtil.createIgnoreVerifySSL();
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            conn.setSSLSocketFactory(ssf);
            conn.setHostnameVerifier(new TrustAnyHostnameVerifier());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public static SSLContext createIgnoreVerifySSL() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sc = null;
        String javaVersion = System.getProperty("java.version");
        sc = !StringUtils.isEmpty((String)javaVersion) && javaVersion.contains("1.6.") ? SSLContext.getInstance("TLSv1") : SSLContext.getInstance("TLSv1.2");
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        sc.init(null, new TrustManager[]{trustManager}, new SecureRandom());
        return sc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String gethtml(String url) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        URL urlx = new URL(url);
        HttpsURLConnection uc = (HttpsURLConnection)urlx.openConnection();
        uc.setDoInput(true);
        uc.setUseCaches(false);
        uc.setRequestMethod("GET");
        uc.setInstanceFollowRedirects(false);
        uc.setConnectTimeout(10000);
        uc.setReadTimeout(10000);
        HttpsClientUtil.compatibleIgnore(uc);
        uc.setRequestProperty("Connection", "Keep-Alive");
        uc.setRequestProperty("Accept", "image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, application/msword, application/vnd.ms-excel, application/vnd.ms-powerpoint, application/x-shockwave-flash, */*");
        uc.setRequestProperty("Accept-Language", "zh-cn");
        uc.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.75 Safari/537.36");
        uc.setRequestProperty("Cookie", "");
        String vhtml = "";
        System.out.println(uc.getResponseCode());
        String htmltype = "utf-8";
        InputStream inputstream = null;
        BufferedReader bufferedreader = null;
        try {
            String s1;
            inputstream = uc.getInputStream();
            bufferedreader = htmltype == null || htmltype.trim().equals("") ? new BufferedReader(new InputStreamReader(inputstream)) : new BufferedReader(new InputStreamReader(inputstream, htmltype));
            while ((s1 = bufferedreader.readLine()) != null) {
                vhtml = vhtml + s1;
            }
            String string = vhtml;
            return string;
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (inputstream != null) {
                    inputstream.close();
                }
                if (bufferedreader != null) {
                    bufferedreader.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        return vhtml;
    }

    public static class TrustAnyHostnameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

