/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util.cloud.kbc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.ICloudRegistSrv;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.license.file.cloudRegist.CloudRegistUserInfo;
import com.kingdee.eas.base.license.file.cloudRegist.SynRegistUserInfo;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.SynStateEnum;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.permission.util.cloud.bean.CloudUserInfo;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class CloudLicenseUtil {
    private static Logger logger = Logger.getLogger(CloudLicenseUtil.class);
    public static boolean isRefreshSyncStatus = true;

    public static ILicenseSrvAgent getLicenseSrvAgent(Context ctx) throws BOSException {
        boolean isRemote = false;
        try {
            if (ctx == null) {
                isRemote = true;
                return LicenseSrvAgentFactory.getRemoteInstance();
            }
            return LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                if (isRemote) {
                    return LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
                }
                return LicenseSrvAgentFactory.getRemoteInstance();
            }
            catch (Exception ex) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    public static ICloudRegistSrv getCloudRegistSrvFromAgent(Context ctx) throws BOSException {
        try {
            if (ctx == null) {
                return CloudRegistSrvAgentFactory.getRemoteInstance();
            }
            return CloudRegistSrvAgentFactory.getLocalInstanceWithContext((Context)ctx);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean isCurValidityNotice(Context ctx) throws BOSException {
        UserInfo user = CloudLicenseUtil.getCurUser(ctx);
        if (user == null || !Administrator.isSuperCUAdmin((IObjectPK)new ObjectStringPK(user.getId().toString()))) {
            return false;
        }
        String erpNumber = user.getNumber();
        ILicenseSrvAgent licenseSrvAgent = CloudLicenseUtil.getLicenseSrvAgent(ctx);
        boolean isCurValidityNotice = licenseSrvAgent.isCurValidityNotice(erpNumber);
        if (isCurValidityNotice) {
            try {
                CloudLicenseUtil.batchOnLineUpdateLicense(ctx);
                isCurValidityNotice = licenseSrvAgent.isCurValidityNotice(erpNumber);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return isCurValidityNotice;
    }

    public static void validateNoticeOnce(Context ctx) throws BOSException {
        UserInfo user = CloudLicenseUtil.getCurUser(ctx);
        if (user == null) {
            return;
        }
        String erpNumber = user.getNumber();
        ILicenseSrvAgent licenseSrvAgent = CloudLicenseUtil.getLicenseSrvAgent(ctx);
        licenseSrvAgent.validateNoticeOnce(erpNumber);
    }

    public static long getValidateEffectDays(Context ctx) throws BOSException {
        ILicenseSrvAgent licenseSrvAgent = CloudLicenseUtil.getLicenseSrvAgent(ctx);
        return licenseSrvAgent.getValidateEffectDays();
    }

    private static UserInfo getCurUser(Context ctx) throws BOSException {
        UserInfo currentUser = null;
        try {
            if (ctx == null) {
                currentUser = ToolUtils.getCurrentUser();
            } else {
                IObjectPK pk = ctx.getCaller();
                if (pk == null) {
                    pk = ContextUtils.getContextFromSession().getCaller();
                }
                currentUser = UserFactory.getLocalInstance(ctx).getUserInfo(pk);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return currentUser;
    }

    public static LicenseBaseInfo getLicenseBaseInfo(Context ctx) throws BOSException {
        try {
            return CloudLicenseUtil.getLicenseSrvAgent(ctx).getLicenseBaseInfo();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static int getLicenseType(Context ctx) throws BOSException {
        try {
            return CloudLicenseUtil.getLicenseBaseInfo(ctx).getLicenseType();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String getProductInstanceID(Context ctx) throws BOSException {
        try {
            return CloudLicenseUtil.getLicenseBaseInfo(ctx).getProductID();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static List<String> getOtherProductInstanceIDs(Context ctx) throws BOSException {
        ArrayList<String> productIds = new ArrayList<String>();
        try {
            List notDefaultLicenseBaseInfos = CloudLicenseUtil.getLicenseSrvAgent(ctx).getNotDefaultLicenseBaseInfos(false);
            for (LicenseBaseInfo info : notDefaultLicenseBaseInfos) {
                productIds.add(info.getProductInstanceID());
            }
            return productIds;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean isKBCLicense(Context ctx) throws BOSException {
        try {
            return 2 == CloudLicenseUtil.getLicenseType(ctx);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void batchOnLineUpdateLicense(Context ctx) throws BOSException {
        try {
            List allLicenseBaseInfos = CloudLicenseUtil.getLicenseSrvAgent(ctx).getAllLicenseBaseInfos(false);
            for (LicenseBaseInfo baseInfo : allLicenseBaseInfos) {
                CloudLicenseUtil.onLineUpdateLicense(ctx, baseInfo);
            }
        }
        catch (LicenseException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void onLineUpdateLicense(Context ctx, LicenseBaseInfo baseInfo) throws BOSException {
        try {
            String downloadLicenseFile = CloudLicenseUtil.downloadLicenseFile(baseInfo);
            String licenseFileId = String.valueOf(System.currentTimeMillis());
            CloudLicenseUtil.uploadLicenseFile(ctx, licenseFileId, downloadLicenseFile);
            CloudLicenseUtil.getCloudRegistSrvFromAgent(ctx).getRebelLicenseStatus(licenseFileId);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static String downloadLicenseFile(LicenseBaseInfo baseInfo) throws Exception {
        try {
            String prod_inst_code = baseInfo.getProductInstanceID();
            File file = File.createTempFile(System.currentTimeMillis() + "", ".zip");
            if (2 == baseInfo.getLicenseType()) {
                EasCloud.downloadLicenseKBC((String)prod_inst_code, (String)file.getPath());
            } else {
                EasCloud.downloadLicense((String)prod_inst_code, (String)file.getPath());
            }
            return file.getPath();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void onLineUpdateLicense(Context ctx) throws BOSException {
        LicenseBaseInfo baseInfo = CloudLicenseUtil.getLicenseBaseInfo(ctx);
        CloudLicenseUtil.onLineUpdateLicense(ctx, baseInfo);
    }

    public static String downloadLicenseFile(Context ctx) throws Exception {
        LicenseBaseInfo baseInfo = CloudLicenseUtil.getLicenseBaseInfo(ctx);
        return CloudLicenseUtil.downloadLicenseFile(baseInfo);
    }

    public static void uploadLicenseFile(Context ctx, String fileId, String licenseFilePath) throws BOSException {
        InputStream input = null;
        try {
            String fileName = licenseFilePath;
            String extName = ".zip";
            if (!StringUtils.isEmpty((String)fileName)) {
                if ((fileName = fileName.toLowerCase()).lastIndexOf(".dat") != -1) {
                    extName = fileName.substring(fileName.lastIndexOf(".dat"));
                } else if (fileName.lastIndexOf(".lic") != -1) {
                    extName = fileName.substring(fileName.lastIndexOf(".lic"));
                }
            }
            input = new BufferedInputStream(new FileInputStream(licenseFilePath));
            int position = 0;
            int readSize = 0x500000;
            int totalSize = input.available();
            readSize = readSize < totalSize ? readSize : totalSize;
            ICloudRegistSrv irs = CloudLicenseUtil.getCloudRegistSrvFromAgent(ctx);
            while (position < totalSize) {
                byte[] bf = new byte[readSize];
                input.read(bf, 0, readSize);
                irs.uploadCloudLicenseFile(fileId, bf, extName);
                readSize = totalSize - (position += readSize) < readSize ? totalSize - position : readSize;
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1);
            throw new BOSException((Throwable)e1);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception e2) {
                    logger.error((Object)e2);
                }
            }
        }
    }

    public static Map getRebelLicenseStatus(Context ctx, String licenseFileId) throws BOSException {
        try {
            String rebelLicenseStatusRt = CloudLicenseUtil.getCloudRegistSrvFromAgent(ctx).getRebelLicenseStatus(licenseFileId);
            Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
            Map statusMap = (Map)gson.fromJson(rebelLicenseStatusRt, Map.class);
            return statusMap;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean rebelLicense(Context ctx, String licenseFileId) throws BOSException {
        try {
            Map rebelLicenseStatusRt = CloudLicenseUtil.getRebelLicenseStatus(ctx, licenseFileId);
            Boolean isSuccess = (Boolean)rebelLicenseStatusRt.get("success");
            return isSuccess;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void synUsersAndGroups(Context ctx, List<CloudUserInfo> cloudUsers) throws BOSException {
        try {
            ICloudRegistSrv ICloudRegistSrv2 = CloudLicenseUtil.getCloudRegistSrvFromAgent(ctx);
            List<SynRegistUserInfo> synRegistUserS = CloudLicenseUtil.covertToSynRegistUserS(cloudUsers);
            ICloudRegistSrv2.synUsersAndGroups(synRegistUserS);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static List<SynRegistUserInfo> covertToSynRegistUserS(List<CloudUserInfo> synUserList) {
        ArrayList<SynRegistUserInfo> list = new ArrayList<SynRegistUserInfo>();
        for (CloudUserInfo cloudUserInfo : synUserList) {
            SynRegistUserInfo synRegistUserInfo = new SynRegistUserInfo();
            synRegistUserInfo.setDelete(1 == cloudUserInfo.getIs_delete());
            synRegistUserInfo.setErpNumber(cloudUserInfo.getErp_account());
            HashSet<Object> groups = new HashSet();
            String prod_group = cloudUserInfo.getProd_group();
            if (!StringUtils.isEmpty((String)prod_group)) {
                String[] prod_groups = StringUtils.split((String)prod_group, (String)";");
                groups = new HashSet<String>(Arrays.asList(prod_groups));
            }
            synRegistUserInfo.setGroup(groups);
            synRegistUserInfo.setPhone(cloudUserInfo.getPhone());
            synRegistUserInfo.setErpStaffNumber(cloudUserInfo.getMid());
            list.add(synRegistUserInfo);
        }
        return list;
    }

    public static void refreshUserSyncStatus(Context ctx, IObjectPK pk) throws BOSException {
        IUser iuser = null;
        iuser = ctx != null ? UserFactory.getLocalInstance(ctx) : UserFactory.getRemoteInstance();
        UserCollection userCollection = iuser.getUserCollection("select id,number,isSynToCloud,uid,isDelete,isForbidden,type,cell,email where id = '" + pk.toString() + "'");
        CloudLicenseUtil.batchCheckUserSyncStatus(ctx, userCollection);
    }

    public static void refreshUserSyncStatus(Context ctx) throws BOSException {
        if (!isRefreshSyncStatus) {
            return;
        }
        IUser iuser = null;
        iuser = ctx != null ? UserFactory.getLocalInstance(ctx) : UserFactory.getRemoteInstance();
        UserCollection userCollection = iuser.getUserCollection("select id,number,isSynToCloud,uid,isDelete,isForbidden,type,cell,email");
        CloudLicenseUtil.batchCheckUserSyncStatus(ctx, userCollection);
    }

    private static void batchCheckUserSyncStatus(Context ctx, UserCollection userCollection) throws BOSException {
        if (userCollection == null || userCollection.size() < 1) {
            return;
        }
        ConcurrentHashMap concurrentRegistMap = CloudLicenseUtil.getCloudRegistSrvFromAgent(ctx).getRegistMap();
        if (concurrentRegistMap == null) {
            return;
        }
        HashMap registMap = new HashMap(concurrentRegistMap);
        boolean isKBC = 2 == CloudLicenseUtil.getLicenseType(ctx);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (int i = 0; i < userCollection.size(); ++i) {
            UserInfo userInfo = userCollection.get(i);
            if (!CloudLicenseUtil.isNeedSyncUser(userInfo)) continue;
            CloudRegistUserInfo cloudRegistUserInfo = (CloudRegistUserInfo)registMap.get(userInfo.getNumber().toLowerCase());
            if (SynStateEnum.SYN_YES == userInfo.getIsSynToCloud()) {
                if (CloudLicenseUtil.checkSyncStatus(userInfo, cloudRegistUserInfo)) continue;
                paramsList.add(new Object[]{0, userInfo.getId().toString()});
                continue;
            }
            if (!isKBC || CloudLicenseUtil.checkNotSyncStatus(userInfo, cloudRegistUserInfo)) continue;
            paramsList.add(new Object[]{1, userInfo.getId().toString()});
        }
        if (paramsList != null && !paramsList.isEmpty()) {
            DbUtil.executeBatch((Context)ctx, (String)"update t_pm_user set fIsSynToCloud= ? where fid= ?", paramsList);
        }
    }

    public static boolean isNeedSyncUser(UserInfo userInfo) {
        String number = userInfo.getNumber();
        if (StringUtils.isEmpty((String)number)) {
            return false;
        }
        return !"administrator".equalsIgnoreCase(number = number.toLowerCase()) && !"user".equalsIgnoreCase(number) && !"authenadmin".equalsIgnoreCase(number) && !"sscadmin".equalsIgnoreCase(number) && !"auditadmin".equalsIgnoreCase(number) && !"virtualuser".equalsIgnoreCase(number) && 10 != userInfo.getType().getValue() && 60 != userInfo.getType().getValue() && 70 != userInfo.getType().getValue();
    }

    public static boolean checkSyncStatus(UserInfo userInfo, CloudRegistUserInfo cloudRegistUserInfo) {
        if (userInfo.isIsForbidden() || userInfo.isIsDelete()) {
            if (cloudRegistUserInfo != null && !StringUtils.isEmpty((String)cloudRegistUserInfo.getCloudUuId())) {
                return false;
            }
        } else {
            if (cloudRegistUserInfo == null || StringUtils.isEmpty((String)cloudRegistUserInfo.getCloudUuId()) || !cloudRegistUserInfo.getCloudUuId().equals(userInfo.getUid())) {
                return false;
            }
            String phone = cloudRegistUserInfo.getPhone();
            String email = cloudRegistUserInfo.getEmail();
            if (StringUtils.isEmpty((String)phone) && StringUtils.isEmpty((String)email)) {
                return true;
            }
            if (!StringUtils.isEmpty((String)phone) || !StringUtils.isEmpty((String)email)) {
                String userEmail;
                String userPhone = userInfo.getCell() == null ? "" : userInfo.getCell();
                String string = userEmail = userInfo.getEmail() == null ? "" : userInfo.getEmail();
                if (phone.contains("@") && !phone.equalsIgnoreCase(userEmail)) {
                    return false;
                }
                if (StringUtils.isEmpty((String)email)) {
                    if (!phone.trim().replaceFirst("\\+", "").equals(userPhone.trim().replaceFirst("\\+", ""))) {
                        logger.error((Object)("userNumber, userCell, phone is " + userInfo.getNumber() + " " + userPhone + " " + phone));
                        return false;
                    }
                } else if (!phone.trim().replaceFirst("\\+", "").equals(userPhone.trim().replaceFirst("\\+", "")) || !email.equalsIgnoreCase(userEmail)) {
                    logger.error((Object)("userNumber, userCell, phone, userEmail, email is " + userInfo.getNumber() + " " + userPhone + " " + phone + " " + userEmail + " " + email));
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean checkNotSyncStatus(UserInfo userInfo, CloudRegistUserInfo cloudRegistUserInfo) {
        if (userInfo.isIsForbidden() || userInfo.isIsDelete()) {
            if (cloudRegistUserInfo == null || StringUtils.isEmpty((String)cloudRegistUserInfo.getCloudUuId())) {
                return false;
            }
        } else if (cloudRegistUserInfo != null && !StringUtils.isEmpty((String)cloudRegistUserInfo.getCloudUuId()) && cloudRegistUserInfo.getCloudUuId().equals(userInfo.getUid())) {
            String phone = cloudRegistUserInfo.getPhone();
            String email = cloudRegistUserInfo.getEmail();
            if (StringUtils.isEmpty((String)phone) && StringUtils.isEmpty((String)email)) {
                return true;
            }
            if (!StringUtils.isEmpty((String)phone) || !StringUtils.isEmpty((String)email)) {
                String userEmail;
                String userPhone = userInfo.getCell() == null ? "" : userInfo.getCell();
                String string = userEmail = userInfo.getEmail() == null ? "" : userInfo.getEmail();
                if (phone.contains("@") && phone.equalsIgnoreCase(userEmail)) {
                    return false;
                }
                if (StringUtils.isEmpty((String)email) ? phone.trim().replaceFirst("\\+", "").equals(userPhone.trim().replaceFirst("\\+", "")) : phone.trim().replaceFirst("\\+", "").equals(userPhone.trim().replaceFirst("\\+", "")) && email.equalsIgnoreCase(userEmail)) {
                    return false;
                }
            }
        }
        return true;
    }
}

