/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.engine.rows.impl;

import com.kingdee.bos.ctrl.common.util.list.FileBasedList;
import com.kingdee.bos.ctrl.common.util.list.exception.ReadObjectFaildException;
import com.kingdee.bos.ctrl.common.util.list.exception.WriteObjectFailedException;
import com.kingdee.bos.ctrl.reportone.data.engine.rows.impl.PlaceholderRow;
import com.kingdee.bos.ctrl.reportone.data.engine.rows.impl.Row;
import com.kingdee.bos.ctrl.reportone.data.engine.rows.impl.SimpleRowsMetaData;
import java.io.IOException;

public class FileStoredRowList
extends FileBasedList {
    protected SimpleRowsMetaData meta;

    public FileStoredRowList(String filePath, SimpleRowsMetaData columnInfoes) throws IOException {
        super(filePath);
        this.meta = columnInfoes;
    }

    protected int pureGetObjectStoreSize(Object obj) {
        return ((Row)obj).getSize();
    }

    protected Object pureReadObject(int position, int size) {
        if (size == 0) {
            return PlaceholderRow.instance;
        }
        byte[] bytes = null;
        try {
            bytes = super.readBytes(position, size);
        }
        catch (IOException ex) {
            throw new ReadObjectFaildException("Read row/object failed, IOException:'" + ex.toString() + "'");
        }
        Row row = new Row(this.meta);
        if (!row.loadByBytes(bytes)) {
            throw new ReadObjectFaildException("Read row/object failed.loadBytes failed.");
        }
        bytes = null;
        return row;
    }

    protected int pureWriteObject(int position, Object obj) {
        Row row = (Row)obj;
        try {
            if (row instanceof PlaceholderRow) {
                return 0;
            }
            byte[] bytes = row.toBytes();
            super.writeBytes(position, bytes);
            row.clearCachedBytes();
            return bytes.length;
        }
        catch (IOException ex) {
            throw new WriteObjectFailedException("Write row/object failed,IOException:" + ex.toString());
        }
    }
}

