/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.engine.rowsfile;

import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.bos.ctrl.common.util.Queue;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ResultSet2Reader {
    private ResultSet resultSet;
    private Queue upperRowsCache = new Queue();
    private Queue lowerRowsCache = new Queue();
    private int upperRowsLeft;
    private int lowerRowsLeft;
    private int separatorRow;
    private int readCache;
    private int rowsCount;

    public ResultSet2Reader(ResultSet resultSet, int rsRows, int separatorRow, int readCache) {
        this.separatorRow = this.upperRowsLeft = separatorRow;
        this.lowerRowsLeft = rsRows - separatorRow;
        this.resultSet = resultSet;
        this.readCache = readCache;
        this.rowsCount = rsRows;
    }

    private final int readRows(Queue rowsQueue, int from) throws IOException, SQLException {
        if (!this.resultSet.absolute(from + 1)) {
            return 0;
        }
        for (int i = 0; i < this.readCache; ++i) {
            Object[] row = DBUtil.readRow((ResultSet)this.resultSet);
            rowsQueue.enqueue((Object)row);
            if (this.resultSet.next()) continue;
            return i + 1;
        }
        return this.readCache;
    }

    public Object[] nextUpperRow() throws IOException, SQLException {
        if (this.upperRowsLeft <= 0) {
            return null;
        }
        if (this.upperRowsCache.isEmpty()) {
            this.readRows(this.upperRowsCache, this.separatorRow - this.upperRowsLeft);
        }
        --this.upperRowsLeft;
        return (Object[])this.upperRowsCache.dequeue();
    }

    public Object[] nextLowerRow() throws IOException, SQLException {
        if (this.lowerRowsLeft <= 0) {
            return null;
        }
        if (this.lowerRowsCache.isEmpty()) {
            this.readRows(this.lowerRowsCache, this.rowsCount - this.lowerRowsLeft);
        }
        --this.lowerRowsLeft;
        return (Object[])this.lowerRowsCache.dequeue();
    }
}

