/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.process.dataset.group;

import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.bos.ctrl.reportone.data.engine.resultset.IRowNode;
import com.kingdee.bos.ctrl.reportone.data.engine.resultset.SimpleResultSetMetaData;
import com.kingdee.bos.ctrl.reportone.data.engine.resultset.SimpleRowNode;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.GroupNode;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.GroupTree;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.TotalRowInfo;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.VMTotalParam;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.aggregate.IAggregate;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.defs.GroupTotalDef;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.defs.GroupTotalDefs;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.resultset.GroupTotalDetailsNode;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.resultset.GroupTotalResultSet;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;

public class GroupTotalSummary {
    private GroupTree groupTree;
    private GroupTotalDefs gtDefs;
    private TotalRowInfo[] totalRowInfoes;
    private HashMap groupNodeMap = new HashMap();
    private boolean solvedGTDefs = false;

    public GroupTotalSummary(GroupTree groupTree, GroupTotalDefs gtDefs) {
        this.groupTree = groupTree;
        this.gtDefs = gtDefs;
        this.initSummary();
    }

    private TotalRowInfo getTotalRowInfo(GroupNode groupNode) {
        return (TotalRowInfo)this.groupNodeMap.get(groupNode);
    }

    private final void initSummary() {
        TotalRowInfo info;
        GroupNode curGroup;
        long l0 = System.currentTimeMillis();
        if (this.groupTree.getRecords() < 1) {
            return;
        }
        if (this.groupTree.getSubGroups() != null && this.groupTree.getSubGroups().size() < 1) {
            return;
        }
        Stack<GroupTree> groups = new Stack<GroupTree>();
        groups.push(this.groupTree);
        Stack<GroupNode> parents = new Stack<GroupNode>();
        parents.push(null);
        int maxLevel = this.gtDefs.levels();
        int curLevel = 0;
        int lastFrom = 0;
        int lastRows = -1;
        ArrayList<TotalRowInfo> summaryAl = new ArrayList<TotalRowInfo>();
        block0: while (true) {
            curGroup = (GroupNode)groups.pop();
            GroupNode parent = (GroupNode)parents.peek();
            if (parent != null && curGroup.getParent() != parent) {
                parents.pop();
                info = new TotalRowInfo(++lastRows, lastFrom - parent.getRecords(), parent.getRecords(), --curLevel);
                summaryAl.add(info);
                this.groupNodeMap.put(parent, info);
            }
            if (curLevel < maxLevel) {
                ++curLevel;
                parents.push(curGroup);
                ArrayList children = curGroup.getSubGroups();
                int i = children.size() - 1;
                while (true) {
                    if (i < 0) continue block0;
                    groups.push((GroupTree)children.get(i));
                    --i;
                }
            }
            info = new TotalRowInfo(lastRows += curGroup.getRecords() + 1, lastFrom, curGroup.getRecords(), curLevel);
            if (curLevel != 0 || curLevel == 0 && this.gtDefs.getRootTotalDef().totals() > 0) {
                summaryAl.add(info);
                this.groupNodeMap.put(curGroup, info);
            }
            lastFrom += curGroup.getRecords();
            if (groups.isEmpty()) break;
        }
        while (!parents.isEmpty()) {
            --curLevel;
            curGroup = (GroupNode)parents.pop();
            if (curGroup == null || curGroup.getParent() == null && this.gtDefs.getRootTotalDef().totals() <= 0) continue;
            info = new TotalRowInfo(++lastRows, lastFrom - curGroup.getRecords(), curGroup.getRecords(), curLevel);
            summaryAl.add(info);
            this.groupNodeMap.put(curGroup, info);
        }
        this.totalRowInfoes = new TotalRowInfo[summaryAl.size()];
        summaryAl.toArray(this.totalRowInfoes);
    }

    public final int getRowCount() {
        if (this.totalRowInfoes == null || this.totalRowInfoes.length == 0) {
            return this.groupTree.getRecords();
        }
        return this.totalRowInfoes[this.totalRowInfoes.length - 1].targetRow + 1;
    }

    public final GroupTree getGroupTree() {
        return this.groupTree;
    }

    public final TotalRowInfo[] getTotalRowInfoes() {
        return this.totalRowInfoes;
    }

    private final int[] computeFirstLeft(int first_totalIdx, int end_totalIdx) {
        int[] left = new int[this.gtDefs.levels() + 1];
        for (int i = 0; i < left.length; ++i) {
            left[i] = -1;
        }
        int needCal = left.length;
        for (int totalIdx = first_totalIdx; totalIdx <= end_totalIdx; ++totalIdx) {
            if (left[this.totalRowInfoes[totalIdx].level] != -1) continue;
            left[this.totalRowInfoes[totalIdx].level] = this.totalRowInfoes[totalIdx].dependRecords;
            if (--needCal == 0) break;
        }
        return left;
    }

    public final void destroy() {
        this.groupTree.detroy();
    }

    public final int[] getTargetRowsInfo(GroupNode groupNode) {
        TotalRowInfo info = this.getTotalRowInfo(groupNode);
        int gFrom = -1;
        int gLast = -1;
        int gCount = -1;
        if (info == null) {
            if (groupNode == this.groupTree && this.gtDefs.getRootTotalDef().totals() == 0) {
                gFrom = 0;
                if (this.getRowCount() > 0) {
                    gLast = this.getRowCount() - 1;
                    gCount = gLast + 1;
                } else {
                    gLast = 0;
                    gCount = 0;
                }
            }
        } else {
            VMTotalParam vm = VMTotalParam.parse(this.totalRowInfoes, info.targetRow, info.targetRow);
            gFrom = this.totalRowInfoes[vm.totalIdx].targetRow - this.totalRowInfoes[vm.totalIdx].dependRecords;
            gLast = info.targetRow;
            gCount = gLast - gFrom + 1;
        }
        return new int[]{gFrom, gLast, gCount};
    }

    public final IRowNode getTargetRows(GroupNode groupNode, int from, int to) throws Exception {
        if (this.getRowCount() < 1) {
            return null;
        }
        int count = to - from + 1;
        int[] rowsInfo = this.getTargetRowsInfo(groupNode);
        if (from < 0 || to < 0 || count <= 0) {
            throw new IllegalArgumentException("bad parameter. from = " + from + ",count = " + count + ",to=" + to);
        }
        if (from > rowsInfo[2] - 1) {
            throw new IllegalArgumentException("bad parameter. from =" + from);
        }
        int left = rowsInfo[2] - from;
        if (count > left) {
            count = left;
        }
        int gFrom = rowsInfo[0] + from;
        int gLast = gFrom + count - 1;
        return this.getTargetRows(gFrom, gLast);
    }

    public final IRowNode getTargetRows(int from, int to) throws Exception {
        SimpleRowNode firstRecord;
        int topLevel;
        if (!this.solvedGTDefs) {
            this.gtDefs.solveGroupTotalDef(this.groupTree.getDetails());
            this.solvedGTDefs = true;
        }
        if (this.getRowCount() < 1) {
            return null;
        }
        SimpleRowNode rootTotal = null;
        int n = topLevel = this.gtDefs.getRootTotalDef().totals() > 0 ? 0 : 1;
        if (to == this.getRowCount() - 1 && this.groupTree.getTotalResult() != null) {
            Object[] rootTotalResults = this.groupTree.getTotalResult();
            Object[] temp = new Object[rootTotalResults.length + 1];
            System.arraycopy(rootTotalResults, 0, temp, 0, rootTotalResults.length);
            temp[temp.length - 1] = GroupTotalSummary.makeTagsString(null, 0);
            rootTotal = new SimpleRowNode();
            rootTotal.setRowData(temp);
            if (to == from) {
                return rootTotal;
            }
            --to;
            topLevel = 1;
        }
        ResultSet details = this.groupTree.getDetails();
        int defLevels = this.gtDefs.levels();
        int colCount = details.getMetaData().getColumnCount();
        VMTotalParam vmt = this.totalRowInfoes == null || this.totalRowInfoes.length == 0 ? null : VMTotalParam.parse(this.totalRowInfoes, from, to);
        IAggregate[][] totalss = this.gtDefs.createAggregatess(colCount);
        int leftRows = to - from + 1 + (vmt == null ? 0 : vmt.offset);
        SimpleRowNode lastRecord = firstRecord = new SimpleRowNode();
        GroupTotalDetailsNode detailsNode = null;
        int readFrom = vmt == null ? from : this.totalRowInfoes[vmt.totalIdx].dependFrom;
        int[] tags = GroupNode.getLastedGroupTag(this.groupTree.getLastedGroup(readFrom), defLevels);
        int[] groupRowsLeft = vmt == null ? null : this.computeFirstLeft(vmt.totalIdx, vmt.endTotalIdx);
        details.absolute(readFrom + 1);
        int needReadRows = vmt == null ? to - from + 1 : vmt.records;
        for (int read = 0; read < needReadRows; ++read) {
            int level;
            Object[] datas = DBUtil.readRow((ResultSet)details);
            details.next();
            if (detailsNode == null) {
                detailsNode = new GroupTotalDetailsNode(details, readFrom + 1 + read, GroupTotalSummary.makeTagsString(tags, -1));
                lastRecord.setNext(detailsNode);
                lastRecord = detailsNode;
            }
            detailsNode.addRows();
            if (--leftRows == 0) break;
            for (level = defLevels; level >= topLevel; --level) {
                Object[] totalResults = null;
                int n2 = level;
                groupRowsLeft[n2] = groupRowsLeft[n2] - 1;
                if (groupRowsLeft[n2] == 0) {
                    totalResults = new Object[colCount + 1];
                }
                GroupTotalDef gtDef = this.gtDefs.getGroupTotalDef(level);
                for (int total = 0; total < gtDef.totals(); ++total) {
                    IAggregate funcObj = totalss[level][total];
                    if (funcObj == null) continue;
                    funcObj.peekData(datas[gtDef.getTotalDef(total).getTotalCol() - 1]);
                    if (groupRowsLeft[level] != 0) continue;
                    totalResults[gtDef.getTotalDef((int)total).getTotalCol() - 1] = funcObj.getValue();
                    funcObj.reset();
                }
                if (groupRowsLeft[level] != 0) continue;
                if (detailsNode != null) {
                    detailsNode = null;
                }
                SimpleRowNode t = new SimpleRowNode();
                totalResults[colCount] = GroupTotalSummary.makeTagsString(tags, level);
                t.setRowData(totalResults);
                lastRecord.setNext(t);
                lastRecord = t;
                ++vmt.totalIdx;
                if (--leftRows == 0) break;
            }
            for (level = topLevel; level <= defLevels; ++level) {
                int i;
                if (groupRowsLeft[level] != 0) continue;
                for (i = vmt.totalIdx; i < this.totalRowInfoes.length; ++i) {
                    if (this.totalRowInfoes[i].level != level) continue;
                    groupRowsLeft[level] = this.totalRowInfoes[i].dependRecords;
                    break;
                }
                int n3 = level;
                tags[n3] = tags[n3] + 1;
                for (i = level + 1; i <= defLevels; ++i) {
                    tags[i] = 0;
                }
            }
        }
        if (rootTotal != null) {
            lastRecord.setNext(rootTotal);
        }
        int offset = (vmt == null ? 0 : vmt.offset) + 1;
        while (offset-- > 0) {
            firstRecord = (SimpleRowNode)firstRecord.nextRow();
        }
        return firstRecord;
    }

    public final ResultSet resultset() throws SQLException {
        return new GroupTotalResultSet(this, this.groupTree);
    }

    public final ResultSet getResultSet(GroupNode groupNode) throws SQLException {
        return new GroupTotalResultSet(this, groupNode);
    }

    public final ResultSetMetaData makeTargetMetaData() throws SQLException {
        SimpleResultSetMetaData metaData = new SimpleResultSetMetaData(this.groupTree.getDetails().getMetaData());
        metaData.addColumn(metaData.getColumnCount() + 1, "groupTotalTAG", 12);
        return metaData;
    }

    public static final String makeTagsString(int[] tags, int gtLevel) {
        boolean addTotalTag;
        StringBuffer sb = new StringBuffer();
        boolean bl = addTotalTag = gtLevel != -1;
        gtLevel = addTotalTag ? ++gtLevel : tags.length;
        for (int level = 1; level < gtLevel; ++level) {
            sb.append(tags[level]);
            sb.append('.');
        }
        if (addTotalTag) {
            sb.append("t");
        } else if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

