/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.process.dataset.group;

import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.TotalRowInfo;

public class VMTotalParam {
    int records;
    boolean lastNeedTotal;
    int offset;
    int totalIdx;
    int endTotalIdx;
    private TotalRowInfo[] summaries;

    private VMTotalParam(TotalRowInfo[] summaries) {
        this.summaries = summaries;
    }

    public static VMTotalParam create(int records, int offset, int totalIdx, boolean lastNeedTotal) {
        VMTotalParam v = new VMTotalParam(null);
        v.records = records;
        v.offset = offset;
        v.totalIdx = totalIdx;
        v.lastNeedTotal = lastNeedTotal;
        return v;
    }

    public String toString() {
        String s = "";
        s = s + "first total:" + this.totalIdx;
        s = s + "\nread records:" + this.records;
        s = s + "\ntarget offset:" + this.offset;
        s = s + "\nlast need total:" + this.lastNeedTotal;
        return s;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof VMTotalParam) {
            VMTotalParam v = (VMTotalParam)o;
            return v.offset == this.offset && v.records == this.records && v.totalIdx == this.totalIdx;
        }
        return false;
    }

    public final int searchTargetRow(int targetRow) {
        int _count = this.summaries.length;
        if (_count == 0) {
            return 0;
        }
        int low = 0;
        int high = _count - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            if (this.summaries[mid].targetRow < targetRow) {
                low = mid + 1;
                continue;
            }
            if (this.summaries[mid].targetRow > targetRow) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low;
    }

    public static final VMTotalParam parse(TotalRowInfo[] summaries, int targetRow0, int targetRow2) {
        int total;
        int headTotal;
        VMTotalParam vt = new VMTotalParam(summaries);
        int totalIdx = vt.searchTargetRow(targetRow0);
        if (totalIdx == -1) {
            return null;
        }
        vt.endTotalIdx = headTotal = totalIdx;
        for (int total2 = totalIdx; total2 < summaries.length; ++total2) {
            if (summaries[headTotal].dependFrom > summaries[total2].dependFrom) {
                headTotal = total2;
            }
            if (summaries[total2].targetRow < targetRow2) continue;
            vt.lastNeedTotal = summaries[total2].targetRow == targetRow2;
            vt.endTotalIdx = total2;
            break;
        }
        int readFrom = -1;
        vt.totalIdx = 0;
        for (int total3 = headTotal - 1; total3 >= 0; --total3) {
            if (vt.dependsContain(headTotal, total3)) continue;
            readFrom = summaries[headTotal].dependFrom;
            vt.offset = targetRow0 - (summaries[total3].targetRow + 1);
            break;
        }
        if (readFrom == -1) {
            readFrom = 0;
            vt.offset = targetRow0;
        }
        vt.records = 0;
        int lastR = -1;
        for (total = headTotal; total <= vt.endTotalIdx; ++total) {
            if (summaries[total].dependFrom <= lastR) continue;
            lastR = summaries[total].dependFrom;
            vt.records += summaries[total].dependRecords;
        }
        if (!vt.lastNeedTotal) {
            vt.records -= summaries[vt.endTotalIdx].targetRow - 1 - targetRow2;
        }
        for (total = 0; total <= headTotal; ++total) {
            if (readFrom != summaries[total].dependFrom) continue;
            vt.totalIdx = total;
            break;
        }
        return vt;
    }

    public final boolean dependsContain(int total0, int total1) {
        return this.summaries[total0].dependFrom <= this.summaries[total1].dependFrom && this.summaries[total0].dependRecords >= this.summaries[total1].dependRecords;
    }
}

