/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.wizard.common;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.reportone.data.modal.query.Column;
import com.kingdee.bos.ctrl.reportone.data.modal.query.Condition;
import com.kingdee.bos.ctrl.reportone.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.reportone.data.modal.query.design.DesignedFilter;
import com.kingdee.bos.ctrl.reportone.data.modal.query.design.DesignedFilterList;
import com.kingdee.bos.ctrl.reportone.data.wizard.Wizard2Resource;
import com.kingdee.bos.ctrl.reportone.data.wizard.common.CommonFilterPanel;
import com.kingdee.bos.ctrl.reportone.data.wizard.formula.FormulaEditorDialog;
import com.kingdee.bos.ctrl.reportone.data.wizard.formula.FormulaWizardEditor;
import com.kingdee.bos.ctrl.reportone.data.wizard.query.QueryResource;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComboBox;

public abstract class AbstractFilterPaneWrapper {
    private FilterPanel _filterPanel = new FilterPanel();
    private KDWorkButton _btnFormula;
    protected KDComboBox _cmbExpress;
    protected KDComboBox _cmbValue;
    private FormulaWizardEditor _formula;
    public static final int COL_LEFT_BRACKET = 0;
    public static final int COL_EXPRESS = 1;
    public static final int COL_OPERATE = 2;
    public static final int COL_VALUE = 3;
    public static final int COL_RIGHT_BRACKET = 4;
    public static final int COL_LOGIC = 5;

    public AbstractFilterPaneWrapper() {
        this.init();
        this.installListener();
    }

    public KDPanel getPanel() {
        return this._filterPanel;
    }

    protected KDTable getTable() {
        return this._filterPanel.getTable();
    }

    private void init() {
        this._btnFormula = new KDWorkButton((Icon)Resource.ICON_FORMULA_WIZARD);
        this._btnFormula.setToolTipText(Wizard2Resource.getString("res_1"));
        this._filterPanel.addButton(this._btnFormula, 1);
        this._cmbExpress = new KDComboBox();
        this._cmbExpress.setEditable(true);
        KDTDefaultCellEditor ceExpress = new KDTDefaultCellEditor((JComboBox)this._cmbExpress);
        this.getTable().getColumn(1).setEditor((ICellEditor)ceExpress);
        this._cmbValue = new KDComboBox();
        this._cmbValue.setEditable(true);
        KDTDefaultCellEditor ceValue = new KDTDefaultCellEditor((JComboBox)this._cmbValue);
        this.getTable().getColumn(3).setEditor((ICellEditor)ceValue);
    }

    private void installListener() {
        FormulaButtonHandler buttonActionHandler = new FormulaButtonHandler();
        this._btnFormula.addActionListener((ActionListener)buttonActionHandler);
    }

    protected FormulaWizardEditor getFormulaWizard() {
        if (this._formula == null) {
            this._formula = new FormulaWizardEditor();
            this._formula.setTitle(Wizard2Resource.getString("res_2"));
            this.initFormulaWizard(this._formula);
        }
        return this._formula;
    }

    protected abstract void initFormulaWizard(FormulaWizardEditor var1);

    protected String getColExpressString(Object value) {
        if (value instanceof Column) {
            return ((Column)((Object)value)).getExpr();
        }
        if (value != null) {
            return value.toString().trim();
        }
        return null;
    }

    protected Object getColExpressCellValue(String expr) {
        int c = this._cmbExpress.getItemCount();
        for (int i = 0; i < c; ++i) {
            Object item = this._cmbExpress.getItemAt(i);
            if (!(item instanceof Column) || !StringUtil.equals((String)((Column)((Object)item)).getExpr(), (String)expr)) continue;
            return item;
        }
        return expr;
    }

    protected String getColValueString(Object value) {
        if (value instanceof MetaField) {
            return "@" + ((MetaField)value).getName();
        }
        if (value != null) {
            return value.toString().trim();
        }
        return null;
    }

    protected Object getColValueCellValue(String value) {
        int c = this._cmbValue.getItemCount();
        for (int i = 0; i < c; ++i) {
            Object item = this._cmbValue.getItemAt(i);
            if (!(item instanceof MetaField) || !StringUtil.equals((String)("@" + ((MetaField)item).getName()), (String)value)) continue;
            return item;
        }
        return value;
    }

    public void setExpressSupply(List supplyData) {
        this._cmbExpress.removeAllItems();
        this._cmbExpress.addItems(supplyData.toArray());
    }

    public void setValueSupply(List supplyData) {
        this._cmbValue.removeAllItems();
        this._cmbValue.addItems(supplyData.toArray());
    }

    public abstract void setFormulaWizardSupply(IQuery var1, CommonFilterPanel.IMetaProvider var2);

    public void updateData(IQuery query) {
        this._filterPanel.acceptEditValue();
        query.setFilter(this._filterPanel.getCondition());
    }

    public void showValue(DesignedFilterList list) {
        this._filterPanel.showValue(list);
    }

    class FilterPanel
    extends KDPanel {
        private KDPanel _panTitle;
        private KDWorkButton _btnInsert;
        private KDWorkButton _btnDelete;
        protected KDTable _table;
        private boolean _isChanged;
        private TableLayout _laoytTitlePane;

        public FilterPanel() {
            this.setOpaque(false);
            this.init();
            this.installListener();
            this._isChanged = false;
        }

        private void init() {
            this.initTable();
            this._btnInsert = new KDWorkButton((Icon)Resource.ICON_INSERT);
            this._btnInsert.setToolTipText(QueryResource.getString("res_13"));
            this._btnDelete = new KDWorkButton((Icon)Resource.ICON_DELETE);
            this._btnDelete.setToolTipText(QueryResource.getString("res_14"));
            this._laoytTitlePane = TableLayout.split((int)1, (int)6);
            this._laoytTitlePane.colStyle(0).setPriX(1);
            for (int i = 1; i < 6; ++i) {
                this._laoytTitlePane.colStyle(i).setMarginLeft(3);
            }
            this._panTitle = new KDPanel((LayoutManager)this._laoytTitlePane);
            this._panTitle.add((Component)this._btnInsert, (Object)this._laoytTitlePane.cell(4));
            this._panTitle.add((Component)this._btnDelete, (Object)this._laoytTitlePane.cell(5));
            TableLayout tl = TableLayout.split((int)2, (int)1);
            tl.rowStyle(0).setHeight(19);
            tl.rowStyle(0).setMarginBottom(3);
            tl.rowStyle(1).setPriY(1);
            this.setLayout((LayoutManager)tl);
            this.add((Component)this._panTitle, tl.cell(0));
            this.add((Component)this._table, tl.cell(1));
        }

        private void initTable() {
            this._table = new KDTable();
            this._table.getSelectManager().setSelectMode(10);
            this._table.addColumns(6);
            this._table.getColumn(0).setWidth(50);
            this._table.getColumn(1).setWidth(180);
            this._table.getColumn(2).setWidth(50);
            this._table.getColumn(3).setWidth(180);
            this._table.getColumn(4).setWidth(50);
            this._table.getColumn(5).setWidth(50);
            IRow headRow = this._table.addHeadRow();
            this._table.addRows(10);
            headRow.getCell(0).setValue((Object)QueryResource.getString("res_15"));
            headRow.getCell(1).setValue((Object)QueryResource.getString("res_16"));
            headRow.getCell(2).setValue((Object)QueryResource.getString("res_17"));
            headRow.getCell(3).setValue((Object)QueryResource.getString("res_18"));
            headRow.getCell(4).setValue((Object)QueryResource.getString("res_19"));
            headRow.getCell(5).setValue((Object)QueryResource.getString("res_20"));
            KDComboBox cmbLeft = new KDComboBox((Object[])new String[]{"", "(", "((", "(((", "((((", "((((("});
            KDTDefaultCellEditor ceLeft = new KDTDefaultCellEditor((JComboBox)cmbLeft);
            this._table.getColumn(0).setEditor((ICellEditor)ceLeft);
            KDComboBox cmbRight = new KDComboBox((Object[])new String[]{"", ")", "))", ")))", "))))", ")))))"});
            KDTDefaultCellEditor ceRight = new KDTDefaultCellEditor((JComboBox)cmbRight);
            this._table.getColumn(4).setEditor((ICellEditor)ceRight);
            KDComboBox cmbOpr = new KDComboBox((Object[])new String[]{" =", "<>", ">", "<", ">=", "<=", "LIKE", "IS", "IS NOT"});
            KDTDefaultCellEditor ceOpr = new KDTDefaultCellEditor((JComboBox)cmbOpr);
            this._table.getColumn(2).setEditor((ICellEditor)ceOpr);
            KDComboBox cmbLogic = new KDComboBox((Object[])new String[]{"", "AND", "OR"});
            KDTDefaultCellEditor ceLogic = new KDTDefaultCellEditor((JComboBox)cmbLogic);
            this._table.getColumn(5).setEditor((ICellEditor)ceLogic);
        }

        private void installListener() {
            ButtonActionHandler buttonActionHandler = new ButtonActionHandler();
            this._btnInsert.addActionListener((ActionListener)buttonActionHandler);
            this._btnDelete.addActionListener((ActionListener)buttonActionHandler);
            TableHandler tableEditHandler = new TableHandler();
            this._table.addKDTEditListener((KDTEditListener)tableEditHandler);
        }

        protected KDTable getTable() {
            return this._table;
        }

        private boolean isValidFilter(IRow row) {
            return row.getCell(1).getValue() != null && !"".equals(row.getCell(1).getValue()) && row.getCell(2).getValue() != null && !"".equals(row.getCell(2).getValue()) && row.getCell(3).getValue() != null && !"".equals(row.getCell(3).getValue());
        }

        private String getExprString() {
            this._table.getEditManager().stopEditing();
            StringBuffer expr = new StringBuffer();
            for (int i = 0; i < this._table.getRowCount(); ++i) {
                IRow row = this._table.getRow(i);
                if (!this.isValidFilter(row)) continue;
                expr.append(" " + this.getFilterString(row));
            }
            String exprStr = expr.toString();
            if (exprStr.length() > 3 && "and".equals(exprStr.substring(exprStr.length() - 3))) {
                exprStr = exprStr.substring(0, exprStr.length() - 4);
            } else if (exprStr.length() > 2 && "or".equals(exprStr.substring(exprStr.length() - 2))) {
                exprStr = exprStr.substring(0, exprStr.length() - 3);
            }
            return exprStr;
        }

        private String getFilterString(IRow row) {
            String result = "";
            if (row.getCell(0).getValue() != null) {
                result = row.getCell(0).getValue().toString();
            }
            if (row.getCell(1).getValue() != null) {
                result = result + this.getRowExpressString(row);
            }
            if (row.getCell(2).getValue() != null) {
                result = result + " " + row.getCell(2).getValue().toString() + " ";
            }
            if (row.getCell(2).getValue() != null && "Like".equals(row.getCell(2).getValue().toString())) {
                result = row.getCell(3).getValue() != null ? result + this.getRowValueString(row) + "%" : result + "%";
            } else if (row.getCell(3).getValue() != null) {
                result = result + this.getRowValueString(row);
            }
            if (row.getCell(4).getValue() != null) {
                result = result + row.getCell(4).getValue().toString();
            }
            if (row.getCell(5).getValue() != null) {
                result = result + " " + row.getCell(5).getValue().toString();
            }
            return result;
        }

        private String getRowExpressString(IRow row) {
            Object value = row.getCell(1).getValue();
            return AbstractFilterPaneWrapper.this.getColExpressString(value);
        }

        private String getRowValueString(IRow row) {
            Object value = row.getCell(3).getValue();
            return AbstractFilterPaneWrapper.this.getColValueString(value);
        }

        private DesignedFilterList getFilter() {
            DesignedFilterList list = new DesignedFilterList();
            for (int i = 0; i < this._table.getRowCount(); ++i) {
                IRow row = this._table.getRow(i);
                if (!this.isValidFilter(row)) continue;
                DesignedFilter filter = new DesignedFilter();
                if (row.getCell(0).getValue() != null) {
                    filter.setLeftBracket(row.getCell(0).getValue().toString());
                }
                if (row.getCell(1).getValue() != null) {
                    filter.setExpression(this.getRowExpressString(row));
                }
                if (row.getCell(2).getValue() != null) {
                    filter.setOperator(row.getCell(2).getValue().toString());
                }
                if (row.getCell(3).getValue() != null) {
                    filter.setValue(this.getRowValueString(row));
                }
                if (row.getCell(4).getValue() != null) {
                    filter.setRightBracket(row.getCell(4).getValue().toString());
                }
                if (row.getCell(5).getValue() != null) {
                    filter.setLogic(row.getCell(5).getValue().toString());
                }
                list.getFilterList().add(filter);
            }
            return list;
        }

        public Condition getCondition() {
            String expr = this.getExprString();
            Condition con = new Condition(expr);
            con.setExtObj(this.getFilter());
            return con;
        }

        public void setChanged(boolean isChanged) {
            this._isChanged = isChanged;
        }

        public boolean isChanged() {
            return this._isChanged;
        }

        public void showValue(DesignedFilterList list) {
            int blankRows;
            this._table.removeRows();
            if (list != null) {
                for (int i = 0; i < list.getFilterList().size(); ++i) {
                    DesignedFilter filter = (DesignedFilter)list.getFilterList().get(i);
                    IRow row = this._table.getRow(i);
                    if (row == null) {
                        row = this._table.addRow(i);
                    }
                    row.getCell(0).setValue((Object)filter.getLeftBracket());
                    row.getCell(1).setValue(AbstractFilterPaneWrapper.this.getColExpressCellValue(filter.getExpression()));
                    if (filter.getOperator() != null) {
                        row.getCell(2).setValue((Object)filter.getOperator().toUpperCase());
                    }
                    row.getCell(3).setValue(AbstractFilterPaneWrapper.this.getColValueCellValue(filter.getValue()));
                    row.getCell(4).setValue((Object)filter.getRightBracket());
                    if (filter.getLogic() == null) continue;
                    row.getCell(5).setValue((Object)filter.getLogic().toUpperCase());
                }
            }
            this._table.addRows((blankRows = 10 - this._table.getRowCount()) > 5 ? blankRows : 5);
        }

        protected void addButton(KDWorkButton btn, int idx) {
            if (idx >= 1 && idx <= 3) {
                this._panTitle.add((Component)btn, (Object)this._laoytTitlePane.cell(idx));
                this._panTitle.validate();
            }
        }

        public void acceptEditValue() {
            this._table.getEditManager().stopEditing();
        }

        class ButtonActionHandler
        implements ActionListener {
            ButtonActionHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == FilterPanel.this._btnInsert) {
                    this.insertRow();
                } else if (e.getSource() == FilterPanel.this._btnDelete) {
                    this.deleteRow();
                }
            }

            private void insertRow() {
                if (FilterPanel.this._table.getSelectManager().get() == null || FilterPanel.this._table.getSelectManager().get().getBeginRow() < 0) {
                    FilterPanel.this._table.addRow();
                } else {
                    FilterPanel.this._table.addRow(FilterPanel.this._table.getSelectManager().get().getBeginRow());
                }
            }

            private void deleteRow() {
                KDTSelectBlock block = FilterPanel.this._table.getSelectManager().get();
                if (block == null) {
                    return;
                }
                if (!WindowUtil.msgboxYesNo((Component)((Object)FilterPanel.this), (Object)QueryResource.getString("res_21"), (String)QueryResource.getString("res_22"))) {
                    return;
                }
                int rowCount = block.getEndRow() - block.getBeginRow() + 1;
                int nextActiveRow = block.getBeginRow();
                for (int i = 0; i < rowCount; ++i) {
                    FilterPanel.this._table.removeRow(block.getBeginRow());
                }
                if (rowCount > 0) {
                    FilterPanel.this._isChanged = true;
                    FilterPanel.this._table.getSelectManager().setActiveRowIndex(nextActiveRow);
                }
            }
        }

        class TableHandler
        extends KDTEditAdapter {
            TableHandler() {
            }

            public void editStopped(KDTEditEvent e) {
                if (e.getValue() != null && !e.getValue().equals(e.getOldValue()) || e.getValue() == null && e.getOldValue() != null) {
                    FilterPanel.this._isChanged = true;
                }
            }
        }
    }

    class FormulaButtonHandler
    implements ActionListener {
        FormulaButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == AbstractFilterPaneWrapper.this._btnFormula) {
                KDTSelectBlock block = AbstractFilterPaneWrapper.this.getTable().getSelectManager().get();
                if (block == null) {
                    return;
                }
                int col = block.getBeginCol();
                if (col == 1 || col == 3) {
                    IRow row = AbstractFilterPaneWrapper.this.getTable().getRow(block.getBeginRow());
                    ICell cell = row.getCell(col);
                    if (col == 1) {
                        this.showFormaulaDialog(cell, AbstractFilterPaneWrapper.this.getColExpressString(cell.getValue()));
                    } else if (col == 3) {
                        this.showFormaulaDialog(cell, AbstractFilterPaneWrapper.this.getColValueString(cell.getValue()));
                    }
                }
            }
        }

        private void showFormaulaDialog(ICell cell, String textToEdit) {
            FormulaWizardEditor wizard = AbstractFilterPaneWrapper.this.getFormulaWizard();
            if (!(wizard.getOwner() instanceof FormulaEditorDialog)) {
                FormulaEditorDialog dlg = (FormulaEditorDialog)((Object)WindowUtil.createWindow(FormulaEditorDialog.class, (Component)((Object)AbstractFilterPaneWrapper.this._filterPanel)));
                dlg.setSize(800, 600);
                wizard.setOwner(dlg);
                wizard.validateChildren();
            }
            wizard.getWizardPane().setResult(textToEdit);
            if (wizard.getOwner().showDialog()) {
                String newText = wizard.getWizardPane().getResult();
                cell.setValue((Object)newText);
            }
        }
    }
}

