/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.wizard.process.simple_gt;

import com.kingdee.bos.ctrl.data.modal.IDefObjList;
import com.kingdee.bos.ctrl.reportone.data.modal.types.grouping.Group;
import com.kingdee.bos.ctrl.reportone.data.modal.types.grouping.Groups;
import com.kingdee.bos.ctrl.reportone.data.modal.types.grouping.Total;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.OutputColumn;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.OutputColumns;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.aggregate.Aggregates;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.defs.GroupTotalDefs;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.defs.SimpleGroupsDef;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.defs.TotalDef;
import com.kingdee.bos.ctrl.reportone.data.wizard.icons.Icons;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GroupTotalDefTree
extends KDTree {
    private boolean defGroup;
    private DefaultKingdeeTreeNode rootNode;

    public GroupTotalDefTree(boolean defGroup) {
        this.defGroup = defGroup;
    }

    public void initRootNode() {
        this.rootNode = new GroupTotalDefNode(true);
        this.rootNode.setText("ROOT");
        this.rootNode.setUserObject((Object)new NodeUserObject(null));
        this.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.rootNode));
        this.setSelectionNode(this.rootNode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setGroups(Groups groups, OutputColumns outputCols) {
        if (this.rootNode == null) {
            this.initRootNode();
        } else {
            this.rootNode.removeAllChildren();
        }
        for (int i = 0; i < groups.size(); ++i) {
            OutputColumn column;
            Group group = (Group)((Object)groups.get(i));
            DefaultKingdeeTreeNode node = null;
            if (!group.isRootGroup()) {
                column = outputCols.findColumn(group.getName());
                if (column == null) throw new UnsupportedOperationException();
                node = this.addGroupDef(column);
            } else {
                node = this.rootNode;
            }
            this.setSelectionNode(node);
            IDefObjList totals = group.getTotals();
            for (int j = 0; j < totals.size(); ++j) {
                Total total = (Total)totals.get(j);
                column = outputCols.findColumn(total.getColumn());
                if (column == null) {
                    throw new UnsupportedOperationException();
                }
                this.addTotalDef(column, total.getFunction());
            }
            this.setSelectionNode(node);
        }
    }

    public SimpleGroupsDef getGroupsDef() {
        ArrayList groups = this.getGroupFields();
        SimpleGroupsDef def = new SimpleGroupsDef(groups.size());
        for (int i = 0; i < groups.size(); ++i) {
            OutputColumn oc = (OutputColumn)((Object)groups.get(i));
            def.setGroupColumn(i + 1, oc.getOriginSeq());
        }
        return def;
    }

    public ArrayList getGroupFields() {
        ArrayList<OutputColumn> list = new ArrayList<OutputColumn>();
        DefaultKingdeeTreeNode node = this.rootNode;
        while (node.getChildCount() > 0) {
            if (!this.isGroupDefNode(node = (DefaultKingdeeTreeNode)node.getLastChild())) continue;
            list.add(((NodeUserObject)node.getUserObject()).columnRef);
        }
        return list;
    }

    public GroupTotalDefs getGroupTotalDefs() {
        ArrayList groups = this.getGroupFields();
        GroupTotalDefs defs = new GroupTotalDefs(groups.size());
        groups.add(0, null);
        for (int i = 0; i < groups.size(); ++i) {
            OutputColumn oc = (OutputColumn)((Object)groups.get(i));
            ArrayList totals = this.getTotalDefs(oc);
            for (int j = 0; j < totals.size(); ++j) {
                NodeUserObject nodeObj = (NodeUserObject)totals.get(j);
                defs.getGroupTotalDef(i).addTotalDef(new TotalDef(nodeObj.columnRef.getOriginSeq(), nodeObj.totalMethod, ""));
            }
        }
        return defs;
    }

    public ArrayList getTotalDefs(OutputColumn oc) {
        DefaultKingdeeTreeNode groupNode;
        ArrayList<NodeUserObject> list = new ArrayList<NodeUserObject>();
        DefaultKingdeeTreeNode defaultKingdeeTreeNode = groupNode = oc == null ? this.rootNode : this.findGroupDefNode(oc);
        if (groupNode != null) {
            for (int i = 0; i < groupNode.getChildCount(); ++i) {
                NodeUserObject nodeObj = (NodeUserObject)((DefaultKingdeeTreeNode)groupNode.getChildAt(i)).getUserObject();
                if (nodeObj.isGroupDefNode) continue;
                list.add(nodeObj);
            }
        }
        return list;
    }

    public void trimColumns(List usedCols) {
        int i;
        ArrayList<DefaultKingdeeTreeNode> discardNodes = new ArrayList<DefaultKingdeeTreeNode>();
        DefaultKingdeeTreeNode node = this.rootNode;
        for (i = 0; i < node.getChildCount(); ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)node.getChildAt(i);
            NodeUserObject nodeObj = (NodeUserObject)child.getUserObject();
            if (usedCols.indexOf((Object)nodeObj.columnRef) == -1) {
                if (nodeObj.isGroupDefNode) {
                    this.removeNodeFromParent((MutableTreeNode)child);
                    break;
                }
                discardNodes.add(child);
            }
            if (i != node.getChildCount() - 1) continue;
            node = child;
            i = -1;
        }
        for (i = 0; i < discardNodes.size(); ++i) {
            this.removeNodeFromParent((MutableTreeNode)((DefaultKingdeeTreeNode)discardNodes.get(i)));
        }
    }

    public void trimGroups(List groupCols) {
        if (this.defGroup) {
            throw new IllegalStateException();
        }
        if (this.rootNode.getChildCount() == 0) {
            for (int i = 0; i < groupCols.size(); ++i) {
                this.addGroupDef((OutputColumn)((Object)groupCols.get(i)));
            }
        } else {
            HashMap defsMap = new HashMap();
            ArrayList<NodeUserObject> totalList = null;
            DefaultKingdeeTreeNode node = this.rootNode;
            NodeUserObject groupObj = (NodeUserObject)node.getUserObject();
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)node.getChildAt(i);
                NodeUserObject childObj = (NodeUserObject)child.getUserObject();
                if (!childObj.isGroupDefNode) {
                    if (totalList == null) {
                        totalList = new ArrayList<NodeUserObject>();
                    }
                    totalList.add(childObj);
                }
                if (i != node.getChildCount() - 1) continue;
                defsMap.put((String)(groupObj.columnRef == null ? "ROOT" : groupObj.columnRef), totalList);
                totalList = null;
                if (child.getChildCount() <= 0) continue;
                node = child;
                groupObj = childObj;
                i = -1;
            }
            this.removeAllChildrenFromParent((MutableTreeNode)this.rootNode);
            ArrayList<String> groupsC = new ArrayList<String>();
            groupsC.addAll(groupCols);
            groupsC.add(0, "ROOT");
            DefaultKingdeeTreeNode newNode = null;
            for (int i = 0; i < groupsC.size(); ++i) {
                ArrayList totalDefs;
                Object groupDefKey = groupsC.get(i);
                if (i != 0) {
                    this.setSelectionNode(this.addGroupDef((OutputColumn)((Object)groupDefKey)));
                }
                if ((totalDefs = (ArrayList)defsMap.get(groupDefKey)) == null) continue;
                for (int j = 0; j < totalDefs.size(); ++j) {
                    NodeUserObject nodeObj = (NodeUserObject)totalDefs.get(j);
                    newNode = this.addTotalDef(nodeObj.columnRef, nodeObj.totalMethod);
                    this.setSelectionNode((DefaultKingdeeTreeNode)newNode.getParent());
                }
            }
        }
    }

    public DefaultKingdeeTreeNode findGroupDefNode(OutputColumn oc) {
        DefaultKingdeeTreeNode node = this.rootNode;
        while (node.getChildCount() > 0) {
            node = (DefaultKingdeeTreeNode)node.getLastChild();
            NodeUserObject nodeObj = (NodeUserObject)node.getUserObject();
            if (!nodeObj.isGroupDefNode || oc != nodeObj.columnRef) continue;
            return node;
        }
        return null;
    }

    public DefaultKingdeeTreeNode findTotalDefNode(DefaultKingdeeTreeNode groupNode, OutputColumn oc) {
        int count = groupNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)groupNode.getChildAt(i);
            NodeUserObject nodeObj = (NodeUserObject)child.getUserObject();
            if (nodeObj.isGroupDefNode || nodeObj.columnRef != oc) continue;
            return child;
        }
        return null;
    }

    public boolean hasSubGroupDef(DefaultKingdeeTreeNode groupNode) {
        int count = groupNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)groupNode.getChildAt(i);
            if (!this.isGroupDefNode(child)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTotalDef(DefaultKingdeeTreeNode groupNode) {
        return groupNode.getChildCount() > (this.hasSubGroupDef(groupNode) ? 1 : 0);
    }

    public boolean isGroupDefNode(DefaultKingdeeTreeNode groupNode) {
        NodeUserObject nodeObj = (NodeUserObject)groupNode.getUserObject();
        return nodeObj.isGroupDefNode;
    }

    public DefaultKingdeeTreeNode getCurrentNode() {
        DefaultKingdeeTreeNode curNode = null;
        TreePath curTreePath = this.getSelectionPath();
        curNode = curTreePath == null ? this.rootNode : (DefaultKingdeeTreeNode)curTreePath.getLastPathComponent();
        return curNode;
    }

    public DefaultKingdeeTreeNode getCurrentGroupDefNode() {
        DefaultKingdeeTreeNode groupNode = this.getCurrentNode();
        NodeUserObject nodeObj = (NodeUserObject)groupNode.getUserObject();
        if (!nodeObj.isGroupDefNode) {
            groupNode = (DefaultKingdeeTreeNode)groupNode.getParent();
        }
        return groupNode;
    }

    public boolean removeCurrentDef(boolean removeAll) {
        if (removeAll) {
            if (this.defGroup) {
                while (this.rootNode.getChildCount() > 0) {
                    this.removeNodeFromParent((MutableTreeNode)((DefaultKingdeeTreeNode)this.rootNode.getFirstChild()));
                }
                this.setSelectionNode(this.rootNode);
            } else {
                ArrayList<DefaultKingdeeTreeNode> nodes = new ArrayList<DefaultKingdeeTreeNode>();
                DefaultKingdeeTreeNode groupNode = this.getCurrentGroupDefNode();
                Enumeration e = groupNode.children();
                while (e.hasMoreElements()) {
                    DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)e.nextElement();
                    if (this.isGroupDefNode(child)) continue;
                    nodes.add(child);
                }
                for (int i = 0; i < nodes.size(); ++i) {
                    this.removeNodeFromParent((MutableTreeNode)((DefaultKingdeeTreeNode)nodes.get(i)));
                }
                this.setSelectionNode(groupNode);
            }
        } else {
            DefaultKingdeeTreeNode node = this.getCurrentNode();
            DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)node.getParent();
            if (!this.defGroup) {
                DefaultKingdeeTreeNode prev = (DefaultKingdeeTreeNode)node.getPreviousSibling();
                DefaultKingdeeTreeNode next = (DefaultKingdeeTreeNode)node.getNextSibling();
                this.removeNodeFromParent((MutableTreeNode)node);
                this.setSelectionNode(prev == null ? next : prev);
                if (next == null && prev == null) {
                    this.setSelectionNode(this.rootNode);
                }
            } else {
                if (node.isLeaf()) {
                    this.removeNodeFromParent((MutableTreeNode)node);
                } else {
                    DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)node.getFirstChild();
                    this.removeNodeFromParent((MutableTreeNode)node);
                    this.addNodeInto((MutableTreeNode)child, (MutableTreeNode)parent);
                }
                this.setSelectionNode(parent);
            }
        }
        return false;
    }

    public DefaultKingdeeTreeNode addGroupDef(OutputColumn oc) {
        DefaultKingdeeTreeNode firstChild_bak;
        if (this.findGroupDefNode(oc) != null) {
            return null;
        }
        GroupTotalDefNode newNode = new GroupTotalDefNode(true);
        newNode.setText(oc.toString());
        newNode.setUserObject(new NodeUserObject(oc));
        DefaultKingdeeTreeNode curNode = this.getCurrentNode();
        DefaultKingdeeTreeNode defaultKingdeeTreeNode = firstChild_bak = curNode.getChildCount() == 0 ? null : (DefaultKingdeeTreeNode)curNode.getFirstChild();
        if (firstChild_bak != null) {
            this.removeNodeFromParent((MutableTreeNode)firstChild_bak);
        }
        this.insertNodeInto((MutableTreeNode)((Object)newNode), (MutableTreeNode)curNode, curNode.getChildCount());
        if (firstChild_bak != null) {
            this.insertNodeInto((MutableTreeNode)firstChild_bak, (MutableTreeNode)((Object)newNode), newNode.getChildCount());
        }
        this.setSelectionNode(newNode);
        this.expandAllNodes(true, (TreeNode)this.rootNode);
        return newNode;
    }

    public void changeTotalMethod(String newMethod) {
        if (this.defGroup) {
            throw new IllegalStateException();
        }
        NodeUserObject nodeObj = (NodeUserObject)this.getCurrentNode().getUserObject();
        nodeObj.totalMethod = newMethod;
    }

    public void addTotalDefToAll(OutputColumn oc) {
        DefaultKingdeeTreeNode node = this.rootNode;
        while (true) {
            this.setSelectionNode(node);
            this.addTotalDef(oc, null);
            if (node.getChildCount() == 0) break;
            node = (DefaultKingdeeTreeNode)node.getLastChild();
        }
    }

    public DefaultKingdeeTreeNode addTotalDef(OutputColumn oc, String method) {
        if (this.defGroup) {
            throw new IllegalStateException();
        }
        DefaultKingdeeTreeNode groupNode = this.getCurrentGroupDefNode();
        if (this.findTotalDefNode(groupNode, oc) != null) {
            return null;
        }
        if (method == null) {
            method = Aggregates.getDefaultTotalMethod(oc.getDataType());
        }
        GroupTotalDefNode newNode = new GroupTotalDefNode(false);
        newNode.setText(oc.toString());
        newNode.setUserObject(new NodeUserObject(oc, method));
        this.insertNodeInto((MutableTreeNode)((Object)newNode), (MutableTreeNode)groupNode, 0);
        this.setSelectionNode(newNode);
        this.expandAllNodes(true, (TreeNode)this.rootNode);
        return newNode;
    }

    private void exchange(DefaultKingdeeTreeNode node0, DefaultKingdeeTreeNode node1) {
        String text = node0.getText();
        Object userObject = node0.getUserObject();
        node0.setText(node1.getText());
        node0.setUserObject(node1.getUserObject());
        node1.setText(text);
        node1.setUserObject(userObject);
        ((DefaultTreeModel)this.getModel()).nodeChanged((TreeNode)node0);
        ((DefaultTreeModel)this.getModel()).nodeChanged((TreeNode)node1);
    }

    public void moveCurrentNode(boolean up) {
        DefaultKingdeeTreeNode curNode = this.getCurrentNode();
        if (this.defGroup) {
            if (up) {
                DefaultKingdeeTreeNode defaultKingdeeTreeNode = curNode;
                curNode = (DefaultKingdeeTreeNode)curNode.getParent();
                this.exchange(defaultKingdeeTreeNode, curNode);
            } else {
                DefaultKingdeeTreeNode defaultKingdeeTreeNode = curNode;
                curNode = (DefaultKingdeeTreeNode)curNode.getFirstChild();
                this.exchange(defaultKingdeeTreeNode, curNode);
            }
        } else {
            NodeUserObject nodeObj = (NodeUserObject)curNode.getUserObject();
            if (up) {
                DefaultKingdeeTreeNode parent_parent = (DefaultKingdeeTreeNode)curNode.getParent().getParent();
                this.setSelectionNode(parent_parent);
            } else {
                DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)curNode.getParent();
                DefaultKingdeeTreeNode subGroupNode = (DefaultKingdeeTreeNode)parent.getChildAt(parent.getChildCount() - 1);
                this.setSelectionNode(subGroupNode);
            }
            this.removeNodeFromParent((MutableTreeNode)curNode);
            curNode = this.addTotalDef(nodeObj.columnRef, nodeObj.totalMethod);
        }
        this.setSelectionNode(curNode);
    }

    public static class GroupTotalDefNode
    extends DefaultKingdeeTreeNode {
        private ImageIcon icon_group_field = Icons.createIcon("tbtn_gt_group.gif");
        private ImageIcon icon_total_def = Icons.createIcon("tbtn_gt_total.gif");

        public GroupTotalDefNode(boolean defGroup) {
            this.setCustomIcon(defGroup ? this.icon_group_field : this.icon_total_def);
        }
    }

    public static class NodeUserObject {
        boolean isGroupDefNode;
        OutputColumn columnRef;
        String totalMethod;

        public NodeUserObject(OutputColumn columnRef) {
            this.isGroupDefNode = true;
            this.columnRef = columnRef;
        }

        public NodeUserObject(OutputColumn columnRef, String totalMethod) {
            this.isGroupDefNode = false;
            this.columnRef = columnRef;
            this.totalMethod = totalMethod;
        }
    }
}

